 {ͻ
   Prog.: QuSample                               Target Platforms :      
   Desc : Sample program for queue services      - real Mode             
                                                 - protected Mode        
                                                 - windows Mode          
   (C) 1994 by Christoph Weller 22/03/94                                 
  ͼ}

program QuSample;

uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  NvFile,
  NvMain,
  NvQueue;

{
              VAR declarations
 }

var
  Input         : Char;
  Result        : Byte;
  i,j           : Integer;

{
               procedure Queue A
 }

procedure QueueA;

var
  QueueName,
  Path        : String;
  QueueTyp    : Word;
  Result,
  Handle,
  Flags       : Byte;
  QueueId     : LongInt;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Create Queue');
  GotoXY(5,6);
  write('Desc : Creates an new Queue');
  GotoXY(5,8);
  write('Call : function CreateQueue(QueueName,Path : String');
  GotoXY(5,9);
  write('       QueueTyp : Word;Handle : Byte):Byte;');
  GotoXY(5,11);
  write('Request  : QueueName = Name of new Queue');
  GotoXY(5,13);
  write('           Handle    = Directory Handle of Path');
  GotoXY(5,14);
  write('           Path      = Path of Queue to create (Network-Styled)');
  GotoXY(5,15);
  write('Reply    : QueueId   = Object Id of new Queue');
  GotoXY(5,16);
  write('Reply    : Error-Code (See Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,10);
  write('Queue-Name            : ');
  readln(QueueName);
  GotoXY(5,12);
  write('Path                  : ');
  readln(Path);
  GetDirHandle(Handle,Flags,'F');
  ClrScr;
  GotoXY(10,4);
  Result := CreateQueue(QueueId,QueueName,Path,Handle);
  if Result = Successfull then
    write('Successfull QueueId = ',QueueId)
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue B
 }

procedure QueueB;

var
  QueueId     : LongInt;
  Result      : Byte;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Destroy Queue');
  GotoXY(5,6);
  write('Desc : Removes all Jobs and destroys an Queue');
  GotoXY(5,8);
  write('Call : function DestroyQueue(QueueId : LongInt):Byte;');
  GotoXY(5,10);
  write('Request  : QueueId   = Id of Queue to destroy');
  GotoXY(5,12);
  write('Reply    : Error-Code (See Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,10);
  write('Queue-Id              : ');
  readln(QueueId);
  ClrScr;
  GotoXY(5,10);
  Result := DestroyQueue(QueueId);
  if Result = Successfull then
    write('Successfull destroyed')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue C
 }

procedure QueueC;

var
 QueueStat : tQueueStatus;
 Result    : Byte;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Get Queue Current Status');
  GotoXY(5,6);
  write('Desc : Gets the current Status of an Queue');
  GotoXY(5,8);
  write('Call : function ReadQueueStatus(var QStat : QueueStatus;');
  GotoXY(5,9);
  write('       QueueId : LongInt):Byte;');
  GotoXY(5,11);
  write('Request  : QStat.QueueId = Queue-Id to get Status');
  GotoXY(5,13);
  write('Reply    : QStat.QueueId         = Object Id of Queue');
  GotoXY(5,14);
  write('           QStat.QStatus         = Queue Status (See Nvmain)');
  GotoXY(5,15);
  write('           QStat.QueueJobs       = Number of Jobs in Queue');
  GotoXY(5,16);
  write('           QStat.ServerAttached  = Number of Servers attached to Queue');
  GotoXY(5,17);
  write('           QStat.AttServerList   = List of Server-Ids attached to Queue');
  GotoXY(5,18);
  write('           QStat.AttStList       = List of Server-Stations attached to Queue');
  GotoXY(5,19);
  write('           Error-Code (See Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,10);
  write('Queue-Id              : ');
  readln(QueueStat.QueueId);
  ClrScr;
  Result := ReadQueueStatus(QueueStat);
  if Result = Successfull then
  begin
    GotoXY(5,4);
    write('Successfull ');
    with QueueStat do
    begin
      GotoXY(5,6);
      write('Object Id of Queue                        : ',QueueId);
      GotoXY(5,7);
      write('Queue Status (See Nvmain) : ');
      GotoXY(35,7);
      if QStatus and OpDisabledNewJobs <> 0 then
          write('Operator disabled addition of new Jobs');
      GotoXY(35,8);
      if QStatus and OpRefusesAddJobAttach <> 0 then
          write('Operators refused new Job Servers attaching');
      GotoXY(35,9);
      if QStatus and OpDisabledJobServicing <> 0 then
          write('Operator disabled Job Servicing');
      GotoXY(5,10);
      write('Number of Jobs in Queue                   : ',QueueJobs);
      GotoXY(5,11);
      write('Number of Servers attached to Queue       : ',ServerAttached);
      GotoXY(5,12);
      write('List of the first 5 Server-Ids attached to Queue : ');
      GotoXY(5,13);
      for i := 1 to 5 do
      begin
        write(AttServerList[i],' ');
      end;
      GotoXY(5,15);
      write('List of the first 5 Server-Stations attached to Queue : ');
      GotoXY(5,17);
      for i := 1 to 5 do
      begin
        write(AttStList[i],' ');
      end;
    end;
  end
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue D
 }

procedure QueueD;

var
  QueueId       : LongInt;
  QueueStat     : Byte;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Set Queue Status');
  GotoXY(5,6);
  write('Desc : Sets the Status Flag of the Queue');
  GotoXY(5,8);
  write('Call : function SetQueueStatus(QueueId : LongInt;QueueStat :Byte):Byte;');
  GotoXY(5,10);
  write('Request  : QueueId     = Object Id of Queue');
  GotoXY(5,11);
  write('           QueueStat   = New Queue Status');
  GotoXY(5,13);
  write('Reply    : Error-Code (see NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  write('Disable Addition of new Jobs           = $01');
  GotoXY(5,5);
  write('Refuse additional Job Server attaching = $02');
  GotoXY(5,6);
  write('Disbling Job Servicing                 = $04');
  GotoXY(5,10);
  Write(' Queue-Id    : ');
  readln(QueueId);
  GotoXY(5,12);
  Write(' Queue-Stat  : ');
  readln(QueueStat);
  ClrScr;
  GotoXY(5,4);
  Result := SetQueueStatus(QueueId,QueueStat);
  if Result = Successfull then
    write('Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue E
 }

procedure QueueE;

var
  Job : tQueue;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Create Queue Job and File');
  GotoXY(5,6);
  write('Desc : Creates an Queue Job and File');
  GotoXY(5,8);
  write('Call : function CreateQueueJobAndFile(var Job : Queue):Byte;');
  GotoXY(5,10);
  write('Request : Job.QueueId     = Object Id of Queue');
  GotoXY(5,11);
  write('          Job.Client      = Client Station');
  GotoXY(5,12);
  write('          Job.ClientTask  = Client Task Number');
  GotoXY(5,13);
  write('          Job.ClientId    = Object Id of Client');
  GotoXY(5,14);
  write('          Job.TargetId    = Target Server Id (FFFFFF if any Server)');
  GotoXY(5,15);
  write('          Job.Execution   = Execution Time (FFFFFF as soon as possible)');
  GotoXY(5,16);
  write('          Job.JobTime     = Job Entry Time');
  GotoXY(5,17);
  write('          Job.JobNo       = Job Number');
  GotoXY(5,18);
  write('          Job.JobType     = Job Type');
  GotoXY(5,19);
  write('          Job.JobPos      = Job Position in Queue');
  GotoXY(5,20);
  write('          Job.JobFlags    = Job Control Flags (See Nvmain)');
  GotoXY(5,21);
  write('          Job.JobName     = Name of Job');
  GotoXY(5,22);
  write('          Job.Handle      = Job Filehandle');
  GotoXY(5,24);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
  ClrScr;
  GotoXY(5,4);
  write('Request : Job.ServerSt    = Server-Station');
  GotoXY(5,5);
  write('          Job.ServerTask  = Server Tasknumber');
  GotoXY(5,6);
  write('          Job.ServerId    = Object Id of Server');
  GotoXY(5,7);
  write('          Job.JobDesc     = Job Description String');
  GotoXY(5,8);
  write('          Job.ClientRec   = Client Record Area');
  GotoXY(5,24);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
  ClrScr;
  GotoXY(5,4);
  write('Reply   : Job.Client      = Client Station');
  GotoXY(5,5);
  write('          Job.ClientTask  = Task Number of Client');
  GotoXY(5,6);
  write('          Job.ClientId    = Object Id of Client');
  GotoXY(5,7);
  write('          Job.TargetId    = Object Id of Target Server');
  GotoXY(5,8);
  write('          Job.Execution   = Target Execution Time');
  GotoXY(5,9);
  write('          Job.JobTime     = Job Entry Time');
  GotoXY(5,10);
  write('          Job.JobNo       = Job Number');
  GotoXY(5,11);
  write('          Job.JobType     = Job Type');
  GotoXY(5,12);
  write('          Job.JobPos      = Job Position in Queue');
  GotoXY(5,13);
  write('          Job.JobFlags    = Job Control Flags (See NvMain)');
  GotoXY(5,14);
  write('          Job.JobName     = Name of Job');
  GotoXY(5,15);
  write('          Job.Handle      = Job Filehandle');
  GotoXY(5,16);
  write('          Job.ServerSt    = Server Station');
  GotoXY(5,17);
  write('          Job.ServerTask  = Server Task Number');
  GotoXY(5,18);
  write('          Job.ServerId    = Object Id of Server');
  GotoXY(5,20);
  write('          Error-Code (See Nvmain)');
  GotoXY(5,24);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  with Job do
  begin
    GotoXY(5,4);
    write('Object Id of Queue    : ');
    readln(QueueId);
    GotoXY(5,5);
    write('Client Station        : ');
    readln(Client);
    GotoXY(5,6);
    write('Client Task Number    : ');
    readln(ClientTask);
    GotoXY(5,7);
    write('Object Id of Client   : ');
    readln(ClientId);
    GotoXY(5,8);
    write('Target Server Id      : ');
    readln(TargetId);
    GotoXY(5,9);
    write('Execution Time        : ',^j^m);
    write('     Year   : ');readln(Execution[6]);
    write('     Month  : ');readln(Execution[5]);
    write('     Day    : ');readln(Execution[4]);
    write('     Hour   : ');readln(Execution[3]);
    write('     Minute : ');readln(Execution[2]);
    write('     Second : ');readln(Execution[1]);
    GotoXY(5,16);
    write('Job Entry Time        : ',^j^m);
    write('     Year   : ');readln(JobTime[6]);
    write('     Month  : ');readln(JobTime[5]);
    write('     Day    : ');readln(JobTime[4]);
    write('     Hour   : ');readln(JobTime[3]);
    write('     Minute : ');readln(JobTime[2]);
    write('     Second : ');readln(JobTime[1]);
    ClrScr;
    GotoXY(5,4);
    write('Job Number            : ');
    readln(JobNo);
    GotoXY(5,5);
    write('Job Type              : ');
    readln(JobType);
    GotoXY(5,6);
    write('Job Position in Queue : ');
    readln(JobPos);
    GotoXY(5,7);
    write('Job Control Flags     : ');
    readln(JobFlags);
    GotoXY(5,8);
    write('Name of Job           : ');
    readln(JobName);
    GotoXY(5,9);
    write('Job Filehandle        : ');
    for i := 1 to 6 do read(JobHandle[i]);
    GotoXY(5,10);
    write('Server Station        : ');
    readln(ServerSt);
    GotoXY(5,11);
    write('Server Task Number    : ');
    readln(ServerTask);
    GotoXY(5,12);
    write('Object Id of Server   : ');
    readln(ServerId);
  end;
  ClrScr;
  GotoXY(10,4);
  Result := CreateQueueJobAndFile(Job);
  if Result = Successfull then
    write('Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue F
 }

procedure QueueF;

var
  QueueId   : LongInt;
  JobNumber : Word;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Close File and start Job');
  GotoXY(5,6);
  write('Desc : Closes an File and starts the Job');
  GotoXY(5,8);
  write('Call :function CloseFileStartJob(QueueId : LongInt;JobNumber : Word):Byte;');
  GotoXY(5,10);
  write('Request : QueueId         = Object Id of Queue');
  GotoXY(5,11);
  write('          JobNumber       = Jobnumber to start');
  GotoXY(5,13);
  write('Reply   : Error-Code (See Nvmain)');
  GotoXY(5,24);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  write('Object Id of Queue    : ');
  readln(QueueId);
  GotoXY(5,5);
  write('Job-Number            : ');
  readln(JobNumber);
  ClrScr;
  GotoXY(10,4);
  Result := CloseFileStartJob(QueueId,JobNumber);
  if Result = Successfull then
    write('Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue G
 }

procedure QueueG;

var
  QueueId : LongInt;
  JobNo   : Word;
  Result  : Byte;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Remove Job from Queue');
  GotoXY(5,6);
  write('Desc : Removes an Job from the Queue');
  GotoXY(5,8);
  write('Call : function RemoveJobFromQueue(QueueId : LongInt;');
  GotoXY(5,9);
  write('       JobNumber : Word):Byte;');
  GotoXY(5,11);
  write('Request : QueueId      = Object Id of Queue');
  GotoXY(5,12);
  write('          JobNumber    = Number of Job in Entry');
  GotoXY(5,14);
  write('Reply   : Error-Code (See NvMain)');
  GotoXY(5,24);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  write('Object Id of Queue    : ');
  readln(QueueId);
  GotoXY(5,5);
  write('Jobnumber             : ');
  readln(JobNo);
  ClrScr;
  GotoXY(5,5);
  Result := RemoveJobFromQueue(QueueId,JobNo);
  if Result = Successfull then
   write('Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue A
 }

procedure QueueH;

var
  QueueId  : LongInt;
  QList    : tQueueList;

begin
  ClrScr;
  GotoXY(17,2);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,4);
  write('Get Queue Job List');
  GotoXY(5,6);
  write('Desc : Gets the List of current Jobs in Queue');
  GotoXY(5,8);
  write('Call : function GetQueueJobList(QueueId : LongInt;');
  GotoXY(5,9);
  write('       Var QList : QueueList):Byte;');
  GotoXY(5,11);
  write('Request : QueueId     = Object Id of Queue');
  GotoXY(5,12);
  write('Reply   : Error-Code (See NvMain)');
  GotoXY(5,24);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  write('Object Id of Queue    : ');
  readln(QueueId);
  ClrScr;
  GotoXY(5,5);
  Result := GetQueueJobList(QueueId,QList);
  if Result = Successfull then
  begin
    write('Successfull');
    GotoXY(5,7);
    write('Job Count : ',QList.JobCount);
    GotoXY(5,8);
    write('Max Jobs  : ',QList.MaxJobs);
    GotoXY(5,10);
    write('First 10 Entrys in Queue');
    for i := 1 to 10 do
    begin
      GotoXY(5,11 + i);
      write('No ',i,' : ',QList.Jobs[i]);
    end;
  end
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue I
 }

procedure QueueI;

var
  Job       : tQueue;
  Result    : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Read Queue Job Entry');
  GotoXY(5,8);
  write('Desc : Reads Queue Job Entry');
  GotoXY(5,10);
  write('Call : function ReadQueueJobEntry(Job : Queue):Byte;');
  GotoXY(5,12);
  write('Request : Job.QueueId     = Object Id of Queue');
  GotoXY(5,13);
  write('          Job             = Job Number');
  GotoXY(5,15);
  write('Reply   : Job.Client      = Client Station');
  GotoXY(5,16);
  write('          Job.ClientTask  = Task Number of Client');
  GotoXY(5,17);
  write('          Job.ClientId    = Object Id of Client');
  GotoXY(5,18);
  write('          Job.TargetId    = Object Id of Target Server');
  GotoXY(5,19);
  write('          Job.Execution   = Target Execution Time');
  GotoXY(5,20);
  write('          Job.JobTime     = Job Entry Time');
  GotoXY(5,21);
  write('          Job.JobNo       = Job Number');
  GotoXY(5,22);
  write('          Job.JobType     = Job Type');
  GotoXY(5,23);
  write('          Job.JobPos      = Job Position in Queue');
  GotoXY(5,24);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
  ClrScr;
  GotoXY(5,4);
  write('          Job.JobFlags    = Job Control Flags (See NvMain)');
  GotoXY(5,5);
  write('          Job.JobName     = Name of Job');
  GotoXY(5,6);
  write('          Job.Handle      = Job Filehandle');
  GotoXY(5,7);
  write('          Job.ServerSt    = Server Station');
  GotoXY(5,8);
  write('          Job.ServerTask  = Server Task Number');
  GotoXY(5,9);
  write('          Job.ServerId    = Object Id of Server');
  GotoXY(5,10);
  write('          Job.JobDesc     = Job Description');
  GotoXY(5,11);
  write('          Job.TabSize     = Tab-Size of Entry');
  GotoXY(5,12);
  write('          Job.Copies      = Number of Copies');
  GotoXY(5,13);
  write('          Job.Printflags  = Print Flags (see NVMain)');
  GotoXY(5,14);
  write('          Job.ClientName  = Name of Client');
  GotoXY(5,15);
  write('          Job.BannerName  = Name of Banner');
  GotoXY(5,16);
  write('          Job.JName       = Job-Name');
  GotoXY(5,17);
  write('          Job.PathName    = Path-Name');
  GotoXY(5,18);
  write('          Job.ClientRec   = Client-Record');
  GotoXY(5,19);
  write('          Error-Code (See Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write('Queue Id    : ');
  readln(Job.QueueId);
  GotoXY(10,5);
  Write('Job Number  : ');
  readln(Job.JobNo);
  ClrScr;
  GotoXY(5,5);
  Result := ReadQueueJobEntry(Job);
  if Result = Successfull then
  begin
    with Job do
    begin
      GotoXY(5,5);
      write('Successfull');
      GotoXY(5,6);
      write('Client Station               : ',Client);
      GotoXY(5,7);
      write('Task Number of Client        : ',ClientTask);
      GotoXY(5,8);
      write('Object Id of Client          : ',ClientId);
      GotoXY(5,9);
      write('Object Id of Target Server   : ',TargetId);
      GotoXY(5,10);
      write('Target Execution Time        : ');
      for i := 4 to 6 do write(Execution[i],' ');
      for i := 3 downto 1 do write(Execution[i],' ');
      GotoXY(5,11);
      write('Job Entry Time               : ');
      for i := 4 to 6 do write(JobTime[i],' ');
      for i := 3 downto 1 do write(JobTime[i],' ');
      GotoXY(5,12);
      write('Job Number                   : ',JobNo);
      GotoXY(5,13);
      write('Job Type                     : ',JobType);
      GotoXY(5,14);
      write('Job Position in Queue        : ',JobPos);
      GotoXY(5,15);
      write('Job Control Flags            : ');
      GotoXY(10,17);
      if JobFlags and ServedAutomat <> 0 then
        write('Job will be serviced automatically if connection broken');
      GotoXY(10,18);
      if JobFlags and RemainInQueue <> 0 then
        write('Job remains in queue after Server aborts Job');
      GotoXY(10,19);
      if JobFlags and NoFilledJobFile <> 0 then
        write('Client has not filled associated Job File');
      GotoXY(10,20);
      if JobFlags and UserHoldJob  <> 0 then
        write('User Hold Job ');
      GotoXY(10,21);
      if JobFlags and OperatorHoldJob <> 0 then
        write('Operator Hold Job');
      GotoXY(5,22);
      write(' Press Key to continue ');
      Input := UpCase(ReadKey);
      ClrScr;
      GotoXY(5,5);
      write('Name of Job                  : ',JobName);
      GotoXY(5,6);
      write('Job Filehandle               : ');
      for i := 1 to 6 do write(JobHandle[i]);
      GotoXY(5,7);
      write('Server Station               : ',ServerSt);
      GotoXY(5,8);
      write('Server Task Number           : ',ServerTask);
      GotoXY(5,9);
      write('Object Id of Server          : ',ServerId);
      GotoXY(5,10);
      write('Job Description              : ',JobDesc);
      GotoXY(5,11);
      write('Tabsize                      : ',TabSize);
      GotoXY(5,12);
      write('Copies                       : ',Copies);
      GotoXY(5,13);
      write('Printflags                   : ');
      GotoXY(36,13);
      if PrintFlags and SupressFormFeed <> 0 then
        write('Supress Form Feed');
      GotoXY(36,14);
      if PrintFlags and NotifyWhenDone <> 0 then
        write('Notify when done');
      GotoXY(36,15);
      if PrintFlags and TextEntry <> 0 then
        write('Text-Entry');
      GotoXY(36,16);
      if PrintFlags and PrintBanner <> 0 then
        write('Print Banner');
      GotoXY(5,22);
      write(' Press Key to continue ');
      Input := UpCase(ReadKey);
      ClrScr;
      GotoXY(5,5);
      write('Client-Name                  : ',ClientName);
      GotoXY(5,6);
      write('Banner-Name                  : ',BannerName);
      GotoXY(5,7);
      write('Job-Name                     : ',JName);
      GotoXY(5,8);
      write('Path-Name                    : ',PathName);
    end;
  end
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue J
 }

procedure QueueJ;

var
  Job       : tQueue;
  Result    : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Change Queue Job Entry');
  GotoXY(5,8);
  write('Desc : Changes an Queue Job Entry');
  GotoXY(5,10);
  write('Call : function ChangeQueueJobEntry(Job : Queue):Byte;');
  GotoXY(5,12);
  write('Request : Job.QueueId     = Object Id of Queue');
  GotoXY(5,13);
  write('          Job.JobNo       = Job Number');
  GotoXY(5,14);
  write('          Job.Client      = Client Station');
  GotoXY(5,15);
  write('          Job.ClientTask  = Task Number of Client');
  GotoXY(5,16);
  write('          Job.ClientId    = Object Id of Client');
  GotoXY(5,17);
  write('          Job.TargetId    = Object Id of Target Server');
  GotoXY(5,18);
  write('          Job.Execution   = Target Execution Time');
  GotoXY(5,19);
  write('          Job.JobTime     = Job Entry Time');
  GotoXY(5,20);
  write('          Job.JobNo       = Job Number');
  GotoXY(5,21);
  write('          Job.JobType     = Job Type');
  GotoXY(5,22);
  write('          Job.JobPos      = Job Position in Queue');
  GotoXY(5,24);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
  ClrScr;
  GotoXY(5,4);
  write('          Job.JobFlags    = Job Control Flags (See NvMain)');
  GotoXY(5,5);
  write('          Job.JobName     = Name of Job');
  GotoXY(5,6);
  write('          Job.Handle      = Job Filehandle');
  GotoXY(5,7);
  write('          Job.ServerSt    = Server Station');
  GotoXY(5,8);
  write('          Job.ServerTask  = Server Task Number');
  GotoXY(5,9);
  write('          Job.ServerId    = Object Id of Server');
  GotoXY(5,10);
  write('          Job.JobDesc     = Job Description');
  GotoXY(5,11);
  write('          Job.TabSize     = Tab-Size of Entry');
  GotoXY(5,12);
  write('          Job.Copies      = Number of Copies');
  GotoXY(5,13);
  write('          Job.Printflags  = Print Flags (see NVMain)');
  GotoXY(5,14);
  write('          Job.ClientName  = Name of Client');
  GotoXY(5,15);
  write('          Job.BannerName  = Name of Banner');
  GotoXY(5,16);
  write('          Job.JName       = Job-Name');
  GotoXY(5,17);
  write('          Job.PathName    = Path-Name');
  GotoXY(5,18);
  write('          Job.ClientRec   = Client-Record');
  GotoXY(5,20);
  write('Reply   : Error-Code (See Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  with Job do
  begin
    GotoXY(10,4);
    Write('Queue Id                     : ');
    readln(QueueId);
    GotoXY(10,5);
    Write('Job Number                   : ');
    readln(JobNo);
    GotoXY(10,6);
    write('Client Station               : ');
    readln(Client);
    GotoXY(10,7);
    write('Task Number of Client        : ');
    readln(ClientTask);
    GotoXY(10,8);
    write('Object Id of Client          : ');
    readln(ClientId);
    GotoXY(10,9);
    write('Object Id of Target Server   : ');
    readln(TargetId);
    GotoXY(10,10);
    write('Target Execution Time        : ');
    GotoXY(41,10);write('Year   :   ');
    readln(Execution[1]);
    GotoXY(41,10);write('Month  :   ');
    readln(Execution[2]);
    GotoXY(41,10);write('Day    :   ');
    readln(Execution[3]);
    GotoXY(41,10);write('Hour   :   ');
    readln(Execution[4]);
    GotoXY(41,10);write('Minute :   ');
    readln(Execution[5]);
    GotoXY(41,10);write('Second :   ');
    readln(Execution[6]);
    GotoXY(10,11);
    write('Job Entry Time               : ');
    GotoXY(41,11);write('Year   :   ');
    readln(JobTime[1]);
    GotoXY(41,11);write('Month  :   ');
    readln(JobTime[2]);
    GotoXY(41,11);write('Day    :   ');
    readln(JobTime[3]);
    GotoXY(41,11);write('Hour   :   ');
    readln(JobTime[4]);
    GotoXY(41,11);write('Minute :   ');
    readln(JobTime[5]);
    GotoXY(41,11);write('Second :   ');
    readln(JobTime[6]);
    GotoXY(10,12);
    write('Job-Number                   : ');
    readln(JobNo);
    GotoXY(10,13);
    write('Job Type                     : ');
    readln(JobType);
    GotoXY(10,14);
    write('Job Position in Queue        : ');
    readln(JobPos);
    GotoXY(10,15);
    write('Job Control Flags            : ');
    readln(JobFlags);
    GotoXY(5,22);
    write(' Press Key to continue ');
    Input := UpCase(ReadKey);
    ClrScr;
    GotoXY(5,5);
    write('Name of Job                  : ');
    readln(JobName);
    GotoXY(5,6);
    write('Job Filehandle               : ');
    for i := 1 to 6 do
    begin
      GotoXY(41+i,6);
      read(JobHandle[i]);
    end;
    GotoXY(5,7);
    write('Server Station               : ');
    readln(ServerSt);
    GotoXY(5,8);
    write('Server Task Number           : ');
    readln(ServerTask);
    GotoXY(5,9);
    write('Object Id of Server          : ');
    readln(ServerId);
    GotoXY(5,10);
    write('Job Description              : ');
    readln(JobDesc);
    GotoXY(5,11);
    write('Tabsize                      : ');
    readln(TabSize);
    GotoXY(5,12);
    write('Copies                       : ');
    readln(Copies);
    GotoXY(5,13);
    write('Printflags                   : ');
    readln(PrintFlags);
    GotoXY(5,22);
    write(' Press Key to continue ');
    Input := UpCase(ReadKey);
    ClrScr;
    GotoXY(5,5);
    write('Client-Name                  : ');
    readln(ClientName);
    GotoXY(5,6);
    write('Banner-Name                  : ');
    readln(BannerName);
    GotoXY(5,7);
    write('Job-Name                     : ');
    readln(JName);
    GotoXY(5,8);
    write('Path-Name                    : ');
    readln(PathName);
  end;
  ClrScr;
  GotoXY(5,5);
  Result := ChangeQueueJobEntry(Job);
  ClrScr;
  GotoXY(5,10);
  if Result = Successfull then
    write('Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue K
 }

procedure QueueK;

var
  QueueId       : LongInt;
  JobNo         : Word;
  NewPos,
  Result        : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Change Queue Job Position');
  GotoXY(5,8);
  write('Desc : Changes the Position of an Queue-Entry');
  GotoXY(5,10);
  write('Call : function ChangeQueueJobPos(QueueId : LongInt;');
  GotoXY(5,11);
  write('                                  JobNo : Word;NewPos : Byte):Byte;');
  GotoXY(5,13);
  write('Request : QueueId       = Object Id of Queue');
  GotoXY(5,14);
  write('          JobNo         = Jobnumber');
  GotoXY(5,15);
  write('          NewPos        = New Position in Queue');
  GotoXY(5,17);
  write('Reply   : Error-Code (See NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write('Queue Id     : ');
  readln(QueueId);
  GotoXY(10,5);
  Write('Job No       : ');
  readln(JobNo);
  GotoXY(10,6);
  Write('New Position : ');
  readln(NewPos);
  ClrScr;
  GotoXY(5,5);
  Result := ChangeQueueJobPos(QueueId,JobNo,NewPos);
  if Result = Successfull then
    write('Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue L
 }

procedure QueueL;

var
  QueueId       : LongInt;
  Result        : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Attach Queue Server to Queue');
  GotoXY(5,8);
  write('Desc : Attachs an Queue Server to an Queue');
  GotoXY(5,10);
  write('Call : function AttachQServerToQueue(QueueId : LongInt):Byte;');
  GotoXY(5,12);
  write('Request : QueueId       = Object Id of Queue');
  GotoXY(5,14);
  write('Reply   : Error-Code (See NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write('Queue Id     : ');
  readln(QueueId);
  ClrScr;
  GotoXY(5,5);
  Result := AttachQServerToQueue(QueueId);
  if Result = Successfull then
    write('Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue M
 }

procedure QueueM;

var
  QueueId       : LongInt;
  Result        : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Deattach Queue Server from Queue');
  GotoXY(5,8);
  write('Desc : Deattachs an Queue Server from an Queue');
  GotoXY(5,10);
  write('Call : function DeAttachQServerFromQueue(QueueId : LongInt):Byte;');
  GotoXY(5,12);
  write('Request : QueueId       = Object Id of Queue');
  GotoXY(5,14);
  write('Reply   : Error-Code (See NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write('Queue Id     : ');
  readln(QueueId);
  ClrScr;
  GotoXY(5,5);
  Result := DeAttachQServerFromQueue(QueueId);
  if Result = Successfull then
    write('Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue N
 }

procedure QueueN;

var
  QueueId       : LongInt;
  TargetJobType : Word;
  Result        : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Service Queue Job and open File');
  GotoXY(5,8);
  write('Desc : Services an Queue Job and opens File');
  GotoXY(5,10);
  write('Call : function ServiceQueueJobOpenFile(QueueId : LongInt;');
  GotoXY(5,11);
  write('       TargetJobType : Word):Byte;');
  GotoXY(5,13);
  write('Request : QueueId       = Object Id of Queue');
  GotoXY(5,14);
  write('          TargetJobType = Job Typ of Target');
  GotoXY(5,15);
  write('Reply   : Error-Code (See NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write('Queue Id        : ');
  readln(QueueId);
  GotoXY(10,5);
  Write('Target Job Type : ');
  readln(TargetJobType);
  ClrScr;
  GotoXY(5,5);
  Result := ServiceQueueJobOpenFile(QueueId,TargetJobType);
  if Result = Successfull then
    write('Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue O
 }

procedure QueueO;

var
  QueueId       : LongInt;
  JobNo         : Word;
  Charge        : LongInt;
  Result        : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Finish Servicing Job and File');
  GotoXY(5,8);
  write('Desc : Finishs Servicing Job and File');
  GotoXY(5,10);
  write('Call : function FinishServicingJob(QueueId : LongInt;');
  GotoXY(5,11);
  write('       JobNo : Word;Charge : LongInt):Byte;');
  GotoXY(5,13);
  write('Request : QueueId       = Object Id of Queue');
  GotoXY(5,14);
  write('          JobNo         = Job No.');
  GotoXY(5,15);
  write('          Charge        = Charge of Job');
  GotoXY(5,17);
  write('Reply   : Error-Code (See NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write('Queue Id        : ');
  readln(QueueId);
  GotoXY(10,5);
  Write('Job No          : ');
  readln(JobNo);
  GotoXY(10,6);
  Write('Charge          : ');
  readln(Charge);
  ClrScr;
  GotoXY(5,5);
  Result := FinishServicingJob(QueueId,JobNo,Charge);
  if Result = Successfull then
    write('Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue P
 }

procedure QueueP;

var
  QueueId       : LongInt;
  JobNo         : Word;
  Result        : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Abort Servicing Queue Servicing Job and File');
  GotoXY(5,8);
  write('Desc : Aborts Servicing Job and File');
  GotoXY(5,10);
  write('Call : function AbortServicingQueue(QueueId : LongInt;');
  GotoXY(5,11);
  write('       JobNo : Word):Byte;');
  GotoXY(5,13);
  write('Request : QueueId       = Object Id of Queue');
  GotoXY(5,14);
  write('          JobNo         = Job No.');
  GotoXY(5,16);
  write('Reply   : Error-Code (See NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write('Queue Id        : ');
  readln(QueueId);
  GotoXY(10,5);
  Write('Job No          : ');
  readln(JobNo);
  ClrScr;
  GotoXY(5,5);
  Result := AbortServicingQueue(QueueId,JobNo);
  if Result = Successfull then
    write('Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue Q
 }

procedure QueueQ;

var
  QueueId       : LongInt;
  JobNo         : Word;
  Result        : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Change to Client Rights');
  GotoXY(5,8);
  write('Desc : Change to the Client-Rights');
  GotoXY(5,10);
  write('Call : function ChangeToClientRights(QueueId : LongInt;JobNo : Word):Byte;');
  GotoXY(5,11);
  write('       JobNo : Word):Byte;');
  GotoXY(5,13);
  write('Request : QueueId       = Object Id of Queue');
  GotoXY(5,14);
  write('          JobNo         = Job No.');
  GotoXY(5,16);
  write('Reply   : Error-Code (See NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  Write('Queue Id        : ');
  readln(QueueId);
  GotoXY(10,5);
  Write('Job No          : ');
  readln(JobNo);
  ClrScr;
  GotoXY(5,5);
  Result := ChangeToClientRights(QueueId,JobNo);
  if Result = Successfull then
    write('Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue R
 }

procedure QueueR;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Restore Queue Server Rights');
  GotoXY(5,8);
  write('Desc : Restores thr Queue Server Rights after `Change to Client Rights`');
  GotoXY(5,10);
  write('Call : function RestoreQueueServerRights:Byte;');
  GotoXY(5,12);
  write('Reply   : Error-Code (See NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,5);
  Result := RestoreQueueServerRights;
  if Result = Successfull then
    write('Successfull')
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue S
 }

procedure QueueS;

var
  QueueId,
  JobSize : LongInt;
  JobNo   : Word;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Queue Job File Size');
  GotoXY(5,8);
  write('Desc : Gets the Filesize of an Queue Job-Entry');
  GotoXY(5,10);
  write('Call : function GetQueueJobFileSize(var JobSize : LongInt');
  GotoXY(5,11);
  write('                QueueId : LongInt;JobNo : Word):Byte;');
  GotoXY(5,13);
  write('Request : QueueId      = Object Id of Queue');
  GotoXY(5,14);
  write('          JobNo        = Jobnumber to get Filesize');
  GotoXY(5,16);
  write('Reply   : JobSize      = Filesize of Job Entry');
  GotoXY(5,17);
  write('          Error-Code see (NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  Write(' Queue-Id  : ');
  readln(QueueId);
  GotoXY(5,6);
  Write(' Job-Number: ');
  readln(JobNo);
  ClrScr;
  GotoXY(10,4);
  Result := GetQueueJobFileSize(JobSize,QueueId,JobNo);
  if Result = SuccessFull then
    write('Successfull,Filesize = ',JobSize)
  else
    write(' Error-result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue T
 }

procedure QueueT;

var
  QueueId : LongInt;
  ServerId : LongInt;
  ServerStation : Byte;
  StatusRec : tServerStatusReply;
  i         : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Read queue server current status');
  GotoXY(5,8);
  write('Desc : Reads a queuer server current status');
  GotoXY(5,10);
  write('Call : function ReadQueueServerCurrentStatus(QueueId : LongInt;');
  GotoXY(5,11);
  write('                                             ServerId : LongInt;');
  GotoXY(5,12);
  write('                                             ServerStation : Byte;');
  GotoXY(5,13);
  write('                                    var StatusRec : tServerStatusReply):Byte;');
  GotoXY(5,15);
  write('Request : QueueId      = Object Id of Queue');
  GotoXY(5,16);
  write('          ServerId     = Object id of server');
  GotoXY(5,17);
  write('          ServerStation = server station');
  GotoXY(5,18);
  write('Reply   : StatusRec    = Server status record');
  GotoXY(5,19);
  write('          Error-Code see (NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  Write(' Queue-Id  : ');
  readln(QueueId);
  GotoXY(5,6);
  Write(' Server-id : ');
  readln(ServerId);
  GotoXY(5,7);
  Write(' Server-station : ');
  readln(ServerStation);
  ClrScr;
  Result := ReadQueueServerCurrentStatus(QueueId,
                                         ServerId,
                                         ServerStation,
                                         StatusRec);
  GotoXY(10,4);
  writeln(' Error-result  : $', Convert2Hex(Result),^j^m);
  writeln('Server record : ',^j^m);
  for i := 1 to 64 do write(Char(StatusRec.ServerStatusRecord[i]));
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
               procedure Queue U
 }

procedure QueueU;

var
  QueueId : LongInt;
  dummy   : String;
  StatusRec : tServerStatusRecord;
  i         : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell queue unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Set queue server current status');
  GotoXY(5,8);
  write('Desc : Sets the queuer server current status');
  GotoXY(5,10);
  write('Call : function SetQueueServerCurrentStatus(QueueId : LongInt;');
  GotoXY(5,11);
  write('                                            StatusRec : tServerStatusRecord):Byte;');
  GotoXY(5,15);
  write('Request : QueueId      = Object Id of Queue');
  GotoXY(5,16);
  write('          StatusRec    = Server status record');
  GotoXY(5,18);
  write('Reply   : Error-Code see (NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(5,4);
  Write(' Queue-Id  : ');
  readln(QueueId);
  GotoXY(5,6);
  Write(' Server-status record : ');
  readln(dummy);
  move(dummy, statusrec, 64);
  ClrScr;
  Result := SetQueueServerCurrentStatus(QueueId, StatusRec);
  GotoXY(10,4);
  writeln(' Error-result  : $', Convert2Hex(Result),^j^m);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                  main program
 }

begin
  repeat
    ClrScr;
    GotoXY(10, 1);
    write(' Sample program for queue unit (C) 1993 by C.Weller');
    {$IFDEF WINDOWS}
    GotoXY(25, 2);
    write(' Running under Windows');
    {$ELSE}
      {$IFDEF DPMI}
      GotoXY(17, 2);
      write(' Protected Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ELSE}
      GotoXY(17, 2);
      write(' Real Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ENDIF}
    {$ENDIF}
    GotoXY(5,4);
    write('A : Create queue, ##');
    GotoXY(5,5);
    write('B : Destroy queue, ##');
    GotoXY(5,6);
    write('C : Get queue current status, ##');
    GotoXY(5,7);
    write('D : Set queue status, ##');
    GotoXY(5,8);
    write('E : Create queue job and file, ##');
    GotoXY(5,9);
    write('F : Close file and start job, ##');
    GotoXY(5,10);
    write('G : Remove job from queue, ##');
    GotoXY(5,11);
    write('H : Get queue job list, ##');
    GotoXY(5,12);
    write('I : Read queue job entry, ##');
    GotoXY(5,13);
    write('J : Change queue job entry, ##');
    GotoXY(5,14);
    write('K : Change queue job position, ##');
    GotoXY(5,15);
    write('L : Attach queue-server to queue, ##');
    GotoXY(5,16);
    write('M : Deattach queue-server from queue, ##');
    GotoXY(5,17);
    write('N : Service queue job and open file, ##');
    GotoXY(5,18);
    write('O : Finishing servicing queue job/file, ##');
    GotoXY(44,4);
    write('P : Abort servicing queue job/file,##');
    GotoXY(44,5);
    write('Q : Change to client rights, ##');
    GotoXY(44,6);
    write('R : Restore queue server rights, ##');
    GotoXY(44,7);
    write('S : Get queues job filesize, ##');
    GotoXY(44,8);
    write('T : Read queue server current status');
    GotoXY(44,9);
    write('U : Set queue server current status');
    GotoXY(18,22);
    Write('0 : Exit to main, X : Exit program choose Function :');
    Input := UpCase(ReadKey);
    case Input of
      'A' : queueA;
      'B' : queueB;
      'C' : queueC;
      'D' : queueD;
      'E' : queueE;
      'F' : queueF;
      'G' : queueG;
      'H' : queueH;
      'I' : queueI;
      'J' : queueJ;
      'K' : queueK;
      'L' : queueL;
      'M' : queueM;
      'N' : queueN;
      'O' : queueO;
      'P' : queueP;
      'Q' : queueQ;
      'R' : queueR;
      'S' : queueS;
      'T' : queueT;
      'U' : queueU;
      'X' : halt(0);
    end;
  until false;
end.
