 {ͻ
   Prog.: SvSample                               Target Platforms :      
   Desc : Sample program for server services     - real Mode             
                                                 - protected Mode        
                                                 - windows Mode          
   (C) 1994 by Christoph Weller 22/03/94                                 
  ͼ}

program SvSample;

uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  NvMain,
  NvServer;

{
              VAR declarations
 }

var
  Result        : Byte;
  Input         : Char;
  i,j           : Integer;

{
                Procedure Server A
 }

procedure ServerA;

var
  Servers : tServerTable;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get File Server Table ');
  GotoXY(5,8);
  write('Desc : Gets the List of available Servers ');
  GotoXY(5,10);
  write('Call : GetFileServerTable(Var Servers : ServerTable);');
  GotoXY(5,12);
  write('Server Table is array[1..8] of String which contains the Server Names');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  GetFileServerTable(Servers);
  clrscr;
  for i := 1 to 8 do
  begin
    GotoXY(10,5 + i);
    Write(' Server No ',i,' : ',Servers[i]);
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server B
 }

procedure ServerB;

var
  ServerInf  : tServerInfo;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Server Info');
  GotoXY(5,8);
  write('Desc : Gets Information about the Server');
  GotoXY(5,10);
  write('Call : procedure GetServerInfo(var ServerInformation : ServerInfo);');
  GotoXY(5,12);
  write('ServerInformation is an Record definied in NvServer');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GetServerInfo(ServerInf);
  with ServerInf do
  begin
    GotoXY(10,4);
    Write('Server Name        : ',ServerName);
    GotoXY(10,5);
    Write('Netware Version    : ',NetWareVersion);
    GotoXY(10,6);
    Write('Netware SubVersion : ',NetWareSubVersion);
    GotoXY(10,7);
    Write('Max. Connections   : ',MaxConn);
    GotoXY(10,8);
    Write('Conns. in Use      : ',ConnInUse);
    GotoXY(10,9);
    Write('Max. Volumes       : ',MaxVols);
    GotoXY(10,10);
    Write('Revision No.       : ',Revision);
    GotoXY(10,11);
    Write('SFT Level          : ',SFTLevel);
    GotoXY(10,12);
    Write('TTS Level          : ',TTSLevel);
    GotoXY(10,13);
    Write('Peak Connection    : ',PeakConn);
    GotoXY(10,14);
    Write('Account Ver.       : ',AccountVer);
    GotoXY(10,15);
    Write('VAP Version        : ',VAPVersion);
    GotoXY(10,16);
    Write('Queue Version      : ',QueueVer);
    GotoXY(10,17);
    Write('Print Server Ver.  : ',PrintServerVer);
    GotoXY(10,18);
    Write('Virtual Ver.       : ',VirtualVer);
    GotoXY(10,19);
    Write('Security Level     : ',SecLevel);
    GotoXY(10,20);
    Write('Brigde Version     : ',BrigdeVersion);
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server C
 }

procedure ServerC;

var
  ServerDesc  : tServerDescription;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get File Server Description');
  GotoXY(5,8);
  write('Desc : Gets Descriptions about the Server');
  GotoXY(5,10);
  write('Call : GetServerDescription(var ServerDesc : ServerDescription);');
  GotoXY(5,12);
  write('ServerDescription is an Record definied in NvServer');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GetServerDescription(ServerDesc);
  with ServerDesc do
  begin
    GotoXY(10,4);
    Write('Company            : ',Company);
    GotoXY(10,5);
    Write('Version            : ',Version);
    GotoXY(10,6);
    Write('Revision Date      : ',RevisionDate);
    GotoXY(10,7);
    Write('Copyright          : ',Copyright);
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server D
 }

procedure ServerD;

var
  NWSerial      : LongInt;
  ApplicationNo : Word;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(18,6);
  write('Get Netware and Application Serial Number');
  GotoXY(5,8);
  write('Desc : Returns the Netware and Application Serial Number');
  GotoXY(5,10);
  write('Call : function GetFileServerSerialNo(var NWSerial : LongInt;');
  GotoXY(5,11);
  write('                var ApplicationNo : Word):boolean;');
  GotoXY(5,13);
  write('Reply : true if Successfull,Serial-Number of Netware and Application');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if GetFileServerSerialNo(NWSerial,ApplicationNo) then
  begin
    GotoXY(10,4);
    write('Successfull ');
    GotoXY(10,6);
    write('Netware Serial Number     : ',NWSerial);
    GotoXY(10,7);
    write('Application Serial Number : ',ApplicationNo);
  end
  else
  begin
    GotoXY(10,4);
    write('Error during Execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server E
 }

procedure ServerE;

var
  NWSerial      : LongInt;
  ApplicationNo : Word;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(18,6);
  write('Verify Netware Serial Number');
  GotoXY(5,8);
  write('Desc : Verifys the Netware Serial Number and returns the ');
  GotoXY(5,9);
  write('       Application No of the File-Server if successfull');
  GotoXY(5,11);
  write('Call : function VerifyFileServerSerialNo(NWSerial : LongInt):Word;');
  GotoXY(5,13);
  write('Request : NWSerial : Fileserver Netware Serial Number');
  GotoXY(5,15);
  write('Reply : Application Number of Fileserver');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Fileserver Netware Serial Number : ');
  readln(NWSerial);
  ApplicationNo := VerifyFileServerSerialNo(NWSerial);
  GotoXY(10,7);
  write('Application Serial Number : ',ApplicationNo);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server F
 }

procedure ServerF;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Disable Server Login');
  GotoXY(5,8);
  write('Desc : Disables Server Login,Supervisor Privileges required');
  GotoXY(5,10);
  write('Call : DisableServerLogin:boolean;');
  GotoXY(5,12);
  write('Reply : false if no Console Rights ');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if DisableServerLogin then
  begin
    GotoXY(10,4);
    write('Server Login disabled');
  end
  else
  begin
    GotoXY(10,4);
    write('You have no Console Rights buhh');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server G
 }

procedure ServerG;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Enable Server Login');
  GotoXY(5,8);
  write('Desc : Enables Server Login,Supervisor Privileges required');
  GotoXY(5,10);
  write('Call : EnableServerLogin:boolean;');
  GotoXY(5,12);
  write('Reply : true if successfull done');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if EnableServerLogin then
  begin
    GotoXY(10,4);
    write('Server Login enabled');
  end
  else
  begin
    GotoXY(10,4);
    write('You have no Console Rights');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server H
 }

procedure ServerH;

var
  LoginStatus : boolean;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Login Status');
  GotoXY(5,8);
  write('Desc : Returns the Login Status,Supervisor Privilege required');
  GotoXY(5,10);
  write('Call : GetLoginStatus(var Status : boolean):boolean;');
  GotoXY(5,12);
  write('Reply : Status = true if Login is enabled');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  if GetLoginStatus(LoginStatus) then
  begin
    GotoXY(5,4);
    write('Server Login Status = ',EnableServerLogin);
  end
  else
  begin
    GotoXY(5,4);
    write('You have no Console Rights,buuhh');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server I
 }

procedure ServerI;

var
  Year,
  Month,
  Day,
  Hour,
  Minute,
  Second : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Set File Server Date and Time');
  GotoXY(5,8);
  write('Desc : Sets the File Server Date and Time,Supervisor Privilege required');
  GotoXY(5,10);
  write('Call : SetFileServerDateTime(Year,Month,Day,Hour,Minute,Second : Byte):boolean;');
  GotoXY(5,12);
  write('Reply : false if no Console Rights');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Enter Year (00-79 = 2000-2079,80-99 = 1980-1999)   : ');
  readln(Year);
  GotoXY(10,5);
  write(' Enter Month  : ');
  readln(Month);
  GotoXY(10,6);
  write(' Enter Day    : ');
  readln(Day);
  GotoXY(10,7);
  write(' Enter Hour   : ');
  readln(Hour);
  GotoXY(10,8);
  write(' Enter Minute : ');
  readln(Minute);
  GotoXY(10,9);
  write(' Enter Second : ');
  readln(Second);
  if SetFileServerDateTime(Year,Month,Day,Hour,Minute,Second) then
  begin
    ClrScr;
    GotoXY(5,4);
    write('Time successfull set !');
  end
  else
  begin
    ClrScr;
    GotoXY(5,4);
    write('You have no Console Rights,buuhh');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server J
 }

procedure ServerJ;

var
  Year,
  Month,
  Day,
  Hour,
  Minute,
  Second,
  DayOfWeek : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get File Server Date and Time');
  GotoXY(5,8);
  write('Desc : Gets the File Server Date and Time');
  GotoXY(5,10);
  write('Call :');
  GotoXY(5,11);
  write('GetFileServerDateTime(var Year,Month,Day,Hour,Minute,Second : Byte):boolean;');
  GotoXY(5,13);
  write('Reply : Date,Time and Day of Week,Functions returns false if');
  GotoXY(13,14);
  write('Error durring Execution');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if GetFileServerDateTime(Year,Month,Day,Hour,Minute,Second,DayOfWeek) then
  begin
    ClrScr;
    GotoXY(5,4);
    GotoXY(10,4);
    write(' Year        : ',Year);
    GotoXY(10,5);
    write(' Month       : ',Month);
    GotoXY(10,6);
    write(' Day         : ',Day);
    GotoXY(10,7);
    write(' Hour        : ',Hour);
    GotoXY(10,8);
    write(' Minute      : ',Minute);
    GotoXY(10,9);
    write(' Second      : ',Second);
    GotoXY(10,10);
    write(' Day Of Week : ',DayOfWeek);
  end
  else
  begin
    ClrScr;
    GotoXY(5,4);
    write(' Error Shit !');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server K
 }

procedure ServerK;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Disable TTS');
  GotoXY(5,8);
  write('Desc : Disables TTS on the Server,Supervisor Privileges required');
  GotoXY(5,10);
  write('Call :function EnableTTS:boolean;');
  GotoXY(5,12);
  write('Reply : false if no Console Priviliges');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if DisableTTS then
  begin
    GotoXY(10,4);
    write('TTS disabled');
  end
  else
  begin
    GotoXY(10,4);
    write('You have no Console Rights');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server L
 }

procedure ServerL;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Enable TTS');
  GotoXY(5,8);
  write('Desc : Enables TTS on the Server,Supervisor Privileges required');
  GotoXY(5,10);
  write('Call : EnableTTS:boolean;');
  GotoXY(5,12);
  write('Reply : false if no Console Privileges');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if EnableTTS then
  begin
    GotoXY(10,4);
    write('TTS Enabled ');
  end
  else
  begin
    GotoXY(10,4);
    write('You have no Console Rights');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server M
 }

procedure ServerM;

var
  LoginStatus : boolean;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get TTS Status');
  GotoXY(5,8);
  write('Desc : Returns the Status of TTS');
  GotoXY(5,10);
  write('Call : TTSStatus:Byte');
  GotoXY(5,12);
  write('Reply : Status  0 no TTS available');
  GotoXY(5,13);
  write('                1 TTS disabled');
  GotoXY(5,14);
  write('                2 TTS available but disabled');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  case TTSStatus of
    0 :
      begin
        GotoXY(5,4);
        write('TTS not available');
      end;
    1 :
      begin
        GotoXY(5,4);
        write('TTS available');
      end;
    2 :
      begin
        GotoXY(5,4);
        write('TTS available but disabled');
      end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server N
 }

procedure ServerN;

var
  ConnectionNo : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Clear Connection ');
  GotoXY(5,8);
  write('Desc : Clears an Connection even if Files are open,Supervisor required');
  GotoXY(5,11);
  write('Call : function ClearConnection(ConnectionNo : Byte):boolean;');
  GotoXY(5,13);
  write('Request : ConnectionNo = Connection to clear');
  GotoXY(5,15);
  write('Reply   : false if no Console Rights');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Enter Connection No. : ');
  readln(ConnectionNo);
  if ClearConnection(ConnectionNo) then
  begin;
    ClrScr;
    GotoXY(10,4);
    Writeln(' User logged out,hehe :-) ');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    Writeln(' You have no Console Rights,buuh');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server O
 }

procedure ServerO;

var
  Quest   : Char;
  ForceIt : boolean;
  Reply   : byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Server down ');
  GotoXY(5,8);
  write('Desc : Down File Server ');
  GotoXY(5,11);
  write('Call : function DownServer(ForceIt : boolean):Byte');
  GotoXY(5,13);
  write('Request : if ForceIt true Server Shutdown even if Files open !!!');
  GotoXY(5,15);
  write('Reply : 00h successfull,01h DPMI-Error,C6h no Console Rights,FFh Files open');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Force It ? (Y/N) : ');
  readln(Quest);
  if UpCase(Quest) = 'Y' then
    ForceIt := true
  else
    Forceit := false;
  Reply := DownServer(ForceIt);
  case  Reply of
    $00 :
        begin;
          ClrScr;
          GotoXY(10,4);
          Writeln(' Server down,hehe :-) ');
        end;
    $01 :
        begin;
          ClrScr;
          GotoXY(10,4);
          Writeln(' DPMI-Error ');
        end;
    $C6 :
        begin;
          ClrScr;
          GotoXY(10,4);
          Writeln(' You have no Console Rights');
        end;
    $FF :
        begin;
          ClrScr;
          GotoXY(10,4);
          Writeln(' Still Files open !');
        end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                Procedure Server P
 }

procedure ServerP;

var
  VolumeNo        : Byte;
  NameSpaceLoaded : tNameSpaceLoaded;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell server unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get name space loaded');
  GotoXY(5,8);
  write('Desc : Get loaded name spaces of an volume');
  GotoXY(5,11);
  write('Call : function GetNameSpacesLoaded(VolumeNo : Byte;');
  GotoXY(5,12);
  write('                                  NameSpaceLoaded : tNameSpaceLoaded):Byte;');
  GotoXY(5,14);
  write('Request : Volume-no       = volume-no to get name spaces');
  GotoXY(5,15);
  write('          NameSpaceLoaded = list of name spaces');
  GotoXY(5,17);
  write('Reply : Error-code (see NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Volume-no : ');
  readln(VolumeNo);
  Result := GetNameSpacesLoaded(VolumeNo, NameSpaceLoaded);
  GotoXY(5,8);
  write(' Result  : $', Convert2Hex(Result));
  GotoXY(5,10);
  write(' Name space count   : ', NameSpaceLoaded.NumberOfNameSpaces);
  GotoXY(5,11);
  write(' Name space list    : ');
  for i := 1 to NameSpaceLoaded.NumberOfNameSpaces do
    write('$', Convert2Hex(NameSpaceLoaded.NameSpaceList[i]), ' ');
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                   main program
 }

begin
  repeat
    ClrScr;
    GotoXY(10, 1);
    write(' Sample program for server unit (C) 1993 by C.Weller');
    {$IFDEF WINDOWS}
    GotoXY(25, 2);
    write(' Running under Windows');
    {$ELSE}
      {$IFDEF DPMI}
      GotoXY(17, 2);
      write(' Protected Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ELSE}
      GotoXY(17, 2);
      write(' Real Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ENDIF}
    {$ENDIF}
    GotoXY(20,4);
    write('A : Get file server table,##');
    GotoXY(20,5);
    write('B : Get server info,##');
    GotoXY(20,6);
    write('C : Get file server description,##');
    GotoXY(20,7);
    write('D : Get netware and application serial number,##');
    GotoXY(20,8);
    write('E : Verify netware serial number,##');
    GotoXY(20,9);
    write('F : Disable server login,##');
    GotoXY(20,10);
    write('G : Enable server login,##');
    GotoXY(20,11);
    write('H : Get login status,##');
    GotoXY(20,12);
    write('I : Set file server date and time,##');
    GotoXY(20,13);
    write('J : Get file server date and time,##');
    GotoXY(20,14);
    write('K : Disable TTS,##');
    GotoXY(20,15);
    write('L : Enable TTS,##');
    GotoXY(20,16);
    write('M : TTS - status,##');
    GotoXY(20,17);
    write('N : Clear connection,##');
    GotoXY(20,18);
    write('O : Down server,##');
    GotoXY(20, 19);
    write('P : Get name spaces loaded,##');
    GotoXY(20, 21);
    write('0 : Exit to Main, X : Exit Program');
    GotoXY(20,22);
    write('Choose Function :');
    Input := UpCase(ReadKey);
    case Input of
      'A' : ServerA;
      'B' : ServerB;
      'C' : ServerC;
      'D' : ServerD;
      'E' : ServerE;
      'F' : ServerF;
      'G' : ServerG;
      'H' : ServerH;
      'I' : ServerI;
      'J' : ServerJ;
      'K' : ServerK;
      'L' : ServerL;
      'M' : ServerM;
      'N' : ServerN;
      'O' : ServerO;
      'P' : ServerP;
      'X' : halt(0);
    end;
  until false;
end.
