 {ͻ
   Prog.: SySample                               Target Platforms :      
   Desc : Sample program for synchronization     - real Mode             
          services                               - protected Mode        
                                                 - windows Mode          
   (C) 1994 by Christoph Weller 22/03/94                                 
  ͼ}

program SySample;

uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  NvFile,
  NvMain,
  NvSync;

{
              VAR declarations
 }

var
  Input         : Char;
  Result        : Byte;
  i, j          : Integer;

{
              procedure Sync A
 }

procedure SyncA;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Get lock mode');
  GotoXY(1, 8);
  writeln('        Desc : Gets the current lock mode', ^j^m);
  writeln('     Call  : function GetLockMode:Byte;', ^j^m);
  writeln('     Reply : Lock-mode (see NvMain)');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Result := GetLockMode;
  ClrScr;
  GotoXY(10, 4);
  case Result of
    CompatibiltyMode   : write(' Comaptibilty mode');
    ExtentedLockMode   : write(' Extended lock mode');
  end;
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync B
 }

procedure SyncB;

var
  LockMode     : Byte;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Set lock mode');
  GotoXY(1, 8);
  writeln('        Desc : Sets the current lock mode', ^j^m);
  writeln('     Call  : procedure SetLockMode(Mode :Byte);', ^j^m);
  writeln('     Request : Mode    = lock mode (see NvSync)',^j^m);
  writeln('     Reply : Lock-mode (see NvMain)');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Log Mode (0-1) ? : ');
  readln(LockMode);
  SetLockMode(LockMode);
  GotoXY(10, 6);
  write(' New mode set');
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync C
 }

procedure SyncC;

var
  LockMode     : Byte;
  FileHandle   : Word;
  StartOffset,
  LockLength   : LongInt;
  TimeOutTicks : Word;
  FileName     : String;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Log physical record');
  GotoXY(5, 8);
  write('Desc : Logs an physical record');
  GotoXY(5, 10);
  writeln('Call : function LogPhysicalRecord(LogMode      : Byte;');
  writeln('                                  FileHandle   : Word;');
  writeln('                                  StartOffset, ');
  writeln('                                  LockLength   : LongInt;');
  writeln('                                  TimeOutTicks : Word):Byte;');
  writeln('      Request : Log mode     = log mode (see source)');
  writeln('                FileHandle   = File-handle to log' );
  writeln('                StartOffset  = Start offset in file');
  writeln('                LockLength   = length to lock');
  writeln('                TimeOutTicks = Time out ticks',^j^m);
  writeln('      Reply : Error-code (see NvMain)');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 3);
  Write(' Filename         : ');
  readln(FileName);
  FileHandle := OpenExistingFile(FileName, 0);
  GotoXY(10, 5);
  Write(' Lock Mode (0, 1, 3) ? : ');
  readln(LockMode);
  GotoXY(10, 6);
  Write(' Start-offset                 : ');
  readln(StartOffset);
  GotoXY(10, 7);
  Write(' Lock-length                  : ');
  readln(LockLength);
  GotoXY(10, 8);
  Write(' Timeout in ticks             : ');
  readln(TimeOutTicks);
  ClrScr;
  GotoXY(10, 4);
  Result := LogPhysicalRecord(LockMode,
                              FileHandle,
                              StartOffset,
                              LockLength,
                              TimeOutTicks);
  ClrScr;
  GotoXY(10, 4);
  write(' Result   : $' , Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync D
 }

procedure SyncD;

var
  LogMode      : Byte;
  TimeOutTicks : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Log physical record set');
  GotoXY(5, 8);
  write('Desc : Logs an physical record set');
  GotoXY(5, 10);
  writeln('Call : function LockPhysicalRecordSet(LogMode      : Byte;' );
  writeln('                                      TimeOutTicks : Word):Byte;',^j^m);
  writeln('   Request : LogMode       = log mode (see source)');
  writeln('             TimeOutTicks  = Time out ticks',^j^m);
  writeln('   Reply   : Error-code (see NvMain)');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 3);
  write('       Lock Mode (0, 1, 3) ? : ');
  readln(LogMode);
  GotoXY(10, 4);
  Write(' Timeout in ticks             : ');
  readln(TimeOutTicks);
  ClrScr;
  GotoXY(10, 4);
  Result := LockPhysicalRecordSet(LogMode, TimeOutTicks);

  ClrScr;
  GotoXY(10, 4);
  write(' Result   : $' , Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync E
 }

procedure SyncE;

var
  LogMode      : Byte;
  FileHandle   : Word;
  StartOffset,
  LockLength   : LongInt;
  TimeOutTicks : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Release physical record');
  GotoXY(5, 8);
  write('Desc : Release an physical record');
  GotoXY(5, 10);
  writeln('Call : function ReleasePhysicalRecord(FileHandle   : Word;');
  writeln('                                      StartOffset,');
  writeln('                                      LockLength   : LongInt):Byte;',^j^m);
  writeln('   Request : File handle   = file handle to log');
  writeln('             Start offset  = Start offset in file');
  writeln('             LockLength    = length to log',^j^m);
  writeln('   Reply   : Error-code (see NvMain)');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 3);
  Write(' File handle                  : ');
  readln(FileHandle);
  GotoXY(10, 4);
  Write(' Start offset                 : ');
  readln(StartOffSet);
  GotoXY(10, 5);
  Write(' Lock length                  : ');
  readln(LockLength);
  ClrScr;
  GotoXY(10, 4);
  Result := ReleasePhysicalRecord(FileHandle, StartOffset, LockLength);
  ClrScr;
  GotoXY(10, 4);
  write(' Result   : $' , Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync F
 }

procedure SyncF;

var
  FileHandle   : Word;
  StartOffset,
  LockLength   : LongInt;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Clear physical record');
  GotoXY(5, 8);
  write('Desc : Clears an physical record');
  GotoXY(5, 10);
  writeln('Call :function ClearPhysicalRecord(FileHandle   : Word;');
  writeln('                                   StartOffset,');
  writeln('                                   LockLength   : LongInt):Byte;',^j^m);
  writeln('   Request : File handle   = file handle to log');
  writeln('             Start offset  = Start offset in file');
  writeln('             LockLength    = length to log',^j^m);
  writeln('   Reply   : Error-code (see NvMain)');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 3);
  Write(' File handle                  : ');
  readln(FileHandle);
  GotoXY(10, 6);
  Write(' Start offset                 : ');
  readln(StartOffSet);
  GotoXY(10, 7);
  Write(' Lock length                  : ');
  readln(LockLength);

  ClrScr;
  GotoXY(10, 4);
  Result := ClearPhysicalRecord(FileHandle, StartOffset, LockLength);

  ClrScr;
  GotoXY(10, 4);
  write(' Result   : $' , Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync G
 }

procedure SyncG;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Release physical record set');
  GotoXY(5, 8);
  write('Desc : Releases an physical record set');
  GotoXY(5, 10);
  writeln('Call : procedure ReleasePhysicalRecordSet;');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ReleasePhysicalRecordSet;
  ClrScr;
  GotoXY(10, 4);
  write(' Done !');
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync H
 }

procedure SyncH;

var
  FileHandle   : Word;
  StartOffset,
  LockLength   : LongInt;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Clear physical record set');
  GotoXY(5, 8);
  write('Desc : Clears an physical record set');
  GotoXY(5, 10);
  writeln('Call : procedure ClearPhysicalRecordSet;');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClearPhysicalRecordSet;
  ClrScr;
  GotoXY(10, 4);
  write(' Done !');
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync I
 }

procedure SyncI;

var
  SemaphoreName         : String;
  SemaphoreValue        : Byte;
  OpenCount             : Byte;
  SemaphoreHandle       : LongInt;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Open semaphore');
  GotoXY(5, 8);
  write('Desc : Opens a semaphore for the station');
  GotoXY(5, 10);
  writeln('Call : function OpenSemaphore(SemaphoreName : String;');
  writeln('                              SemaphoreValue : Byte;');
  writeln('                              var OpenCount : Byte;');
  writeln('                              var SemaphoreHandle : LongInt):Byte;', ^j^m);
  writeln('          SemaphoreName   = Name of semaphore');
  writeln('          SemaphoreValue  = Value of semaphore',  ^j^m);
  writeln('Reply   : OpenCount       = Open count of semaphore');
  writeln('          SemaphoreHandle = Semaphore handle');
  writeln('          Error-code (see NvMain) ');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Seamphore name : ');
  readln(SemaphoreName);
  GotoXY(10, 5);
  Write(' Semaphore value : ');
  readln(SemaphoreValue);
  ClrScr;
  GotoXY(10, 4);
  Result := OpenSemaphore(SemaphoreName,
                          SemaphoreValue,
                          OpenCount,
                          SemaphoreHandle);
  ClrScr;
  GotoXY(1, 4);
  writeln('      Result           : $', Convert2Hex(Result));
  writeln('      Open count       : ', OpenCount);
  writeln('      Semaphore handle : ', SemaphoreHandle);
  GotoXY(5, 22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync J
 }

procedure SyncJ;

var
  SemaphoreName         : String;
  SemaphoreValue        : Byte;
  OpenCount             : Byte;
  SemaphoreHandle       : LongInt;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Examine semaphore');
  GotoXY(5, 8);
  write('Desc : Examines a semaphore');
  GotoXY(5, 10);
  writeln('Call : function ExamineSemaphore(var SemaphoreValue : Byte;');
  writeln('                                var OpenCount : Byte;');
  writeln('                                SemaphoreHandle : LongInt):Byte;',^j^m);
  writeln('Request   SemaphoreHandle = Handle of semaphore', ^j^m);
  writeln('Reply   : OpenCount       = Open count of semaphore');
  writeln('          SemaphoreValue  = Value of semaphore);');
  writeln('          Error-code (see NvMain) ');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Semaphore handle : ');
  readln(SemaphoreHandle);
  ClrScr;
  GotoXY(10, 4);
  Result := ExamineSemaphore(SemaphoreValue, OpenCount, SemaphoreHandle);
  ClrScr;
  GotoXY(1, 4);
  writeln('      Result           : $', Convert2Hex(Result));
  writeln('      Open count       : ', OpenCount);
  writeln('      Semaphore value  : ', SemaphoreValue);
  GotoXY(5, 22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync K
 }

procedure SyncK;

var
  SemaphoreHandle       : LongInt;
  TimeOutTicks          : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Wait on semaphore');
  GotoXY(5, 8);
  write('Desc : Waits for the semaphore');
  GotoXY(5, 10);
  writeln('Call : function WaitOnSemaphore(TimeOutTicks : Word;');
  writeln('                                SemaphoreHandle : LongInt):Byte;',^j^m);
  writeln('Request:  SemaphoreHandle = Handle of semaphore');
  writeln('          TimeOutTicks    = Time out for waiting', ^j^m);
  writeln('Reply  :  Error-code (see NvMain) ');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Semaphore handle : ');
  readln(SemaphoreHandle);
  GotoXY(10, 5);
  Write(' Time out ticks   : ');
  readln(TimeOutTicks);
  ClrScr;
  GotoXY(10, 4);
  Result := WaitOnSemaphore(TimeOutTicks, SemaphoreHandle);
  ClrScr;
  GotoXY(1, 4);
  writeln('      Result           : $', Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync L
 }

procedure SyncL;

var
  SemaphoreHandle       : LongInt;
  TimeOutTicks          : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Signal semaphore');
  GotoXY(5, 8);
  write('Desc : Signals an semaphore');
  GotoXY(5, 10);
  writeln('Call : function SignalSemaphore(SemaphoreHandle : LongInt):Byte;',^j^m);
  writeln('Request:  SemaphoreHandle = Handle of semaphore',^j^m);
  writeln('Reply  :  Error-code (see NvMain) ');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Semaphore handle : ');
  readln(SemaphoreHandle);
  ClrScr;
  GotoXY(10, 4);
  Result := SignalSemaphore(SemaphoreHandle);
  ClrScr;
  GotoXY(1, 4);
  writeln('      Result           : $', Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync M
 }

procedure SyncM;

var
  SemaphoreHandle       : LongInt;
  TimeOutTicks          : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Close semaphore');
  GotoXY(5, 8);
  write('Desc : Closes an semaphore');
  GotoXY(5, 10);
  writeln('Call : function CloseSemaphore(SemaphoreHandle : LongInt):Byte;',^j^m);
  writeln('Request:  SemaphoreHandle = Handle of semaphore');
  writeln('          TimeOutTicks    = Time out for waiting', ^j^m);
  writeln('Reply  :  Error-code (see NvMain) ');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Semaphore handle : ');
  readln(SemaphoreHandle);
  ClrScr;
  GotoXY(10, 4);
  Result := CloseSemaphore(SemaphoreHandle);
  ClrScr;
  GotoXY(1, 4);
  writeln('      Result           : $', Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync N
 }

procedure SyncN;

var
  Conn                : Byte;
  ConnectionSemaphore : tConnectionSemaphore;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get connection`s semaphore');
  GotoXY(5,8);
  write('Desc : Gets the semaphore of a station');
  GotoXY(1, 10);
  writeln(' Call : function GetConnectionSemaphore(var ConnectionSemaphore : tConnectionSemaphore;');
  writeln('                                        Conn : Byte):Byte;',^j^m);
  writeln('    Request : Conn : connection-no',^j^m);
  writeln('    Reply : ConnectionSemaphore-record and error-code (see NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Connection-number         : ');
  readln(Conn);
  ClrScr;
  ConnectionSemaphore.NextReqRecord := 0;
  Result := GetConnectionSemaphore(ConnectionSemaphore, Conn);
  GotoXY(10, 3);
  write(' Result  : $', Convert2Hex(Result));
  for i := 1 to ConnectionSemaphore.NoOfSemaphores do
  begin
    with ConnectionSemaphore do
    begin
      GotoXY(1, 4);
      writeln('        Record         : ', i);
      writeln('        Open count     : ', SemaphoreInfoRec[i].OpenCount);
      writeln('        Semaphore val. : ', SemaphoreInfoRec[i].SemaphoreValue);
      writeln('        Task-no.       : ', SemaphoreInfoRec[i].TaskNumber);
      writeln('        Name           : ', SemaphoreInfoRec[i].SemaphoreName);
    end;
    GotoXY(5,22);
    write(' Press Key to continue ');
    Input := UpCase(ReadKey);
    ClrScr;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync O
 }

procedure SyncO;

var
  SemaphoreInfo : tSemaphoreInformation;
  SemaphoreName : String;
  Conn          : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get semaphore information');
  GotoXY(5,8);
  write('Desc : Gets various information about semaphores');
  GotoXY(1, 10);
  writeln(' Call : function GetSemaphoreInfo(var SemaphoreInfo : tSemaphoreInformation;');
  writeln('                                   SemaphoreName : String;');
  writeln('                                   Conn : Byte):Byte;',^j^m);
  writeln('    Request : Conn          : connection-no');
  writeln('              SemaphoreName : Name of semaphore',^j^m);
  writeln('    Reply : SemaphoreInfo-record and error-code (see NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Connection-number         : ');
  readln(Conn);
  GotoXY(10,5);
  write(' Semaphore name            : ');
  readln(SemaphoreName);
  ClrScr;
  SemaphoreInfo.NextReqRecord := 0;
  Result := GetSemaphoreInfo(SemaphoreInfo, SemaphoreName, Conn);

  GotoXY(1, 3);
  writeln('    Result          : $', Convert2Hex(Result));
  writeln('    Open count      : ', SemaphoreInfo.OpenCount);
  writeln('    Semaphore value : ', SemaphoreInfo.SemaphoreValue);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
  ClrScr;
  for i := 1 to SemaphoreInfo.NoOfRecords do
  begin
    with SemaphoreInfo do
    begin
      GotoXY(1, 4);
      writeln('        Record         : ', i);
      writeln('        Conn-no.       : ', SemaphoreInfoRec[i].ConnNo);
      writeln('        Task number    : ', SemaphoreInfoRec[i].TaskNumber);
    end;
    GotoXY(5,22);
    write(' Press Key to continue ');
    Input := UpCase(ReadKey);
    ClrScr;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync P
 }

procedure SyncP;

var
  LogMode      : Byte;
  TimeOutTicks : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Clear file set');
  GotoXY(5, 8);
  write('Desc : Clears a file set');
  GotoXY(5, 10);
  writeln('Call : procedure ClearFileSet;');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  ClearFileSet;
  GotoXY(10, 4);
  write(' Done !');
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync Q
 }

procedure SyncQ;

var
  LogMode      : Byte;
  TimeOutTicks : Word;
  RecordName     : String;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Log logical record');
  GotoXY(5, 8);
  write('Desc : Logs an logical record');
  GotoXY(5, 10);
  writeln('Call : function LogLogicalRecord(LogicalRecord : String;');
  writeln('                                 LogMode : Byte;');
  writeln('                                 TimeOutTicks : Word):Byte;');
  writeln('      Request : LogicalRecord = Logical record name');
  writeln('                LogMode       = Log mode (see source)');
  writeln('                TimeOutTicks = Time out ticks',^j^m);
  writeln('      Reply : Error-code (see NvMain)');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 3);
  Write(' Logical record name : ');
  readln(RecordName);
  GotoXY(10, 4);
  Write(' Log Mode (0, 1, 3) ? : ');
  readln(LogMode);
  GotoXY(10, 5);
  Write(' Timeout in ticks             : ');
  readln(TimeOutTicks);
  ClrScr;
  GotoXY(10, 4);
  Result := LogLogicalRecord(RecordName, LogMode, TimeOutTicks);
  ClrScr;
  GotoXY(10, 4);
  write(' Result   : $' , Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync R
 }

procedure SyncR;

var
  LogMode      : Byte;
  TimeOutTicks : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Log logical record set');
  GotoXY(5, 8);
  write('Desc : Logs an logical record set');
  GotoXY(5, 10);
  writeln('Call : function LockLogicalRecordSet(LogMode : Byte;');
  writeln('                                     TimeOutTicks : Word):Byte;');
  writeln('   Request : LogMode       = log mode (see source)');
  writeln('             TimeOutTicks  = Time out ticks',^j^m);
  writeln('   Reply   : Error-code (see NvMain)');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 3);
  write('       Log Mode (0, 1, 3) ? : ');
  readln(LogMode);
  GotoXY(10, 4);
  Write(' Timeout in ticks             : ');
  readln(TimeOutTicks);
  Result := LockLogicalRecordSet(LogMode, TimeOutTicks);
  ClrScr;
  GotoXY(10, 4);
  write(' Result   : $' , Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync S
 }

procedure SyncS;

var
  LogMode      : Byte;
  TimeOutTicks : Word;
  RecordName     : String;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Release logical record');
  GotoXY(5, 8);
  write('Desc : Releases an logical record');
  GotoXY(5, 10);
  writeln('Call : function ReleaseLogicalRecord(LogicalRecord : String):Byte;',^j^m);
  writeln('      Request : LogicalRecord = Logical record name',^j^m);
  writeln('      Reply : Error-code (see NvMain)');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 3);
  Write(' Logical record name : ');
  readln(RecordName);
  Result := ReleaseLogicalRecord(RecordName);
  ClrScr;
  GotoXY(10, 4);
  write(' Result   : $' , Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync T
 }

procedure SyncT;

var
  LogMode      : Byte;
  TimeOutTicks : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Release logical record set');
  GotoXY(5, 8);
  write('Desc : Release an logical record set');
  GotoXY(5, 10);
  writeln('Call : procedure ReleaseLogicalRecordSet;');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ReleaseLogicalRecordSet;
  ClrScr;
  GotoXY(10, 4);
  write(' Done !');
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync U
 }

procedure SyncU;

var
  LogMode      : Byte;
  TimeOutTicks : Word;
  RecordName     : String;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Clear logical record');
  GotoXY(5, 8);
  write('Desc : Clears an logical record');
  GotoXY(5, 10);
  writeln('Call : function ClearLogicalRecord(LogicalRecord : String):Byte;',^j^m);
  writeln('      Request : LogicalRecord = Logical record name',^j^m);
  writeln('      Reply : Error-code (see NvMain)');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 3);
  Write(' Logical record name : ');
  readln(RecordName);
  Result := ClearLogicalRecord(RecordName);
  ClrScr;
  GotoXY(10, 4);
  write(' Result   : $' , Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync V
 }

procedure SyncV;

var
  LogMode      : Byte;
  TimeOutTicks : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Clear logical record set');
  GotoXY(5, 8);
  write('Desc : Clears an logical record set');
  GotoXY(5, 10);
  writeln('Call : procedure ClearLogicalRecordSet;');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClearLogicalRecordSet;
  ClrScr;
  GotoXY(10, 4);
  write(' Done !');
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync W
 }

procedure SyncW;

var
  FilePath     : String;
  TimeoutLimit : Word;
  LogMode      : Byte;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Log file');
  GotoXY(5, 8);
  write('Desc : Logs an file');
  GotoXY(1, 10);
  writeln('       Call : function LogFile(FilePath : String;');
  writeln('                               TimeoutLimit : Word;');
  writeln('                               LogMode : Byte):Byte;');
  writeln('      Request : FilePath     = path to file');
  writeln('                TimeOutLimit = Time out for logging');
  writeln('                LogMode      = Log mode (see source)');
  writeln('      Reply : Error-code (see NvMain)');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 3);
  Write(' Logical file path   : ');
  readln(FilePath);
  GotoXY(10, 4);
  Write(' Time out limit      : ');
  readln(TimeOutLimit);
  GotoXY(10, 5);
  Write(' Log mode            : ');
  readln(LogMode);

  Result := LogFile(FilePath, TimeoutLimit, LogMode);
  ClrScr;
  GotoXY(10, 4);
  write(' Result   : $' , Convert2Hex(Result));
  GotoXY(5, 22);

  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync 1
 }

procedure Sync1;

var
  FilePath     : String;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Release file');
  GotoXY(5, 8);
  write('Desc : Releases an file');
  GotoXY(1, 10);
  writeln('       Call : function ReleaseFile(FilePath : String):Byte;',^j^m);
  writeln('      Request : FilePath     = path to file',^j^m);
  writeln('      Reply : Error-code (see NvMain)');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 3);
  write(' Logical file path   : ');
  readln(FilePath);
  Result := ReleaseFile(FilePath);
  ClrScr;
  GotoXY(10, 4);
  write(' Result   : $' , Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync 2
 }

procedure Sync2;

var
  FilePath     : String;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Clear file');
  GotoXY(5, 8);
  write('Desc : Clears an file');
  GotoXY(1, 10);
  writeln('       Call : function ClearFile(FilePath : String):Byte;');
  writeln('      Request : FilePath     = path to file',^j^m);
  writeln('      Reply : Error-code (see NvMain)');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 3);
  write(' Logical file path   : ');
  readln(FilePath);
  Result := ClearFile(FilePath);
  ClrScr;
  GotoXY(10, 4);
  write(' Result   : $' , Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync 3
 }

procedure Sync3;

var
  TimeOutLimit : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Lock file set');
  GotoXY(5, 8);
  write('Desc : Locks an file set');
  GotoXY(1, 10);
  writeln('       Call : function LockFileSet(TimeOutLimit : Word):Byte;',^j^m);
  writeln('      Request : TimeOutLimit = Limit for locking',^j^m);
  writeln('      Reply : Error-code (see NvMain)');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 3);
  write(' Time out limit  : ');
  readln(TimeOutLimit);
  Result := LockFileSet(TimeOutLimit);
  ClrScr;
  GotoXY(10, 4);
  write(' Result   : $' , Convert2Hex(Result));
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync 4
 }

procedure Sync4;

var
  FilePath     : String;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Release file set');
  GotoXY(5, 8);
  write('Desc : Releases a file set');
  GotoXY(1, 10);
  writeln('       Call : procedure ReleaseFileSet;');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  ReleaseFileSet;
  GotoXY(10, 4);
  write(' Done !');
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Sync 5
 }

procedure Sync5;

var
  FileName : String;
  AccessMode : Byte;
  Handle   : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell File Unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Open existing File');
  GotoXY(5, 8);
  write('Desc : Opens an existing File and returns Filehandle');
  GotoXY(2, 10);
  write('Call : function OpenExistingFile(FileName : String;AccessMode : Byte):Word;');
  GotoXY(5, 12);
  write('Request : Filename            = Path and Name of File');
  GotoXY(5, 13);
  write('          AccessMode          = Access Mode for File (see Nvmain)');
  GotoXY(5, 15);
  write('Reply   : Handle or Error-Code (See NvMain Extended Errors');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Filename        : ');
  readln(FileName);
  GotoXY(10, 5);
  Write(' Access-Mode (0 for example) : ');
  readln(AccessMode);
  Handle := OpenExistingFile(FileName, AccessMode);
  case Handle of
    Invalidfunction     :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' Invalid function');
     end;
    FileNotFound        :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' File not found !');
    end;
    PathNotFound        :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' Path not found');
    end;
    ToManyOpenFiles     :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' To many open Files');
    end;
    AccessCodeInvalid   :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' Access Code invalid');
    end;
  else
    ClrScr;
    GotoXY(10, 4);
    write(' Successfull Handle ', Handle);
  end;
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;


{
                  main program
 }

begin
  repeat
    ClrScr;
    GotoXY(10, 1);
    write(' Sample program for synchronization unit (C) 1993 by C.Weller');
    {$IFDEF WINDOWS}
    GotoXY(25, 2);
    write(' Running under Windows');
    {$ELSE}
      {$IFDEF DPMI}
      GotoXY(17, 2);
      write(' Protected Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ELSE}
      GotoXY(17, 2);
      write(' Real Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ENDIF}
    {$ENDIF}
    GotoXY(5, 4);
    write('A : Get lock mode,##');
    GotoXY(5, 5);
    write('B : Set lock mode,##');
    GotoXY(5, 6);
    write('C : Log physical record,##');
    GotoXY(5, 7);
    write('D : Log physical record set,##');
    GotoXY(5, 8);
    write('E : Release physical record,##');
    GotoXY(5, 9);
    write('F : Clear physical record,##');
    GotoXY(5, 10);
    write('G : Release physical record set,##');
    GotoXY(5, 11);
    write('H : Clear physical record set,##');
    GotoXY(5, 12);
    write('I : Open semaphore');
    GotoXY(5, 13);
    write('J : Examine semaphore');
    GotoXY(5, 14);
    write('K : Wait on semaphore');
    GotoXY(5, 15);
    write('L : Signal semaphore');
    GotoXY(5, 16);
    write('M : Close semaphore');
    GotoXY(5, 17);
    write('N : Get connection`s semaphore,##');
    GotoXY(5, 18);
    write('O : Get semaphore info,##');
    GotoXY(40, 4);
    write('P : Clear file set,##');
    GotoXY(40, 5);
    write('Q : Log logical record,##');
    GotoXY(40, 6);
    write('R : Log logical record set,##');
    GotoXY(40, 7);
    write('S : Release logical set,##');
    GotoXY(40, 8);
    write('T : Release logical record set,##');
    GotoXY(40, 9);
    write('U : Clear logical record,##');
    GotoXY(40, 10);
    write('V : Clear logical record set,##');
    GotoXY(40, 11);
    write('W : Log file,##');
    GotoXY(40, 12);
    write('1 : Release file,##');
    GotoXY(40, 13);
    write('2 : Clear file,##');
    GotoXY(40, 14);
    write('3 : Lock file set,##');
    GotoXY(40, 15);
    write('4 : Release file set,##');
    GotoXY(40, 16);
    write('5 : Open file,##');
    GotoXY(20, 20);
    write('X : exit program, choose function :');
    Input := UpCase(ReadKey);
    case Input of
      'A' : SyncA;
      'B' : SyncB;
      'C' : SyncC;
      'D' : SyncD;
      'E' : SyncE;
      'F' : SyncF;
      'G' : SyncG;
      'H' : SyncH;
      'I' : SyncI;
      'J' : SyncJ;
      'K' : SyncK;
      'L' : SyncL;
      'M' : SyncM;
      'N' : SyncN;
      'O' : SyncO;
      'P' : SyncP;
      'Q' : SyncQ;
      'R' : SyncR;
      'S' : SyncS;
      'T' : SyncT;
      'U' : SyncU;
      'V' : SyncV;
      'W' : SyncW;
      'X' : halt(0);
      '1' : Sync1;
      '2' : Sync2;
      '3' : Sync3;
      '4' : Sync4;
      '5' : Sync5;
    end;
  until false;
end.
