 {ͻ
   Prog.: WsSampl1                               Target Platforms :      
   Desc : Sample program for workstation         - real Mode             
          services part II                       - protected Mode        
                                                 - windows Mode          
   (C) 1994 by Christoph Weller 22/03/94                                 
  ͼ}

program WsSampl1;

uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  NvSync,
  NvMain,
  NvFile,
  NvWorkst;

{
              VAR declarations
 }

var
  Result        : Byte;
  Input         : Char;
  i,j           : Integer;

{
              procedure Workstation A
 }

procedure WorkstationA;

var
  Conn      : Byte;
  OpenFiles : tOpenFiles;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get connection`s open files');
  GotoXY(1,8);
  writeln('     Desc : Gets the open files of a station');
  writeln('     Call : function GetConnectionOpenFiles(var OpenFiles : tOpenFiles; ');
  writeln('                                            Conn : Byte):Byte;',^j^m);
  writeln('     Request : Conn : connection-no',^j^m);
  writeln('     Reply : OpenFile-record and error-code (see NvMain)',^j^m);
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Connection-number         : ');
  readln(Conn);
  ClrScr;
  OpenFiles.NextReqRecord := 0;
  Result := GetConnectionOpenFiles(OpenFiles, Conn);
  GotoXY(10, 3);
  write(' Result  : $', Convert2Hex(Result));
  for i := 1 to OpenFiles.NoOfRecords do
  begin
    with OpenFiles do
    begin
      GotoXY(1, 4);
      writeln('          Record   : ', i);
      writeln('          Task-number  : ', FileInfoRecords[i].TaskNumber);
      writeln('          Lock type    : ', FileInfoRecords[i].LockType);
      writeln('          Access flag  : ', FileInfoRecords[i].AccessFlag);
      writeln('          Lock flag    : ', FileInfoRecords[i].LockFlag);
      writeln('          Volume-no    : ', FileInfoRecords[i].VolumeNo);
      writeln('          Parent-entry : ', FileInfoRecords[i].ParentEntry);
      writeln('          Dir-entry    : ', FileInfoRecords[i].DirectoryEntry);
      writeln('          Name space   : ', FileInfoRecords[i].NameSpace);
      writeln('          File name    : ', FileInfoRecords[i].FileName);
    end;
    GotoXY(5,22);
    write(' Press Key to continue ');
    Input := UpCase(ReadKey);
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Workstation B
 }

procedure WorkstationB;

var
  ServerConn      : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Attach to file server');
  GotoXY(1,8);
  writeln('     Desc : Attaches the station to a file server');
  writeln('     Call : function AttachToServer(ServerConn : Byte):byte;',^j^m);
  writeln('     Request : ServerConn : server connection id',^j^m);
  writeln('     Reply : Error-code (see NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Server connection-number         : ');
  readln(ServerConn);
  ClrScr;
  Result := AttachToServer(ServerConn);
  GotoXY(10, 3);
  write(' Result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Workstation C
 }

procedure WorkstationC;

var
  ServerConn      : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Detach to file server');
  GotoXY(1,8);
  writeln('     Desc : Detaches the station from the file server');
  writeln('     Call : function DetachToServer(ServerConn : Byte):byte;',^j^m);
  writeln('     Request : ServerConn : server connection id',^j^m);
  writeln('     Reply : Error-code (see NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Server connection-number         : ');
  readln(ServerConn);
  ClrScr;
  Result := DetachServer(ServerConn);
  GotoXY(10, 3);
  write(' Result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Workstation D
 }

procedure WorkstationD;

var
  ServerConn      : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Logout from file sever');
  GotoXY(1,8);
  writeln('     Desc : Logs the station from the file server');
  writeln('     Call : procedure LogOutFromServer(ServerConn : Byte);',^j^m);
  writeln('     Request : ServerConn : server connection id',^j^m);
  writeln('     Reply : Error-code (see NvMain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Server connection-number         : ');
  readln(ServerConn);
  ClrScr;
  LogOutFromServer(ServerConn);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Workstation E
 }

procedure WorkstationE;

var
  Conn      : Byte;
  Semaphores : tSemaphores;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get connection`s semaphore' );
  GotoXY(1,8);
  writeln('     Desc : Gets the semaphore of a station');
  writeln('     Call : function GetConnectionSemaphore(var Semaphores : tSemaphores;');
  writeln('                                            Conn : Byte):Byte;',^j^m);
  writeln('     Request : Conn : connection-no',^j^m);
  writeln('     Reply : Semaphore-record and error-code (see NvMain)',^j^m);
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Connection-number         : ');
  readln(Conn);
  ClrScr;
  Semaphores.NextReqRecord := 0;
  Result := GetConnectionSemaphore(Semaphores, Conn);

  GotoXY(10, 3);
  write(' Result  : $', Convert2Hex(Result));
  for i := 1 to Semaphores.NoOfRecords do
  begin
    with Semaphores do
    begin
      ClrScr;
      GotoXY(1, 4);
      writeln('          Record                 : ', i);
      writeln('          Open count             : ', SemaphoreInfoRecs[i].OpenCount);
      writeln('          Semaphore value        : ', SemaphoreInfoRecs[i].SemaphoreValue);
      writeln('          Task number            : ', SemaphoreInfoRecs[i].TaskNumber);
      writeln('          Semaphore-name         : ', SemaphoreInfoRecs[i].SemaphoreName);
    end;
    GotoXY(5,22);
    write(' Press Key to continue ');
    Input := UpCase(ReadKey);
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Workstation F
 }

procedure WorkstationF;

var
  Conn      : Byte;
  TaskInfo  : tTaskInfo;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get connection`s task info' );
  GotoXY(1,8);
  writeln('     Desc : Gets infos about the stations tasks');
  writeln('     Call : function GetConnectionTaskInfo(var TaskInfo : tTaskInfo;' );
  writeln('                                            Conn : Byte):Byte;',^j^m);
  writeln('     Request : Conn : connection-no',^j^m);
  writeln('     Reply : Task-record and error-code (see NvMain)',^j^m);
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Connection-number         : ');
  readln(Conn);
  ClrScr;
  Result := GetConnectionTaskInfo(TaskInfo, Conn);

  GotoXY(1, 3);
  writeln('             Result  : $', Convert2Hex(Result),^j^m);
  writeln('             Connection lock status : ', TaskInfo.ConLockStatus, ^j^m);
  writeln(' Task-info status information. Note : Not all informations are available,');
  writeln(' it occcurs to the connection lock status (see source)',^j^m);
  with TaskInfo.StatusInformation do
  begin
    writeln('             Waiting task no        : ', WaitingTaskNo);
    writeln('             Begin adress           : ', BeginAdress);
    writeln('             End adress             : ', EndAdress);
    writeln('             Volume no              : ', VolumeNo);
    writeln('             Name space             : ', NameSpace);
    writeln('             File name              : ', FileName);
    writeln('             Directory entry        : ', DirectoryEntry);
    writeln('             Reocord name           : ', RecordName);
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
  ClrScr;
  GotoXY(1, 3);
  writeln('             No of records          : ', TaskInfo.NoOfRecords);
  for i := 1 to TaskInfo.NoOfRecords do
  begin
    with TaskInfo do
    begin
      ClrScr;
      GotoXY(1, 4);
      writeln('          Record                 : ', i);
      writeln('          Task number            : ', TaskInfos[i].TaskNumber);
      write('          Task                   : ');
      for j := 1 to 3 do write(TaskInfos[i].Task[j]);
      writeln;
      writeln('          Task state             : ', TaskInfos[i].TaskState);
    end;
    GotoXY(5,22);
    write(' Press Key to continue ');
    Input := UpCase(ReadKey);
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Workstation G
 }

procedure WorkstationG;

var
  UsageInfo     : tFileUsageInfo;
  ForkType     : Byte;
  VolumeNo     : Byte;
  FileEntryId  : LongInt;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get connection`s using a file' );
  GotoXY(1,8);
  writeln('     Desc : Gets infos about the stations using an file');
  writeln('     Call : function GetConnectionUsingAFile(var UsageInfo : tFileUsageInfo;');
  writeln('                                             ForkType : Byte;');
  writeln('                                             VolumeNo : Byte;');
  writeln('                                             FileEntryId : LongInt):Byte;');
  writeln('     Request : UsageInfo.NextReqRec = Record no (first call 1)', ^j^m);
  writeln('     Reply : Task-record and error-code (see NvMain)',^j^m);
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  write(' Fork-type        : ');
  readln(ForkType);
  GotoXY(10, 5);
  write(' Volume-no        : ');
  readln(VolumeNo);
  GotoXY(10, 6);
  write(' File-entry id    : ');
  readln(FileEntryId);

  ClrScr;
  UsageInfo.NextReqRecord := 0;
  Result := GetConnectionUsingAFile(UsageInfo,
                                    ForkType,
                                    VolumeNo,
                                    FileEntryId);

  GotoXY(1, 3);
  writeln('             Result  : $', Convert2Hex(Result),^j^m);
  with UsageInfo do
  begin
    writeln('             Use count              : ', UseCount);
    writeln('             Open count             : ', OpenCount);
    writeln('             Open for read count    : ', OpenForReadCount);
    writeln('             Deny read count        : ', DenyReadCount);
    writeln('             Deny write count       : ', DenyWriteCount);
    writeln('             Lock flag              : ', LockFlag);
    writeln('             Fork count             : ', ForkCount);
  end;
  GotoXY(5,22);
  write(' Press key to continue ');
  Input := UpCase(ReadKey);
  ClrScr;
  for i := 1 to UsageInfo.NoOfRecords do
  begin
    with UsageInfo do
    begin
      GotoXY(1, 3);
      writeln('             Task number            : ', UsageInfoRecs[i].TaskNumber);
      writeln('             Lock type              : ', UsageInfoRecs[i].LockType);
      writeln('             Access flag            : ', UsageInfoRecs[i].AccessFlag);
      writeln('             Lock flag              : ', UsageInfoRecs[i].LockFlag);
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
              procedure Workstation S
 }

procedure WorkstationS;

var
  FileName : String;
  AccessMode : Byte;
  Handle   : Word;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell file unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Open existing File');
  GotoXY(5, 8);
  write('Desc : Opens an existing file and returns filehandle');
  GotoXY(2, 10);
  write('Call : function OpenExistingFile(FileName : String;AccessMode : Byte):Word;');
  GotoXY(5, 12);
  write('Request : Filename            = Path and name of file');
  GotoXY(5, 13);
  write('          AccessMode          = Access mode for file (see Nvmain)');
  GotoXY(5, 15);
  write('Reply   : Handle or error-code (See NvMain)');
  GotoXY(5, 22);
  write(' Press key to start function (A to abort)');
  Input := UpCase(Readkey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Filename        : ');
  readln(FileName);
  GotoXY(10, 5);
  Write(' Access-Mode (0 for example) : ');
  readln(AccessMode);
  Handle := OpenExistingFile(FileName, AccessMode);
  case Handle of
    Invalidfunction     :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' Invalid function');
     end;
    FileNotFound        :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' File not found !');
    end;
    PathNotFound        :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' Path not found');
    end;
    ToManyOpenFiles     :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' To many open Files');
    end;
    AccessCodeInvalid   :
    begin
      ClrScr;
      GotoXY(10, 4);
      write(' Access Code invalid');
    end;
  else
    ClrScr;
    GotoXY(10, 4);
    write(' Successfull Handle ', Handle);
  end;
  GotoXY(5, 22);
  write(' Press key to continue ');
  Input := UpCase(Readkey);
end;

{
              procedure Workstation T
 }

procedure WorkstationT;

var
  SemaphoreName         : String;
  SemaphoreValue        : Byte;
  OpenCount             : Byte;
  SemaphoreHandle       : LongInt;

begin
  ClrScr;
  GotoXY(17, 4);
  write(' Novell synchronization unit (C) 1993 by C.Weller');
  GotoXY(25, 6);
  write('Open semaphore');
  GotoXY(5, 8);
  write('Desc : Opens a semaphore for the station');
  GotoXY(5, 10);
  writeln('Call : function OpenSemaphore(SemaphoreName : String;');
  writeln('                              SemaphoreValue : Byte;');
  writeln('                              var OpenCount : Byte;');
  writeln('                              var SemaphoreHandle : LongInt):Byte;', ^j^m);
  writeln('          SemaphoreName   = Name of semaphore');
  writeln('          SemaphoreValue  = Value of semaphore',  ^j^m);
  writeln('Reply   : OpenCount       = Open count of semaphore');
  writeln('          SemaphoreHandle = Semaphore handle');
  writeln('          Error-code (see NvMain) ');
  GotoXY(5, 22);
  write(' Press Key to start function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10, 4);
  Write(' Seamphore name : ');
  readln(SemaphoreName);
  GotoXY(10, 5);
  Write(' Semaphore value : ');
  readln(SemaphoreValue);
  ClrScr;
  GotoXY(10, 4);
  Result := OpenSemaphore(SemaphoreName,
                          SemaphoreValue,
                          OpenCount,
                          SemaphoreHandle);
  ClrScr;
  GotoXY(1, 4);
  writeln('      Result           : $', Convert2Hex(Result));
  writeln('      Open count       : ', OpenCount);
  writeln('      Semaphore handle : ', SemaphoreHandle);
  GotoXY(5, 22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

(** Workstation Main **)
begin
  repeat
    ClrScr;
    GotoXY(10, 1);
    write(' Sample program for workstation unit II (C) 1993 by C.Weller');
    {$IFDEF WINDOWS}
    GotoXY(25, 2);
    write(' Running under Windows');
    {$ELSE}
      {$IFDEF DPMI}
      GotoXY(17, 2);
      write(' Protected Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ELSE}
      GotoXY(17, 2);
      write(' Real Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ENDIF}
    {$ENDIF}
    GotoXY(5,4);
    write('A : Get connections open files,##');
    GotoXY(5,5);
    write('B : Attach to file server,##');
    GotoXY(5,6);
    write('C : Detach from file server,##');
    GotoXY(5,7);
    write('D : Logout from file server,##');
    GotoXY(5,8);
    write('E : Get connections semaphore,##');
    GotoXY(5,9);
    write('F : Get connections task info,##');
    GotoXY(5,10);
    write('G : Get connections using a file,##');
    GotoXY(5,11);
    write('H : ');
    GotoXY(5,12);
    write('I : ');
    GotoXY(5,13);
    write('J : ');
    GotoXY(5,14);
    write('K : ');
    GotoXY(5,15);
    write('L : ');
    GotoXY(5,16);
    write('M : ');
    GotoXY(5,17);
    write('N : ');
    GotoXY(5,18);
    write('O : ');
    GotoXY(5,19);
    write('P : ');
    GotoXY(45,4);
    write('Q : ');
    GotoXY(45,5);
    write('R : ');
    GotoXY(45,6);
    write('S : Open a file (for menu G)');
    GotoXY(45,7);
    write('T : Open semaphore (for menu E)');
    GotoXY(20,21);
    write('0 : Exit to main, X : Exit program');
    GotoXY(20,22);
    write('Choose Function :');
    Input := UpCase(ReadKey);
    case Input of
      'A' : WorkstationA;
      'B' : WorkstationB;
      'C' : WorkstationC;
      'D' : WorkstationD;
      'E' : WorkstationE;
      'F' : WorkstationF;
      'G' : WorkstationG;
      (*
      'H' : WorkstationH;
      'I' : WorkstationI;
      'J' : WorkstationJ;
      'K' : WorkstationK;
      'L' : WorkstationL;
      'M' : WorkstationM;
      'N' : WorkstationN;
      'O' : WorkstationO;
      'P' : WorkstationP;
      'Q' : WorkstationQ;
      'R' : WorkstationR;
      *)
      'S' : WorkstationS;
      'T' : WorkstationT;
      'X' : halt(0);
    end;
  until false;
end.
