 {ͻ
   Prog.: WsSample                               Target Platforms :      
   Desc : Sample program for workstation         - real Mode             
          services part I                        - protected Mode        
                                                 - windows Mode          
   (C) 1994 by Christoph Weller 22/03/94                                 
  ͼ}

program WsSample;

uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  NvMain,
  NvWorkst;

{
              VAR declarations
 }

var
  Result        : Byte;
  Input         : Char;
  i,j           : Integer;

{
             procedure Workstation A
 }

procedure WorkstationA;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Console Privileges ');
  GotoXY(5,8);
  write('Desc : Gets the Console Privilege Status of the WS');
  GotoXY(5,10);
  write('Call : function ConsolePrivilege:boolean;');
  GotoXY(5,12);
  write('Reply : true if the WS has Console Privileges');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  if ConsolePrivilege then
  begin
    GotoXY(10,4);
    write('WS has Console Privileges');
  end
  else
  begin
    GotoXY(10,4);
    write('WS has no Console Rights');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation B
 }

procedure WorkstationB;

var
  DisableStr : Char;
  Enable     : boolean;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Set EOJ Status of WS');
  GotoXY(5,8);
  write('Desc : Sets the End of Job Status of the WS');
  GotoXY(5,10);
  write('Call : procedure SetEOJ(Enable : boolean);');
  GotoXY(5,12);
  write('Request : Enable enables or disables the EOJ Status');
  GotoXY(5,14);
  write('Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Disable or Enable (D/E) ? : ');
  readln(DisableStr);
  if StupCase(DisableStr) = 'E' then
    Enable := true
  else
    Enable := false;
  GotoXY(5,22);
  SetEOJ(Enable);
  GotoXY(10,6);
  write(' Done ! ');
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation C
 }

procedure WorkstationC;

var
  OnlyCurrStr : Char;
  OnlyCurr    : boolean;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Workstation End of Job');
  GotoXY(5,8);
  write('Desc : Makes an End of Job');
  GotoXY(5,10);
  write('Call : function EOJ(OnlyCurrJob : boolean):boolean;');
  GotoXY(5,12);
  write('Request : OnlyCurrJob if true only the Current Job will be EOJ');
  GotoXY(5,14);
  write('Reply : true if successfull done ');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Only Current Job (Y/N) ? : ');
  readln(OnlyCurrStr);
  if StupCase(OnlyCurrStr) = 'Y' then
    OnlyCurr := true
  else
    OnlyCurr := false;
  if EOJ(OnlyCurr) then
  begin
    ClrScr;
    GotoXY(10,4);
    write('EOJ successfull');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    write('Error during execution');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation D
 }

procedure WorkstationD;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Connection No');
  GotoXY(5,8);
  write('Desc : Gets the Connection-No of the WS');
  GotoXY(5,10);
  write('Call : GetConnectionNo:Byte;');
  GotoXY(5,12);
  write('Reply : Connection-No ');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write('Connection-No : ',GetConnectionNo);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation E
 }

procedure WorkstationE;

var
  NodeAddr : PhyNodeAddress;
  NodeStr  : String;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Physical Station Adress');
  GotoXY(5,8);
  write('Desc : Gets the Physical Station Adress of the WS');
  GotoXY(5,10);
  write('Call : GetPhyNodeAdress(var NodeAdress : PhyNodeAdress);');
  GotoXY(5,12);
  write('Reply : PhyNodeAdress,which is definied in Unit Worksation and ');
  GotoXY(5,13);
  write('        containts an array[1..6] of Byte');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GetPhyNodeAdress(NodeAddr);
  GotoXY(10,4);
  write('Physical Node Adress = ');
  j := 1;
  for i := 1 to 6 do
  begin
    GotoXY(30 + j,4);
    Write(Convert2Hex(NodeAddr[i]));
    inc(j,2);
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation F
 }

procedure WorkstationF;

var
  LoginStatus : boolean;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get preferred Connection ID');
  GotoXY(5,8);
  write('Desc : Gets the preffered Connection Id of the WS');
  GotoXY(5,10);
  write('Call : function GetPreferredConnId:Byte;');
  GotoXY(5,12);
  write('Reply : Preferred Connection Id of File-Server (1-8)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  GotoXY(5,4);
  write('Preferred Connection Id = ',GetPreferredConnId);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation G
 }

procedure WorkstationG;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get default Connection Id');
  GotoXY(5,8);
  write('Desc : Gets the default Connection ID of the WS');
  GotoXY(5,10);
  write('Call : function GetDefaultConnId:Byte;');
  GotoXY(5,12);
  write('Reply : Default Connection Id of the File-Server (1-8) ');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Default Connection Id = ',GetDefaultConnId);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation H
 }

procedure WorkstationH;

var
  ConnId : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Set Preferred Connection ID');
  GotoXY(5,8);
  write('Desc : Sets the preferred Connection ID of the WS');
  GotoXY(5,10);
  write('Call : procedure SetPreferredConnId(ConnId : Byte);');
  GotoXY(5,13);
  write('Request : Connection Id of preferred File-Server (1-8)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' New preferred Connection Id : ');
  readln(ConnId);
  SetPreferredConnId(ConnId);
  ClrScr;
  GotoXY(10,4);
  write(' Done ! ');
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation I
 }

procedure WorkstationI;

var
  ConnId : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Set Primary Connection ID');
  GotoXY(5,8);
  write('Desc : Sets the Primary Connection Id');
  GotoXY(5,10);
  write('Call : procedure SetPrimaryConnId(ConnId : Byte);');
  GotoXY(5,12);
  write('Request : Connection Id of the primaray File-Server (1-8)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' New primary Connection Id : ');
  readln(ConnId);
  SetPrimaryConnId(ConnId);
  ClrScr;
  GotoXY(10,4);
  write(' Done ! ');
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation J
 }

procedure WorkstationJ;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Primary Connection Id');
  GotoXY(5,8);
  write('Desc : Gets the Primary Connection Id of the WS');
  GotoXY(5,10);
  write('Call : function GetPrimaryConnId:Byte;');
  GotoXY(5,12);
  write('Request : Connection Id of Primary File-Server (1-8)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Primary Connection Id : ',GetPrimaryConnId);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation K
 }

procedure WorkstationK;

var
  ConnId : tConnIdTable;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Connection Id');
  GotoXY(5,8);
  write('Desc : Get Connection Id of the WS');
  GotoXY(5,10);
  write('Call : procedure GetConnId(var ConnId : ConnIdTable);');
  GotoXY(5,12);
  write('Reply : ConnId Table,which is definied in Unit Workstation');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GetConnId(ConnId);
  with ConnId do
  begin
    GotoXY(10,4);
    writeln(' In Use Flag                           : ',InUseFlag);
    GotoXY(10,5);
    writeln(' Orders Number assigned to Server(1-8) : ',OrderNo);
    GotoXY(10,6);
    writeln(' File Server Network Adress            : ',NetWorkAddress);
    GotoXY(10,7);
    writeln(' File Server Node Number               : ');
    for i := 1 to 6 do
    begin
      GotoXY(50 + i,7);
      Write(FileServerNodeNo[i]);
    end;
    GotoXY(10,8);
    writeln(' Socket No.                            : ',SocketNo);
    GotoXY(10,9);
    writeln(' Base Time Out                         : ',BaseTimeOut);
    GotoXY(10,10);
    writeln(' Preferred Route Node                  : ',BaseTimeOut);
    for i := 1 to 6 do
    begin
      GotoXY(50 + i,10);
      Write(PreferredRoutNode[i]);
    end;
    GotoXY(10,11);
    writeln(' Packet Sequence No.                   : ',PacketSequenceNo);
    GotoXY(10,12);
    writeln(' Connection No.                        : ',ConnNo);
    GotoXY(10,13);
    writeln(' Connection Status                     : ',ConnStatus);
    GotoXY(10,14);
    writeln(' Max. Recive Timeout                   : ',MaxReciveTimeOut);
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation L
 }

procedure WorkstationL;

var
  Conn       : byte;
  Connection : tConnectionInfo;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Connection Info');
  GotoXY(5,8);
  write('Desc : Gets Info about an Connection');
  GotoXY(5,10);
  write('procedure GetConnInfo(var Connection : tConnectionInfo;Conn : Byte);');
  GotoXY(5,15);
  write('Request : Connection    = Connection-No to get Info');
  GotoXY(5,16);
  write('Reply   : ConnInfo,which is definied in Unit Workstation');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,5);
  Write('Connection-No : ');
  readln(Conn);
  GetConnInfo(Connection,Conn);
  with Connection do
  begin
    GotoXY(10,4);
    writeln(' Object-Id                             : ',ObjectId);
    GotoXY(10,5);
    writeln(' Object-Type                           : ',ObjectType);
    GotoXY(10,6);
    writeln(' Object-Name                           : ',ObjectName);
    GotoXY(10,7);
    writeln(' Login-Day                             : ',LoginTime[7]);
    GotoXY(10,8);
    writeln(' Login-Time                            : ');
    GotoXY(51,8);
    for i := 4 to 6 do
    begin
      Write(LoginTime[i],' ');
    end;
    GotoXY(10,9);
    writeln(' Login-Date                            : ');
    GotoXY(51,9);
    for i := 3 downto 1 do
    begin
      Write(LoginTime[i],' ');
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation M
 }

procedure WorkstationM;

var
  CList      : tConnList;
  ObjectTyp  : Word;
  ObjectName : ObjName;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Object Connections');
  GotoXY(5,8);
  write('Desc : Get the Connections of an Bindery Object');
  GotoXY(5,10);
  write('Call : procedure GetObjectConnection(var CList  : tConnList;);');
  GotoXY(5,11);
  write('                                     ObjectTyp  : Word;');
  GotoXY(5,12);
  write('                                     ObjectName : ObjName);');
  GotoXY(5,12);
  write('Request : ObjectTyp     = Object Typ of Object');
  GotoXY(5,13);
  write('          ObjectName    = Name of Object to get Connections');
  GotoXY(5,14);
  write('Reply   : CList         = Connection List of Object');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,5);
  Write('Object-Typ    : ');
  readln(ObjectTyp);
  GotoXY(10,6);
  Write('Object-Name   : ');
  readln(ObjectName);
  ClrScr;
  GetObjectConnection(CList, ObjectTyp, ObjectName);
  GotoXY(10,4);
  write(' Connection-List : ');
  for i := 1 to CList.ConnNo do
  write(CList.Conns[i],' ');
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation N
 }

procedure WorkstationN;

var
  ConnNo        : Byte;
  NodeAddress   : PhyNodeAddress;
  NetworkNumber : LongInt;
  SocketNumber  : Word;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Internet Address');
  GotoXY(5,8);
  write('Desc : Gets the Internet Address of an Connection-No');
  GotoXY(5,10);
  write('Call : procedure GetInternetAddress(ConnNo            : Byte;');
  GotoXY(5,11);
  write('                                    var NodeAddress   : PhyNodeAddress;');
  GotoXY(5,12);
  write('                                    var NetworkNumber : LongInt;');
  GotoXY(5,13);
  write('                                    var SocketNumber  : Word);');
  GotoXY(5,15);
  write('Request : Connection    = Connection-No to get Info');
  GotoXY(5,16);
  write('Reply   : ConnInfo,which is definied in Unit Workstation');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,5);
  Write('Connection-No : ');
  readln(ConnNo);
  ClrScr;
  GetInternetAddress(ConnNo,NodeAddress,NetworkNumber,SocketNumber);
  GotoXY(10,4);
  write(' NodeAddress       : ');
  for i := 6 downto 1 do write(Convert2Hex(NodeAddress[i]));
  GotoXY(10,5);
  writeln(' Network-Number    : ',NetworkNumber);
  GotoXY(10,6);
  writeln(' Socket-Number     : ',SocketNumber);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation O
 }

procedure WorkstationO;

var
  Shell : tShellInfo;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Shell Version');
  GotoXY(5,8);
  write('Desc : Gets the Network Shell Version');
  GotoXY(5,10);
  write('Call : GetShellVersion(Var Shell : ShellInfo);');
  GotoXY(5,12);
  write('Reply : Shell which is definied in Unit Workstation');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GetShellVersion(Shell);
  with Shell do
  begin
    GotoXY(10,4);
    writeln(' DOS Operating System ?                     : ',DOSOperatingSystem);
    GotoXY(10,5);
    writeln(' Hardware Type 00 = IBM PC,01 = Victor 9000 : ',HardwareType);
    GotoXY(10,6);
    writeln(' Shell Major Version Number                 : ',ShellMajorVer);
    GotoXY(10,7);
    writeln(' Shell Minor Version Number                 : ',ShellMinorVer);
    GotoXY(10,8);
    writeln(' Shell Type (v3.01+) 00 = conventional Mem');
    GotoXY(10,9);
    writeln(' 01 = expanded Mem,02 = extended Mem        : ',ShellType);
    GotoXY(10,10);
    writeln(' Shell Revision                             : ',ShellRevision);
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation P
 }

procedure WorkstationP;

var
   ShellCheckStr : Char;
   Enable        : boolean;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Shell Timer Interrupt Checks');
  GotoXY(5,8);
  write('Desc : Disable or enable Shell Timer Interrupt Checks');
  GotoXY(5,10);
  write('Call : procedure ShellTimerIntrCheck(Enable : boolean);');
  GotoXY(5,12);
  write('Request : Enable,enables or disables Shell Timer Interupt Check');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Enable Shell Timer Interrupt Checks (Y/N) : ');
  readln(ShellCheckStr);
  if UpCase(ShellCheckStr) = 'Y' then
  begin
    Enable := true;
  end
  else
  begin
    Enable := false;
  end;
  ClrScr;
  ShellTimerIntrCheck(Enable);
  GotoXY(10,4);
  Writeln(' Successfull done !');
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation Q
 }

procedure WorkstationQ;

var
  ErrorMode : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Set NWError Mode,still buggy :-( ');
  GotoXY(5,8);
  write('Desc : Sets the Netware Error Mode');
  GotoXY(5,10);
  write('Call : function SetNWErrorMode(ErrorMode : Byte):Byte;');
  GotoXY(5,12);
  write('Request : Error Mode,00h invoke INT 24 on critical I/O errors (default)');
  GotoXY(5,13);
  write('          01h return NetWare extended error code ');
  GotoXY(5,14);
  write('          02h Return Error Code,mapped to standard DOS Error Codes');
  GotoXY(5,16);
  write('Reply   : Previous Error Mode');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Error Mode : ');
  readln(ErrorMode);
  ClrScr;
  GotoXY(10,4);
  Writeln(' Done,Previous Error Mode : ',SetNWErrorMode(ErrorMode));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation R
 }

procedure WorkstationR;

var
  AttachFc  : Byte;
  Attach    : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Server Attach');
  GotoXY(5,8);
  write('Desc : Several Server Attach Functions');
  GotoXY(5,11);
  write('Call : ');
  GotoXY(5,12);
  write('function ServerAttach(AttachFunction : Byte;Attachment : Byte):byte; ');
  GotoXY(5,14);
  write('Request : ');
  GotoXY(5,15);
  write('Attachfunction : 00 : attach to Server,Attachment = Preferred File-Server');
  GotoXY(5,16);
  write('                 01 : deattach from Server,Attachment = Connection Id ');
  GotoXY(5,17);
  write('                 02 : logout from File Server,Attachment = Connection Id ');
  GotoXY(5,19);
  write('Reply : Error-Code as definied in NVMain');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Attach-Function : ');
  readln(AttachFc);
  GotoXY(10,5);
  write(' Attachment : ');
  readln(Attach);
  case ServerAttach(AttachFc,Attach) of
    Successfull        :
    begin
      ClrScr;
      GotoXY(10,4);
      Writeln(' Successfull done ');
    end;
    AlreadyAttToServer     :
    begin
      ClrScr;
      GotoXY(10,4);
      Writeln(' Alread attached to Server');
    end;
    NoMoreServerSlots   :
    begin
      ClrScr;
      GotoXY(10,4);
      Writeln(' No more Server Slots');
    end;
    UnknownFileServer   :
    begin
      ClrScr;
      GotoXY(10,4);
      Writeln(' Unknown File Server');
    end;
    BinderyLocked       :
    begin
      ClrScr;
      GotoXY(10,4);
      Writeln(' Bindery locked');
    end;
    NoResponseFromServer          :
    begin
      ClrScr;
      GotoXY(10,4);
      Writeln(' No respones from Server');
    end;
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation S
 }

procedure WorkstationS;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('System Logout');
  GotoXY(5,8);
  write('Desc : Logout from all Servers');
  GotoXY(5,11);
  write('Call : procedure SystemLogOut;');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  SystemLogout;
  GotoXY(10,4);
  Writeln(' Done ! ');
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation T
 }

procedure WorkstationT;

var
  ObjectTyp     : Word;
  LoginName,
  Password   : String;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('System Logout');
  GotoXY(5,8);
  write('Desc : Login to File-Server');
  GotoXY(5,11);
  write('Call : function UserLogin(ObjectTyp : Word;');
  GotoXY(5,12);
  write('                          LoginName,PassWord : String):boolean;');
  GotoXY(5,14);
  write('Request : Object-typ, login-name, password');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,3);
  Write(' Object-type : ');
  readln(ObjectTyp);
  GotoXY(10,4);
  Write(' User-Name : ');
  readln(LoginName);
  GotoXY(10,5);
  Write(' Password : ');
  readln(Password);
  Result := LoginToFileServer(ObjectTyp,LoginName,PassWord);
  GotoXY(10,4);
  Writeln(' Result  : $', Convert2Hex(Result));
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation U
 }

procedure WorkstationU;

var
  MaxLogLocks,
  MaxPhyLocks : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell Server Unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Get Application Threshold');
  GotoXY(5,8);
  write('Desc : Get the Per-Application Limits on Record-Locks allowed before');
  GotoXY(5,9);
  write('       an implicit Transaction is begun');

  GotoXY(5,11);
  write('Call :');
  GotoXY(5,12);
  write('function GetApplicationTreshold(MaxLogLocks,MaxPhyLocks : Byte):boolean;');
  GotoXY(5,13);
  write('Reply : MaxLogLocks = Maximum Logical Locks,');
  GotoXY(5,14);
  write('        MaxPhyLocks = Maximum Physical Locks');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GetApplicationTreshold(MaxLogLocks,MaxPhyLocks);
  GotoXY(10,4);
  Writeln('Maximum Logical Locks = ',MaxLogLocks);
  GotoXY(10,5);
  Writeln('Maximum Physical Locks = ',MaxPhyLocks);
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation V
 }

procedure WorkstationV;

var
  MaxLogLocks,
  MaxPhyLocks : Byte;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell Server Unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Set Application Threshold');
  GotoXY(5,8);
  write('Desc : Sets the Per-Application Limits on Record-Locks allowed before');
  GotoXY(5,9);
  write('       an implicit Transaction is begun');

  GotoXY(5,11);
  write('Call :');
  GotoXY(5,12);
  write('function SetApplicationTreshold(MaxLogLocks,MaxPhyLocks : Byte):boolean;');
  GotoXY(5,13);
  write('MaxLogLocks = Maximum Logical Locks');
  GotoXY(5,14);
  write('MaxPhyLocks = Maximum Physical Locks');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  write(' Enter Maximum Logical Locks   : ');
  readln(MaxLogLocks);
  GotoXY(10,5);
  write(' Enter Maximum Physical Locks  : ');
  readln(MaxPhyLocks);
  if SetApplicationTreshold(MaxLogLocks,MaxPhyLocks) then
  begin;
    ClrScr;
    GotoXY(10,4);
    Writeln(' Successfull done !');
  end
  else
  begin
    ClrScr;
    GotoXY(10,4);
    Writeln(' Failure during Execution !');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation W
 }

procedure WorkstationW;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Begin Transaction');
  GotoXY(5,8);
  write('Desc : Starts an Transaction');
  GotoXY(5,10);
  write('Call : function BeginTransaction:byte;');
  GotoXY(5,12);
  write('Reply   : Error-Code (See Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  case BeginTransaction of
    Successfull         : write('Successfull !');
    ImplicitTTSactive   : write('Implicit Transaction already activ');
    ExpTTSactive        : write('Explicit Transaction already activ');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation 1
 }

procedure Workstation1;

var
  TransactionNo : LongInt;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('End Transaction');
  GotoXY(5,8);
  write('Desc : Ends an Transaction');
  GotoXY(5,10);
  write('Call : function EndTransaction(var TransactionNo : LongInt):byte;');
  GotoXY(5,12);
  write('Reply   : Transaction-No  = Transaction No which was ended');
  GotoXY(5,13);
  write('          Error-Code (See Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  case EndTransaction(TransactionNo) of
    Successfull         : write('Successfull ! Transaction-Numer =',TransactionNo);
    TTSDisabled         : write('Transaction Tracking disabled');
    TTSEndRecordLock    : write('Transaction ended Records locked');
    NoExpTTSactive      : write('No Transaction activ');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation 2
 }

procedure Workstation2;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Abort Transaction');
  GotoXY(5,8);
  write('Desc : Aborts an Transaction');
  GotoXY(5,10);
  write('Call : function AbortTransaction:byte;');
  GotoXY(5,12);
  write('Reply   : Error-Code (See Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  case AbortTransaction of
    Successfull         : write('Successfull ! Transaction-Numer ');
    TTSDisabled         : write('Transaction Tracking disabled');
    TTSEndRecordLock    : write('Transaction ended Records locked');
    NoExpTTSactive      : write('No Transaction activ');
  end;
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
             procedure Workstation 3
 }

procedure Workstation3;

var
  TransactionNo : LongInt;

begin
  ClrScr;
  GotoXY(17,4);
  write(' Novell workstation unit (C) 1993 by C.Weller');
  GotoXY(25,6);
  write('Transaction-Status');
  GotoXY(5,8);
  write('Desc : Gets the Transaction-Status');
  GotoXY(5,10);
  write('Call : function TransactionStatus(var TransactionNo : LongInt):boolean;');
  GotoXY(5,12);
  write('Reply   : TransactionNo  = activ Transaction-No,0 if none');
  GotoXY(5,13);
  write('          Error-Code (See Nvmain)');
  GotoXY(5,22);
  write(' Press Key to start Function (A to abort)');
  Input := UpCase(ReadKey);
  if Input = 'A' then exit;
  ClrScr;
  GotoXY(10,4);
  if TransactionStatus(TransactionNo) then
    write('Successfull ! Transaction-No = ',TransactionNo)
  else
    write('Not yet written to Disk');
  GotoXY(5,22);
  write(' Press Key to continue ');
  Input := UpCase(ReadKey);
end;

{
                    main program
 }

begin
  repeat
    ClrScr;
    GotoXY(10, 1);
    write(' Sample program for workstation unit (C) 1993 by C.Weller');
    {$IFDEF WINDOWS}
    GotoXY(25, 2);
    write(' Running under Windows');
    {$ELSE}
      {$IFDEF DPMI}
      GotoXY(17, 2);
      write(' Protected Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ELSE}
      GotoXY(17, 2);
      write(' Real Mode Available Memory : ', MemAvail div 1024, ' Kbyte');
      {$ENDIF}
    {$ENDIF}
    GotoXY(5,4);
    write('A : Console privileges,##');
    GotoXY(5,5);
    write('B : Set EOJ status of WS,##');
    GotoXY(5,6);
    write('C : Workstation End of Job,##');
    GotoXY(5,7);
    write('D : Get connection-no,##');
    GotoXY(5,8);
    write('E : Get physical station adress,##');
    GotoXY(5,9);
    write('F : Get preferred connection id,##');
    GotoXY(5,10);
    write('G : Get default connection id,##');
    GotoXY(5,11);
    write('H : Set preferred connection id,##');
    GotoXY(5,12);
    write('I : Set primary connection id,##');
    GotoXY(5,13);
    write('J : Get primary connection id,##');
    GotoXY(5,14);
    write('K : Get connection id,##');
    GotoXY(5,15);
    write('L : Get connection info ');
    GotoXY(5,16);
    write('M : Get object connections,##');
    GotoXY(5,17);
    write('N : Get internet address,##');
    GotoXY(5,18);
    write('O : Get shell version,##');
    GotoXY(5,19);
    write('P : Shell timer interrupt checks,##');
    GotoXY(45,4);
    write('Q : Set NWError mode,##');
    GotoXY(45,5);
    write('R : Server attach');
    GotoXY(45,6);
    write('S : System logout,##');
    GotoXY(45,7);
    write('T : Login to file server,##');
    GotoXY(45,8);
    write('U : Get application threshold,##');
    GotoXY(45,9);
    write('V : Set application threshold,##');
    GotoXY(45,10);
    write('W : Begin transaction,##');
    GotoXY(45,11);
    write('1 : End transaction,##');
    GotoXY(45,12);
    write('2 : Abort transaction,##');
    GotoXY(45,13);
    write('3 : Transaction status,##');
    GotoXY(20,21);
    write('0 : Exit to main, X : Exit program');
    GotoXY(20,22);
    write('Choose Function :');
    Input := UpCase(ReadKey);
    case Input of
      'A' : WorkstationA;
      'B' : WorkstationB;
      'C' : WorkstationC;
      'D' : WorkstationD;
      'E' : WorkstationE;
      'F' : WorkstationF;
      'G' : WorkstationG;
      'H' : WorkstationH;
      'I' : WorkstationI;
      'J' : WorkstationJ;
      'K' : WorkstationK;
      'L' : WorkstationL;
      'M' : WorkstationM;
      'N' : WorkstationN;
      'O' : WorkstationO;
      'P' : WorkstationP;
      'Q' : WorkstationQ;
      'R' : WorkstationR;
      'S' : WorkstationS;
      'T' : WorkstationT;
      'U' : WorkstationU;
      'V' : WorkstationV;
      'W' : WorkstationW;
      '1' : Workstation1;
      '2' : Workstation2;
      '3' : Workstation3;
      'X' : halt(0);
    end;
  until false;
end.
