 {ͻ
   unit : Novell Netware 4.x                    Target Platforms :       
   desc : Novell Netware 4.x functions            - DOS-Real             
                                                  - DOS-Protected        
                                                  - Windows              
   This unit is absolutly untested because                               
   I have no access to a Netware 4.x                                     
   file server !                                                         
                                                                         
   (C) 1994 by Christoph Weller 16/01/93 v1.1                            
  ͼ}

(*

  18.1.1995  : Inserted all possible error-results of a procedure/function
               into the description-header.

  18.1.1995  : inserted the error-results :
               neNDS_NCPNotAvailable   = $FB;
               neBadConnectionNo       = $FD;
               neInvalidDelay          = $01;
               neInvalidBoardFailure   = $FF;
               neInvalidStartNumber    = $F5;
               neFailureInvalidStartNo = $FF;

  18.1.1995  : the following function doesn't return an error-result
               and where therefore changed into procedures :

               - GetExtendedVolumeInfo
               - GetObjectEffRightsForDirEntry
               - ActiveLANBoardList
               - GetCacheInfo
               - GetFileServerInfo
               - GetKnownNetworksInfo
               - GetNetworkRouterInfo
               - GetIPX_SPXInfo
               - GetCPUInfo

*)

unit NV4_x;

interface

{$I NVDEFINE.INC}

uses
  Strings,  { Borland strings unit }
  NvMain;   { Novell main unit     }

{
              CONST declarations
 }

const

  { Netware 4.x specific (n)etwork (e)rror-codes }
  neConnectionAlreadyTemp = $7A; { Connection already temporeary          }
  neConnAlreadLoggedIn    = $7B; { Connection already logged in           }
  neConnNotAuthenticated  = $7C; { Connection not authenticated           }
  neUnknownRequest        = $FB; { Unknown request                        }
  neNDS_NCPNotAvailable   = $FB; { NDS/NCP not available                  }
  neBadConnectionNo       = $FD; { Bad connection no                      }
  neInvalidDelay          = $01; { Invalid delay                          }
  neInvalidBoardFailure   = $FF; { Invalid board failure                  }
  neInvalidStartNumber    = $F5; { Invalid start number                   }
  neFailureInvalidStartNo = $FF; { Failure or invalid start number        }

  { (B)us (t)ype flags for CPU info }
  btISABus                = $00; { Bus type ISA            }
  btMCBus                 = $01; { Bus type Microchannel   }
  btEISABus               = $02; { Bus type EISA           }

  { (NL)M bit flags }
  nlReentrantNLM          = $0001; { Reentrant code can be shared         }
  nlReloadableNLM         = $0002; { NLM reloadable, can be loaded more
                                     than once                            }
  nlSynchronizeNLM        = $0004; { Synchronize, during NLM loading there
                                     are not console-inputs possible      }
  nlPseudoPreemptionNLM   = $0008; { Pseudo preemption, means Netware
                                     watches that the NLM doesn't use
                                     to much CPU cycles                   }

  { (N)LM (t)ypes }
  ntStandardNLM           = $00; { Standard NLM           }
  ntLAN_NLM               = $01; { LAN NLM                }
  ntDiskNLM               = $02; { Disk driver NLM        }
  ntNameSpaceNLM          = $03; { Name space NLM         }
  ntUtilityNLM            = $04; { Utility NLM            }
  ntSFT_IIINLM            = $05; { SFT III NLM            }
  ntOS_NLM                = $06; { OS NLM                 }
  ntPagedHighOS_NLM       = $07; { Paged high OS NLM      }
  ntHostAdapterModulNLM   = $08; { Host adapter modul NLM }
  ntCustomDeviceNLM       = $09; { Custom device NLM      }
  ntFileSystemEngineNLM   = $0A; { File system engine NLM }
  ntRealModeNLM           = $0B; { Real mode NLM          }
  ntHiddenNLM             = $0C; { Hidden NLM             }

  { (C)onnection (s)ervice type }
  csCLibComaptible        = $01; { CLib compatible        }
  csNCPConnection         = $02; { NCP connection         }
  csNLMConnection         = $03; { NLM connection         }
  csAFPConnection         = $04; { AFP connection         }
  csFTAMConnection        = $05; { FTAM connection        }
  csANCPConnection        = $06; { ANCP connection        }

  { (U)ser (s)tatus }
  usLoggedIn              = $01; { Logged in                      }
  usBeingAborted          = $02; { Being aborted                  }
  usAudited               = $04; { Audited                        }
  usNeedsSecurityChange   = $08; { Needs security change          }
  usMacStation            = $10; { Mac station                    }
  usTempAuthenticated     = $20; { Temporeaery authenticated      }
  usAuditConnRecorded     = $40; { Audit connection recorded      }
  usDSAuditConnRecorded   = $80; { DS audit connection recorded   }

  { (U)ser (i)nfo : write flags }
  uiWriting               = $01; { Writing                        }
  uiWriteAborted          = $02; { Write aborted                  }

  { (U)ser (i)nfo : file write state }
  uiNotWriting            = $00; { User not writing               }
  uiWriteInProgress       = $01; { Write in progress              }
  uiWriteBeingStopped     = $02; { Write being stopped            }

{
              TYPE declarations
 }

type

  { Directory name }
  tDirName              = String[128];

  { Connection list }
  tConnList             =
  record
    NoOfFields          : Word;    { No of fields                         }
    ConnectionList      : array[1..127] of LongInt; { Connection list     }
  end;

  { Ping for NDS NCP}
  tPingNDS_NCP          =
  record
    PingVer             : LongInt; { Ping version                         }
    TreeName            : String;  { Tree name                            }
  end;

  { Network router info }
  tNetworkRouterInfo    =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved            : Word;    { reserved                             }
    NetAddress          : LongInt; { Network adress                       }
    HopsToNetCount      : Word;    { Hops to net count                    }
    NetStatus           : Word;    { Net status                           }
    TimeToNet           : Word;    { Time to net                          }
  end;

  { extended volume info }
  tExtendedVolInfo      =
  record
    VolInfoLength       : Word;    { Volume info length                   }
    VolumeType          : LongInt; { Volume type                          }
    StatusFlagBits      : LongInt; { Status flag bits                     }
    SectorSize          : LongInt; { Sector size                          }
    SectorsPerCluster   : LongInt; { Sectors per cluster                  }
    VolumeSizeInCluster : LongInt; { Volume size in cluster               }
    FreedCluster        : LongInt; { Freed cluster                        }
    SubAllocFreeableCl  : LongInt; { Sub alloc freeable clusters          }
    FreeableLimboSec    : LongInt; { Freeable limbo sectors               }
    NonFreeableLimboSec : LongInt; { Non freeable limbo sectors           }
    NonFreeableSubAlloc : LongInt; { Non freeable sub alloc sectors       }
    NotUseableSubAlloc  : LongInt; { Non useable sub alloc sectors        }
    SubAllocClusters    : LongInt; { Sub alloc clusters                   }
    DataStreamsCount    : LongInt; { Data stream counts                   }
    LimboDataStreamsCo  : LongInt; { Limbo data streams count             }
    OldDeletedFileAge   : LongInt; { Longes deleted file age in ticks     }
    CompDataStreamCount : LongInt; { Compressed data stream count         }
    CompLimboDataStream : LongInt; { Compressed limbo data streams        }
    UncompDataStreamsCo : LongInt; { Uncompressable data streams count    }
    PreCompSectors      : LongInt; { Precompressed sectors                }
    CompressedSectors   : LongInt; { Compressed sectors                   }
    MigratedFiles       : LongInt; { Migrated files                       }
    MigratedSectors     : LongInt; { Migrated sectors                     }
    ClusterUsedByFAT    : LongInt; { Clusters used by FAT                 }
    ClusterUsedByDir    : LongInt; { Clusters used by directories         }
    ClusterUsedByExtDir : LongInt; { Clusters used by ext. directories    }
    TotalDirEntries     : LongInt; { Total directory entries              }
    UnusedDirEntries    : LongInt; { Unused directory entries             }
    TotalExtDirEntries  : LongInt; { Total extended directory entries     }
    UnusedExtDirEntries : LongInt; { Unused extended directory entries    }
    ExtendedAttrDefined : LongInt; { Extended attribute defined           }
    ExtendedAttrExtants : LongInt; { Extended attributes extants used     }
    DirServcicesObjId   : LongInt; { Directory services object id         }
    VolumeLastModified  : LongInt; { Volume last modified date/time       }
    VolumeName          : String;  { Volume name                          }
  end;

  { Active LAN board list }
  tActiveLANBoardList   =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved            : Word;    { reserved                             }
    MaxNoOfLANs         : LongInt; { Max. no of LAN's                     }
    BoardNumbers        : array[1..125] of LongInt;
                          { List of board numbers                         }
  end;

  { CPU info }
  tCPUInfo              =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved            : Word;    { reserved                             }
    NumberOfCPUs        : LongInt; { Number of CPU's                      }
    WeOwnPageTableFlag  : LongInt; { We own the page table flags          }
    CPUTypFlag          : LongInt; { CPU type flag                        }
    NumericCoProcFlag   : LongInt; { Numeric coprocessor flag             }
    BusTypeFlag         : LongInt; { Bus type flag                        }
    IOEngineFlag        : LongInt; { IO Engine flag                       }
    FSEngineFlag        : LongInt; { FS Engine flag                       }
    NonDedicatedFlag    : LongInt; { Non dedicated flag                   }
    CPUType             : String;  { CPU type                             }
    NumericCoProcPres   : String;  { Numeric coprocessor present          }
    Bus                 : String;  { Bus type                             }
  end;

  { Cache info }
  tCacheInfo            =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved            : Word;    { reserved                             }
    Reserved1           : Byte;    { reserved                             }
    ReadExisBlockCount  : LongInt; { Read existing block count            }
    ReadExisWriteCount  : LongInt; { Read existing write wait count       }
    ReadExistPartReadC  : LongInt; { Read existing partial read count     }
    ReadExistReadErrorC : LongInt; { Read existing read error count       }
    WriteBlockCount     : LongInt; { Write block count                    }
    WriteEntireBlockC   : LongInt; { Write entire block count             }
    InternalDiskGetC    : LongInt; { Internal disk get count              }
    IntDiskNeedToAllocC : LongInt; { Internal disk get need to alloc count}
    IntDiskToBeatMeC    : LongInt; { Internal disk get someone to beat
                                     me count                             }
    IntDiskGetPartReadC : LongInt; { Internal disk get partial read count }
    IntDiskGetReadError : LongInt; { Internald isk get read error count   }
    AsyncIntDiskGetC    : LongInt; { Async internal disk get count        }
    AsyncIntDiskAlloc   : LongInt; { Async internal disk get need to alloc}
    AsyncIntDiskToBeatMe: LongInt; { Async internal disk get someone to
                                     beat me                              }
    ErrorDoingAsyncRead : LongInt; { Error doing async read count         }
    IntDiskGetNoReadC   : LongInt; { Internal disk get no read count      }
    IntDiskGetNoReadA   : LongInt; { Internal disk get no read alloc count}
    GetNoReadSomeoneBC  : LongInt; { Get no read someone to beat count    }
    IntDiskWriteCount   : LongInt; { Internal disk write count            }
    IntDiskWriteAllocC  : LongInt; { Internal disk write alloc count      }
    WriteSomeoneToBeatC : LongInt; { Write someone to beat count          }
    WriteErrorCount     : LongInt; { Write error count                    }
    WaitOnSemaphoreC    : LongInt; { Wait on semaphore count              }
    AllocBlockWaiting   : LongInt; { Alloc block i had to wait for someone}
    AllockBlockCount    : LongInt; { Alloc block count                    }
    AllocBlockWaitC     : LongInt; { Alloc block i had to wait count      }
    OrigNoOfCacheBuffer : LongInt; { Original numbers of cache buffers    }
    CurrNoOfCacheBuffer : LongInt; { Current no of cache buffers          }
    CacheDirtyBlockTres : LongInt; { Cache dirty block treshold           }
    WaitNodeCount       : LongInt; { Wait node count                      }
    WaitNodeAllocFailC  : LongInt; { Wait node allocate failure count     }
    MoveCacheNodeCount  : LongInt; { Move cache node count                }
    MoveCacheNodeAvailC : LongInt; { Move cache node from avail count     }
    AccCacheNodeWriteC  : LongInt; { Accelerate cache node write count    }
    RemoveCacheNodeC    : LongInt; { Remove cache node count              }
    RemoveCaacheAvailC  : LongInt; { Remove cache node from avail count   }
    NoOfCacheChecks     : LongInt; { No of cache checks                   }
    NoOfCacheHits       : LongInt; { No of cache hits                     }
    NoOfDirtyCacheCheck : LongInt; { No of dirty cache checks             }
    NoOfCacheDirtyHits  : LongInt; { No of cache dirty hits               }
    CacheUsedWhileCheck : LongInt; { Cache used while checking            }
    WaitTillDirtyBlockD : LongInt; { Wait till dirty blocks decrease count}
    AllocBlockAvailC    : LongInt; { Alloc block from avail count         }
    AllocBlockFromLRUC  : LongInt; { Alloc block from LRU count           }
    AllocBlockAlreadyW  : LongInt; { Alloc block already waiting          }
    LRUSittingTime      : LongInt; { LRU sitting time                     }
    MaxByteCount        : LongInt; { Max byte count                       }
    MinNoOfCacheBuffers : LongInt; { Min no of cache buffers              }
    MinCacheReportTresh : LongInt; { Min cache report treshold            }
    AllocWaitingCount   : LongInt; { Alloc waiting count                  }
    NoOfDirtyBlocks     : LongInt; { No of dirty blocks                   }
    CacheDirtyWaitTime  : LongInt; { Cache dirty wait time                }
    CacheMaxConcWrites  : LongInt; { Cache max concurrent writes          }
    MaxDirtyTime        : LongInt; { Max. dirty time                      }
    NoOfDirCacheBuffers : LongInt; { No of directory cache buffers        }
    CacheByteToBlockSF  : LongInt; { Cache byte to block shift factor     }
  end;

  { File server info }
  tFileServerInfo       =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved1           : Word;    { Reserved                             }
    Reserved2           : Byte;    { Reserved                             }
    NCPStaInUseCount    : LongInt; { NCP Sta in use count                 }
    NCPPeakStaInUse     : LongInt; { NCP Peak sta in use                  }
    NoOfNCPRequests     : LongInt; { No of NCP requests                   }
    ServerUtilization   : LongInt; { Server utilization                   }
    ReplyCanceledCount  : LongInt; { Reply caceled count                  }
    WriteHeldOffCount   : LongInt; { Write held off count                 }
    WriteHeldOffDuplReq : LongInt; { Write held off with dupl. req        }
    InvalidReqTypeCount : LongInt; { Invalid request type count           }
    BeginAbortedCount   : LongInt; { Begin aborted count                  }
    AlreadyDoingRealloc : LongInt; { Alread doing realloc count           }
    DeallocInvalidSlotC : LongInt; { Dealloc invalid slot count           }
    DeallocBeingProc    : LongInt; { Dealloc being processed              }
    DeallocForgedPacket : LongInt; { Dealloc forged packet                }
    DeallocStillTrans   : LongInt; { Dealloc still transmitting           }
    StartStationErrorC  : LongInt; { Start station error count            }
    InvalidSlotCount    : LongInt; { Invalid slot count                   }
    BeingProcessedCount : LongInt; { Being processed count                }
    ForgedPacketCount   : LongInt; { Forged packet count                  }
    StillTransmittingC  : LongInt; { Still transmitting count             }
    ReexecutRequestC    : LongInt; { Reexecute request count              }
    InvalidSequenzeNo   : LongInt; { Invalid sequenze no                  }
    DuplicateBeingSent  : LongInt; { Duplicate is being sent              }
    SendPositivAckCount : LongInt; { Send positiv ack count               }
    SendDuplicateReplyC : LongInt; { Send duplicate reply count           }
    NoMemForStControl   : LongInt; { No memory for station control        }
    NoAvailableConn     : LongInt; { No available connections             }
    ReallocateSlotCount : LongInt; { Reallocate slot count                }
    ReallocSlotToSoon   : LongInt; { Reallocate slot to soon              }
    TooManyHops         : LongInt; { Too many hops                        }
    UnknownNetwork      : LongInt; { UnknownNetwork                       }
    NoSpaceForService   : LongInt; { No space for service                 }
    NoReceiveBuffers    : LongInt; { No receive buffers                   }
    NotMyNetwork        : LongInt; { Not my network                       }
    NetbiosPropCount    : LongInt; { Netbios propagated count             }
    TotalPacketsRec     : LongInt; { Total packets received               }
    TotalPacketsRouted  : LongInt; { Total packets routed                 }
  end;

  { Network info for known network info }
  tNetworkInfo          =
  record
    NetAdress           : LongInt; { Network adress                       }
    HopsToNetCount      : Word;    { Hops to net count                    }
    NetStatus           : Word;    { Net status                           }
    TimeToNet           : Word;    { Time to net                          }
  end;

  { Known network info }
  tKnownNetWorkInfo     =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved1           : Word;    { Reserved                             }
    Reserved2           : Byte;    { Reserved                             }
    ReportedNetworks    : LongInt; { Reported networks                    }
    NetworkInformation  : array[1..50] of tNetworkInfo;
                          { Network info, repeated ReportedNetworks times }
  end;

  { Server info for Known server info }
  tServerInfo           =
  record
    NetAdress           : LongInt; { Net adress                           }
    StationAdress       : array[1..6] of Byte; { Station adress           }
    SocketNo            : Word;    { Socket no                            }
    HopsToServer        : Word;    { Hops to server                       }
    ServerName          : String;  { Server name                          }
  end;

  { NLM loaded list }
  tNLMLoadedList        =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved            : Word;    { Reserved                             }
    NoOfNLMLoaded       : LongInt; { No of NLM's loaded                   }
    NoOfNLMReturned     : LongInt; { No of NLM returned                   }
    NLMNumberList       : array[1..124] of LongInt; { NLM number list     }
  end;

  { Operating system info }
  tOperatingSystemInfo  =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved            : Word;    { Reserved                             }
    OSMajorVer          : Byte;    { OS major version                     }
    OSMinorVer          : Byte;    { OS minor version                     }
    OSRevision          : Byte;    { OS revivision                        }
    AccountVer          : Byte;    { Account version                      }
    VAPVer              : Byte;    { VAP version                          }
    QueueingVer         : Byte;    { Queueing version                     }
    SecurityRestLevel   : Byte;    { Security rest level                  }
    BridgingSupport     : Byte;    { Bridging support                     }
    MaxNoOfVolumes      : LongInt; { Max no of volumes                    }
    MaxNoOfConn         : LongInt; { Max no of connections                }
    MaxNoOfUsers        : LongInt; { Max no of users                      }
    MaxNoOfNameSpaces   : LongInt; { Max no of name spaces                }
    MaxNoOfLANs         : LongInt; { Max no of LAN's                      }
    MaxNoOfMedias       : LongInt; { Max no of medias                     }
    MaxNoOfStacks       : LongInt; { Max no of stacks                     }
    MaxDirDepth         : LongInt; { Max dir depth                        }
    MaxDataStreams      : LongInt; { Max data streams                     }
    MaxNoOfSpooledPr    : LongInt; { Max no of spooled printers           }
    ServerSerialNo      : LongInt; { Server serial no                     }
    ServerApplNo        : LongInt; { Server application no                }
  end;

  { Protocol stack info }
  tProtocolStackInfo    =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved            : Word;    { Reserved                             }
    ConfigMajorVer      : Word;    { Config major version                 }
    ConfigMinorVer      : Word;    { Config minor version                 }
    ProtocolModuleName  : String;  { Protocol module name                 }
    ProtocolShortName   : String;  { Protocl short name                   }
    ProtocolLongName    : String;  { Protocol long name                   }
  end;

  { Server set categories }
  tServerSetCategories  =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved            : Word;    { Reserved                             }
    NextStartNo         : LongInt; { Next start no                        }
    CategoryNo          : LongInt; { Category no                          }
    CategoryName        : String;  { Category name                        }
  end;

  { Server set commands info }
  tServerSetCommandInfo =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved            : Word;    { Reserved                             }
    TotalSetCommands    : LongInt; { Total set commands                   }
    NextStartNo         : LongInt; { Next start no                        }
    SetCmdType          : LongInt; { Set cmd type                         }
    SetCmdCategory      : LongInt; { Set cmd category                     }
    SetCmdFlags         : LongInt; { Set cmd flags                        }
    SetCmdName          : String;  { Set cmd name                         }
  end;

  { IPX/SPX info }
  tIPX_SPXInfo          =
  record
    IPXSendPacketCount  : LongInt; { IPX send packet count                }
    IPXMalformPacketC   : LongInt; { IPX malform packet count             }
    IPXGetECBRequestC   : LongInt; { IPX get ECB request count            }
    IPXGetECBFailCount  : LongInt; { IPX get ECB fail count               }
    IPXAESEventCount    : LongInt; { IPX AES event count                  }
    PostponedAESCount   : LongInt; { Postponed AES count                  }
    IPXMaxConfigSocket  : LongInt; { IPX max configed sockets             }
    IPXMaxOpenSocketC   : LongInt; { IPX max open socket count            }
    IPXOpenSocketFailC  : LongInt; { IPX open socket fail count           }
    IPXListenECBCount   : LongInt; { IPX listen ECB count                 }
    IPXECBCancelFailC   : LongInt; { IPX ECB cancel fail count            }
    IPXGetLocalTargetF  : LongInt; { IPX get local target fail            }
    SPXMaxConn          : LongInt; { SPX max connections                  }
    SPXMaxUsedConn      : LongInt; { SPX max used connections             }
    SPXESTConnReq       : LongInt; { SPX EST connection request           }
    SPXESTConnFail      : LongInt; { SPX EST connection fail              }
    SPXListenConnectReq : LongInt; { SPX listen connect request           }
    SPXListenConnectFail: LongInt; { SPX listen connect fail              }
    SPXSendCount        : LongInt; { SPX send count                       }
    SPXWindowChokeCount : LongInt; { SPX window choke count               }
    SPXBadSendCount     : LongInt; { SPX bad send count                   }
    SPXSendFailCount    : LongInt; { SPX send fail count                  }
    SPXAbortedConn      : LongInt; { SPX aborted connection               }
    SPXListenPacketC    : LongInt; { SPX listen packet count              }
    SPXBadListenCount   : LongInt; { SPX bad listen count                 }
    SPXIncomingPacketC  : LongInt; { SPX incoming packet count            }
    SPXBadInPacketCount : LongInt; { SPX bad in packet count              }
    SPXSuppressPacketC  : LongInt; { SPX suppress packet count            }
    SPXNoSesListenECBC  : LongInt; { SPX no ses listen ECB count          }
    SPXWatchdogDestSesC : LongInt; { SPX watchdog dest ses count          }
  end;

  { LAN common counters info }
  tLANCommonCounterInfo =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved1           : Word;    { Reserved 1                           }
    StatMajorVer        : Byte;    { Stat major version                   }
    StatMinorVer        : Byte;    { Stat minor version                   }
    TotalCommonCounts   : LongInt; { Total common counts                  }
    TotalCountBlocks    : LongInt; { Total count blocks                   }
    CustomCounters      : LongInt; { Custom counters                      }
    NextCountBlock      : LongInt; { Next count block                     }
    NotSupportedMask    : LongInt; { Not supported mask                   }
    TotalPxPacketCount  : LongInt; { Total Px packet count                }
    TotalRxPacketCount  : LongInt; { Total Rx packet count                }
    NoECBAvailableCount : LongInt; { No ECB available count               }
    PacketTxTooBigC     : LongInt; { Packet Tx too big count              }
    PacketTxTooSmallC   : LongInt; { Packet TX too small count            }
    PacketRxOverflowC   : LongInt; { Packet Rx overflow count             }
    PacketRxTooBigC     : LongInt; { Packet Rx too big count              }
    PacketRxTooSmallC   : LongInt; { Packet Rx too small count            }
    PacketTxMiscErrorC  : LongInt; { Packet Tx misc error count           }
    PacketRxMiscErrorC  : LongInt; { Packet Rx misc error count           }
    RetryTxCount        : LongInt; { Retry Tx count                       }
    ChecksumErrorCount  : LongInt; { Checksum error count                 }
    HardwareRxMismatchC : LongInt; { Hardware Rx mismatch count           }
    Reserved2           : array[1..50] of Byte; { reserved 2              }
  end;

  { LAN Configuration info }
  tLANConfigInfo        =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved            : Word;    { Reserved                             }
    LANDriverCfgMajorV  : Byte;    { LAN driver cfg major version         }
    LANDriverCfgMinorV  : Byte;    { LAN driver cfg minor version         }
    LANDriverNodeAddr   : array[1..6] of Byte; { LAN driver node address  }
    LANDriverModeFlags  : Word;    { LAN driver mode flags                }
    LANDriverBoardNo    : Word;    { LAN driver board no                  }
    LANDriverBoardInst  : Word;    { LAN driver board instance            }
    LANDriverMaxSize    : LongInt; { LAN driver max size                  }
    LANDriverMaxRecSize : LongInt; { LAN driver max received size         }
    LANDriverRecSize    : LongInt; { LAN driver received size             }
    LANDriverCardID     : LongInt; { LAN driver card id                   }
    LANDriverMediaID    : LongInt; { LAN driver media id                  }
    LANDriverTransTime  : LongInt; { LAN driver transport time            }
    LANDriverSrcRouting : LongInt; { LAN driver scr routing               }
    LANDriveLineSpeed   : LongInt; { LAN drive line speed                 }
    LANDriverReserved   : LongInt; { LAN driver reserved                  }
    LANDriverMajorVer   : Byte;    { LAN driver major version             }
    LANDriverMinorVer   : Byte;    { LAN driver minor version             }
    LANDriverFlags      : Word;    { LAN driver flags                     }
    LANDriverSendRetr   : Word;    { LAN driver send retries              }
    LANDriverLink       : LongInt; { LAN driver link                      }
    LANDriverShareFlags : Word;    { LAN driver sharing flags             }
    LANDriverDriverSlot : Word;    { LAN driver driver slot               }
    LANDriverIOPorts    : array[1..4] of Word; { LAN driver IO ports      }
    LANDriverMemoryDec0 : LongInt; { LAN driver memory decode 0           }
    LANDriverMemoryLen0 : Word;    { LAN driver memory length 0           }
    LANDriverMemoryDec1 : LongInt; { LAN driver memory decode 1           }
    LANDriverMemoryLen1 : Word;    { LAN driver memory length 1           }
    LANDriverInterrupt  : array[1..2] of Byte; { LAN driver interrupt     }
    LANDriverDMAUsage   : array[1..2] of Byte; { LAN driver DMA usage     }
    LANDriverLogName    : array[1..18] of Char; { LAN driver log. name    }
    LANDriverIOReserved : array[1..14] of Char; { LAN driver IO reserved  }
    LANDriverCardName   : array[1..180] of Char; { LAN driver card name   }
  end;

  { NLM information }
  tNLMInformation       =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved            : Word;    { Reserved                             }
    IdentificationNo    : LongInt; { Identification no                    }
    Flags               : LongInt; { Flags                                }
    NLMType             : LongInt; { Type                                 }
    ParendId            : LongInt; { Parent id                            }
    MajorVer            : LongInt; { Major version                        }
    MinorVer            : LongInt; { Minor version                        }
    Year                : LongInt; { Year                                 }
    Month               : LongInt; { Month                                }
    Day                 : LongInt; { Day                                  }
    AllocAvailBytes     : LongInt; { Alloc avail bytes                    }
    AllocFreeCount      : LongInt; { Alloc free count                     }
    LastGarbCollec      : LongInt; { Last garb collec                     }
    MessageLanguage     : LongInt; { Message language                     }
    ReferencedPublics   : LongInt; { Referenced publics                   }
    FileName            : String;  { File name                            }
    Name                : String;  { Name + copyright                     }
  end;

  { User info }
  tUserInfo             =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved            : Word;    { Reserved                             }
    ConnNo              : LongInt; { Connection no                        }
    UseCount            : LongInt; { Use count                            }
    ConnServiceType     : Byte;    { Connection service type              }
    LoginTime           : array[1..7] of Byte; { login time               }
    Status              : LongInt; { Status                               }
    ExpirationTime      : LongInt; { Expiration time                      }
    ObjectType          : LongInt; { Object type                          }
    TransactionFlag     : Byte;    { Transaction flag                     }
    LogicalLockThres    : Byte;    { Logical lock threshold               }
    RecordLockThres     : Byte;    { Record lock trheshold                }
    FileWriteFlags      : Byte;    { File write flags                     }
    FileWriteState      : Byte;    { File write state                     }
    Filler              : Byte;    { Filler                               }
    FileLockCount       : Word;    { File lock count                      }
    RecordLockCount     : Word;    { Record lock count                    }
    TotalBytesRead      : array[1..6] of Byte; { Total bytes read         }
    TotalBytesWritten   : array[1..6] of Byte; { Total bytes written      }
    TotalRequests       : LongInt; { Total requests                       }
    HeldRequests        : LongInt; { Held requests                        }
    HeldBytesRead       : array[1..6] of Byte; { Held bytes read          }
    HeldBytesWritten    : array[1..6] of Byte; { Hel bytes written        }
    UserName            : String;  { Username                             }
  end;

  { Volume switch info }
  tVolumeSwitchInfo     =
  record
    CurrentServerTime   : LongInt; { Current server time                  }
    VirtualConsoleVer   : Byte;    { Virtual console version              }
    VirtualConsoleRev   : Byte;    { Virtual console revision             }
    Reserved            : Word;    { Reserved                             }
    TotalLFSCounters    : LongInt; { Total LFS counters                   }
    CurrentLFSCounters  : LongInt; { Current LFS counters                 }
    ReadFile            : LongInt; { Read file                            }
    WriteFile           : LongInt; { Write file                           }
    DeleteFile          : LongInt; { Delete file                          }
    RenameMove          : LongInt; { Rename move                          }
    OpenFile            : LongInt; { Open file                            }
    CreateFile          : LongInt; { Create file                          }
    CreateAndOpenFile   : LongInt; { Create and open file                 }
    CloseFile           : LongInt; { Close file                           }
    ScanDeleteFile      : LongInt; { Scan/delete file                     }
    SalvageFile         : LongInt; { Salvage file                         }
    PurgeFile           : LongInt; { Purge file                           }
    MigrateFile         : LongInt; { Migrate file                         }
    DemigrateFile       : LongInt; { Demigrate file                       }
    CreateDir           : LongInt; { Create directory                     }
    DeleteDir           : LongInt; { Delete directory                     }
    DirectoryScans      : LongInt; { Directory scans                      }
    MapPathToDirNo      : LongInt; { Map path to directory-no             }
    ModifyDirEntry      : LongInt; { Modify directory entry               }
    GetAccessRights     : LongInt; { Get access directory rights          }
    GetAccessRightsID   : LongInt; { Get access rights from id            }
    MapDirNoToPath      : LongInt; { Map directory-no to path             }
    GetEntryFromPathStr : LongInt; { Get entry from path string           }
    GetOtherNSEntry     : LongInt; { Get other NS entry                   }
    GetExtDirInfo       : LongInt; { Get extended directory info          }
    GetParentDirNo      : LongInt; { Get parent directory no              }
    AddTrusteeRights    : LongInt; { Add trustee rights                   }
    ScanTrusteeRights   : LongInt; { Scan trustee rights                  }
    DelTrusteeRights    : LongInt; { Delete trustee rights                }
    PurgeTrust          : LongInt; { Purge trust                          }
    FindNextTrusRef     : LongInt; { Find next trust reference            }
    ScanUserRestrNodes  : LongInt; { Scan user restricted nodes           }
    AddUserRestriction  : LongInt; { Add user restriction                 }
    DeleteUserRestr     : LongInt; { Delete user restriction              }
    RtnDirSpaceRestr    : LongInt; { Rtn directory space restrictions     }
    GetActualAvailDiskS : LongInt; { Get actual available disk space      }
    CountOwnedFilesDirs : LongInt; { Count owned files directorys         }
    MigFileInfo         : LongInt; { Mig file info                        }
    VolMigInfo          : LongInt; { Vol mig info                         }
    ReadMigFileData     : LongInt; { Read mig file date                   }
    GetVolUsageStats    : LongInt; { Get volume usage stats               }
    GetActualVolsUsageS : LongInt; { Get actual volume useage stats       }
    GetDirUsageStats    : LongInt; { Get directory usage stats            }
    FileReadsCount      : LongInt; { File reads count                     }
    FileWritesCount     : LongInt; { File writes count                    }
    MapPathToDirNoOrP   : LongInt; { Map path to dir no or phantom        }
    StnHasAccessRightsG : LongInt; { Stn has access rights granted        }
    StreamLengthsFromPB : LongInt; { Stream length from path base         }
    CheckAndGetDirEntry : LongInt; { Check and get directory entry        }
    GetDeletedEntry     : LongInt; { Get deleted entry                    }
    GetOriginalNameSp   : LongInt; { Get original name space              }
    GetAcutalFileSize   : LongInt; { Get actual file size                 }
    VerifyNameSpaceNo   : LongInt; { Verify name space no                 }
    VerifyDataStreamNo  : LongInt; { Verify data stream no                }
    CheckVolumeNumber   : LongInt; { Check volume no                      }
    CommitFile          : LongInt; { Commit file                          }
    VMGetDirectoryEntry : LongInt; { VM Get directory entry               }
    CreateDMFileEntry   : LongInt; { Create DM file entry                 }
    RenNameSpaceEntry   : LongInt; { Rename name space entry              }
    LogFile             : LongInt; { Log file                             }
    ReleaseFile         : LongInt; { Release file                         }
    ClearFile           : LongInt; { Clear file                           }
    SetVolumeFlag       : LongInt; { Set volume flag                      }
    ClearVolumeFlag     : LongInt; { Clear volume flag                    }
    GetOriginalInfo     : LongInt; { Get original info                    }
    CreateMigratedDir   : LongInt; { Create migrated directory            }
    OpenCreate          : LongInt; { Open create                          }
    InitFileSearch      : LongInt; { Init file search                     }
    ContinueFileSearch  : LongInt; { Continue file search                 }
    RenameFile          : LongInt; { Rename file                          }
    ScanForTrustees     : LongInt; { Scan for trustees                    }
    ObtainFileInfo      : LongInt; { Obtain file info                     }
    ModifyInfo          : LongInt; { Modify info                          }
    EraseFile           : LongInt; { Erase file                           }
    SetDirHandle        : LongInt; { Set directory handle                 }
    AddTrustee          : LongInt; { Add trustee                          }
    DeleteTrustees      : LongInt; { Delete trustees                      }
    AllocDirHandle      : LongInt; { Allocate directory handle            }
    ScanSalvagedFiles   : LongInt; { Scan salvaged files                  }
    RecoverSalvagedF    : LongInt; { Recover salvaged files               }
    PurgeSalvagedFiles  : LongInt; { Purge salvaged files                 }
    GetNSSpecificInfo   : LongInt; { Get NS specific info                 }
    ModifyNSSpecificInfo: LongInt; { Modify NS specific info              }
    SearchSet           : LongInt; { Search set                           }
    GetDirBase          : LongInt; { Get dir base                         }
    QueryNameSpaceInfo  : LongInt; { Query name space info                }
    GetNameSpaceList    : LongInt; { Get name space list                  }
    GetHugeInfo         : LongInt; { Get huge info                        }
    SetHugeInfo         : LongInt; { Set huge info                        }
    GetFullPathString   : LongInt; { Get full path string                 }
    GetEffDirRights     : LongInt; { Get effective directory rights       }
    ParseTree           : LongInt; { Parse tree                           }
  end;

{
        procedure and function-headers
 }

{ NETWARE 4.0 INFOS Ping for NDS/NCP }
function PingForNDS_NCP(var PingInfo : tPingNDS_NCP):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Change connection authentication state }
function ChangeConnAuthenticationState(ConnectionState : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Clear connection no }
function ClearConnectionNo(ConnNo : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get connection list from object }
procedure GetConnListFromObject(ObjectId : LongInt;
                                SearchNo : LongInt;
                                var ConnList : tConnList);
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Set watchdog delay interval }
function SetWatchDogDelayInterval(Interval : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get extended volume info }
procedure GetExtendedVolumeInfo(VolumeNo : Byte;
                                var VolInfo : tExtendedVolInfo);
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get object effective rights for dir entry }
prcoedure GetObjectEffRightsForDirEntry(ObjectId : LongInt;
                                        DirectoryHandle : Byte;
                                        DirectoryPath : tDirName;
                                        var EffectiveRights : Word);
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Active LAN board list }
procedure ActiveLANBoardList(StartNo : LongInt;
                             var LANBoardList : tActiveLANBoardList):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get cache info }
procedure GetCacheInfo(var CacheInfo : tCacheInfo);
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get file server info }
procedure GetFileServerInfo(var ServerInfo : tFileServerInfo);
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get known networks info }
procedure GetKnownNetworksInfo(StartNo : LongInt;
                               var NetworksInfo : tKnownNetWorkInfo);
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get networks router info }
procedure GetNetworkRouterInfo(StartNo : LongInt;
                               var NetworkRouterInfo : tNetworkRouterInfo);
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get NLM loaded list }
function GetNLMLoadedList(StartNo : LongInt;
                          var NLMLoadedList : tNLMLoadedList):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get operating system info }
function GetOSSystemInfo(var OSSystemInfo : tOperatingSystemInfo):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get IPX/SPX info }
procedure GetIPX_SPXInfo(var IPX_SPXInfo : tIPX_SPXInfo);
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get LAN common counters info }
function LANCommonCountersInfo(BoardNo : LongInt;
                               BlockNo : LongInt;
                               var LANCounterInfo : tLANCommonCounterInfo):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get LAN configuration info }
function GetLANConfigurationInfo(LANBoardNo : LongInt;
                                 var LANConfigInfo : tLANConfigInfo):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get user info }
function GetUserInfo(ConnNo : LongInt;
                     var UserInfo : tUserInfo):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get volume switch info }
function GetVolumeSwitchInfo(StartNo : LongInt;
                             var VolumeSwitchInfo : tVolumeSwitchInfo):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get CPU info }
procedure GetCPUInfo(StartNo : LongInt;
                     var CPUInfo : tCPUInfo);
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get protocol stack config info }
function GetProtocolStackConfigInfo(LANBoardNo : LongInt;
                                    var ProtocolStackInfo : tProtocolStackInfo):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get server set categories }
function GetServerSetCategories(StartNo : LongInt;
                                var ServerSetCategories :
                                  tServerSetCategories):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get server set commands info }
function GetServerSetCommandsInfo(StartNo : LongInt;
                                  var ServerSetCommandsInfo :
                                    tServerSetCommandInfo):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ NETWARE 4.0 INFOS Get NLM info }
function GetNLMInfo(NLMNo : LongInt;
                    var NLMInfo : tNLMInformation):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

(* -------------------------- implemenation -------------------------- *)

implementation

{
  function        : PingForNDS_NCP
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Checks if directory services are loaded
         on the server and returns then tree-name

  Errors : - neSuccessfull
           - neNDS_NCPNotAvailable
 }

function PingForNDS_NCP(var PingInfo : tPingNDS_NCP):Byte;

var
  NovRegs : Word;

  Request       :
  record
    Func        : Byte;    { Function    }
    Dummy       : LongInt; { Dummy ?     }
  end;

  Reply         :
  record
    Ping        : LongInt; { Ping version   }
    TreeLength  : LongInt; { Tree length    }
    TreeName    : array[1..200] of Byte;  { Tree name      }
  end;

begin
  with Request do
  begin
    Func  := 1;
    Dummy := 0;
  end;
  NovRegs := $F268;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  with Reply do
  begin
    PingInfo.PingVer     := Ping;
    PingInfo.TreeName[0] := Char(TreeLength);
    Move(TreeName, Ptr(Seg(PingInfo.TreeName), Ofs(PingInfo.TreeName) + 1)^,
         TreeLength);
  end;
  PingForNDS_NCP := Lo(NovRegs);
end;

{
  function        : ChangeConnAuthenticationState
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Changes the login-status between a
         normal logged in connection and a
         temporaery authenticated connection

  Errors : - neSuccessfull
           - neConnectionAlreadyTemp
           - neConnAlreadLoggedIn
           - neConnNotAuthenticated
           - neUnknownRequest
 }

function ChangeConnAuthenticationState(ConnectionState : LongInt):Byte;

var
  NovRegs       : tRegister;

  Request       :
  record
    Func        : Word;    { Function           }
    SubF        : LongInt; { Subfunction        }
    ConnState   : LongInt; { Connection state   }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with Request do
  begin
    Func      := 5;
    SubF      := $1D;
    ConnState := ConnectionState;
  end;
  NovRegs.AX := $F217;
  RequestBufferIntr(Request, SizeOf(Request), NovRegs);
  ChangeConnAuthenticationState := NovRegs.AL;
end;

{
  function        : ClearConnectionNo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Clears an connection no

  Errors : - neSuccessfull
           - neBadConnectionNo
 }

function ClearConnectionNo(ConnNo : LongInt):Byte;

var
  NovRegs       : tRegister;

  Request       :
  record
    Size        : Word;    { Size of request }
    SubF        : LongInt; { Subfunction     }
    Conn        : LongInt; { Connection no   }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with Request do
  begin
    Size := SizeOf(Request) -2;
    SubF := $FE;
    Conn := ConnNo;
  end;
  NovRegs.AX := $F217;
  RequestBufferIntr(Request, SizeOf(Request), NovRegs);
  ClearConnectionNo := NovRegs.AL;
end;

{
  procedure       : GetConnListFromObject
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Returns a list of the connections used
         by the object.
 }

procedure GetConnListFromObject(ObjectId : LongInt;
                                SearchNo : LongInt;
                                var ConnList : tConnList);

var
  NovRegs       : Word;
  Reply         : tConnList absolute ConnList;

  Request       :
  record
    Size        : Word;    { Size of request }
    SubF        : LongInt; { Subfunction     }
    ObjId       : LongInt; { Object id       }
    Search      : LongInt; { Search number   }
  end;

begin
  with Request do
  begin
    Size   := SizeOf(Request) -2;
    SubF   := $1F;
    ObjId  := ObjectId;
    Search := SearchNo;
  end;
  NovRegs := $F217;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
end;

{
  function        : SetWatchDogDelayInterval
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Set's the watchdog interval of the
         server.

  Errors : - neSuccessfull
           - neInvalidDelay
 }

function SetWatchDogDelayInterval(Interval : LongInt):Byte;

var
  NovRegs       : tRegister;

  Request       :
  record
    Size        : Word;    { Size of request }
    SubF        : LongInt; { Subfunction     }
    Int         : LongInt; { Interval        }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with Request do
  begin
    Size := SizeOf(Request) -2;
    SubF := $1E;
    Int  := Interval;
  end;
  NovRegs.AX := $F217;
  RequestBufferIntr(Request, SizeOf(Request), NovRegs);
  SetWatchDogDelayInterval := NovRegs.AL;
end;

{
  procedure       : GetExtendedVolumeInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's extended infos about the volume
 }

procedure GetExtendedVolumeInfo(VolumeNo : Byte;
                                var VolInfo : tExtendedVolInfo);

var
  NovRegs       : Word;
  Reply         : tExtendedVolInfo absolute VolInfo;

  Request       :
  record
    Size        : Word;    { Size of request }
    SubF        : Byte;    { Subfunction     }
    VolNo       : LongInt; { Volume-no       }
  end;

begin
  with Request do
  begin
    Size  := SizeOf(Request) -2;
    SubF  := $33;
    VolNo := VolumeNo;
  end;
  NovRegs := $F216;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
end;

{
  procedure       : GetObjectEffRightsForDirEntry
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's the effectiv rights of a object
         for an directory entry
 }

procedure GetObjectEffRightsForDirEntry(ObjectId : LongInt;
                                        DirectoryHandle : Byte;
                                        DirectoryPath : tDirName;
                                        var EffectiveRights : Word);

var
  NovRegs       : Word;

  Request       :
  record
    Size        : Word;    { Size of request               }
    SubF        : Byte;    { Subfunction                   }
    ObjId       : LongInt; { Object id                     }
    DirHandle   : Byte;    { Directory handle              }
    DirPath     : array[1..128] of Char; { Directory-name  }
  end;

  Reply         :
  record
    EffRights   : Word;    { Effectiv rights      }
    Reserved    : array[1..6] of Byte; { Reserved }
  end;

begin
  with Request do
  begin
    Size      := SizeOf(Request) -2;
    SubF      := $32;
    ObjId     := ObjectId;
    DirHandle := DirectoryHandle;
    StrPCopy(@DirPath, DirectoryPath);
  end;
  NovRegs := $F216;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  EffectiveRights := Reply.EffRights;
end;

{
  procedure       : ActiveLANBoardList
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's the active LAN borad list of the
         file server
 }

procedure ActiveLANBoardList(StartNo : LongInt;
                             var LANBoardList : tActiveLANBoardList);

var
  NovRegs       : Word;
  Reply         : tActiveLANBoardList absolute LANBoardList;

  Request       :
  record
    Size        : Word;    { Size of request               }
    SubF        : Byte;    { Subfunction                   }
    Start       : LongInt; { Start number                  }
  end;

begin
  with Request do
  begin
    Size  := SizeOf(Request) -2;
    SubF  := $14;
    Start := StartNo;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
end;

{
  procedure       : GetCacheInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's cache statistics from the
         file server
 }

procedure GetCacheInfo(var CacheInfo : tCacheInfo);

var
  NovRegs       : Word;
  Reply         : tCacheInfo absolute CacheInfo;

  Request       :
  record
    Size        : Word;    { Size of request               }
    SubF        : Byte;    { Subfunction                   }
  end;

begin
  with Request do
  begin
    Size := SizeOf(Request) -2;
    SubF := $01;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
end;

{
  procedure       : GetFileServerInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's infos about the file server
 }

procedure GetFileServerInfo(var ServerInfo : tFileServerInfo);

var
  NovRegs       : Word;
  Reply         : tServerInfo absolute ServerInfo;

  Request       :
  record
    Size        : Word;    { Size of request               }
    SubF        : Byte;    { Subfunction                   }
  end;

begin
  with Request do
  begin
    Size := SizeOf(Request) -2;
    SubF := $02;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
end;

{
  procedure       : GetKnownNetworksInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's infos about other server in
         the network
 }

procedure GetKnownNetworksInfo(StartNo : LongInt;
                               var NetworksInfo : tKnownNetWorkInfo);

var
  NovRegs       : Word;
  Reply         : tKnownNetWorkInfo absolute NetworksInfo;

  Request       :
  record
    Size        : Word;    { Size of request  }
    SubF        : Byte;    { Subfunction      }
    Start       : LongInt; { Start no         }
  end;

begin
  with Request do
  begin
    Size  := SizeOf(Request) -2;
    SubF  := $38;
    Start := StartNo;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
end;

{
  procedure       : GetNetworkRouterInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's infos about network routers
 }

procedure GetNetworkRouterInfo(StartNo : LongInt;
                               var NetworkRouterInfo : tNetworkRouterInfo);

var
  NovRegs       : Word;
  Reply         : tNetworkRouterInfo absolute NetworkRouterInfo;

  Request       :
  record
    Size        : Word;    { Size of request  }
    SubF        : Byte;    { Subfunction      }
    Start       : LongInt; { Net adress       }
  end;

begin
  with Request do
  begin
    Size  := SizeOf(Request) -2;
    SubF  := $33;
    Start := StartNo;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetNetworkRouterInfo := Lo(NovRegs);
end;

{
  function        : GetNLMLoadedList
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's infos about loaded NLM's on
         the file server

  Errors : - neSuccessfull
 }

function GetNLMLoadedList(StartNo : LongInt;
                          var NLMLoadedList : tNLMLoadedList):Byte;

var
  NovRegs       : Word;
  Reply         : tNLMLoadedList absolute NLMLoadedList;

  Request       :
  record
    Size        : Word;    { Size of request  }
    SubF        : Byte;    { Subfunction      }
    Start       : LongInt; { Net adress       }
  end;

begin
  with Request do
  begin
    Size  := SizeOf(Request) -2;
    SubF  := $0A;
    Start := StartNo;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetNLMLoadedList := Lo(NovRegs);
end;

{
  function        : GetOSSystemInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's infos about the file server
         OS versions

  Errors : - neSuccessfull
 }

function GetOSSystemInfo(var OSSystemInfo : tOperatingSystemInfo):Byte;

var
  NovRegs       : Word;
  Reply         : tOperatingSystemInfo absolute OSSystemInfo;

  Request       :
  record
    Size        : Word;    { Size of request  }
    SubF        : Byte;    { Subfunction      }
  end;

begin
  with Request do
  begin
    Size := SizeOf(Request) -2;
    SubF := $0D;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetOSSystemInfo := Lo(NovRegs);
end;

{
  procedure       : GetIPX_SPXInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's infos about IPX/SPX statistics
 }

procedure GetIPX_SPXInfo(var IPX_SPXInfo : tIPX_SPXInfo);

var
  NovRegs       : Word;
  Reply         : tIPX_SPXInfo absolute IPX_SPXInfo;

  Request       :
  record
    Size        : Word;    { Size of request  }
    SubF        : Byte;    { Subfunction      }
  end;

begin
  with Request do
  begin
    Size := SizeOf(Request) -2;
    SubF := $06;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetIPX_SPXInfo := Lo(NovRegs);
end;

{
  function        : LANCommonCountersInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's statistics from LAN-cards in the
         file server

  Errors : - neSuccessfull
           - neInvalidBoardFailure
 }

function LANCommonCountersInfo(BoardNo : LongInt;
                               BlockNo : LongInt;
                               var LANCounterInfo : tLANCommonCounterInfo):Byte;

var
  NovRegs       : Word;
  Reply         : tLANCommonCounterInfo absolute LANCounterInfo;

  Request       :
  record
    Size        : Word;    { Size of request  }
    SubF        : Byte;    { Subfunction      }
    Board       : LongInt; { Board number     }
    Block       : LongInt; { Block number     }
  end;

begin
  with Request do
  begin
    Size  := SizeOf(Request) -2;
    SubF  := $16;
    Board := BoardNo;
    Block := BlockNo;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  LANCommonCountersInfo := Lo(NovRegs);
end;

{
  function        : GetLANConfigurationInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's LAN driver configuration info

  Errors : - neSuccessfull
 }

function GetLANConfigurationInfo(LANBoardNo : LongInt;
                                 var LANConfigInfo : tLANConfigInfo):Byte;

var
  NovRegs       : Word;
  Reply         : tLANConfigInfo absolute LANConfigInfo;

  Request       :
  record
    Size        : Word;    { Size of request  }
    SubF        : Byte;    { Subfunction      }
    Board       : LongInt; { Board number     }
  end;

begin
  with Request do
  begin
    Size  := SizeOf(Request) -2;
    SubF  := $15;
    Board := LANBoardNo;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetLANConfigurationInfo := Lo(NovRegs);
end;

{
  function        : GetUserInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's infos about the connection-no
         logged in user

  Errors : - neSuccessfull
 }

function GetUserInfo(ConnNo : LongInt;
                     var UserInfo : tUserInfo):Byte;

var
  NovRegs       : Word;
  Reply         : tUserInfo absolute UserInfo;

  Request       :
  record
    Size        : Word;    { Size of request  }
    SubF        : Byte;    { Subfunction      }
    Conn        : LongInt; { Connection no    }
  end;

begin
  with Request do
  begin
    Size := SizeOf(Request) -2;
    SubF := $04;
    Conn := ConnNo;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetUserInfo := Lo(NovRegs);
end;

{
  function        : GetVolumeSwitchInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's statistics about the volume
         switch functions

  Errors : - neSuccessfull
 }

function GetVolumeSwitchInfo(StartNo : LongInt;
                             var VolumeSwitchInfo : tVolumeSwitchInfo):Byte;

var
  NovRegs       : Word;
  Reply         : tVolumeSwitchInfo absolute VolumeSwitchInfo;

  Request       :
  record
    Size        : Word;    { Size of request  }
    SubF        : Byte;    { Subfunction      }
    Start       : LongInt; { Start no         }
  end;

begin
  with Request do
  begin
    Size  := SizeOf(Request) -2;
    SubF  := $09;
    Start := StartNo;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetVolumeSwitchInfo := Lo(NovRegs);
end;

{
  procedure       : GetCPUInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's infos about the file severs
         CPU
 }

procedure GetCPUInfo(StartNo : LongInt;
                     var CPUInfo : tCPUInfo);

var
  NovRegs       : Word;
  Marker        : Word;

  Request       :
  record
    Size        : Word;    { Size of request  }
    SubF        : Byte;    { Subfunction      }
    Start       : LongInt; { Start no         }
  end;

  Reply         :
  record
    Buffer1     : array[1..36] of Byte;  { First buffer of CPU structure  }
    Buffer2     : array[1..476] of Byte; { Second buffer with CPU strings }
  end;

begin
  with Request do
  begin
    Size  := SizeOf(Request) -2;
    SubF  := $08;
    Start := StartNo;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  Move(Reply.Buffer1, CPUInfo, SizeOf(Reply.Buffer1));

  Marker := 1;
  with CPUInfo do
  begin
    CPUType := StrPas(@Reply.Buffer2[Marker]);
    Inc(Marker, Length(CPUType) + 1);
    NumericCoProcPres := StrPas(@Reply.Buffer2[Marker]);
    Inc(Marker, Length(NumericCoProcPres) + 1);
    Bus := StrPas(@Reply.Buffer2[Marker]);
  end;
end;

{
  function        : GetProtocolStackConfigInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's infos about the protocol stacks
         of an physical or logical LAN-card

  Errors : - neSuccessfull
 }

function GetProtocolStackConfigInfo(LANBoardNo : LongInt;
                                    var ProtocolStackInfo : tProtocolStackInfo):Byte;

var
  NovRegs       : Word;
  Marker        : Word;

  Request       :
  record
    Size        : Word;    { Size of request  }
    SubF        : Byte;    { Subfunction      }
    Board       : LongInt; { LAN-board no     }
  end;

  Reply         :
  record
    Buffer1     : array[1..12] of Byte;  { First buffer of stack structure  }
    Buffer2     : array[1..500] of Byte; { Second buffer with strings       }
  end;

begin
  with Request do
  begin
    Size  := SizeOf(Request) -2;
    SubF  := $29;
    Board := LANBoardNo;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  Move(Reply.Buffer1, ProtocolStackInfo, SizeOf(Reply.Buffer1));

  Marker := 1;
  with ProtocolStackInfo do
  begin
    ProtocolModuleName := StrPas(@Reply.Buffer2[Marker]);
    Inc(Marker, Length(ProtocolModuleName) + 1);
    ProtocolShortName := StrPas(@Reply.Buffer2[Marker]);
    Inc(Marker, Length(ProtocolShortName) + 1);
    ProtocolLongName := StrPas(@Reply.Buffer2[Marker]);
  end;
  GetProtocolStackConfigInfo := Lo(NovRegs);
end;

{
  function        : GetServerSetCategories
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's info about the setable parameters
         categories of the file server

  Errors : - neSuccessfull
           - neInvalidStartNumber
 }

function GetServerSetCategories(StartNo : LongInt;
                                var ServerSetCategories : tServerSetCategories):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    Size        : Word;    { Size of request  }
    SubF        : Byte;    { Subfunction      }
    Start       : LongInt; { Start no         }
  end;

  Reply         :
  record
    Buffer1     : array[1..16] of Byte;  { First buffer of set structure  }
    Buffer2     : array[1..496] of Byte; { Second buffer with strings     }
  end;

begin
  with Request do
  begin
    Size  := SizeOf(Request) -2;
    SubF  := $3D;
    Start := StartNo;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  Move(Reply.Buffer1, ServerSetCategories, SizeOf(Reply.Buffer1));
  ServerSetCategories.CategoryName := StrPas(@Reply.Buffer2);
  GetServerSetCategories := Lo(NovRegs);
end;

{
  function        : GetServerSetCommandsInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's info about the setable parameters
         of the file server

  Errors : - neSuccessfull
           - neFailureOrInvalidStartNo
 }

function GetServerSetCommandsInfo(StartNo : LongInt;
                                  var ServerSetCommandsInfo :
                                    tServerSetCommandInfo):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    Size        : Word;    { Size of request  }
    SubF        : Byte;    { Subfunction      }
    Start       : LongInt; { Start no         }
  end;

  Reply         :
  record
    Buffer1     : array[1..28] of Byte;  { First buffer of set structure  }
    Buffer2     : array[1..484] of Byte; { Second buffer with strings     }
  end;

begin
  with Request do
  begin
    Size  := SizeOf(Request) -2;
    SubF  := $3C;
    Start := StartNo;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  Move(Reply.Buffer1, ServerSetCommandsInfo, SizeOf(Reply.Buffer1));
  ServerSetCommandsInfo.SetCmdName := StrPas(@Reply.Buffer2);
  GetServerSetCommandsInfo := Lo(NovRegs);
end;

{
  function        : GetNLMInfo
  service type    : Netware 4.0 infos
  Netware version : NW v4.x

  Desc : Get's info about the loaded NLM's on
         the file server

  Errors : - neSuccessfull
 }

function GetNLMInfo(NLMNo : LongInt;
                    var NLMInfo : tNLMInformation):Byte;

var
  NovRegs       : Word;
  Marker        : Word;

  Request       :
  record
    Size        : Word;    { Size of request  }
    SubF        : Byte;    { Subfunction      }
    NLM         : LongInt; { NLM no           }
  end;

  Reply         :
  record
    Buffer1     : array[1..68] of Byte;  { First buffer of set structure  }
    Buffer2     : array[1..444] of Byte; { Second buffer with strings     }
  end;

begin
  with Request do
  begin
    Size := SizeOf(Request) -2;
    SubF := $0B;
    NLM  := NLMNo;
  end;
  NovRegs := $F27B;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  Move(Reply.Buffer1, NLMInfo, SizeOf(Reply.Buffer1));

  Marker := 1;
  with NLMInfo do
  begin
    Move(Reply.Buffer2[Marker], FileName, Reply.Buffer2[Marker]);
    Inc(Marker, Length(FileName) + 1);
    Move(Reply.Buffer2[Marker], Name, Reply.Buffer2[Marker]);
  end;
  GetNLMInfo := Lo(NovRegs);
end;

{------------------------ end of unit ------------------------}

end.
