 {ͻ
   unit : Novell Bindery                        Target Platforms :       
   desc : Novell Bindery functions                - DOS Real             
                                                  - DOS Protected        
                                                  - Windows              
   (C) 1994 by Christoph Weller 16/01/93 v1.1                            
  ͼ}

(*

  30.12.1994 : record tProperty, changed PropertyValue[1..128] into
               PropertyValue[0..127] cause all property-records
               described in Charles G. Rose Netware-programing book
               starting with zero.

  3.1.1995   : Some object-names were declared wrong as String[47].

  4.2.1995   : added the functions
               - function GetBinderyTypeString(ObjectType : Word):String;
                 This function returns the given object-type as a
                 string

               - function GetObjectTypeStringId(ObjectType : String):Word;
                 This functions returns the given object-type string
                 as word

  4.2.1995   : added the constants for restriction flags
               (property LoginControl)

  18.1.1995  : Inserted all possible error-results of a procedure/function
               into the description-header.

*)

unit NVBindry;

interface

{$I NVDEFINE.INC}

uses
  Strings,  { Borland strings unit                      }
  NvMain;   { Novell main unit                          }

{
              CONST-Declarations
 }

const

  {---- Well known (pr)operties ----}

  prAccountBalance        = 'ACCOUNT_BALANCE';
  { Account balance : users account limits
     0     4  long   account (big endian !)
     4     4  long   account limit (-1 no limit) (big endian !)
     8   120         unused
  }

  prAccountHolds          = 'ACCOUNT_HOLDS';
  { Account holds : users account holds
     0     4  long   holder id 1
     4     4  long   from id 1 holded account
   ...   ...  ....   ...
   120     4  long   holder id 16
   124     4  long   from id 16 holded account
  }

  prAccountServers        = 'ACCOUNT_SERVERS';
  { Account servers : object id list of account servers }

  prAccountLockout        = 'ACCOUNT_LOCKOUT';
  { Account Lockout : intruder lockout
     0     2  word   count of allowed login retries
     2     2  word   minutes until counter-reset
     4     2  word   lockouts in minutes
  }

  prBlocksRead            = 'BLOCKS_READ';
  { Block Reads : fee for block reads
     long  time of next change
     word  current charge rate multiplier
     word  current charge rate divisor
   struct  [
     byte  days charge occurs mask
     byte  time charge occurs
     word  charge rate multiplier
     byte  charge rate divisor
 ]rate 20 
  }

  prBlocksWritten         = 'BLOCKS_WRITTEN';
  { Blocks written : fee for writing blocks
     long  time of next change
     word  current charge rate multiplier
     word  current charge rate divisor
   struct  [
     byte  days charge occurs mask
     byte  time charge occurs
     word  charge rate multiplier
     byte  charge rate divisor
 ]rate 20 
  }

  prConnectTime           = 'CONNECT_TIME';
  { Connect Time : fee for login time
     long  time of next change
     word  current charge rate multiplier
     word  current charge rate divisor
   struct  [
     byte  days charge occurs mask
     byte  time charge occurs
     word  charge rate multiplier
     byte  charge rate divisor
 ]rate 20 
  }

  prDiskStorage           = 'DISK_STORAGE';
  { Disk storage : fee for disk-space
     long  time of next change
     word  current charge rate multiplier
     word  current charge rate divisor
   struct  [
     byte  days charge occurs mask
     byte  time charge occurs
     word  charge rate multiplier
     byte  charge rate divisor
 ]rate 20 
  }

  prGroupMembers          = 'GROUP_MEMBERS';
  { Group members : user-id's of an group }

  prGroups_Im_In          = 'GROUPS_I''M_IN';
  { Groups i'm in : group-id of an user  }

  prIdentification        = 'IDENTIFICATION';
  { Identification : users full name }

  prLoginControl          = 'LOGIN_CONTROL';
  { Login control : account restrictions
     0     3  byte   account expiration date
     3     1  byte   account disabled flag
     4     3  byte   password expiration date
     7     1  byte   remaining grace logins
     8     2  word   password expiration interval (big-endian !)
    10     1  byte   grace login reset value
    11     1  byte   min. password length
    12     2  word   max. connections (big-endian !)
    14    42  byte   time limit (bit mask)
    56     3  byte   date of last login
    59     3  byte   time of last login
    62     1  byte   restrictions flags
    63     1  byte   unused
    64     4  long   max. disk space (blocks)
    68     2  word   bad login counter (big-endian !)
    70     4  long   time until bad login reset (big-endian !)
    74    12  byte   last intruder adress
  }

  prManagers              = 'MANAGERS';
  { Managers : id list of workgroup managers }

  prMiscLoginInfo         = 'MISC_LOGIN_INFO';
  { misc. login info : date and time of login
     0     1  byte   year (0-1 99)
     1     1  byte   month (1-12)
     2     1  byte   day (1-31)
     3     1  byte   hour (0-23)
     4     1  byte   minute (0-59)
     5     1  byte   seconds (0-59)
     6     1  byte   day of week (0-6, 0 = sunday)
  }

  prNetAddress            = 'NET_ADDRESS';
  { Net adress : adress of other file and print server
     0     4  byte   net adress
     4     6  byte   station adress
    10     2  byte   socket no.
  }

  prNodeControl           = 'NODE_CONTROL';
  { Node control : net/station adress which allow the user login
     0     4  byte   net 1
     4     6  byte   station 1
   ...   ...  ....   ..........
    ??     4  byte   net n
    ??     6  byte   station 1
  }

  prObjSupervisors        = 'OBJ_SUPERVISORS';
  { Obj supervisors : id list of account-manager for an object }

  prOldPasswords          = 'OLD_PASSWORDS';
  { Old passwords : if the option 'unique passwords' in login control
    is enabled, netware stores here the last 8 passwords of the user }

  prOperators             = 'OPERATORS';
  { operators : id list of console operators }

  prPassword              = 'PASSWORD';
  { Password : user passwords (no direct access, even for the supervisor !) }

  prQDirectory            = 'Q_DIRECTORY';
  { Queue directory : path to an queue-directory
     0     ?  ASCIIZ  Directory name
  }

  prQOperators            = 'Q_OPERATORS';
  { Queue operators : user-id list of the queue operators }

  prQServers              = 'Q_SERVERS';
  { Queue servers : contains the server-ids which can handle the jobs
    of an queue                                                       }

  prRequestsMade          = 'REQUESTS_MADE';
  { Requests made : fee for user requests
     long  time of next change
     word  current charge rate multiplier
     word  current charge rate divisor
   struct  [
     byte  days charge occurs mask
     byte  time charge occurs
     word  charge rate multiplier
     byte  charge rate divisor
 ]rate 20 
  }

  prSecEquals             = 'SECURITY_EQUALS';
  { Security equals : id list of the user or groups which are equal to
    the user                                                           }

  prUserDefaults          = 'USER_DEFAULTS';
  { User defaults : default for creating new users
     0     3  byte   account expiration date
     3     1  byte   restrictions flags
     4     2  word   password expiration interval
     6     1  byte   grace login reset value
     7     1  byte   min. password length
     8     2  word   max. connections
    10    42  byte   time limits (bit mask)
    52     4  long   account
    56     4  long   account limit
    60     4  long   max. disk space (blocks)
  }

  {---- (r)estriction (f)lags (see property LoginControl) ----}
  rfAllowUserPasswordChange  = $01; { allow user to change his password }
  rfRequireUniquePasswords   = $02; { user requires unique passwords    }


  {---- Netware (s)ecurity (l)evels write access ----}
  slWriteAnyone              = $00; { anyone  may access                     }
  slWriteLoggedOnly          = $10; { "logged" only logged-in clients
                                      may access                             }
  slWriteObjectOnly          = $20; { "object" only clients logged-in
                                      with object's name, type, and password }
  slWriteSuperVisor          = $30; { "supervisor" only clients logged-in
                                      with supervisor privileges             }
  slWriteNetwareOnly         = $40; { "NetWare" only NetWare may access      }

  { Netware (s)ecurity (l)evels read access }
  slReadAnyone               = $00; { Anyone,Everyone may access            }
  slReadLoggedOnly           = $01; { "logged" only logged-in clients
                                      may access                            }
  slReadObjectOnly           = $02; { "Object" only clients logged-in with
                                      object's name, type, and password     }
  slReadSuperVisor           = $03; { "Supervisor" only Clients logged-in
                                      with supervisor privileges            }
  slReadNetwareOnly          = $04; { "NetWare" only NetWare may access     }

  { (O)bject (t)ype }
  otWildcard                 =  Word(-1);{ wildcard searches all objects }
  otUnknown                  =  $0000; { unknown                         }
  otUser                     =  $0001; { User                            }
  otUserGroup                =  $0002; { User Group                      }
  otPrintQueue               =  $0003; { Print queue                     }
  otFileServer               =  $0004; { File server                     }
  otJobServer                =  $0005; { Job Server                      }
  otGateway                  =  $0006; { Gateway                         }
  otPrintServer              =  $0007; { Print Server                    }
  otArchiveQueue             =  $0008; { Archive Queue                   }
  otArchiveServer            =  $0009; { Archive Server                  }
  otJobQueue                 =  $000A; { Job Queue                       }
  otAdministration           =  $000B; { Administration                  }
  otNAS_SNAGateway           =  $0021; { NAS SNA Gateway                 }
  otRemoteBrigdeServer       =  $0026; { Remote Bridge Server            }
  otTCPIPGateway             =  $0027; { TPC/IP Gateway                  }
  otX25Bridge                =  $0028; { X25 bridge                      }
  otX25Gateway               =  $0029; { X25 gateway                     }
  otTimeSyncServer           =  $002D; { Time snychronization server     }
  otArchiveServerDynSAP      =  $002E; { Archive server dynamic SAP      }
  otDI3270Gateway            =  $0045; { DI 3270 gateway                 }
  otAdvertisingPServer       =  $0047; { Advertising Print Server        }
  otBtrieve5                 =  $004B; { Btrieve 5 server VAP/NLM        }
  otSQL                      =  $004C; { SQL VAP/NLM                     }
  otXTreeNetwork             =  $004D; { XTree network                   }
  otBtrieve4                 =  $0050; { Btrieve 4 server VAP/NLM        }
  otPrintQueueUser           =  $0053; { Print queue user                }
  otEiconRouter              =  $0058; { Eicon router                    }
  otArcserve30               =  $0066; { Arcserve 30                     }
  otWanCopyUtility           =  $0072; { Wancopy utility                 }
  otTESNetwareForVMS         =  $007A; { TES netware for VMS             }
  otEmeralBackup             =  $0092; { Emeral backup                   }
  otNetwareAccessServer      =  $0098; { Netware access server           }
  otPortableNetware          =  $009E; { Portable netware                }
  otPowerChute               =  $00A1; { Power chute                     }
  otCompaqStatusMonitor      =  $00AC; { Compaq status monitor           }
  otBindery                  =  $0102; { Netware bindery                 }
  otOracleDatabaseServer     =  $0103; { Oracle database montitor        }
  otRSPCXServer              =  $0107; { RSPCX Server                    }
  otCSAMux                   =  $0114; { CSA mux                         }
  otCSALsa                   =  $0115; { CSA lsa                         }
  otCSACm                    =  $0116; { CSA cm                          }
  otCSASma                   =  $0117; { CSA sma                         }
  otCSADba                   =  $0118; { CSA dba                         }
  otCSANma                   =  $0119; { CSA nma                         }
  otCSASsa                   =  $011A; { CSA ssa                         }
  otCSAStatus                =  $011B; { CSA status                      }
  otCSAAppc                  =  $011E; { CSA appc                        }
  otCSATest                  =  $0126; { CSA test                        }
  otCSATrace                 =  $012A; { CSA trace                       }
  otCommunicationsExec       =  $0130; { Communications exec             }
  otNNSDomain                =  $0133; { NNS domain                      }
  otNNSProfile               =  $0135; { NNS profile                     }
  otNw386PrintQueue          =  $0137; { Netware 386 print queue         }
  otLANSpoolServer           =  $0141; { LAN spool server                }
  otCompaqSMNPAgent          =  $0174; { Compaq SMNP agent               }
  otHPLaserjet               =  $030C; { HP laserjet                     }
  otPC3M                     =  $037E; { PC3M                            }
  otArcserve40               =  $03C4; { Arcserve 4.0                    }
  otNetwareSQL               =  $03DE; { Netware SQL                     }
  otSiteLockVRSFiles         =  $0429; { Site lock VRS files             }
  otSiteLockChecks           =  $0529; { Site lock checks                }
  otSiteLock                 =  $0B29; { Site lock                       }
  otSiteLockApplications     =  $0C29; { Site lock applications          }
  otSiteLock2                =  $2380; { Site lock 2                     }
  otSiteLockServer           =  $4808; { Site lock server                }
  otSiteLockUser             =  $5555; { Site lock user                  }
  otRabbitGateway            =  $6F00; { Rabbit gateway                  }
  otTapewareAgent            =  $7F82; { Tapeware agent                  }
  otLANport                  =  $8002; { LAN port                        }
  otIntelNetport             =  $8002; { Intel netport                   }
  otQuickNwManagement        =  $8888; { Quick netware management        }
  otWordPerfectNwVer         =  $8888; { Word perfect netware version    }
  otPegasusMail              =  $9009; { Pegasus mail                    }

{
              TYPE declarations
 }

type

  { bindery object }
  tBinderyObj    =
  record
    ObjectFlag     : Byte;         { 00h static,01h dynamic  }
    ObjectType     : Word;         { Object type             }
    ObjectName     : String[48];   { Object name             }
    ObjectId       : LongInt;      { Object id               }
    ObjectSec      : Byte;         { Object security level   }
    ObjectProperty : Byte;         { Object property flag    }
    ObjectPassword : String[127];  { Password                }
    MemberType     : Word;         { Member-type             }
    MemberName     : String[48];   { Member-name             }
  end;

  { property object }
  tProperty       =
  record
    PropertyName  : String[15];            { Property name                }
    PropertySeg   : Byte;                  { Property segment             }
    PropertyValue : array[0..127] of Byte; { Property value               }
    PropValueFlag : Byte;                  { Property value flag          }
    MoreSegments  : Byte;                  { More segments 00h no,FFh yes }
    PropertyFlag  : Byte;                  { Property flags               }
    PropertySec   : Byte;                  { Property security            }
  end;

  { bindery object set }
  tBinderyObjSet  =
  record
    ObjectType    : Word;       { Object type           }
    ObjectName    : String[48]; { Object name           }
    PropertyName  : String[15]; { Property name         }
    MemberType    : Word;       { Member typ            }
    MemberName    : String[48]; { Member name           }
  end;

  { account object }
  tAccount     =
  record
    ServiceType   : Word;        { Service type                          }
    AccCharged    : LongInt;     { Amount to be charged                  }
    AccReserved   : LongInt;     { Amount of account balance to reserve  }
    PriorHold     : LongInt;     { Amount of prior hold to be cancelled  }
    BinderyType   : Word;        { Bindery object type                   }
    CommentType   : Word;        { Type of comment 8000h-FFFFh reserved
                                   for exeperimental use                 }
    ObjectName    : String[48];  { Object name                           }
    Comment       : String;      { Comment                               }
  end;

  { Server account record for account status }
  tServerAccount  =
  record
    ServerId      : LongInt;    { Servers object id     }
    ServerAmount  : LongInt;    { Servers amount        }
  end;

  { Account status record }
  tAccountStatus  =
  record
    Size          : Word;                   { size of reply         }
    AccBalance    : LongInt;                { account balance       }
    CreditLimit   : LongInt;                { Credit limit          }
    Reserved      : array[1..120] of Byte;  { Reserved              }
    { server list with account holds }
    ServerList    : array[1..16] of tServerAccount;
  end;

{
        Procedure and Function-Headers
 }

{ BINDERY SERVICES Open bindery }
function OpenBindery:boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Close bindery }
function CloseBindery:boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Get bindery access level }
function GetBinderyAccessLevel(var SecLevels : Byte;
                               var ObjId : LongInt):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Get bindery object type-string }
function GetBinderyTypeString(ObjectType : Word):String;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Get object type-string id }
function GetObjectTypeStringId(ObjectType : String):Word;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Create bindery object }
function CreateBinderyObject(BinderyObject : tBinderyObj):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Delete bindery object }
function DeleteBinderyObject(BinderyObject : tBinderyObj):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Rename bindery object }
function RenameBinderyObject(NewName : String;
                             BinderyObject : tBinderyObj):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Get bindery object id }
function GetBinderyObjId(var Obj : tBinderyObj):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Get bindery object name }
function GetBinderyObjName(var Obj : tBinderyObj):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Scan bindery object name }
function ScanBinderyObject(var Obj : tBinderyObj):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Change bindery object security }
function ChangeBinderyObjectSecurity(var Obj : tBinderyObj):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Change bindery object password  }
function ChangeBinderyObjectPassword(var Obj : tBinderyObj;
                                     OldPassword,
                                     NewPassword : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Create property }
function CreateProperty(Obj : tBinderyObj;
                        Prop : tProperty):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Delete property }
function DeleteProperty(Obj : tBinderyObj;
                        var Prop : tProperty):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Read property value }
function ReadPropertyValue(Obj : tBinderyObj;
                           var Prop : tProperty):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Write property value }
function WritePropertyValue(Obj : tBinderyObj;
                            var Prop : tProperty;
                            EraseRemaining : boolean):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Scan property }
function ScanProperty(Obj : tBinderyObj;
                      var Prop : tProperty;
                      var Seq : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Change property security }
function ChangePropertySecurity(Obj : tBinderyObj;
                                var Prop : tProperty):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY SERVICES Verify bindery object password }
function VerifyBinderyPassword(Obj : tBinderyObj):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY GROUP SERVICES Is bindery object in set }
function IsObjectInSet(ObjSet : tBinderyObjSet):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY GROUP SERVICES Add bindery object to set }
function AddBinderyObject2Set(ObjSet : tBinderyObjSet):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ BINDERY GROUP SERVICES Delete bindery object from set }
function DeleteBinderyObjectFromSet(ObjSet : tBinderyObjSet):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ ACCOUNT SERVICES Get account status }
function GetAccountStatus(var AccStatus : tAccountStatus;
                          ObjectName : String;
                          ObjectType : Word):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ ACCOUNT SERVICES Sumbit account charge }
function SubmitAccountCharge(Acc : tAccount):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ ACCOUNT SERVICES Sumbit account hold }
function SubmitAccountHold(Acc : tAccount):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ ACCOUNT SERVICES Sumbit account note }
function SubmitAccountNote(Acc : tAccount):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

(* -------------------------- implemenation -------------------------- *)

implementation

{
  function        : OpenBindery
  Service type    : bindery services
  Netware version : NW v2.0 - v3.x

  Desc : Bindery open request, console privilege
         required.

  Errors : - neSuccessfull
 }

function OpenBindery:boolean;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    Size        : Word;
    SubF        : Byte;
  end;

begin
  Reply := 0;
  with Request do
  begin
    Size := SizeOf(Request) -2;
    SubF := $45;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  OpenBindery := (Lo(NovRegs) = neSuccessfull);
end;

{
  function        : CloseBindery
  Service type    : bindery services
  Netware version : NW v2.0 - v3.x

  Desc : Bindery close request, console privilege
         required.

  Errors : - neSuccessfull
 }

function CloseBindery:boolean;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    Size        : Word;
    SubF        : Byte;
  end;

begin
  Reply := 0;
  with Request do
  begin
    Size := SizeOf(Request) -2;
    SubF := $44;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  CloseBindery := (Lo(NovRegs) = neSuccessfull);
end;

{
  function        : GetBinderyAccessLevel
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Get's the access-level for the bindery

  Errors : - neSuccessfull
 }

function GetBinderyAccessLevel(var SecLevels : Byte;
                               var ObjId : LongInt):boolean;

var
  NovRegs       : Word;

  Request       :
  record
    Size        : Word;
    SubF        : Byte;
  end;

  Reply         :
  record
    Size        : Word;      { Size of reply                     }
    SecLevel    : Byte;      { Bindery security level            }
    ObjectId    : LongInt;   { Object id of bindery (big-endian) }
  end;

begin
  Reply.Size := SizeOf(Reply) -2;
  with Request do
  begin
    Size := SizeOf(Request) -2;
    SubF := $46;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  if Lo(NovRegs) = neSuccessfull then
  begin
    GetBinderyAccessLevel := true;
    SecLevels             := Reply.SecLevel;
    ObjId                 := SwapLongInt(Reply.ObjectId);
  end
  else
  begin
    GetBinderyAccessLevel := false;
    SecLevels             := 0;
    ObjId                 := 0;
  end;
end;

{
  function        : GetBinderyTypeString
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Returns a desc-string of the given
         object-type
 }

function GetBinderyTypeString(ObjectType : Word):String;

begin
  if ObjectType = otWildcard then
  begin
    GetBinderyTypeString := 'Wildcard';
    exit;
  end;
  case ObjectType of
    otUnknown                  : GetBinderyTypeString := 'unknown type';
    otUser                     : GetBinderyTypeString := 'User';
    otUserGroup                : GetBinderyTypeString := 'Group';
    otPrintQueue               : GetBinderyTypeString := 'Printer queue';
    otFileServer               : GetBinderyTypeString := 'File server';
    otJobServer                : GetBinderyTypeString := 'Job server';
    otGateway                  : GetBinderyTypeString := 'Gateway';
    otPrintServer              : GetBinderyTypeString := 'Print server';
    otArchiveQueue             : GetBinderyTypeString := 'Archiv queue';
    otArchiveServer            : GetBinderyTypeString := 'Archive server';
    otJobQueue                 : GetBinderyTypeString := 'Job queue';
    otAdministration           : GetBinderyTypeString := 'Administration';
    otNAS_SNAGateway           : GetBinderyTypeString := 'NAS/SNA Gateway';
    otRemoteBrigdeServer       : GetBinderyTypeString := 'Remote bridge server';
    otTCPIPGateway             : GetBinderyTypeString := 'TCP/IP Gateway';
    otX25Bridge                : GetBinderyTypeString := 'X25 bridge';
    otX25Gateway               : GetBinderyTypeString := 'X25 gateway';
    otTimeSyncServer           : GetBinderyTypeString := 'Time synchronization server';
    otArchiveServerDynSAP      : GetBinderyTypeString := 'Archive server dyn SAP';
    otDI3270Gateway            : GetBinderyTypeString := 'DI3270 gateway';
    otAdvertisingPServer       : GetBinderyTypeString := 'Advertising print server';
    otBtrieve5                 : GetBinderyTypeString := 'Btrieve 5';
    otSQL                      : GetBinderyTypeString := 'SQL';
    otXTreeNetwork             : GetBinderyTypeString := 'XTree network';
    otBtrieve4                 : GetBinderyTypeString := 'Btrieve 4';
    otPrintQueueUser           : GetBinderyTypeString := 'Print queue user';
    otEiconRouter              : GetBinderyTypeString := 'Eicon router';
    otArcserve30               : GetBinderyTypeString := 'Arcserve 3.0';
    otWanCopyUtility           : GetBinderyTypeString := 'Wan copy utility';
    otTESNetwareForVMS         : GetBinderyTypeString := 'TES Netware for VMS';
    otEmeralBackup             : GetBinderyTypeString := 'Emeral backup';
    otNetwareAccessServer      : GetBinderyTypeString := 'Netware access server';
    otPortableNetware          : GetBinderyTypeString := 'Portable Netware';
    otPowerChute               : GetBinderyTypeString := 'Power chute';
    otCompaqStatusMonitor      : GetBinderyTypeString := 'Compaq status monitor';
    otBindery                  : GetBinderyTypeString := 'Bindery';
    otOracleDatabaseServer     : GetBinderyTypeString := 'Orcale database server';
    otRSPCXServer              : GetBinderyTypeString := 'RSPCX server';
    otCSAMux                   : GetBinderyTypeString := 'CSA mux';
    otCSALsa                   : GetBinderyTypeString := 'CSA Lsa';
    otCSACm                    : GetBinderyTypeString := 'CSA Cm';
    otCSASma                   : GetBinderyTypeString := 'CSA Sma';
    otCSADba                   : GetBinderyTypeString := 'CSA Dba';
    otCSANma                   : GetBinderyTypeString := 'CSA Nma';
    otCSASsa                   : GetBinderyTypeString := 'CSA Ssa';
    otCSAStatus                : GetBinderyTypeString := 'CSA status';
    otCSAAppc                  : GetBinderyTypeString := 'CSA Appc';
    otCSATest                  : GetBinderyTypeString := 'CSA test';
    otCSATrace                 : GetBinderyTypeString := 'CSA trace';
    otCommunicationsExec       : GetBinderyTypeString := 'Communications exec';
    otNNSDomain                : GetBinderyTypeString := 'NNS domain';
    otNNSProfile               : GetBinderyTypeString := 'NNS profile';
    otNw386PrintQueue          : GetBinderyTypeString := 'Nw 386 print queue';
    otLANSpoolServer           : GetBinderyTypeString := 'LAN spool server';
    otCompaqSMNPAgent          : GetBinderyTypeString := 'Compaq SMNP agent';
    otHPLaserjet               : GetBinderyTypeString := 'HP Laserjet';
    otPC3M                     : GetBinderyTypeString := 'PC3M';
    otArcserve40               : GetBinderyTypeString := 'Arcserve 4.0';
    otNetwareSQL               : GetBinderyTypeString := 'Netware SQL';
    otSiteLockVRSFiles         : GetBinderyTypeString := 'Site lock VRS files';
    otSiteLockChecks           : GetBinderyTypeString := 'Site lock checks';
    otSiteLock                 : GetBinderyTypeString := 'Site lock';
    otSiteLockApplications     : GetBinderyTypeString := 'Site lock applications';
    otSiteLock2                : GetBinderyTypeString := 'Site lock 2';
    otSiteLockServer           : GetBinderyTypeString := 'Site lock server';
    otSiteLockUser             : GetBinderyTypeString := 'Site lock user';
    otRabbitGateway            : GetBinderyTypeString := 'Rabbit gateway';
    otTapewareAgent            : GetBinderyTypeString := 'Tapeware agent';
    otLANport                  : GetBinderyTypeString := 'LAN port';
    otIntelNetport             : GetBinderyTypeString := 'Intel netport';
    otQuickNwManagement        : GetBinderyTypeString := 'Quick NW Managment';
    otWordPerfectNwVer         : GetBinderyTypeString := 'Word perfect NW version';
    otPegasusMail              : GetBinderyTypeString := 'Pegasus mail';
  end;
end;

{
  function        : GetObjectTypeStringId
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Gets the object-type id from the
         given string
 }

function GetObjectTypeStringId(ObjectType : String):Word;

begin
  ObjectType := StUpCase(ObjectType);
  if ObjectType = 'WILDCARD'             then GetObjectTypeStringId := otWildcard;
  if ObjectType = 'UNKNOWN'              then GetObjectTypeStringId := otUnknown;
  if ObjectType = 'USER'                 then GetObjectTypeStringId := otUser;
  if ObjectType = 'USERGROUP'            then GetObjectTypeStringId := otUserGroup;
  if ObjectType = 'PRINTQUEUE'           then GetObjectTypeStringId := otPrintQueue;
  if ObjectType = 'FILESERVER'           then GetObjectTypeStringId := otFileServer;
  if ObjectType = 'JOBSERVER'            then GetObjectTypeStringId := otJobServer;
  if ObjectType = 'GATEWAY'              then GetObjectTypeStringId := otGateway;
  if ObjectType = 'PRINTSERVER'          then GetObjectTypeStringId := otPrintServer;
  if ObjectType = 'ARCHIVEQUEUE'         then GetObjectTypeStringId := otArchiveQueue;
  if ObjectType = 'ARCHIVESERVER'        then GetObjectTypeStringId := otArchiveServer;
  if ObjectType = 'JOBQUEUE'             then GetObjectTypeStringId := otJobQueue;
  if ObjectType = 'AMINISTRATION'        then GetObjectTypeStringId := otAdministration;
  if ObjectType = 'NAS_SNAGATEWAY'       then GetObjectTypeStringId := otNAS_SNAGateway;
  if ObjectType = 'REMOTEBRIGDESERVER'   then GetObjectTypeStringId := otRemoteBrigdeServer;
  if ObjectType = 'TCPIPGATEWAY'         then GetObjectTypeStringId := otTCPIPGateway;
  if ObjectType = 'X25BRIDGE'            then GetObjectTypeStringId := otX25Bridge;
  if ObjectType = 'X25GATEWAY'           then GetObjectTypeStringId := otX25Gateway;
  if ObjectType = 'TIMESYNCSERVER'       then GetObjectTypeStringId := otTimeSyncServer;
  if ObjectType = 'ARCHIVESERVERDYNSAP'  then GetObjectTypeStringId := otArchiveServerDynSAP;
  if ObjectType = 'DI3270GATEWAY'        then GetObjectTypeStringId := otDI3270Gateway;
  if ObjectType = 'ADVERTISINGPSERVER'   then GetObjectTypeStringId := otAdvertisingPServer;
  if ObjectType = 'BTRIEVE5'             then GetObjectTypeStringId := otBtrieve5;
  if ObjectType = 'SQL'                  then GetObjectTypeStringId := otSQL;
  if ObjectType = 'XTREENETWORK'         then GetObjectTypeStringId := otXTreeNetwork;
  if ObjectType = 'BTRIEVE4'             then GetObjectTypeStringId := otBtrieve4;
  if ObjectType = 'PRINTQUEUEUSER'       then GetObjectTypeStringId := otPrintQueueUser;
  if ObjectType = 'EICONROUTER'          then GetObjectTypeStringId := otEiconRouter;
  if ObjectType = 'ARCSERVE30'           then GetObjectTypeStringId := otArcserve30;
  if ObjectType = 'WANCOPYUTILITY'       then GetObjectTypeStringId := otWanCopyUtility;
  if ObjectType = 'TESNETWAREFORVMS'     then GetObjectTypeStringId := otTESNetwareForVMS;
  if ObjectType = 'EMERALBACKUP'         then GetObjectTypeStringId := otEmeralBackup;
  if ObjectType = 'NETWAREACCESSSERVER'  then GetObjectTypeStringId := otNetwareAccessServer;
  if ObjectType = 'PORTABLENETWARE'      then GetObjectTypeStringId := otPortableNetware;
  if ObjectType = 'POWERCHUTE'           then GetObjectTypeStringId := otPowerChute;
  if ObjectType = 'COMPAQSTATUSMONITOR'  then GetObjectTypeStringId := otCompaqStatusMonitor;
  if ObjectType = 'BINDERY'              then GetObjectTypeStringId := otBindery;
  if ObjectType = 'ORACLEDATABASESERVER' then GetObjectTypeStringId := otOracleDatabaseServer;
  if ObjectType = 'RSPCXSERVER'          then GetObjectTypeStringId := otRSPCXServer;
  if ObjectType = 'CSAMUX'               then GetObjectTypeStringId := otCSAMux;
  if ObjectType = 'CSALSA'               then GetObjectTypeStringId := otCSALsa;
  if ObjectType = 'CSACM'                then GetObjectTypeStringId := otCSACm;
  if ObjectType = 'CSASMA'               then GetObjectTypeStringId := otCSASma;
  if ObjectType = 'CSADBA'               then GetObjectTypeStringId := otCSADba;
  if ObjectType = 'CSANMA'               then GetObjectTypeStringId := otCSANma;
  if ObjectType = 'CSASSA'               then GetObjectTypeStringId := otCSASsa;
  if ObjectType = 'CSASTATUS'            then GetObjectTypeStringId := otCSAStatus;
  if ObjectType = 'CSAAPPC'              then GetObjectTypeStringId := otCSAAppc;
  if ObjectType = 'CSATEST'              then GetObjectTypeStringId := otCSATest;
  if ObjectType = 'CSATRACE'             then GetObjectTypeStringId := otCSATrace;
  if ObjectType = 'COMMUNICATIONSEXEC'   then GetObjectTypeStringId := otCommunicationsExec;
  if ObjectType = 'NNSDOMAIN'            then GetObjectTypeStringId := otNNSDomain;
  if ObjectType = 'NNSPROFILE'           then GetObjectTypeStringId := otNNSProfile;
  if ObjectType = 'NW386PRINTQUEUE'      then GetObjectTypeStringId := otNw386PrintQueue;
  if ObjectType = 'LANSPOOLSERVER'       then GetObjectTypeStringId := otLANSpoolServer;
  if ObjectType = 'COMPAQSMNPAGENT'      then GetObjectTypeStringId := otCompaqSMNPAgent;
  if ObjectType = 'HPLASERJET'           then GetObjectTypeStringId := otHPLaserjet;
  if ObjectType = 'PC3M'                 then GetObjectTypeStringId := otPC3M;
  if ObjectType = 'ARCSERVE40'           then GetObjectTypeStringId := otArcserve40;
  if ObjectType = 'NETWARESQL'           then GetObjectTypeStringId := otNetwareSQL;
  if ObjectType = 'SITELOCKVRSFILES'     then GetObjectTypeStringId := otSiteLockVRSFiles;
  if ObjectType = 'SITELOCKCHECKS'       then GetObjectTypeStringId := otSiteLockChecks;
  if ObjectType = 'SITELOCK'             then GetObjectTypeStringId := otSiteLock;
  if ObjectType = 'SITELOCKAPPLICATIONS' then GetObjectTypeStringId := otSiteLockApplications;
  if ObjectType = 'SITELOCK2'            then GetObjectTypeStringId := otSiteLock2;
  if ObjectType = 'SITELOCKSERVER'       then GetObjectTypeStringId := otSiteLockServer;
  if ObjectType = 'SITELOCKUSER'         then GetObjectTypeStringId := otSiteLockUser;
  if ObjectType = 'RABBITGATEWAY'        then GetObjectTypeStringId := otRabbitGateway;
  if ObjectType = 'TAPEWAREAGENT'        then GetObjectTypeStringId := otTapewareAgent;
  if ObjectType = 'LANPORT'              then GetObjectTypeStringId := otLANport;
  if ObjectType = 'INTELNETPORT'         then GetObjectTypeStringId := otIntelNetport;
  if ObjectType = 'QUICKNWMANAGEMENT'    then GetObjectTypeStringId := otQuickNwManagement;
  if ObjectType = 'WORDPERFECTNWVER'     then GetObjectTypeStringId := otWordPerfectNwVer;
  if ObjectType = 'PEGASUSMAIL'          then GetObjectTypeStringId := otPegasusMail;
end;

{
  function        : CreateBinderyObject
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Creates an bindery-object

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neObjectExists
           - neInvalidName
           - neInvalidBindSecLevel
           - neNoCreateObjPrivilege
           - neBinderyLocked
           - neBinderyError
 }

function CreateBinderyObject(BinderyObject : tBinderyObj):Byte;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    Size        : Word; { Length of request           }
    SubF        : Byte; { Subfunction                 }
    ObjFlag     : Byte; { Object flag                 }
    ObjSec      : Byte; { Object security             }
    ObjType     : Word; { Object type  (big-endian)   }
    ObjName     : String[48]; { Object name           }
  end;

begin
  Reply := 0;
  FillChar(Request, SizeOf(Request), 0);
  with Request, BinderyObject do
  begin
    Size    := SizeOf(Request) -2;
    SubF    := $32;
    ObjFlag := ObjectFlag;
    ObjSec  := ObjectSec;
    ObjType := Swap(ObjectType);
    ObjName := ObjectName;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  CreateBinderyObject := Lo(NovRegs);
end;

{
  procedure       : DeleteBinderyObject
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Deletes an bindery-object

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neInvalidName
           - neNoWildcardAllowed
           - neNoDeleteObjPrivilege
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function DeleteBinderyObject(BinderyObject : tBinderyObj):Byte;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    Size        : Word; { Length of request         }
    SubF        : Byte; { Subfunction               }
    ObjType     : Word; { Object type  (big-endian) }
    ObjName     : String[48]; { Object name         }
  end;

begin
  Reply := 0;
  FillChar(Request, SizeOf(Request), 0);
  with Request do
  begin
    Size    := SizeOf(Request) -2;
    SubF    := $33;
    ObjType := Swap(BinderyObject.ObjectType);
    ObjName := BinderyObject.ObjectName;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  DeleteBinderyObject := Lo(NovRegs);
end;

{
  function        : RenameBinderyObject
  Service type    : bindery services
  Netware version : NW v2.x - vx.x

  Desc : Renames an bindery-object

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neInvalidName
           - neNoWildcardAllowed
           - neNoRenameObjPrivilege
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function RenameBinderyObject(NewName : String;
                             BinderyObject : tBinderyObj):Byte;

var
  NovRegs       : Word;
  Reply         : Word;
  Marker        : Byte;

  Request       :
  record
    Size        : Word; { Length of request         }
    SubF        : Byte; { Subfunction               }
    ObjType     : Word; { Object type  (big-endian) }
    ObjName     : array[1..96] of Byte;
                  { 48 Bytes object name
                    48 Bytes new name               }
  end;

begin
  Reply := 0;
  FillChar(Request, SizeOf(Request), 0);
  with Request, BinderyObject do
  begin
    SubF    := $34;
    ObjType := Swap(ObjectType);
    Marker := 1;

    ObjectName := StupCase(ObjectName);
    Move(ObjectName, Ptr(Seg(ObjName[Marker]), Ofs(ObjName[Marker]))^, Length(ObjectName) + 1);
    Inc(Marker, Length(ObjectName) + 1);

    NewName := StupCase(NewName);
    Move(NewName, Ptr(Seg(ObjName[Marker]), Ofs(ObjName[Marker]))^, Length(NewName) + 1);
    Inc(Marker, Length(NewName) + 1);

    Size := 3 + Marker;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  RenameBinderyObject := Lo(NovRegs);
end;

{
  function        : GetBinderyObjectID
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Gets the object-id of an bindery-object

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neInvalidName
           - neNoWildcardAllowed
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function GetBinderyObjId(var Obj : tBinderyObj):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    Size       : Word; { Length of request           }
    SubF       : Byte; { Subfunction                 }
    ObjType    : Word; { Object type  (big-endian)   }
    ObjName    : String[48]; { Object name           }
  end;

  Reply         :
  record
    Size        : Word;    { Length of reply          }
    ObjId       : LongInt; { Object id (big endian)   }
    ObjType     : Word;    { Object type              }
    ObjName     : array[1..48] of Char; { Object name }
  end;

begin
  Reply.Size := SizeOf(Reply) -2;
  FillChar(Request, SizeOf(Request), 0);
  with Request do
  begin
    Size    := SizeOf(Request) -2;
    SubF    := $35;
    ObjType := Swap(Obj.ObjectType);
    ObjName := StUpCase(Obj.ObjectName);
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetBinderyObjId := Lo(NovRegs);
  if Lo(NovRegs) = neSuccessfull then
  begin
    with Obj, Reply do
    begin
      ObjectType   := Swap(ObjType);
      ObjectName   := StrPas(@ObjName);
      ObjectId     := SwapLongInt(Reply.ObjId);
    end;
  end;
end;

{
  function        : GetBinderyObjectName
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Get's the object-name of an
         bindery-object

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function GetBinderyObjName(var Obj : tBinderyObj):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    Size       : Word;     { Length of request           }
    SubF       : Byte;     { Subfunction                 }
    ObjId      : LongInt;  { Object id                   }
  end;

  Reply         :
  record
    Size        : Word;    { Length of reply          }
    ObjId       : LongInt; { Object id (big endian)   }
    ObjType     : Word;    { Object type              }
    ObjName     : array[1..48] of Char; { Object name }
  end;

begin
  Reply.Size := SizeOf(Reply) - 2;
  with Request do
  begin
    Size  := SizeOf(Request) -2;
    SubF  := $36;
    ObjId := SwapLongInt(Obj.ObjectId);
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetBinderyObjName := Lo(NovRegs);
  with Obj, Reply do
  begin
    ObjectType := Swap(ObjType);
    ObjectName := StrPas(@ObjName);
    ObjectId   := SwapLongInt(ObjId);
  end;
end;

{
  function        : ScanBinderyObject
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Scan's the bindery for an object

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neInvalidName
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function ScanBinderyObject(var Obj : tBinderyObj):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    Size       : Word;       { Length of request           }
    SubF       : Byte;       { Subfunction                 }
    LastObjId  : LongInt;    { last object id              }
    ObjTyp     : Word;       { Object typ                  }
    ObjName    : String[48]; { Object name                 }
  end;

  Reply         :
  record
    Size        : Word;                 { Length of reply                 }
    ObjId       : LongInt;              { Object id (big endian)          }
    ObjType     : Word;                 { Object type                     }
    ObjName     : array[1..48] of Char; { Object name                     }
    ObjFlag     : Byte;                 { Object flag
                                          00h static,
                                          01h dynamic                     }
    ObjSec      : Byte;                 { Object security level           }
    ObjProp     : Byte;                 { Objects property flag           }
  end;

begin
  Reply.Size := SizeOf(Reply) - 2;
  FillChar(Request, SizeOf(Request), 0);
  with Request do
  begin
    Size      := SizeOf(Request) -2;
    SubF      := $37;
    LastObjId := SwapLongInt(Obj.ObjectId);
    ObjTyp    := Swap(Obj.ObjectType);
    ObjName   := Obj.ObjectName;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  ScanBinderyObject := Lo(NovRegs);
  with Obj, Reply do
  begin
    FillChar(ObjectName, SizeOf(ObjectName), 0);
    ObjectId       := SwapLongInt(ObjId);
    ObjectType     := Swap(ObjType);
    ObjectName     := StrPas(@ObjName);
    ObjectFlag     := ObjFlag;
    ObjectSec      := ObjSec;
    ObjectProperty := ObjProp;
  end;
end;

{
  function        : ChangeBinderyObjectSecurity
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Changes the security of an
         bindery object

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neNoWildcardAllowed
           - neInvalidBindSecLevel
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function ChangeBinderyObjectSecurity(var Obj : tBinderyObj):Byte;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    Size        : Word;       { Length of request           }
    SubF        : Byte;       { Subfunction                 }
    NewSecLevel : Byte;       { New security level          }
    ObjTyp      : Word;       { Object typ                  }
    ObjName     : String[48]; { Object name                 }
  end;

begin
  Reply := 0;
  FillChar(Request, SizeOf(Request), 0);
  with Request do
  begin
    Size        := SizeOf(Request) -2;
    SubF        := $38;
    NewSecLevel := Obj.ObjectSec;
    ObjTyp      := Swap(Obj.ObjectType);
    ObjName     := Obj.ObjectName;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  ChangeBinderyObjectSecurity := Lo(NovRegs);
end;

{
  function        : ChangeBinderyObjectPassword
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Changes the password of an
         bindery object

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neNoWildcardAllowed
           - neNoSuchProperty
           - neNoSuchObject
           - neBinderyLocked
           - neNoSuchObjectOrBadPwd
 }

function ChangeBinderyObjectPassword(var Obj : tBinderyObj;
                                     OldPassword,
                                     NewPassword : String):Byte;

var
  NovRegs       : Word;
  Reply         : Word;
  Marker        : Integer;

  Request       :
  record
    Size        : Word;    { Length of request           }
    SubF        : Byte;    { Subfunction                 }
    ObjTyp      : Word;    { Object typ                  }
    ObjNamePwd  : array[1..304] of Byte;
                  { 48  Bytes Object name
                    127 Bytes New password
                    127 Bytes Old password               }
  end;

begin
  Reply := 0;
  FillChar(Request, SizeOf(Request), 0);
  with Request, Obj do
  begin
    SubF   := $40;
    ObjTyp := Swap(Obj.ObjectType);
    Marker := 1;

    ObjectName := StupCase(ObjectName);
    Move(ObjectName, Ptr(Seg(ObjNamePwd[Marker]), Ofs(ObjNamePwd[Marker]))^,
         Length(ObjectName) + 1);
    Inc(Marker, Length(ObjectName) + 1);

    OldPassword := StupCase(OldPassword);
    Move(OldPassword, Ptr(Seg(ObjNamePwd[Marker]), Ofs(ObjNamePwd[Marker]))^,
         Length(OldPassword) + 1);
    Inc(Marker, Length(OldPassword) + 1);

    NewPassword := StupCase(NewPassword);
    Move(NewPassword, Ptr(Seg(ObjNamePwd[Marker]), Ofs(ObjNamePwd[Marker]))^,
         Length(NewPassword) + 1);
    Inc(Marker, Length(NewPassword) + 1);

    Size := 3 + Marker;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  ChangeBinderyObjectPassword := Lo(NovRegs);
end;

{
  function        : CreateProperty
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Creates an object property

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neNoWildcardAllowed
           - neNoSuchProperty
           - neNoSuchObject
           - neBinderyLocked
           - neNoSuchObjectOrBadPwd
 }

function CreateProperty(Obj : tBinderyObj;
                        Prop : tProperty):Byte;

var
  NovRegs       : Word;
  Reply         : Word;
  Marker        : Byte;

  Request       :
  record
    Size        : Word;    { Length of request           }
    SubF        : Byte;    { Subfunction                 }
    ObjTyp      : Word;    { Object typ                  }
    BindObject  : array[1..67] of Byte;
                   { 1  Byte Object name length
                     48 Bytes Objects name
                     1  Byte  Property flags
                     1  Byte  Property security
                     1  Byte  Property length
                     15 Bytes Property name               }
  end;

begin
  Reply := 0;
  FillChar(Request, SizeOf(Request), 0);
  with Request, Obj, Prop do
  begin
    SubF   := $39;
    ObjTyp := Swap(Obj.ObjectType);
    Marker := 1;

    ObjectName := StupCase(ObjectName);
    Move(ObjectName, Ptr(Seg(BindObject[Marker]), Ofs(BindObject[Marker]))^,
         Length(ObjectName) + 1);
    Inc(Marker, Length(ObjectName) + 1);

    ObjectName[Marker] := Chr(PropertyFlag);
    Inc(Marker);

    ObjectName[Marker] := Chr(PropertySec);
    Inc(Marker);

    PropertyName := StUpCase(PropertyName);
    Move(PropertyName, Ptr(Seg(BindObject[Marker]), Ofs(BindObject[Marker]))^,
         Length(PropertyName) + 1);
    Inc(Marker, Length(PropertyName) + 1);

    Size := 3 + Marker;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  CreateProperty := Lo(NovRegs);
end;

{
  function        : DeleteProperty
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Deletes an object property

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neNoWildcardAllowed
           - neInvalidBindSecLevel
           - neNoDeletePropPriv
           - neNoSuchProperty
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function DeleteProperty(Obj : tBinderyObj;
                        var Prop : tProperty):Byte;

var
  NovRegs       : Word;
  Reply         : Word;
  Marker        : Byte;

  Request       :
  record
    Size        : Word;    { Length of request           }
    SubF        : Byte;    { Subfunction                 }
    ObjTyp      : Word;    { Object typ                  }
    BindObj     : array[1..66] of Byte;
                  { 1   Byte object name length
                    N   Bytes object name
                    1   Byte property name length
                    N   Bytes property name              }
  end;

begin
  Reply := 0;
  FillChar(Request, SizeOf(Request), 0);
  with Request, Obj, Prop do
  begin
    SubF      := $3A;
    ObjTyp    := Swap(Obj.ObjectType);
    Marker := 1;

    ObjectName := StupCase(ObjectName);
    Move(ObjectName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(ObjectName) + 1);
    Inc(Marker, Length(ObjectName) + 1);

    PropertyName := StUpCase(PropertyName);
    Move(PropertyName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(PropertyName) + 1);
    Inc(Marker, Length(PropertyName) + 1);

    Size := 3 + Marker;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  DeleteProperty := Lo(NovRegs);
end;

{
  function        : ReadPropertyValue
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Reads the property values of an object

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neNoSuchSegment
           - neNoWildcardAllowed
           - neInvalidBindSecLevel
           - neNoSuchProperty
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function ReadPropertyValue(Obj : tBinderyObj;
                           var Prop : tProperty):Byte;

var
  NovRegs       : Word;
  Marker        : Byte;

  Request       :
  record
    Size        : Word;       { Length of request           }
    SubF        : Byte;       { Subfunction                 }
    ObjTyp      : Word;       { Object typ                  }
    BindObj     : array[1..67] of Byte;
                  { 1   Byte object name length
                    N   Bytes object name
                    4   Bytes sequenze no
                    1   Byte property name length
                    N   Bytes property name                  }
  end;

  Reply         :
  record
    Size        : Word;                   { Size of reply                 }
    PropValue   : array[0..127] of Byte;  { Property value                }
    MoreSeg     : Byte;                   { More Segments 00h no, FFh yes }
    PropFlag    : Byte;                   { Property flags                }
  end;

begin
  Reply.Size := SizeOf(Reply) - 2;
  FillChar(Request, SizeOf(Request), 0);
  with Request, Obj, Prop do
  begin
    SubF    := $3D;
    ObjTyp  := Swap(Obj.ObjectType);
    Marker  := 1;

    ObjectName := StupCase(ObjectName);
    Move(ObjectName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(ObjectName) + 1);
    Inc(Marker, Length(ObjectName) + 1);

    BindObj[Marker] := PropertySeg;
    Inc(Marker);

    PropertyName := StupCase(PropertyName);
    Move(PropertyName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(PropertyName) + 1);
    Inc(Marker, Length(PropertyName) + 1);

    Size := 3 + Marker;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  ReadPropertyValue := Lo(NovRegs);
  with Prop, Reply do
  begin
    Move(PropValue, PropertyValue, 128);
    MoreSegments  := MoreSeg;
    PropertyFlag  := PropFlag;
  end;
end;

{
  function        : WritePropertyValue
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Writes an property value to an object

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neNoItemProperty
           - neNoSuchSegment
           - neNoWildcardAllowed
           - neInvalidBindSecLevel
           - neNoPropWritePrivilege
           - neNoSuchProperty
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function WritePropertyValue(Obj : tBinderyObj;
                            var Prop : tProperty;
                            EraseRemaining : boolean):Byte;

var
  NovRegs       : Word;
  Reply         : Word;
  Marker        : Byte;

  Request       :
  record
    Size        : Word;    { Length of request           }
    SubF        : Byte;    { Subfunction                 }
    ObjTyp      : Word;    { Object typ                  }
    BindObj     : array[1..196] of Byte;
                  { 1   Byte  Object length
                    48  Bytes Object name
                    1   Byte  Property segment
                    1   Byte  Flag erase remaining segemnts
                    1   Byte  Length of property
                    16  Bytes Property name
                    128 Bytes Property value segment     }
  end;

begin
  Reply := 0;
  FillChar(Request, SizeOf(Request), 0);
  with Request, Obj, Prop do
  begin
    SubF   := $3E;
    ObjTyp := Swap(ObjectType);
    FillChar(BindObj, SizeOf(BindObj), 0);
    Marker := 1;

    ObjectName := StupCase(ObjectName);
    Move(ObjectName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(ObjectName) + 1);
    Inc(Marker, Length(ObjectName) + 1);

    BindObj[Marker] := Prop.PropertySeg;
    Inc(Marker);

    if EraseRemaining then
      BindObj[Marker] := 255
    else
      BindObj[Marker] := 0;
    Inc(Marker);

    PropertyName := StupCase(PropertyName);
    Move(PropertyName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(PropertyName) + 1);
    Inc(Marker, Length(PropertyName) + 1);

    Move(PropertyValue, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         SizeOf(PropertyValue));
    Inc(Marker, SizeOf(PropertyValue));

    Size := 3 + Marker;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  WritePropertyValue := Lo(NovRegs);
end;

{
  function        : ScanProperty
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Scan's the property's of an object

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neInvalidBindSecLevel
           - neNoSuchProperty
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function ScanProperty(Obj : tBinderyObj;
                      var Prop : tProperty;
                      var Seq : LongInt):Byte;

var
  NovRegs       : Word;
  Marker        : Byte;

  Request       :
  record
    Size        : Word;        { Length of request           }
    SubF        : Byte;        { Subfunction                 }
    ObjTyp      : Word;        { Object typ                  }
    BindObj     : array[1..70] of Byte;
                  { 1   Byte object name length
                    N   Bytes object name
                    4   Bytes sequenze no
                    1   Byte property name length
                    N   Bytes property name                  }
  end;

  Reply         :
  record
    Size          : Word;                  { Size of reply      }
    PropName      : array[1..16] of Char;  { Property name      }
    PropFlags     : Byte;                  { Property flags     }
    PropSec       : Byte;                  { Property security  }
    Sequence      : LongInt;               { Sequence number    }
    PropValue     : Byte;                  { Property value     }
    MoreProp      : Byte;                  { More properties    }
  end;

begin
  Reply.Size := SizeOf(Reply) - 2;
  FillChar(Request, SizeOf(Request), 0);
  with Request, Obj, Prop do
  begin
    SubF    := $3C;
    ObjTyp  := Swap(ObjectType);
    Marker  := 1;

    ObjectName := StupCase(ObjectName);
    Move(ObjectName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(ObjectName) + 1);
    Inc(Marker, Length(ObjectName) + 1);

    Seq := SwapLongInt(Seq);
    Move(Seq, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^, 4);
    Inc(Marker, 4);

    PropertyName := StupCase(PropertyName);
    Move(PropertyName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(PropertyName) + 1);
    Inc(Marker, Length(PropertyName) + 1);

    Size := 3 + Marker;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  ScanProperty := Lo(NovRegs);
  Seq          := Reply.Sequence;
  with Prop, Reply do
  begin
    PropertyName  := StrPas(@PropName);
    PropertyFlag  := PropFlags;
    PropertySec   := PropSec;
    Seq           := SwapLongInt(Sequence);
    PropValueFlag := PropValue;
    MoreSegments  := MoreProp;
  end;
end;

{
  function        : ChangePropertySecurity
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Changes the security of an property

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neNoWildcardAllowed
           - neInvalidBindSecLevel
           - neNoSuchProperty
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function ChangePropertySecurity(Obj : tBinderyObj;
                                var Prop : tProperty):Byte;

var
  NovRegs       : Word;
  Reply           : Word;
  Marker          : Byte;

  Request         :
  record
    Size          : Word;    { Length of request           }
    SubF          : Byte;    { Subfunction                 }
    ObjTyp        : Word;    { Object typ                  }
    BindObj     : array[1..67] of Byte;
                  { 1   Byte object name length
                    N   Bytes object name
                    1   Bytes new object security
                    1   Byte property name length
                    N   Bytes property name                  }
  end;

begin
  Reply := 0;
  FillChar(Request, SizeOf(Request), 0);
  with Request, Obj, Prop do
  begin
    SubF    := $3B;
    ObjTyp  := Swap(ObjectType);
    Marker  := 1;

    ObjectName := StupCase(ObjectName);
    Move(ObjectName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(ObjectName) + 1);
    Inc(Marker, Length(ObjectName) + 1);

    BindObj[Marker] := PropertySec;
    Inc(Marker);

    PropertyName := StupCase(PropertyName);
    Move(PropertyName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(PropertyName) + 1);
    Inc(Marker, Length(PropertyName) + 1);

    Size := 3 + Marker;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  ChangePropertySecurity := Lo(NovRegs);
end;

{
  function        : VerifyBinderyPassword
  Service type    : bindery services
  Netware version : NW v2.0 - v4.x

  Desc : Verifies the bindery password

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neNoWildcardAllowed
           - neNoSuchProperty
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function VerifyBinderyPassword(Obj : tBinderyObj):Byte;

var
  NovRegs       : Word;
  Reply         : Word;
  Marker        : Byte;

  Request       :
  record
    Size         : Word;    { Length of request           }
    SubF         : Byte;    { Subfunction                 }
    ObjTyp       : Word;    { Object typ                  }
    BindObject   : array[1..177] of Byte;
                   { 1   Byte  Length of object
                     48  Bytes Name of object
                     1   Byte  Length of password
                     127 Bytes password                   }
  end;

begin
  Reply := 0;
  FillChar(Request, SizeOf(Request), 0);
  with Request, Obj do
  begin
    SubF   := $3F;
    ObjTyp := Swap(Obj.ObjectType);
    Marker := 1;

    ObjectName := StupCase(ObjectName);
    Move(ObjectName, Ptr(Seg(BindObject[Marker]), Ofs(BindObject[Marker]))^,
         Length(ObjectName) + 1);
    Inc(Marker, Length(ObjectName) + 1);

    ObjectPassword := StupCase(ObjectPassword);
    Move(ObjectPassword, Ptr(Seg(BindObject[Marker]), Ofs(BindObject[Marker]))^,
         Length(ObjectPassword) + 1);
    Inc(Marker, Length(ObjectPassword) + 1);

    Size := 3 + Marker;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  VerifyBinderyPassword := Lo(NovRegs);
end;

{
  function        : IsObjectInSet
  Service type    : bindery group services
  Netware version : NW v2.0 - v4.x

  Desc : Test's if the bindery object exists in
         the set

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neMemberNotExist
           - neNotGroupProperty
           - neNoWildcardAllowed
           - neNoPropReadPrivilege
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function IsObjectInSet(ObjSet : tBinderyObjSet):Byte;

var
  NovRegs       : Word;
  Reply         : Word;
  Marker        : Byte;

  Request       :
  record
    Size        : Word;         { Size of request       }
    SubF        : Byte;         { Subfunction           }
    ObjType     : Word;         { Object typ            }
    BindObj     : array[1..117] of Byte;
                  { 1   Byte length of object
                    48  Bytes name of object
                    1   Byte length of property
                    15  Byte property name
                    2   Byte member type
                    1   Byte length of member
                    48  Byte member name                }
  end;

begin
  Reply := 0;
  with Request, ObjSet do
  begin
    Size     := SizeOf(Request) -2;
    SubF     := $43;
    ObjType  := Swap(ObjectType);
    Marker   := 1;

    ObjectName := StupCase(ObjectName);
    Move(ObjectName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(ObjectName) + 1);
    Inc(Marker, Length(ObjectName) + 1);

    PropertyName := StupCase(PropertyName);
    Move(PropertyName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(PropertyName) + 1);
    Inc(Marker, Length(PropertyName) + 1);

    MemberType := Swap(MemberType);
    Move(MemberType, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^, 2);
    Inc(Marker, 2);

    MemberName := StupCase(MemberName);
    Move(MemberName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(MemberName) + 1);
    Inc(Marker, Length(MemberName) + 1);

    Size := 3 + Marker;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  IsObjectInSet := Lo(NovRegs);
end;

{
  function        : AddBinderyObject2Set
  Service type    : bindery group services
  Netware version : NW v2.0 - v4.x

  Desc : Add's an bindery object to an set

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neMemberAlreadyExists
           - neNotGroupProperty
           - neNoWildcardAllowed
           - neNoPropWritePrivilege
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function AddBinderyObject2Set(ObjSet : tBinderyObjSet):Byte;

var
  NovRegs       : Word;
  Reply         : Word;
  Marker        : Byte;

  Request       :
  record
    Size        : Word;         { Size of request       }
    SubF        : Byte;         { Subfunction           }
    ObjType     : Word;         { Object typ            }
    BindObj     : array[1..117] of Byte;
                  { 1   Byte length of object
                    48  Bytes name of object
                    1   Byte length of property
                    15  Byte property name
                    2   Byte member type
                    1   Byte length of member
                    48  Byte member name                }
  end;

begin
  Reply := 0;
  with Request, ObjSet do
  begin
    SubF     := $41;
    ObjType  := Swap(ObjectType);
    Marker   := 1;

    ObjectName := StupCase(ObjectName);
    Move(ObjectName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(ObjectName) + 1);
    Inc(Marker, Length(ObjectName) + 1);

    PropertyName := StupCase(PropertyName);
    Move(PropertyName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(PropertyName) + 1);
    Inc(Marker, Length(PropertyName) + 1);

    MemberType := Swap(MemberType);
    Move(MemberType, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^, 2);
    Inc(Marker, 2);

    MemberName := StupCase(MemberName);
    Move(MemberName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(MemberName) + 1);
    Inc(Marker, Length(MemberName) + 1);

    Size := 3 + Marker;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  AddBinderyObject2Set := Lo(NovRegs);
end;

{
  function        : DeleteBinderyObjectFromSet
  Service type    : bindery group services
  Netware version : NW v2.x - vx.x

  Desc : Delete's an bindery object from set

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neMemberNotExist
           - neNotGroupProperty
           - neNoWildcardAllowed
           - neNoPropWritePrivilege
           - neNoSuchProperty
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function DeleteBinderyObjectFromSet(ObjSet : tBinderyObjSet):Byte;

var
  NovRegs       : Word;
  Reply         : Word;
  Marker        : Byte;

  Request       :
  record
    Size        : Word;         { Size of request       }
    SubF        : Byte;         { Subfunction           }
    ObjType     : Word;         { Object typ            }
    BindObj     : array[1..117] of Byte;
                  { 1   Byte length of object
                    48  Bytes name of object
                    1   Byte length of property
                    15  Byte property name
                    2   Byte member type
                    1   Byte length of member
                    48  Byte member name                }
  end;

begin
  Reply := 0;
  with Request, ObjSet do
  begin
    SubF     := $42;
    ObjType  := Swap(ObjectType);
    Marker   := 1;

    ObjectName := StupCase(ObjectName);
    Move(ObjectName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(ObjectName) + 1);
    Inc(Marker, Length(ObjectName) + 1);

    PropertyName := StupCase(PropertyName);
    Move(PropertyName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(PropertyName) + 1);
    Inc(Marker, Length(PropertyName) + 1);

    MemberType := Swap(MemberType);
    Move(MemberType, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^, 2);
    Inc(Marker, 2);

    MemberName := StupCase(MemberName);
    Move(MemberName, Ptr(Seg(BindObj[Marker]), Ofs(BindObj[Marker]))^,
         Length(MemberName) + 1);
    Inc(Marker, Length(MemberName) + 1);

    Size := 3 + Marker;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  DeleteBinderyObjectFromSet := Lo(NovRegs);
end;

{
  function        : GetAccountStatus
  Service type    : bindery group services
  Netware version : NW v2.1x - v4.x

  Desc : Gets the account status of an object

  Errors : - neSuccessfull
           - neNoAccountPrivlege
           - neNoAccountBalance
 }

function GetAccountStatus(var AccStatus : tAccountStatus;
                          ObjectName : String;
                          ObjectType : Word):Byte;

var
  NovRegs       : Word;
  i             : Byte;
  Reply         : tAccountStatus absolute AccStatus;

  Request       :
  record
    Size        : Word;         { Size of request       }
    SubF        : Byte;         { Subfunction           }
    ObjType     : Word;         { Object typ            }
    ObjName     : String[48];   { Object name           }
  end;

begin
  Reply.Size := SizeOf(Reply) - 2;
  with Request do
  begin
    Size    := 4 + Length(ObjectName);
    SubF    := $96;
    ObjType := Swap(ObjectType);
    ObjName := StUpCase(ObjectName);
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetAccountStatus := Lo(NovRegs);
  if Lo(NovRegs) = neSuccessfull then
  begin
    with Reply do
    begin
      AccBalance    := SwapLongInt(AccBalance);
      CreditLimit   := SwapLongInt(CreditLimit);
      for i := 1 to 16 do
      begin
        ServerList[i].ServerId     := SwapLongInt(ServerList[i].ServerId);
        ServerList[i].ServerAmount := SwapLongInt(ServerList[i].ServerAmount);
      end;
    end;
  end;
end;

{
  function        : SubmitAccountCharge
  Service type    : account services
  Netware version : NW v2.1 - v4.x

  Desc : Submitts an account charge

  Errors : - neSuccessfull
           - neNoAccountPrivlege
           - neNoAccountBalance
           - neAccCreditLimitExceed
 }

function SubmitAccountCharge(Acc : tAccount):Byte;

var
  NovRegs       : Word;
  Reply         : Word;
  Marker        : Byte;

  Request       :
  record
    Size         : Word;    { Length of request                       }
    SubF         : Byte;    { Subfunction                             }
    ServiceT     : Word;    { Service type (big-endian)               }
    AccC         : LongInt; { Amount to be charged (big-endian)       }
    PriorH       : LongInt; { Amount of prior hold to be cancelled
                              (big-endian)                            }
    BinderyT     : Word;    { Bindery object type (big-endian)        }
    ComType      : Word;    { Type of comment 8000h-FFFFh reserved
                              for exeperimental use (big-endian)      }
    AccObject    : array[1..304] of Byte;
                   { 1  Byte Length of Objectname
                     N  Bytes Objectname
                     1  Byte Length of Comment
                     N  Bytes Comment                                 }
  end;

begin
  Reply := 0;
  FillChar(Request, SizeOf(Request), 0);
  with Request, Acc do
  begin
    SubF       := $97;
    ServiceT   := Swap(ServiceType);
    AccC       := SwapLongInt(AccCharged);
    PriorH     := SwapLongInt(PriorHold);
    BinderyT   := Swap(BinderyType);
    ComType    := Swap(CommentType);
    Marker     := 1;

    ObjectName := StupCase(ObjectName);
    Move(ObjectName, Ptr(Seg(AccObject[Marker]), Ofs(AccObject[Marker]))^,
         Length(ObjectName) + 1);
    Inc(Marker, Length(ObjectName) + 1);

    Comment := StupCase(Comment);
    Move(Comment, Ptr(Seg(AccObject[Marker]), Ofs(AccObject[Marker]))^,
         Length(Comment) + 1);
    Inc(Marker, Length(Comment) + 1);

    Size := 15 + Marker;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  SubmitAccountCharge := Lo(NovRegs);
end;

{
  function        : SubmitAccountHold
  Service type    : account services
  Netware version : NW v2.1 - v4.x

  Desc : Submits an account hold

  Errors : - neSuccessfull
           - neNoAccountPrivlege
           - neNoAccountBalance
           - neAccCreditLimitExceed
           - neAccountToManyHolds
 }

function SubmitAccountHold(Acc : tAccount):Byte;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    Size        : Word;       { Length of Request                       }
    SubF        : Byte;       { Subfunction                             }
    AccR        : LongInt;    { Amount of Account Balance to reserve    }
    ObjTyp      : Word;       { Bindery Object Type (big-endian)        }
    ObjName     : String[48]; { Object Name                             }
  end;

begin
  Reply := 0;
  FillChar(Request, SizeOf(Request), 0);
  with Request, Acc do
  begin
    Size        := 8 + Length(ObjectName);
    SubF        := $98;
    AccR        := AccReserved;
    ObjTyp      := Swap(BinderyType);
    ObjName     := StupCase(ObjectName);
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  SubmitAccountHold := Lo(NovRegs);
end;

{
  function        : SubmitAccountNote
  Service type    : account services
  Netware version : NW v2.1 - v4.x

  Desc : Submitts an account note

  Errors : - neSuccessfull
           - neNoAccountPrivlege
 }

function SubmitAccountNote(Acc : tAccount):Byte;

var
  NovRegs       : Word;
  Reply         : Word;
  Marker        : Byte;

  Request       :
  record
    Size        : Word;    { Length of request                       }
    SubF        : Byte;    { Subfunction                             }
    ServiceT    : Word;    { Service type (big-endian)               }
    BinderyT    : Word;    { Bindery object (big-endian)             }
    ComType     : Word;    { Type of comment 8000h-FFFFh reserved
                             for exeperimental use (big-endian)      }
    AccObject   : array[1..304] of Byte;
                  { 1  Byte Length of objectname
                    N  Bytes objectname
                    1  Byte length if comment
                    N  Bytes comment                                 }
  end;

begin
  Reply := 0;
  FillChar(Request, SizeOf(Request), 0);
  with Request, Acc do
  begin
    SubF        := $99;
    ServiceT    := Swap(ServiceType);
    BinderyT    := Swap(BinderyType);
    ComType     := Swap(CommentType);
    Marker      := 1;

    ObjectName := StupCase(ObjectName);
    Move(ObjectName, Ptr(Seg(AccObject[Marker]), Ofs(AccObject[Marker]))^,
         Length(ObjectName) + 1);
    Inc(Marker, Length(ObjectName) + 1);

    Comment  := StupCase(Comment);
    Move(Comment, Ptr(Seg(AccObject[Marker]), Ofs(AccObject[Marker]))^,
         Length(Comment) + 1);
    Inc(Marker, Length(Comment) + 1);

    Size :=  7 + Marker;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  SubmitAccountNote := Lo(NovRegs);
end;

{------------------------ end of unit ------------------------}

end.
