 {ͻ
   unit : Novell file                           Target Platforms :       
   desc : Novell file Functions                   - DOS Real             
                                                  - DOS Protected        
                                                  - Windows              
   (C) 1994 by Christoph Weller 16/01/93 v1.1                            
  ͼ}

(*

  8.1.1995   : added the constants
               - MaxVolumesNw2x
               - MaxVolumesNw3x
               who holds the value of the maximum volumes the Netware-
               version can handle

  8.1.1995   : function AllocateTempDirHandle, AllocatePermanentDirHandle,
               changed Request-Buffer DirPath

  8.1.1995   : Changed all time-variables in the records from
               array[1..4] of Byte into LongInt.

  18.1.1995  : Inserted all possible error-results of a procedure/function
               into the description-header.

*)

unit NVFile;

interface

{$I NVDEFINE.INC }

uses
  Strings,  { Borland strings unit                      }
  NvMain,   { Novell main unit                          }
  {$IFDEF WINDOWS}
  WinDos;   { Borland Windows DOS unit                  }
  {$ELSE}
  Dos;      { Borland DOS unit                          }
  {$ENDIF}

{
              CONST declarations
 }

const

  { (A)ccess and (s)haring modes }
  asROnly               = $00; { Use file read only         }
  asWOnly               = $01; { Use file write only        }
  asReadWrite           = $02; { Use file read/write        }
  asCompMode            = $00; { Compatibility mode         }
  asDenyAll             = $10; { Deny all                   }
  asDenyWrite           = $20; { Deny write                 }
  asDenyRead            = $30; { Deny read                  }
  asDenyNone            = $40; { Allow full access by other }
  asInheritance         = $80; { If set, file is private to
                                 current process and will
                                 not be inherited by child
                                 processes                  }

  { (Se)arch mode values }
  seMode1               = $00; { Search mode 1              }
  seMode2               = $01; { Search mode 2              }
  seMode3               = $02; { Search mode 3              }
  seMode4               = $03; { Search mode 4              }
  seMode5               = $04; { Search mode 5              }
  seMode6               = $05; { Search mode 6              }
  seMode7               = $06; { Search mode 7              }

  { DOS (f)ile (a)ttribut shareable }
  faShareable           = $80;

  { (E)xtended (f)ile-attributes }
  efReserved            = $08; { Reserved                   }
  efTransactional       = $10; { Transactional              }
  efIndexed             = $20; { Indexed                    }
  efReadAudit           = $40; { Read audit                 }
  efWriteAudit          = $80; { Write audit                }

  { (D)irectory (r)ights }
  drSupervisory         = $FF; { Supervisory                }
  drReadAllowed         = $01; { Read allowed               }
  drWriteAllowed        = $02; { Write allowed              }
  drCreateAllowed       = $08; { Create allowed             }
  drEraseAllowed        = $10; { Erase allowed              }
  drModifyAllowed       = $80; { Modify allowed             }
  drFileScan            = $40; { File scan                  }
  drAccessControl       = $20; { Access control             }

  { Drive (m)apping (f)lags }
  mfDriveNotMapped      = $00; { Drive is not mapped            }
  mfPermNetDrive        = $01; { Permanent network-drive        }
  mfTempNetDrive        = $02; { Temporary network drive        }
  mfMappedLocal         = $80; { Mapped to an local drive       }
  mfLocalPermNetDrive   = $81; { Local drive used as permanent
                                 network drive                  }
  mfLocalTempNetDrive   = $82; { Local drive used as temporary
                                 network drive                  }

  { max. Netware volumes }
  MaxVolumesNw2x        = 31;  { Netware 2.x 0..31 volumes      }
  MaxVolumesNw3x        = 63;  { Netware 3.x 0..63 volumes      }

{
              TYPE declarations
 }

type

  { Drive table }
  tDriveTable = array[1..32] of Byte;

  { Volume name }
  tVolumeName = String[16];

  { File name }
  tFileName   = String[15];

  { Volume information }
  tVolInfo      =
  record
    SecPerBlock   : Word;         { Sectors per block           }
    TotalBlocks   : Word;         { Total blocks                }
    AvailBlocks   : Word;         { Available blocks            }
    TotalDirSlots : Word;         { Total directory slots       }
    AvailDirSlots : Word;         { Available directory slots   }
    VolName       : String[16];   { Volume name                 }
    VolRemovable  : boolean;      { Volume removable            }
  end;

  { Extented volume info }
  tExtVolInfo    =
  record
    TotalBlocks     : LongInt;    { Total blocks                }
    FreeBlocks      : LongInt;    { Free blocks                 }
    PurgableBlocks  : LongInt;    { Purgable blocks             }
    NotYetPurgable  : LongInt;    { Not yet purgable            }
    TotalDirEntries : LongInt;    { Total directory entries     }
    AvailDirEntries : LongInt;    { Available directory entries }
    Flags           : Byte;       { Flags                       }
    SectorsPerBlock : LongInt;    { Sectorys per block          }
    VolumeName      : String;     { Volume name                 }
  end;

  { File information }
  tFileInfo     =
  record
    FName        : String[15];  { Filename                      }
    FAttrib      : Word;        { File attributes               }
    ExtFAttrib   : Byte;        { Extended file attributes      }
    Size         : LongInt;     { Filesize                      }
    CrDate       : Word;        { Creation date                 }
    LastAccess   : Word;        { Last access                   }
    LastUpdate   : LongInt;     { Last update                   }
    ObjId        : LongInt;     { Object id of owner            }
    LastArchived : LongInt;     { Last archived                 }
  end;

  { Directory entry information }
  tDirectoryEntry  =
  record
    Size           : Word;                 { length of reply               }
    Reserved1      : LongInt;              { reserved                      }
    Attributes     : LongInt;              { entry-attributes              }
    Reserved2      : Word;                 { reserved                      }
    NameSpaceType  : Byte;                 { Name space support type       }
    EntryName      : String[12];           { Entry name                    }
    CreationDtTi   : LongInt;              { creation date/time            }
    OwnerObjId     : LongInt;              { object id of owner            }
    ArchiveDtTi    : LongInt;              { archive date/time             }
    ArchiverId     : LongInt;              { archiver id                   }
    ModifyDtTi     : LongInt;              { modify date/time              }
    LastModifier   : LongInt;              { last modifier id              }
    DataForkSize   : LongInt;              { Data fork size (Macintosh)    }
    Reserved3      : array[1..48] of Byte; { reserved                      }
    InhRightsMask  : Word;                 { inherited right mask          }
    LastAccessDt   : Word;                 { last access date              }
    Reserved4      : array[1..26] of Byte; { reserved                      }
  end;

  { salvagable files }
  tSalvagableFiles =
  record
    Size          : Word;                { Length of reply         }
    EntryId       : LongInt;             { Entry id                }
    Reserved      : array[1..4] of Byte; { Reserved                }
    Attributes    : LongInt;             { Attributes              }
    Reserved2     : Word;                { Reserved                }
    NameSpaceType : Byte;                { Name space support type }
    Name          : String[12];          { Name of file            }
    ReservedDtTi  : LongInt;             { Reserved date/time      }
    ReservedId    : LongInt;             { Reserved Id             }
    ArchivedDtTi  : LongInt;             { Archived date/time      }
    ArchiverId    : LongInt;             { Archiver object id      }
    ModifyDtTi    : LongInt;             { Modify date/time        }
    ModifierId    : LongInt;             { Modifier object id      }
    DataForkSize  : LongInt;             { Data fork size          }
    Reserved3     : array[1..46] of Byte;{ Reserved                }
    LastAccessDt  : Word;                { Last access date        }
    Reserved4     : array[1..4] of Byte; { Reserved                }
    DeleteDtTi    : LongInt;             { Deleted date and time   }
    DeletorId     : LongInt;             { Deletor object id       }
    Reserved5     : array[1..16] of Byte;{ Reserved                }
  end;

  { Directory information }
  tDirInfo        =
  record
    DirName       : String[16];    { Directory name            }
    CrDateTi      : LongInt;       { Date and time of creation }
    ObjId         : LongInt;       { Object id of owner        }
    MaxDirRights  : Byte;          { Maximum directory rights  }
    DirNumber     : Word;          { Directory number          }
  end;

  { Directory entry }
  tDirEntry       =
  record
    VolumeNo      : Byte;      { Volume number             }
    EntryId       : LongInt;   { Directory entry id        }
  end;

  { file server copy block, all entrys big endian !! }
  tFSCopyBlock     =
  record
    SourceHandle   : Word;    { Source file handle             }
    DestHandle     : Word;    { Destination file handle        }
    SourceStartOfs : LongInt; { Starting offset in source      }
    DestStartOfs   : LongInt; { Starting offset in destination }
    BytesToCopy    : LongInt; { Number of bytes to copy        }
  end;

  { Trustee record }
  tTrusteeRec      =
  record
    DirName        : String;                 { Directory name            }
    CrDateTime     : LongInt;                { Date and time of creation }
    Owner          : LongInt;                { Object id of owner        }
    Trustees       : array[0..4] of LongInt; { Object id of trustees     }
    TrusteeRight   : array[0..4] of Byte;    { Trustees directory rights }
  end;

  { Trustee entry record }
  tTrusteeEntryRec =
  record
    Size           : Word;                    { Size of reply             }
    NoOfTrustees   : Byte;                    { No of trustees found      }
    TrusteesId     : array[1..20] of LongInt; { Object id of trustees     }
    TrusteeRight   : array[1..20] of Word;    { Trustees directory rights }
  end;

  { Trustees path record }
  tTrusteePath     =
  record
    NextSeq        : Word;      { Next sequenz no           }
    ObjectId       : LongInt;   { Object id                 }
    AccessMask     : Byte;      { Trustee access mask       }
    TrusteePath    : String;    { Trustee path              }
  end;

{
        procedure and function headers
 }

{ FILE FUNCTIONS Get extended file attributes }
function GetExtendedFileAttributes(FName : String;
                                   var ErrorCode :Byte):Word;
{$IFDEF PROTECTED} export; {$ENDIF}

{ FILE FUNCTIONS Set extended file attributes }
function SetExtendedFileAttributes(FName : String;
                                   Attrib : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ FILE FUNCTIONS Is file shareable #DOS function#}
function IsFileShareable(FName : String):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ FILE FUNCTIONS Make file shareable #DOS function#}
function ToggleShareable(FName : String):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ FILE FUNCTIONS Get file information }
function GetFileInformation(var FInfo : tFileInfo;
                            Handle : Byte;
                            var Seq : Word):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ FILE FUNCTIONS Set file information  }
function SetFileInformation(var FInfo : tFileInfo;
                            Handle : Byte;
                            var Seq : Word):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ FILE FUNCTIONS File server file-copy }
function FileServerCopy(var Copy : tFSCopyBlock):LongInt;
{$IFDEF PROTECTED} export; {$ENDIF}

{ FILE FUNCTIONS Erase files }
function EraseFiles(FileSpec : String;
                    Handle : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ FILE FUNCTIONS Scan salvagable files }
function ScanSalvagableFiles(var SalvageFiles : tSalvagableFiles;
                             DirectoryHandle : Byte;
                             FileEntryId : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ FILE FUNCTIONS Recover salvagable files }
function RecoverSalvagableFile(DirectoryHandle : Byte;
                               FileEntryId : LongInt;
                               OldName,
                               NewName : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ FILE FUNCTIONS Purge salvagable files }
function PurgeSalvagableFiles(DirectoryHandle : Byte;
                              FileEntryId : LongInt;
                              FileName : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ FILE FUNCTIONS Open existing file #FCB#}
function OpenExistingFile(FileName : String;
                          AccessMode : Byte):Word;
{$IFDEF PROTECTED} export; {$ENDIF}

{ FILE FUNCTIONS Create file #FCB#}
function CreateFile(FileName : String;
                    FAttrib : Byte):Word;
{$IFDEF PROTECTED} export; {$ENDIF}

{ FILE FUNCTIONS Close file #FCB#}
function CloseFile(Handle : Word):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Get directory information }
function GetDirectoryInfo(var Dir : tDirInfo;
                          Path : String;
                          DirHandle : Byte):byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Get directory entry }
function GetDirectoryEntry(var DirEntryInfo : tDirectoryEntry;
                           DirHandle : Byte):byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Set directory information }
function SetDirectoryInfo(var Dir : tDirInfo;
                          Path : String;
                          DirHandle : Byte):byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Show dots true = set dots }
Procedure ShowDots(Show : boolean);
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Get directory handle }
Procedure GetDirHandle(var Handle : Byte;
                       var Flags : Byte;
                       Drive : Char);
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Allocate temporaery directory handle }
function AllocateTempDirHandle(var DirHandle : Byte;
                               Drive : Char;
                               Path : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Allocate permanent directory handle }
function AllocatePermanentDirHandle(var DirHandle : Byte;
                                    Drive : Char;
                                    Path : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS DeAllocate directory handle }
function DeAllocateDirHandle(DirHandle : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Set directory handle }
function SetDirHandle(SourceHandle,
                      TargetHandle : Byte;
                      Path : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Map root directory }
function MapRootDirectory(Drive : Byte;
                          RootPath : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Delete map root directory }
procedure DeleteMapRootDirectory(Drive : Byte);
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Get relative drive depth }
function GetDriveDepth(Drive : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Get directory path }
function GetDirectoryPath(Handle : Byte):String;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Convert path to directory entry }
function ConvertPathToDirEntry(DirHandle : Byte;
                               DirPath : String;
                               var DirEntry : tDirEntry):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Map directory number to path }
function MapDirNoToPath(DirEntry : tDirEntry;
                        NameSpaceSupport : Byte;
                        var DirPath : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Get effective directory rights }
function GetDirRights(Path : String;
                      Handle : Byte;
                      var Rights : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Modify directory rights }
function ModifyDirRights(Path : String;
                         Handle,
                         Grant,
                         Revoke : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Create directory  }
function CreateDirectory(NewDir : String;
                         Handle,
                         DirRights : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Delete directory  }
function DeleteDirectory(Path : String;
                         Handle : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DIRECTORY FUNCTIONS Rename directory }
function RenameDirectory(OldPath,
                         NewName : String;
                         Handle : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRUSTEE FUNCTIONS Scan directory for trustees  }
function ScanTrustees(var Trustee : tTrusteeRec;
                      Path : String;
                      Handle,
                      Seq : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRUSTEE FUNCTIONS Scan entry for trustees  }
function ScanEntryForTrustees(var Trustee : tTrusteeEntryRec;
                              Path : String;
                              Handle,
                              Seq : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRUSTEE FUNCTIONS Scan bindery object trustee path }
function ScanBindObjectTrusteePath(VolumeNo : Byte;
                                   var TrusteePathRecord : tTrusteePath):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRUSTEE FUNCTIONS Add trustee to directory  }
function AddTrustee(Trustee : tTrusteeRec;
                    Handle : Byte;
                    Path : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRUSTEE FUNCTIONS Delete trustee from directory }
function DeleteTrustee(Trustee : tTrusteeRec;
                       Handle : Byte;
                       Path : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ VOLUME AND DRIVE FUNCTIONS Get volume information with handle }
function GetVolumeInfoWithHandle(var Volume : tVolInfo;
                                 DirHandle : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ VOLUME AND DRIVE FUNCTIONS Get volume information with number }
function GetVolumeInfoWithNumber(var Volume : tVolInfo;
                                 VolumeNo : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ VOLUME AND DRIVE FUNCTIONS Get extended volume information }
function GetExtendedVolumeInfo(var Volume : tExtVolInfo;
                               VolumeNo : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ VOLUME AND DRIVE FUNCTIONS Get number of local drives as set in Lastdrive }
function LocalDrives:Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ VOLUME AND DRIVE FUNCTIONS Get drive connection id }
procedure GetDriveConnId(var IDTable : tDriveTable);
{$IFDEF PROTECTED} export; {$ENDIF}

{ VOLUME AND DRIVE FUNCTIONS Get drive flag table }
procedure GetDriveFlagTable(var FlagTable : tDriveTable);
{$IFDEF PROTECTED} export; {$ENDIF}

{ VOLUME AND DRIVE FUNCTIONS Get drive handle table }
procedure GetDriveHandleTable(var HandleTable : tDriveTable);
{$IFDEF PROTECTED} export; {$ENDIF}

{ VOLUME AND DRIVE FUNCTIONS Get volume number }
function GetVolumeNumber(VolumeName : String;
                         var VolNo : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ VOLUME AND DRIVE FUNCTIONS Get volume name }
function GetVolumeName(VolNo : Byte;
                       var VolumeName : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ RESTRICTION SERVICES Add user disk space restriction }
function AddUserDiskSpaceRestriction(VolumeNo : Byte;
                                     ObjectId : LongInt;
                                     DiskSpaceLimit : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ RESTRICTION SERVICES Remove user disk space restriction }
function RemoveUserDiskSpaceRestriction(VolumeNo : Byte;
                                        ObjectId : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ RESTRICTION SERVICES Get object disk-usage and restriction }
function GetObjectDiskUsage(VolumeNo : Byte;
                            ObjectId : LongInt;
                            var DiskRestriction : LongInt;
                            var DiskSpaceInUse : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ RESTRICTION SERVICES Set directory disk space restriction }
function SetDirectoryDiskSpaceRestriction(DirHandle : Byte;
                                          DiskSpaceLimit : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

(* -------------------------- implemenation -------------------------- *)

implementation

{
  function        : GetExtendedFileAttributes
  service type    : file functions
  Netware version : NW v2.0 - v4.x

  Desc : Get's the extended file attributes
         of an file

  Errors : - neSuccessfull
           - neNoFilesFoundError
           - neNotPermittSearchDir
 }

function GetExtendedFileAttributes(FName : String;
                                   var ErrorCode : Byte):Word;

var
  NovRegs : tRegister;
  PathZ   : array[1..255] of Char;

begin
  StrPCopy(@PathZ, StupCase(FName));
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $B600;
  PathIntr(PathZ, Length(FName), NovRegs);
  ErrorCode := NovRegs.Al;
  GetExtendedFileAttributes := NovRegs.CX;
end;

{
  function        : SetExtendedFileAttributes
  service type    : file functions
  Netware version : NW v2.0 - v4.x

  Desc : Set's the extended file attributes of
         an file

  Errors : - neSuccessfull
           - neNoFilesFoundError
           - neInsuffAccessPriv
 }

function SetExtendedFileAttributes(FName : String;
                                   Attrib : Byte):Byte;

var
  NovRegs : tRegister;
  PathZ   : array[1..255] of Char;

begin
  StrPCopy(@PathZ, StupCase(FName));
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $B601;
    CL := Attrib;
  end;
  PathIntr(PathZ, Length(FName), NovRegs);
  SetExtendedFileAttributes := NovRegs.AL;
end;

{
  function        : IsFileShareable
  service type    : file functions
  Netware version : NW v2.x - vx.x

  Desc : Returns true if file is flagged as
         shareable
 }

function IsFileShareable(FName : String):boolean;

var
  f    : file;
  Attr : Word;

begin
  Assign(f, FName);
  GetFAttr(f, Attr);
  if DOSError = 0 then
    IsFileShareable := ((Attr and $80) <> 0 )
  else
    IsFileShareable := false;
end;

{
  function        : ToggleFileShareable
  service type    : file functions
  Netware version : NW v2.x - vx.x

  Desc : Toggles the shareable-flag of an file
 }

function ToggleShareable(FName : String):boolean;

var
  f       : file;
  Attr    : Word;

begin
  Assign(F, FName);
  GetFAttr(f, Attr);
  Attr := Attr xor $80;
  SetFattr(f, Attr);
  ToggleShareable := (DOSError = 0);
end;

{
  function        : GetFileInformation
  service type    : file functions
  Netware version : NW v2.0 - v4.x

  Desc : Get's various infos about an file

  Errors : - neSuccessfull
           - neNoSearchPrivileges
           - neNoMoreMatchingFiles
 }

function GetFileInformation(var FInfo : tFileInfo;
                            Handle : Byte;
                            var Seq : Word):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    FLen        : Word;  { Length of request                }
    SubF        : Byte;  { Subfunction                      }
    FSeq        : Word;  { Sequenz                          }
    DirHandle   : Byte;  { Dirhandle                        }
    SAttrib     : Byte;  { Search attribut                  }
    SpecLen     : Byte;  { FileSpec length                  }
    FileSpec    : array[1..13] of Char; { Filespecification }
  end;

  Reply         :
  record
    Size        : Word;
    NextSeq     : Word;
    FileNameZ   : array[1..15] of Char;
    ExtFAttr    : Byte;
    FSize       : LongInt;
    CreatDate   : Word;
    LstAccess   : Word;
    LstUpdate   : LongInt;
    ObjectId    : LongInt;
    LstArchived : LongInt;
    Reserved    : array[1..55] of Byte;
  end;

begin
  Reply.Size := SizeOf(Reply) - 2;
  with Request do
  begin
    FLen      := SizeOf(Request) -2;
    SubF      := $0F;
    FSeq      := Swap(Seq);
    DirHandle := Handle;
    SAttrib   := $FF;
    SpecLen   := Length(FInfo.FName);
    StrPCopy(@FileSpec, FInfo.FName);
    FileSpec[Length(FInfo.FName) + 1] := #0;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetFileInformation := Lo(NovRegs);
  with FInfo do
  begin
    Seq          := Swap(Reply.NextSeq);
    FName        := StrPas(@Reply.FileNameZ);
    ExtFAttrib   := Reply.ExtFAttr;
    Size         := SwapLongInt(Reply.FSize);
    CrDate       := Swap(Reply.CreatDate);
    LastAccess   := Swap(Reply.LstAccess);
    LastUpdate   := SwapLongInt(Reply.LstUpdate);
    ObjId        := SwapLongInt(Reply.ObjectId);
    LastArchived := Swap(Reply.LstArchived);
  end;
end;

{
  function        : SetFileInformation
  service type    : file functions
  Netware version : NW v2.0 - v4.x

  Desc : Set's the file-info of an file

  Errors : - neSuccessfull
}

function SetFileInformation(var FInfo : tFileInfo;
                            Handle : Byte;
                            var Seq : Word):Byte;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    FLen        : Word;                 { Length of request            }
    SubF        : Byte;                 { Subfunction                  }
    FAttrib     : Byte;                 { File-attributes              }
    ExtFAttrib  : Byte;                 { Extended File-attributes     }
    Reserved    : array[1..4] of Byte;  { Reserved                     }
    CreatDate   : Word;                 { Creation date (big endian)   }
    LstAccess   : Word;                 { Last access (big endian)     }
    LstUpdate   : LongInt;              { Last update (big endian)     }
    ObjectId    : LongInt;              { Object id (big endian)       }
    LstArchived : LongInt;              { Last archived (big endian)   }
    Reserved2   : array[1..56] of Byte; { Reserved                     }
    DirHandle   : Byte;                 { Dirhandle                    }
    SAttrib     : Byte;                 { Search Attribut              }
    FileName    : String;               { Filename                     }
  end;

begin
  Reply := SizeOf(Reply) - 2;
  with Request do
  begin
    FLen        := SizeOf(Request) -2;
    SubF        := $0F;
    FAttrib     := FInfo.FAttrib;
    ExtFAttrib  := FInfo.ExtFAttrib;
    CreatDate   := FInfo.CrDate;
    LstAccess   := FInfo.LastAccess;
    LstUpdate   := FInfo.LastUpdate;
    ObjectId    := FInfo.ObjId;
    LstArchived := FInfo.LastArchived;
    DirHandle   := Handle;
    SAttrib     := $FF;
    FileName    := FInfo.FName;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  SetFileInformation := Lo(NovRegs);
end;

{
  function        : FileServerCopy
  service Type    : file functions
  Netware version : NW v2.0 - v4.x

  Desc : Copies an file from/to server-directories
         without copying it through the WS

  Errors : - neSuccessfull
 }

function FileServerCopy(var Copy : tFSCopyBlock):LongInt;

var
  NovRegs     : tRegister;
  BytesCopied : LongInt;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $F3;
  ReplyBufferIntr(Copy, SizeOf(Copy), NovRegs);
  with Copy do
  begin
    SourceHandle   := Swap(SourceHandle);
    DestHandle     := Swap(DestHandle);
    SourceStartOfs := SwapLongInt(SourceStartOfs);
    DestStartOfs   := SwapLongInt(DestStartOfs);
    BytesToCopy    := SwapLongInt(BytesToCopy);
  end;
  FileServerCopy           := NovRegs.AL;
  tHiLoWord(BytesCopied).Hi := NovRegs.CX;
  tHiLoWord(BytesCopied).Lo := NovRegs.DX;
  FileServerCopy := BytesCopied;
end;

{
  function        : EraseFiles
  Service Type    : file functions
  Netware version : NW v2.0 - v4.x

  Desc : Erases an file from volume

  Errors : - neSuccessfull
           - neNonExistentVol
           - neInvalidDirHandle1
           - neInvalidPath
           - neNoFilesFoundError
 }

function EraseFiles(FileSpec : String;
                    Handle : Byte):Byte;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    DirHandle   : Byte;                 { Directory Handle             }
    SearchAttr  : Byte;                 { Search Attributes            }
    SpecLen     : Byte;                 { File Specification Length    }
    Spec        : array[1..15] of Char; { File Specification           }
  end;

begin
  Reply := SizeOf(Reply) - 2;
  with Request do
  begin
    DirHandle    := Handle;
    SearchAttr   := $00;
    SpecLen      := Length(FileSpec);
    StrPCopy(@Spec, FileSpec);
  end;
  NovRegs := $F244;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  EraseFiles := Lo(NovRegs);
end;

{
  function        : ScanSalvagableFiles
  Service Type    : file functions
  Netware version : NW v3.x, v4.x

  Desc : Scan's the salvageable files of a
         directory

  Errors : - neSuccessfull
           - neNonExistentVol
           - neNoMoreErasedFiles
 }

function ScanSalvagableFiles(var SalvageFiles : tSalvagableFiles;
                             DirectoryHandle : Byte;
                             FileEntryId : LongInt):Byte;

var
  NovRegs         : Word;
  Reply           : tSalvagableFiles absolute SalvageFiles;

  Request         :
  record
    FLen          : Word;           { Length of request            }
    SubF          : Byte;           { Subfunction                  }
    DirHandle     : Byte;           { Directory handle             }
    EntryId       : LongInt;        { Entry id                     }
  end;

begin
  Reply.Size := SizeOf(Reply) -2;
  with Request do
  begin
    FLen         := SizeOf(Request) -2;
    SubF         := $1B;
    DirHandle    := DirectoryHandle;
    EntryId      := FileEntryId;
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  with Reply do
  begin
    ReservedId    := SwapLongInt(ReservedId);
    ArchiverId    := SwapLongInt(ArchiverId);
    ModifierId    := SwapLongInt(ModifierId);
    DeletorId     := SwapLongInt(DeletorId);
  end;
  ScanSalvagableFiles := Lo(NovRegs);
end;

{
  function        : RecoverSalvagableFiles
  Service Type    : file functions
  Netware version : NW v3.x, v4.x

  Desc : Recovers an salvagable file

  Errors : - neSuccessfull
           - neNonExistentVol
           - neNoMoreErasedFiles
 }

function RecoverSalvagableFile(DirectoryHandle : Byte;
                               FileEntryId : LongInt;
                               OldName,
                               NewName : String):Byte;

var
  NovRegs         : tRegister;
  Marker          : Byte;

  Request         :
  record
    FLen          : Word;           { Length of request            }
    SubF          : Byte;           { Subfunction                  }
    DirHandle     : Byte;           { Directory handle             }
    EntryId       : LongInt;        { Entry id                     }
    NameRec       : array[1..26] of Byte;
                                    { 1   Byte old name length
                                      N   Bytes old name
                                      1   Byte new name length
                                      N   Bytes new name           }
  end;

begin
  with Request do
  begin
    SubF        := $1C;
    DirHandle   := DirectoryHandle;
    EntryId     := FileEntryId;
    Marker      := 1;

    OldName := StupCase(OldName);
    Move(OldName, Ptr(Seg(NameRec[Marker]), Ofs(NameRec[Marker]))^,
         Length(OldName) + 1);
    Inc(Marker, Length(OldName) + 1);

    NewName := StupCase(NewName);
    Move(NewName, Ptr(Seg(NameRec[Marker]), Ofs(NameRec[Marker]))^,
         Length(NewName) + 1);
    Inc(Marker, Length(NewName) + 1);

    FLen := 6 + Marker;
  end;
  NovRegs.AX := $E200;
  RequestBufferIntr(Request, Request.FLen + 2, NovRegs);
  RecoverSalvagableFile := NovRegs.AL;
end;

{
  function        : PurgeSalvagableFiles
  Service Type    : file functions
  Netware version : NW v3.x, v4.x

  Desc : Purges salvagable files of the station

  Errors : - neSuccessfull
 }

function PurgeSalvagableFiles(DirectoryHandle : Byte;
                              FileEntryId : LongInt;
                              FileName : String):Byte;

var
  NovRegs         : Word;
  Reply           : Word;

  Request         :
  record
    FLen          : Word;    { Length of request            }
    SubF          : Byte;    { Subfunction                  }
    DirHandle     : Byte;    { Directory handle             }
    EntryId       : LongInt; { File entry id                }
    Name          : String;  { File name                    }
  end;

begin
  Reply := 0;
  with Request do
  begin
    FLen      := SizeOf(Request) -2;
    SubF      := $1D;
    DirHandle := DirectoryHandle;
    EntryId   := FileEntryId;
    Name      := FileName;
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  PurgeSalvagableFiles := Lo(NovRegs);
end;

{
  function        : OpenExistingFile
  service type    : file functions
  Netware version : none, FCB function

  Desc : Open existing file and return handle
 }

function OpenExistingFile(FileName : String;
                          AccessMode : Byte):Word;

var
  NovRegs : tRegister;
  FName   : array[1..255] of Char;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $3D;
    AL := AccessMode;
    CL := 0;
  end;
  StrPCopy(@FName, FileName);
  PathIntr(FName, SizeOf(FName), NovRegs);
  OpenExistingFile := NovRegs.AX;
end;

{
  function        : CreateFile
  service type    : file functions
  Netware version : none, FCB function

  Desc : Create new file and return handle
 }

function CreateFile(FileName : String;
                    FAttrib : Byte):Word;

var
  NovRegs : tRegister;
  FName   : array[1..255] of Char;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $3C;
    CX := FAttrib;
  end;
  StrPCopy(@FName, FileName);
  PathIntr(FName, SizeOf(FName), NovRegs);
  CreateFile := NovRegs.AX;
end;

{
  function        : CloseFile
  service type    : file functions
  Netware version : none, FCB function

  Desc : Close file-handle
 }

function CloseFile(Handle : Word):boolean;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $3E;
    BX := Handle;
  end;
  CallIntr(NovRegs);
  if NovRegs.AX <> $06 then
    CloseFile := true
  else
    CloseFile := false;
end;

{
  function        : GetDirectoryInfo
  service type    : directory functions
  Netware version : NW v2.0 - v4.x

  Desc : Get's various infos about a directory

  Errors : - neSuccessfull
           - neNonExistentVol
           - neInvalidDirHandle1
           - neInvalidPath
 }

function GetDirectoryInfo(var Dir : tDirInfo;
                          Path : String;
                          DirHandle : Byte):byte;

var
  NovRegs       : Word;

  Request       :
  record
    FLen        : Word;  { Length of request }
    SubF        : Byte;  { Subfunction       }
    Handle      : Byte;  { Directory handle  }
    DirNo       : Word;  { Dir-number        }
    DPath       : String;{ Directory path    }
  end;

  Reply         :
  record
    Len         : Word;                 { Length of reply           }
    DName       : array[1..16] of Char; { Directory name            }
    CDate       : LongInt;              { Date and time of creation }
    Obj         : LongInt;              { Object id of owner        }
    MaxDRights  : Byte;                 { Maximum directory rights  }
    Unused      : Byte;                 { unused                    }
    DirNo       : Word;                 { Directory Number          }
  end;

begin
  with Request do
  begin
    FLen   := SizeOf(Request) -2;
    SubF   := $02;
    Handle := DirHandle;
    DirNo  := 0;
    DPath  := StupCase(Path);
  end;
  Reply.Len := SizeOf(Reply) - 2;
  NovRegs   := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetDirectoryInfo := Lo(NovRegs);
  with Dir, Reply do
  begin
    DirName      := StrPas(@DName);
    CrDateTi     := SwapLongInt(CDate);
    ObjId        := SwapLongInt(Obj);
    MaxDirRights := MaxDRights;
    DirNumber    := Swap(DirNo);
  end;
end;

{
  function        : GetDirectoryEntry
  service type    : directory functions
  Netware version : NW v3.x, v4.x

  Desc : Gets various information about an
         directory entry

  Errors : - neSuccessfull
           - neNonExistentVol
           - neInvalidDirHandle1
           - neInvalidPath
 }

function GetDirectoryEntry(var DirEntryInfo : tDirectoryEntry;
                           DirHandle : Byte):byte;

var
  NovRegs       : Word;
  Reply         : tDirectoryEntry absolute DirEntryInfo;

  Request       :
  record
    FLen        : Word;  { Length of request }
    SubF        : Byte;  { Subfunction       }
    Handle      : Byte;  { Directory handle  }
  end;

begin
  with Request do
  begin
    FLen   := SizeOf(Request) -2;
    SubF   := $1F;
    Handle := DirHandle;
  end;
  Reply.Size := SizeOf(Reply) - 2;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetDirectoryEntry := Lo(NovRegs);
  with DirEntryInfo do
  begin
    OwnerObjId     := SwapLongInt(OwnerObjId);
    ArchiverId     := SwapLongInt(ArchiverId);
    LastModifier   := SwapLongInt(LastModifier);
  end;
end;

{
  function        : SetDirectoryInfo
  service type    : directory functions
  Netware version : NW v2.0 - v4.x

  Desc : Set's the directory-infos of a directory

  Errors : - neSuccessfull
           - neInvalidDirHandle1
           - neInvalidPath
 }

function SetDirectoryInfo(var Dir : tDirInfo;
                          Path : String;
                          DirHandle : Byte):byte;

var
  NovRegs       : Word;
  Reply         : Word;
  i             : Integer;

  Request       :
  record
    FLen        : Word;      { Length of request         }
    SubF        : Byte;      { Subfunction               }
    Handle      : Byte;      { Directory-handle          }
    CDateTi     : LongInt;   { Date and time of creation }
    Obj         : LongInt;   { Object id of owner        }
    MaxDRights  : Byte;      { Maximum directory rights  }
    DPath       : String;    { Directory path            }
  end;

begin
  with Request do
  begin
    FLen        := SizeOf(Request) -2;
    SubF        := $19;
    Handle      := DirHandle;
    DPath       := StupCase(Path);
    CDateTi     := SwapLongInt(Dir.CrDateTi);
    Obj         := SwapLongInt(Dir.ObjId);
    MaxDRights  := Dir.MaxDirRights;
    DPath       := Path;
  end;
  Reply := SizeOf(Reply) - 2;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  SetDirectoryInfo := Lo(NovRegs);
end;

{
  procedure       : ShowDots
  service type    : directory functions
  Netware version : Shell v3.00+

  Desc : Toggles the 'Show dots' status
 }

procedure ShowDots(Show : boolean);

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  if Show then
    NovRegs.BL := $01
  else
    NovRegs.BL := $00;
  NovRegs.AX := $E908;
  CallIntr(NovRegs);
end;

{
  function        : GetDirHandle
  service type    : directory functions
  Netware version : NW v2.0 - v4.x

  Desc : Get's directory handle from drive
 }

procedure GetDirHandle(var Handle : Byte;
                       var Flags : Byte;
                       Drive : Char);

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $E900;
    DX := Ord(UpCase(Drive)) - 65;
  end;
  if CallIntr(NovRegs) then
  begin
    Handle := NovRegs.AL;
    Flags  := NovRegs.AH;
  end
  else
  begin
    Handle := 0;
    Flags  := 0;
  end;
end;

{
  function        : AllocateTempDirHandle
  service type    : directory functions
  Netware version : NW v2.0 - v4.x

  Desc : Alloactes temporaery directory handle

  Errors : - neSuccessfull
           - neNonExistentVol
           - neInvalidPath
 }

function AllocateTempDirHandle(var DirHandle : Byte;
                               Drive : Char;
                               Path : String):Byte;

var
  NovRegs       : Word;
  i             : Integer;

  Request       :
  record
    FLen        : Word;                  { Length of request     }
    SubF        : Byte;                  { Subfunction           }
    Handle      : Byte;                  { Directory handle      }
    Drv         : Char;                  { Drive 'A'-'Z'         }
    DirPath     : String;                { Directory path        }
  end;

  Reply         :
  record
    Len         : Word;                  { reply length          }
    NewHandle   : Byte;                  { new handle            }
    DirRights   : Byte;                  { directory rights      }
  end;

begin
  Reply.Len := SizeOf(Reply) -2;
  with Request do
  begin
    SubF      := $13;
    Handle    := 0;
    Drv       := UpCase(Drive);
    DirPath   := Path;
    FLen      := SizeOf(Request) - 2;
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  DirHandle := Reply.NewHandle;
  AllocateTempDirHandle := Lo(NovRegs);
end;

{
  function        : AllocatePermanentDirHandle
  service type    : directory functions
  Netware version : NW v2.0 - v4.x

  Desc : Allocates permanent directory-handle

  Errors : - neSuccessfull
           - neNonExistentVol
           - neInvalidPath
 }

function AllocatePermanentDirHandle(var DirHandle : Byte;
                                    Drive : Char;
                                    Path : String):Byte;

var
  NovRegs       : Word;
  i             : Integer;

  Request       :
  record
    FLen        : Word;                  { Length of Request   }
    SubF        : Byte;                  { Subfunction         }
    Handle      : Byte;                  { Directory-Handle    }
    Drv         : Char;                  { Drive 'A'-'Z'       }
    DirPath     : String;                { Directory Path      }
  end;

  Reply         :
  record
    Len         : Word;                  { length of reply     }
    NewHandle   : Byte;                  { new handle          }
    DirRights   : Byte;                  { directory rights    }
  end;

begin
  Reply.Len := SizeOf(Reply) -2;
  with Request do
  begin
    FLen      := SizeOf(Request) - 2;
    SubF      := $12;
    Handle    := 0;
    Drv       := UpCase(Drive);
    DirPath   := Path;
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  DirHandle := Reply.NewHandle;
  AllocatePermanentDirHandle := Lo(NovRegs);
end;

{
  function        : DeallocateDirHandle
  service type    : directory functions
  Netware version : NW v2.0 - v4.x

  Desc : Deallocate an directory handle and
         therefore delete the maping

  Errors : - neSuccessfull
           - neInvalidDirHandle1
 }

function DeAllocateDirHandle(DirHandle : Byte):boolean;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    FLen        : Word; { Length of request  }
    SubF        : Byte; { Subfunction        }
    Handle      : Byte; { Directory-handle   }
  end;

begin
  Reply := SizeOf(Reply) -2;
  with Request do
  begin
    FLen      := SizeOf(Request) -2;
    SubF      := $14;
    Handle    := DirHandle;
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  DeAllocateDirHandle := (Lo(NovRegs) = neSuccessfull);
end;

{
  Function        : SetDirHandle
  service type    : directory functions
  Netware version : NW v2.0 - v4.x

  Desc : Set's a directory-handle

  Errors : - neSuccessfull
           - neNonExistentVol
           - neInvalidDirHandle1
           - neInvalidPath
 }

function SetDirHandle(SourceHandle,
                      TargetHandle : Byte;
                      Path : String):Byte;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    FLen        : Word;                  { Length of Request             }
    SubF        : Byte;                  { Subfunction                   }
    Target      : Byte;                  { Directory Handle of Target    }
    Source      : Byte;                  { Directory Handle of Source    }
    PLen        : Byte;                  { Length of Directory           }
    ScrPath     : array[1..255] of Byte; { Source-Directory Path         }
  end;

begin
  Reply := SizeOf(Reply) -2;
  with Request do
  begin
    FLen      := SizeOf(Request) -2;
    SubF      := $00;
    Target    := TargetHandle;
    Source    := SourceHandle;
    PLen      := Length(Path);
    StrPCopy(@ScrPath, Path);
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  SetDirHandle := Lo(NovRegs);
end;

{
  function        : MapRootDirectory
  service type    : directory functions
  Netware version : Shell v3.00+

  Desc : Maps an fake root directory to
         an drive

  Errors : - neSuccessfull
           - nePathNotFound
           - neNotSameDevice
 }

function MapRootDirectory(Drive : Byte;
                          RootPath : String):Byte;

var
  NovRegs       : tRegister;
  RPath         : array[1..255] of Char;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $E905;
    BL := Drive;
  end;
  StrPCopy(@RPath,StupCase(RootPath));
  PathIntr(RPath, Length(RootPath), NovRegs);
  MapRootDirectory := NovRegs.AL;
end;

{
  function        : DeleteMapRootDirectory
  service type    : directory functions
  Netware version : Shell v3.00+

  Desc : Deletes the fake root maping, but only
         the fake root ! the maping itself will
         not be deleted
 }

procedure DeleteMapRootDirectory(Drive : Byte);

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $E906;
    BL := Drive;
  end;
  CallIntr(NovRegs);
end;

{
  function        : GetDriveDepth
  service type    : directory functions
  Netware version : Shell v3.00+

  Desc : Get's the relative drive depth of
         an mapped drive
 }

function GetDriveDepth(Drive : Byte):Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $E907;
    BL := Drive;
  end;
  CallIntr(NovRegs);
  GetDriveDepth := NovRegs.AL
end;

{
  function        : GetDirectoryPath
  service type    : directory functions
  Netware version : NW v2.0 - v4.x

  Desc : Gets a directoy-path from handle

  Errors : - neSuccessfull
           - neInvalidDirHandle1
 }

function GetDirectoryPath(Handle : Byte):String;

var
  NovRegs       : Word;
  TempString    : String;

  Request       :
  record
    FLen        : Word;         { Length of request     }
    SubF        : Byte;         { Subfunction           }
    DirHandle   : Byte;         { Dir handle            }
  end;

  Reply         :
  record
    Size        : Word;
    PathLen     : Byte;
    Path        : array[1..255] of Byte;
  end;

begin
  Reply.Size := SizeOf(Reply) -2;
  with Request do
  begin
    FLen       := SizeOf(Request) -2;
    SubF       := $01;
    DirHandle  := Handle;
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  if Lo(NovRegs) = neSuccessfull then
  begin
    Move(Reply.Path, TempString[1], Reply.PathLen);
    TempString[0] := Char(Reply.PathLen);
    GetDirectoryPath := TempString;
  end
  else
    GetDirectoryPath := '';
end;

{
  function        : ConvertPathToDirEntry
  service type    : directory functions
  Netware version : NW v3.x, v4.x

  Desc : Converts a path to a directory-entry
         number

  Errors : - neSuccessfull
           - neNoConsoleOperator
 }

function ConvertPathToDirEntry(DirHandle : Byte;
                               DirPath : String;
                               var DirEntry : tDirEntry):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    FLen        : Word;         { Length of request     }
    SubF        : Byte;         { Subfunction           }
    Handle      : Byte;         { directory handle      }
    Path        : String;       { directory path        }
  end;

begin
  with Request do
  begin
    FLen       := SizeOf(Request) -2;
    SubF       := $F4;
    Handle     := DirHandle;
    Path       := DirPath;
  end;
  NovRegs := $F217;
  ReqCallIntr(Request, DirEntry, SizeOf(Request),
              SizeOf(DirEntry), NovRegs);
  ConvertPathToDirEntry := Lo(NovRegs);
end;

{
  function        : MapDirNoToPath
  service type    : directory functions
  Netware version : NW v3.x - v4.x

  Desc : Returns the path of the directory
         given entry id.
         The returned string has a special
         format ! The single path parts
         are not seperated with '/' or '\'
         instead with the length byte.
         Means :
         Length-byte | Path-name | Length-byte |
         Path-name .....

  Errors : - neSuccessfull
           - neNoConsoleOperator
 }

function MapDirNoToPath(DirEntry : tDirEntry;
                        NameSpaceSupport : Byte;
                        var DirPath : String):Byte;

var
  NovRegs       : Word;
  i             : Byte;

  Request       :
  record
    FLen        : Word;    { Length of request     }
    SubF        : Byte;    { Subfunction           }
    VolNo       : Byte;    { Volume-no             }
    DirEntryId  : LongInt; { Directory entry id    }
    NameSpace   : Byte;    { Name space            }
  end;

begin
  FillChar(DirPath, SizeOf(DirPath), 0);
  with Request do
  begin
    FLen       := SizeOf(Request) - 2;
    SubF       := $F3;
    VolNo      := DirEntry.VolumeNo;
    DirEntryId := DirEntry.EntryId;
    NameSpace  := NameSpaceSupport;
  end;
  NovRegs := $F217;
  ReqCallIntr(Request, DirPath, SizeOf(Request), SizeOf(DirPath), NovRegs);
  for i := 1 to 255 do
  begin
    if Ord(DirPath[i]) = 0 then break;
    if Ord(DirPath[i]) < 15 then
    begin
      Inc(DirPath[0], Ord(DirPath[i]) + 1);
      DirPath[i] := '/';
    end;
  end;
  MapDirNoToPath := Lo(NovRegs);
end;

{
  function        : GetDirRights
  service type    : directory functions
  Netware version : NW v2.0 - v4.x

  Desc : Get's the directory-rights of a
         directory with path and handle

  Errors : - neSuccessfull
           - neNonExistentVol
           - neInvalidDirHandle1
 }

function GetDirRights(Path : String;
                      Handle : Byte;
                      var Rights : Byte):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    FLen        : Word;       { Length of Request        }
    SubF        : Byte;       { Subfunction              }
    DirHandle   : Byte;       { Directory Handle         }
    Dir         : String;     { Directory                }
  end;

  Reply         :
  record
    Size        : Word;       { Size of Reply            }
    DRights     : Byte;       { effective Dir-Rights     }
  end;

begin
  Reply.Size := SizeOf(Reply) -2;
  with Request do
  begin
    FLen       := SizeOf(Request) -2;
    SubF       := $03;
    DirHandle  := Handle;
    Dir        := StupCase(Path);
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetDirRights  := Lo(NovRegs);
  Rights        := Reply.DRights;
end;

{
  function        : ModifyDirRights
  service type    : directory functions
  Netware version : NW v2.0 - v4.x

  Desc : Modifies the directory rights

  Errors : - neSuccessfull
           - neNoModifyPrivileges
           - neNonExistentVol
           - neInvalidPath
 }

function ModifyDirRights(Path : String;
                         Handle,
                         Grant,
                         Revoke : Byte):Byte;

var
  NovRegs       : Word;
  Reply         : Word;      { Size of Reply            }

  Request :
  record
    FLen       : Word;       { Length of Request        }
    SubF       : Byte;       { Subfunction              }
    DirHandle  : Byte;       { Directory Handle         }
    GrantR     : Byte;       { Rights to grant          }
    RevokeR    : Byte;       { Rights to revoke         }
    Dir        : String;     { Directory                }
  end;

begin
  Reply := SizeOf(Reply) -2;
  with Request do
  begin
    FLen       := SizeOf(Request) -2;
    SubF       := $04;
    DirHandle  := Handle;
    GrantR     := Grant;
    RevokeR    := Revoke;
    Dir        := StupCase(Path);
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  ModifyDirRights := Lo(NovRegs);
end;

{
  function        : CreateDirectory
  service type    : directory functions
  Netware version : NW v2.0 - v4.x

  Desc : Create a directory on the volume

  Errors : - neSuccessfull
           - neNoCreatePrivileges
           - neNonExistentVol
 }

function CreateDirectory(NewDir : String;
                         Handle,
                         DirRights : Byte):Byte;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    FLen        : Word;       { Length of Request        }
    SubF        : Byte;       { Subfunction              }
    DirHandle   : Byte;       { Directory Handle         }
    MaxRights   : Byte;       { Maximum Right Mask       }
    Dir         : String;     { Directory                }
  end;

begin
  Reply := SizeOf(Reply) -2;
  with Request do
  begin
    FLen       := SizeOf(Request) -2;
    SubF       := $0A;
    DirHandle  := Handle;
    MaxRights  := DirRights;
    Dir        := StupCase(NewDir);
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  CreateDirectory := Lo(NovRegs);
end;

{
  function        : DeleteDirectory
  service type    : directory functions
  Netware version : NW v2.0 - v4.x

  Desc : Delete a directory from volume

  Errors : - neSuccessfull
           - neNoDeletePrivileges
           - neNonExistentVol
           - neInvalidDirHandle1
           - neInvalidPath
           - neDirInUse
           - neDirNotEmpty
 }

function DeleteDirectory(Path : String;
                         Handle : Byte):Byte;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    FLen        : Word;       { Length of Request        }
    SubF        : Byte;       { Subfunction              }
    DirHandle   : Byte;       { Directory Handle         }
    Unused      : Byte;       { unused                   }
    Dir         : String;     { Directory                }
  end;

begin
  Reply := SizeOf(Reply) -2;
  with Request do
  begin
    FLen       := SizeOf(Request) -2;
    SubF       := $0B;
    DirHandle  := Handle;
    Dir        := StupCase(Path);
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  DeleteDirectory := Lo(NovRegs);
end;

{
  function        : RenameDirectory
  service type    : directory functions
  Netware version : NW v2.0 - v4.x

  Desc : Rename a directory on the volume

  Errors : - neSuccessfull
           - neNoRenamePrivileges
           - neInvalidDirHandle1
           - neInvalidPath
           - neInvalidFileName
 }

function RenameDirectory(OldPath,
                         NewName : String;
                         Handle : Byte):Byte;

var
  NovRegs       : Word;
  Reply         : Word;
  Marker        : Byte;

  Request :
  record
    FLen        : Word;                  { Length of Request              }
    SubF        : Byte;                  { Subfunction                    }
    DirHandle   : Byte;                  { Directory Handle               }
    OldNewDir   : array[1..255] of Char; { Path of Directory and new Name }
  end;

begin
  Reply := SizeOf(Reply) -2;
  with Request do
  begin
    SubF       := $0F;
    DirHandle  := Handle;
    Marker := 1;
    OldPath := StupCase(OldPath);
    Move(OldPath, Ptr(Seg(OldNewDir[Marker]), Ofs(OldNewDir[Marker]))^, Length(OldPath)+1);
    Inc(Marker, Length(OldPath) + 1);
    NewName := StupCase(NewName);
    Move(NewName, Ptr(Seg(OldNewDir[Marker]), Ofs(OldNewDir[Marker]))^, Length(NewName)+1);
    Inc(Marker, Length(NewName) + 1);
    FLen       := 2 + Marker;
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  RenameDirectory := Lo(NovRegs);
end;

{
  function        : ScanTrustees
  service type    : trustee functions
  Netware version : NW v2.0 - v4.x

  Desc : Scan's the directory for trustees

  Errors : - neSuccessfull
           - neNoMoreTrustees
 }

function ScanTrustees(var Trustee : tTrusteeRec;
                      Path : String;
                      Handle,
                      Seq : Byte):boolean;

var
  NovRegs       : Word;
  i             : Byte;

  Request       :
  record
    FLen        : Word;   { Length of request          }
    SubF        : Byte;   { Subfunction                }
    DirHandle   : Byte;   { Directory handle           }
    Sequenze    : Byte;   { Sequenze number            }
    DirPath     : String; { Directory path             }
  end;

  Reply         :
  record
    Size        : Word;                   { Size of reply                  }
    Dir         : array[1..16] of Char;   { Directory name                 }
    CrDate      : LongInt;                { Date and time of creation      }
    DirOwner    : LongInt;                { Object id of owner (big-endian)}
    DirTrustee  : array[0..4] of LongInt; { Directory-trustee (big-endian) }
    DirRights   : array[0..4] of Byte;    { Trustee-dir rights             }
  end;

begin
  Reply.Size := SizeOf(Reply) -2;
  with Request do
  begin
    FLen       := SizeOf(Request) -2;
    SubF       := $0C;
    DirHandle  := Handle;
    Sequenze   := Seq;
    DirPath    := StupCase(Path);
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  with Trustee do
  begin
    DirName    := StrPas(@Reply.Dir);
    CrDateTime := Reply.CrDate;
    Owner      := SwapLongInt(Reply.DirOwner);
    for i := 0 to 4 do
    begin
      Trustees[i] := SwapLongInt(Reply.DirTrustee[i]);
    end;
    for i := 0 to 4 do
    begin
      TrusteeRight[i] := Reply.DirRights[i];
    end;
  end;
  if Lo(NovRegs) = neSuccessfull then
    ScanTrustees := true
  else
    ScanTrustees := false;
end;

{
  function        : ScanEntryForTrustees
  service type    : trustee functions
  Netware version : NW v3.x, v4.x

  Desc : Scan's an entry for trustees

  Errors : - neSuccessfull
           - neNoMoreTrustees
 }

function ScanEntryForTrustees(var Trustee : tTrusteeEntryRec;
                              Path : String;
                              Handle,
                              Seq : Byte):Byte;

var
  NovRegs       : Word;
  i             : Byte;

  Request       :
  record
    FLen        : Word;   { Length of request          }
    SubF        : Byte;   { Subfunction                }
    DirHandle   : Byte;   { Directory handle           }
    Sequenze    : Byte;   { Sequenze number            }
    DirPath     : String; { Directory path             }
  end;

  Reply         : tTrusteeEntryRec absolute Trustee;

begin
  Reply.Size := SizeOf(Reply) -2;
  with Request do
  begin
    FLen       := SizeOf(Request) -2;
    SubF       := $26;
    DirHandle  := Handle;
    Sequenze   := Seq;
    DirPath    := StupCase(Path);
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  for i := 1 to 20 do
    Trustee.TrusteesId[i] := SwapLongInt(Trustee.TrusteesId[i]);
  ScanEntryForTrustees := Lo(NovRegs);
end;

{
  function        : ScanBindObjectTrusteePath
  service type    : trustee functions
  Netware version : NW v2.0 - v4.x

  Desc : Scans a bindery objects trustee pathes.
         TrusteePathRecord must be preinitialized
         by first call.
         TrusteePathRecord.ObjectId = object id
         TrusteePathRecord.NextSeq  = 0 for first
                                      call

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neNoWildcardAllowed
           - neInvalidBindSecLevel
           - neNoSuchObject
           - neBinderyLocked
           - neBinderyError
 }

function ScanBindObjectTrusteePath(VolumeNo : Byte;
                                   var TrusteePathRecord : tTrusteePath):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    FLen        : Word;    { Length of request          }
    SubF        : Byte;    { Subfunction                }
    VolNo       : Byte;    { Directory handle           }
    LastSeq     : Word;    { last sequenze number       }
    ObjId       : LongInt; { Object id                  }
  end;

  Reply         :
  record
    Size        : Word;    { Size of reply              }
    NextSeq     : Word;    { Next sequenze no           }
    ObjId       : LongInt; { Object id                  }
    AccessMask  : Byte;    { access mask                }
    Path        : String;  { Trustee path               }
  end;

begin
  Reply.Size := SizeOf(Reply) -2;
  with Request do
  begin
    FLen       := SizeOf(Request) - 2;
    SubF       := $47;
    VolNo      := VolumeNo;
    LastSeq    := Swap(TrusteePathRecord.NextSeq);
    ObjId      := SwapLongInt(TrusteePathRecord.ObjectId);
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  with TrusteePathRecord do
  begin
    NextSeq        := Swap(Reply.NextSeq);
    ObjectId       := SwapLongInt(Reply.ObjId);
    AccessMask     := Reply.AccessMask;
    TrusteePath    := Reply.Path;
  end;
  ScanBindObjectTrusteePath := Lo(NovRegs);
end;

{
  function        : AddTrustee
  service type    : trustee functions
  Netware version : NW v2.0 - v4.x

  Desc : Add's an trustee to an directory

  Errors : - neSuccessfull
           - neNoModifyPrivileges
           - neNoSuchObject
 }

function AddTrustee(Trustee : tTrusteeRec;
                    Handle : Byte;
                    Path : String):Byte;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    FLen        : Word;    { Length of request          }
    SubF        : Byte;    { Subfunction                }
    DirHandle   : Byte;    { Directory handle           }
    TrusteeId   : LongInt; { Object-id of new trustee   }
    DirRights   : Byte;    { Trustee right              }
    DirPath     : String;  { Directory path             }
  end;

begin
  Reply := SizeOf(Reply) -2;
  with Request do
  begin
    FLen       := SizeOf(Request) -2;
    SubF       := $0D;
    DirHandle  := Handle;
    TrusteeId  := SwapLongInt(Trustee.Trustees[0]);
    DirRights  := Trustee.TrusteeRight[0];
    DirPath    := StupCase(Path);
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  AddTrustee := Lo(NovRegs);
end;

{
  function        : DeleteTrustee
  service type    : trustee functions
  Netware version : NW v2.0 - v4.x

  Desc : Deletes a trustee from directory

  Errors : - neSuccessfull
           - neNonExistentVol
           - neInvalidDirHandle1
           - neInvalidPath
 }

function DeleteTrustee(Trustee : tTrusteeRec;
                       Handle : Byte;
                       Path : String):Byte;

var
  NovRegs       : Word;
  Reply         : Word;
  i             : Byte;

  Request       :
  record
    FLen        : Word;    { Length of request          }
    SubF        : Byte;    { Subfunction                }
    DirHandle   : Byte;    { Directory handle           }
    TrusteeId   : LongInt; { Trustee-id                 }
    Unused      : Byte;    { Unused                     }
    DirPath     : String;  { Directory path             }
  end;

begin
  Reply := SizeOf(Reply) -2;
  with Request do
  begin
    FLen       := SizeOf(Request) -2;
    SubF       := $0E;
    DirHandle  := Handle;
    TrusteeId  := SwapLongInt(Trustee.Trustees[0]);
    DirPath    := StupCase(Path);
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  DeleteTrustee := Lo(NovRegs);
end;

{
  function        : GetVolumeInfoWithHandle
  service type    : volume and file functions
  Netware version : NW v2.0 - v4.x

  Desc : Get's various infos about an volume
         with directory-handle

  Errors : - neSuccessfull
 }

function GetVolumeInfoWithHandle(Var Volume : tVolInfo;
                                 DirHandle : Byte):boolean;

var
  NovRegs : Word;

  Request        :
  record
    FLen         : Word; { Length of Request}
    SubF         : Byte; { Subfunction }
    Handle       : Byte; { Directory-Handle }
  end;

  Reply            :
  record
    Len            : Word;
    SecPerBl       : Word;
    TotalBl        : Word;
    AvailBl        : Word;
    TotalDirSl     : Word;
    AvailDirSl     : Word;
    VolumeName     : array[1..16] of Byte;
    RemoveableFlag : Word;
  end;

begin
  with Request do
  begin
    FLen   := $02;
    SubF   := $15;
    Handle := DirHandle;
  end;
  Reply.Len := $1C;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetVolumeInfoWithHandle := (Lo(NovRegs) = neSuccessfull);
  with Volume, Reply do
  begin
    SecPerBlock   := Swap(SecPerBl);
    TotalBlocks   := Swap(TotalBl);
    AvailBlocks   := Swap(AvailBl);
    TotalDirSlots := Swap(TotalDirSl);
    AvailDirSlots := Swap(AvailDirSl);
    VolName       := StrPas(@VolumeName);
    VolRemovable  := (RemoveableFlag <> $00);
  end;
end;

{
  function        : GetVolumeInfoWithNumber
  service type    : volume and file functions
  Netware version : NW v2.0 - v4.x

  Desc : Get's various information about the
         volume with volume-no

  Errors : - neSuccessfull
 }

function GetVolumeInfoWithNumber(Var Volume : tVolInfo;
                                 VolumeNo : Byte):boolean;

var
  NovRegs : tRegister;

  Reply   :
  record
    SecPerBl       : Word;
    TotalBl        : Word;
    AvailBl        : Word;
    TotalDirSl     : Word;
    AvailDirSl     : Word;
    VolumeName     : array[1..16] of Byte;
    RemoveableFlag : Word;
  end;

begin
  with NovRegs do
  begin
    AH := $DA;
    DL := VolumeNo;
  end;
  ReplyBufferIntr(Reply, SizeOf(Reply), NovRegs);
  GetVolumeInfoWithNumber := (NovRegs.AL = neSuccessfull);
  with Volume, Reply do
  begin
    SecPerBlock   := Swap(SecPerBl);
    TotalBlocks   := Swap(TotalBl);
    AvailBlocks   := Swap(AvailBl);
    TotalDirSlots := Swap(TotalDirSl);
    AvailDirSlots := Swap(AvailDirSl);
    VolName       := StrPas(@VolumeName);
    VolRemovable  := (RemoveableFlag <> $00);
  end;
end;

{
  function        : GetExtendedVolumeInfo
  service type    : volume and file functions
  Netware version : NW v3.x, v4.x

  Desc : Get's extended infos about the volume
         with volume-no

  Errors : - neSuccessfull
 }

function GetExtendedVolumeInfo(Var Volume : tExtVolInfo;
                               VolumeNo : Byte):boolean;

var
  NovRegs        : Word;
  Reply          : tExtVolInfo absolute Volume;

  Request        :
  record
    FLen         : Word; { Length of request }
    SubF         : Byte; { Subfunction       }
    Volume       : Byte; { Volume-no         }
  end;

begin
  NovRegs := $F216;
  with Request do
  begin
    FLen   := SizeOf(Request) - 2;
    SubF   := $2C;
    Volume := VolumeNo;
  end;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  Reply.SectorsPerBlock := SwapLongInt(Reply.SectorsPerBlock);
  GetExtendedVolumeInfo := (Lo(NovRegs) = neSuccessfull);
end;

{
  function        : LocalDrives
  service type    : volume and file functions
  Netware version : NW v2.0 - v4.x

  Desc : Returns the count of local drives
         as definied in LASTDRIVE
 }

function LocalDrives:Byte;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $DB;
  CallIntr(NovRegs);
  LocalDrives := NovRegs.AL
end;

{
  procedure       : GetDriveConnID
  service type    : volume and file functions
  Netware version : NW v2.0 - v4.x

  Desc : Gets the drive connection table
 }

procedure GetDriveConnId(Var IDTable : tDriveTable);

var
  NovRegs       : tRegister;
  i             : Integer;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $EF02;
  CallIntr(NovRegs);
  {$IFDEF DPMI}
  Segment2Descriptor(NovRegs.ES);
  {$ENDIF}
  Move(Ptr(NovRegs.ES, NovRegs.SI)^, IDTable, 32);
end;

{
  procedure       : GetDriveFlagTable
  service type    : volume and file functions
  Netware version : NW v2.0 - v4.x

  Desc : Get's the drive flag-table
 }

procedure GetDriveFlagTable(var FlagTable : tDriveTable);

var
  NovRegs    : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $EF01;
  CallIntr(NovRegs);
  {$IFDEF DPMI}
  Segment2Descriptor(NovRegs.ES);
  {$ENDIF}
  Move(Ptr(NovRegs.ES, NovRegs.SI)^, FlagTable, 32);
end;

{
  procedure       : GetDriveHandleTable
  service type    : volume and file functions
  Netware version : NW v2.0 - v4.x

  Desc : Gets the drive handle-table
 }

procedure GetDriveHandleTable(var HandleTable : tDriveTable);

var
  NovRegs    : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $EF00;
  CallIntr(NovRegs);
  {$IFDEF DPMI}
  Segment2Descriptor(NovRegs.ES);
  {$ENDIF}
  Move(Ptr(NovRegs.ES, NovRegs.SI)^, HandleTable, 32);
end;

{
  procedure       : GetVolumeNumber
  service type    : volume and file functions
  Netware version : NW v2.0 - v4.x

  Desc : Get's the volume-no from volume-name

  Errors : - neSuccessfull
           - neNonExistentVol
 }

function GetVolumeNumber(VolumeName : String;
                         var VolNo : Byte):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    FLen        : Word;          { Length of request }
    SubF        : Byte;          { Subfunction       }
    Volume      : String[16];    { Volume name       }
  end;

  Reply         :
  record
    Size        : Word;
    VolumeNo    : Byte;
  end;

begin
  Reply.Size := SizeOf(Reply) -2;
  with Request do
  begin
    FLen      := SizeOf(Request) -2;
    SubF      := $05;
    Volume    := VolumeName;
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetVolumeNumber := Lo(NovRegs);
  VolNo           := Reply.VolumeNo;
end;

{
  function        : GetVolumeName
  service type    : volume and file functions
  Netware version : NW v2.0 - v4.x

  Desc : Get's the volume-name from volume-no

  Errors : - neSuccessfull
           - neNonExistentVol
 }

function GetVolumeName(VolNo : Byte;
                       var VolumeName : String):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    FLen        : Word; { Length of request }
    SubF        : Byte; { Subfunction       }
    VolumeNo    : Byte; { Volume no         }
  end;

  Reply         :
  record
    Size        : Word;       { Size of reply   }
    VolName     : String[16]; { Volume name     }
  end;

begin
  Reply.Size := SizeOf(Reply) -2;
  with Request do
  begin
    FLen      := SizeOf(Request) -2;
    SubF      := $06;
    VolumeNo  := VolNo;
  end;
  NovRegs := $E200;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetVolumeName := Lo(NovRegs);
  VolumeName    := Reply.VolName;
end;

{
  function        : AddUserDiskSpaceRestriction
  service type    : restriction services
  Netware version : NW v3.x, v4.x

  Desc : Restricts the available volume
         disk space for an object

  Errors : - neSuccessfull
           - neNoModifyPrivileges
           - neNonExistentVol
 }

function AddUserDiskSpaceRestriction(VolumeNo : Byte;
                                     ObjectId : LongInt;
                                     DiskSpaceLimit : LongInt):Byte;

var
  NovRegs       : tRegister;

  Request       :
  record
    FLen        : Word;    { Length of request    }
    SubF        : Byte;    { Subfunction          }
    VolNo       : Byte;    { Volume no            }
    ObjId       : LongInt; { Object id            }
    DiskLimit   : LongInt; { Disk limit in blocks }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with Request do
  begin
    FLen      := SizeOf(Request) -2;
    SubF      := $21;
    VolNo     := VolumeNo;
    ObjId     := SwapLongInt(ObjectId);
    DiskLimit := DiskSpaceLimit;
  end;
  NovRegs.AX := $F216;
  RequestBufferIntr(Request, SizeOf(Request), NovRegs);
  AddUserDiskSpaceRestriction := NovRegs.AL;
end;

{
  function        : RemoveUserDiskSpaceRestriction
  service type    : restriction services
  Netware version : NW v3.x, v4.x

  Desc : Removes the disk space restrictions
         of an object

  Errors : - neSuccessfull
           - neNoModifyPrivileges
           - neUserNotFound
 }

function RemoveUserDiskSpaceRestriction(VolumeNo : Byte;
                                        ObjectId : LongInt):Byte;

var
  NovRegs       : tRegister;

  Request       :
  record
    FLen        : Word;    { Length of request    }
    SubF        : Byte;    { Subfunction          }
    VolNo       : Byte;    { Volume no            }
    ObjId       : LongInt; { Object id            }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with Request do
  begin
    FLen      := SizeOf(Request) -2;
    SubF      := $22;
    VolNo     := VolumeNo;
    ObjId     := SwapLongInt(ObjectId);
  end;
  NovRegs.AX := $F216;
  RequestBufferIntr(Request, SizeOf(Request), NovRegs);
  RemoveUserDiskSpaceRestriction := NovRegs.AL;
end;

{
  function        : GetObjectDiskUsage
  service type    : restriction services
  Netware version : NW v3.x, v4.x

  Desc : Gets the disk-usage and disk-restriction
         of an object

  Errors : - neSuccessfull
           - neNoModifyPrivileges
           - neNonExistentVol
 }

function GetObjectDiskUsage(VolumeNo : Byte;
                            ObjectId : LongInt;
                            var DiskRestriction : LongInt;
                            var DiskSpaceInUse : LongInt):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    FLen        : Word;    { Length of request    }
    SubF        : Byte;    { Subfunction          }
    VolNo       : Byte;    { Volume no            }
    ObjId       : LongInt; { Object id            }
  end;

  Reply         :
  record
    DiskRest    : LongInt; { Disk restriction     }
    DiskSpace   : LongInt; { Disk space in use    }
  end;

begin
  with Request do
  begin
    FLen  := SizeOf(Request) -2;
    SubF  := $29;
    VolNo := VolumeNo;
    ObjId := SwapLongInt(ObjectId);
  end;
  NovRegs := $F216;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  with Reply do
  begin
    DiskRestriction := DiskRest;
    DiskSpaceInUse  := DiskSpace;
  end;
  GetObjectDiskUsage := Lo(NovRegs);
end;

{
  function        : SetDirectoryDiskSpaceRestriction
  service type    : restriction services
  Netware version : NW v3.x, v4.x

  Desc : Set's an disk space restriction for
         an directory

  Errors : - neSuccessfull
           - neInvalidSpaceLimit
           - neNoModifyPrivileges
           - neNameSpaceNotFound
 }

function SetDirectoryDiskSpaceRestriction(DirHandle : Byte;
                                          DiskSpaceLimit : LongInt):Byte;

var
  NovRegs       : tRegister;

  Request       :
  record
    FLen        : Word;    { Length of request    }
    SubF        : Byte;    { Subfunction          }
    Handle      : Byte;    { Directory handle     }
    DiskSpace   : LongInt; { Disk space limit     }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with Request do
  begin
    FLen      := SizeOf(Request) -2;
    SubF      := $24;
    Handle    := DirHandle;
    DiskSpace := DiskSpaceLimit;
  end;
  NovRegs.AX := $F216;
  RequestBufferIntr(Request, SizeOf(Request), NovRegs);
  SetDirectoryDiskSpaceRestriction := NovRegs.AL;
end;

{------------------------ end of unit ------------------------}

end.
