 {ͻ
   unit : Novell main procedures                Target Platforms         
   desc : Procedures for interupt-calls           - DOS Real             
          and DPMI.                               - DOS Protected        
                                                  - Windows              
   (C) 1994 by Christoph Weller 16/01/93 v1.1                            
  ͼ}

(*

  18.1.1995  : inserted the error-results :
               neInsuffAccessPriv     = $FE;
               neNoMoreErasedFiles    = $FF;
               neNoMoreTrustees       = $9C;
               neUserNotFound         = $FE;
               neInvalidSpaceLimit    = $01;
               neIOError              = $FE;
               neMessageQueueFull     = $FC;
               neNoSuchPrinter        = $FF;
               neMaxQueueServer       = $DB;
               neFileOpen             = $FF;
               neError                = $FF;
               neNoLockedRecordFound  = $FF;
               neConnectionNotExist   = $FF;

*)


unit NVMain;

interface

{$I NVDEFINE.INC}

uses
  {$IFDEF PROTECTED}
  WinApi,   { windows API      }
  {$ENDIF}
  {$IFDEF WINDOWS}
  WinDos;   { windows DOS unit }
  {$ELSE}
  Dos;      { DOS unit         }
  {$ENDIF}

{
              CONST declarations
 }

const

  {
           (n)etwork (e)rrors for all units
              except the NV4_x.PAS unit
   }

  neSuccessfull          = $00; { Operation successfull                  }
  neSPXNotInstalled      = $00; { SPX not installed                      }
  neSPXConnectionOk      = $00; { SPX connection ok                      }
  neSPXConnectionStarted = $00; { SPX connection started                 }
  neSPXConnEstablished   = $00; { SPX connection established             }
  neSPXPacketSuccessfull = $00; { SPX packet successfull                 }
  neServerNotInUse       = $00; { Server not in use                      }
  neTTSNotAvailable      = $00; { TTS not available                      }
  neCaptureNotActive     = $00; { Capture is not active                  }
  neShellVerToOld        = $00; { Shell version to old                   }

  neInvalidSpaceLimit    = $01; { Invalid space limit                    }
  neSuccessfullSet       = $01; { Successfull set                        }
  neInvalidFunction      = $01; { DOS invalid function number            }
  neServerInUse          = $01; { Server in use                          }
  neSemaphoreOverflow    = $01; { Semaphore overflow                     }
  neTTSAvailable         = $01; { TTS available                          }
  neLPTDeviceOutOfRange  = $01; { LPT device out of range                }

  neFileNotFound         = $02; { DOS File not found                     }
  nePathNotFound         = $03; { DOS Path not found                     }
  neToManyOpenFiles      = $04; { DOS too many open files                }
  neAccessDenied         = $05; { DOS access denied                      }
  neInvalidHandle        = $06; { DOS Invalid file handle                }
  neMemoryBlDestroyed    = $07; { DOS Memory blocks destroyed            }
  neInsuffMemory         = $08; { DOS insufficient memory                }
  neMemBlockAdressInv    = $09; { DOS memory block address invalid       }
  neEnvInvalid           = $0A; { DOS environment invalid                }
  neFormatInvalid        = $0B; { DOS Format invalid                     }
  neAccessCodeInvalid    = $0C; { DOS Access code invalid                }
  neDataInvalid          = $0D; { DOS Data invalid                       }
  neInvalidDrive         = $0F; { DOS Invalid drive                      }
  neAttemptDeleteCurDir  = $10; { DOS Attempt to delete current
                                  directory                              }
  neNotSameDevice        = $11; { DOS not the same device                }
  neNoMoreFiles          = $12; { DOS no more files                      }
  neSharingViolation     = $20; { DOS sharing violation                  }
  neLockViolation        = $21; { DOS lock violation                     }
  neFileInUse            = $80; { File in use                            }
  neNoMoreFileHandles    = $81; { No more file handles                   }
  neNoOpenPrivileges     = $82; { No open privileges                     }
  neIOErrorNetworkDisk   = $83; { IO errror network disk                 }
  neNoCreatePrivileges   = $84; { No create privileges                   }
  neNoCreaDelPrivileges  = $85; { No create/delete privileges            }
  neCreateFileExistsRO   = $86; { Created file exists 'read only'        }
  neWildCardsInFileName  = $87; { Wildcards in created file name         }
  neInvalidFileHandle    = $88; { Invalid file handle                    }
  neNoSearchPrivileges   = $89; { No search privileges                   }
  neNoDeletePrivileges   = $8A; { No delete privileges                   }
  neNoRenamePrivileges   = $8B; { No rename privileges                   }

  neNoModifyPrivileges   = $8C; { No modify privileges                   }
  neCallerLacksPriv      = $8C; { Caller lacks privilege                 }

  neSomeFilesAffInUse    = $8D; { Some files affected in use             }
  neNoFilesAffInUse      = $8E; { No files affected in use               }
  neSomeFilesAffRO       = $8F; { Some files affected 'read only'        }
  neNoFilesAffRO         = $90; { No files affected 'read only'          }
  neSomeFilesRenExists   = $91; { Some files renamed name exists         }
  neNoFilesRenExists     = $92; { No files renamed name exists           }
  neNoReadPrivileges     = $93; { No read privileges                     }
  neNoWritePrivOrRO      = $94; { No write privileges or 'read only'     }
  neFileDeatached        = $95; { File detached                          }

  neServerOutOfMem       = $96; { Server out of memory                   }
  neOutOfDynWorkSpace    = $96; { Out of dynamic workspace               }

  neNoDiskSpaceForSpool  = $97; { No disk space for spool file           }
  neNonExistentVol       = $98; { Non existent volume                    }
  neDirectoryFull        = $99; { Directory full                         }
  neRenamingAcrossVol    = $9A; { Renaming across volumes                }
  neInvalidDirHandle1    = $9B; { Invalid directory handle 1             }
  neInvalidPath          = $9C; { Invalid path                           }
  neNoMoreTrustees       = $9C; { No more trustees                       }
  neInvalidFileName      = $9E; { Invalid filename                       }
  neDirInUse             = $9F; { Directory in use                       }
  neDirNotEmpty          = $A0; { Directory not empty                    }
  neDirectoryIOError     = $A1; { Directory IO Error                     }
  neReadFileWithRecLock  = $A2; { Read file with record locked           }
  neBadDiskNumber        = $A3; { Bad disk number                        }
  neUnusedDiskNumber     = $A4; { Unused disk number                     }
  neSearchDrvVectorFull  = $B0; { Search drive vector full               }
  neDriveNotMapped       = $B1; { Drive is not mapped                    }
  neCantMapLocalDrive    = $B2; { Can't map local drive                  }
  neInvaildMapType       = $B3; { Invaild map type                       }
  neInvalidDriveLetter   = $B4; { Invalid drive letter                   }
  neNoDriveAvailable     = $B5; { No drive available                     }
  neWorkstationOutOfMem  = $B6; { Workstation out of memory              }
  nePathEnvVarInvalid    = $B8; { Path enviroment invalid                }
  neNameSpaceNotFound    = $BF; { Name space not found                   }
  neNoAccountPrivlege    = $C0; { No account privilege                   }
  neNoAccountBalance     = $C1; { No account balance                     }
  neAccCreditLimitExceed = $C2; { Account credit limit exceeded          }
  neAccountToManyHolds   = $C3; { Account to many holds                  }
  neIntruderDetectLock   = $C5; { Intruder detection lock                }
  neNoConsoleOperator    = $C6; { No console operator                    }
  neMissingExtAttrKey    = $C8; { Missing extended attribute key         }
  neExtAttrNotFound      = $C9; { Extended attribute found               }
  neInvalidExtAttrType   = $CA; { Invalid extended attribute handle type }
  neExtAttrNoKeyNoData   = $CB; { Extended attribute no key no data      }
  neExtAttrNoMismatch    = $CC; { Extended attribute number mismatch     }
  neExtNumberOutOfRange  = $CD; { Extent number out of range             }
  neExtAttrBadDirNum     = $CE; { Extent attribute dir num               }
  neInvalidExtAttrHandle = $CF; { Invalid extent attribute handle        }

  neQueueError           = $D0; { Queue error                            }
  neExtAttrPosOutOfRange = $D0; { Ext. attribute position out of range   }

  neNoSuchQueue          = $D1; { No such queue                          }
  neExtAttrAccessDenied  = $D1; { Extendted attribute access denied      }

  neNoServerQueue        = $D2; { No server for queue                    }
  neDataPageOddSize      = $D2; { Data page odd size                     }

  neNoQueueRights        = $D3; { No queue rights                        }
  neExtAttrVolNotMounted = $D3; { Extended attribute volume not mounted  }

  neQueueFull            = $D4; { Queue full                             }
  neBadPageBoundary      = $D4; { Bad page boundary                      }

  neNoQueueJob           = $D5; { No queue job                           }
  neInspectFailure       = $D5; { Inspect failure                        }

  neNoJobRights          = $D6; { No job rights                          }
  neExtAttrAlradyClaimed = $D6; { Extended attribute already claimed     }
  neEncryptedPasswordExp = $D6; { Encrypted password expteced            }

  nePasswordNotUnique    = $D7; { Password not unique                    }
  neQueueServicing       = $D7; { Queue servicing                        }
  neOddBufferSize        = $D7; { Off buffer size                        }

  nePasswordToShort      = $D8; { Password to short                      }
  neQueueNotActive       = $D8; { Queue not active                       }
  neNoScorecards         = $D8; { No score cards                         }

  neLoginDenied          = $D9; { Login denied - no connection           }
  neStationIsNotServer   = $D9; { Station is not a server                }
  neBadSignature         = $D9; { Bad signature                          }

  neUnauthorizedLoginTi  = $DA; { Unauthorized login time                }
  neQueueHalted          = $DA; { Queue halted                           }
  neExtAttrSpaceLimit    = $DA; { Extended attribute space limit         }

  neMaxQueueServer       = $DB; { Max queue server                       }
  neUnauthorizedLoginSt  = $DB; { Unauthorized login station             }
  neTooMuchQueueServers  = $DB; { To many queue servers                  }
  neExtAttrKeyCorrupt    = $DB; { Extended attribute key corrupt         }

  neAccountDisabled      = $DC; { Account disabled                       }
  neExtAttrKeyLimit      = $DC; { Extended attribute key limit           }

  neTallyCorrupt         = $DD; { Tally corrupt                          }
  nePasswordExpNoGrace   = $DE; { Password expired - no grace            }
  nePasswordExp          = $DF; { Password expired                       }

  neNoItemProperty       = $E8; { Not an item property                   }
  neWritePropertyToGroup = $E8; { Write property to group                }

  neMemberAlreadyExists  = $E9; { Member already exists                  }
  neMemberNotExist       = $EA; { Member does not exist                  }
  neNotGroupProperty     = $EB; { Not a group property                   }

  neNoSuchSegment        = $EC; { No such a segment                      }
  neNoSuchSet            = $EC; { No such set                            }
  neSPXTerminatedPoorly  = $EC; { SPX terminated poorly                  }

  nePropertyExists       = $ED; { Property already exists                }
  neSPXNoAnswer          = $ED; { SPX no answer from target              }
  neSPXConnectionFailed  = $ED; { SPX connection failed                  }
  neSPXConnTerminated    = $ED; { SPX connection terminated              }

  neObjectExists         = $EE; { Object already exists                  }
  neSPXInvalidConnection = $EE; { SPX invalid connection                 }

  neInvalidName          = $EF; { Invalid name                           }
  neSPXConnTableFull     = $EF; { SPX connection table full              }

  neNoWildcardAllowed    = $F0; { No Wildcard allowed                    }
  neIPXNotInstalled      = $F0; { IPX not installed                      }

  neInvalidBindSecLevel  = $F1; { Invalid bindery security level         }
  neIPX_SPXNotInit       = $F1; { IPX/SPX not initialized                }

  neNoObjectReadPriv     = $F2; { No object read privilege               }
  neNoDOSMemory          = $F2; { No DOS memory                          }

  neNoRenameObjPrivilege = $F3; { No rename object privilege             }
  neNoFreeECB            = $F3; { No free ECB                            }

  neNoDeleteObjPrivilege = $F4; { No delete object privilege             }

  neNoCreateObjPrivilege = $F5; { No create object privilege             }
  nePacketSizeTooLarge   = $F5; { Packet size to large                   }

  neNoDeletePropPriv     = $F6; { No delete property privilege           }
  neNotSameLocalDrive    = $F6; { Not same local drive                   }

  neNoCreatePropPriv     = $F7; { No create property privelege           }
  neTargetDriveNotLocal  = $F7; { Target drive not local                 }

  neNoPropWritePrivilege = $F8; { No property write privilege            }
  neAlreadyAttToServer   = $F8; { Already attached to server             }
  neNotAttachedToServer  = $F8; { Not attached to server                 }

  neNoFreeConnSlots      = $F9; { No free connection slots               }
  neNoPropReadPrivilege  = $F9; { Not poperty read privilege             }
  neCancelError          = $F9; { cancel error                           }

  neNoMoreServerSlots    = $FA; { No more server slots                   }
  neTempRemapError       = $FA; { Temp remap error                       }
  neNoPathToDestFound    = $FA; { No path to destination found           }

  neNoSuchProperty       = $FB; { No such an property                    }
  neInvalidParameters    = $FB; { Invalid parameters                     }
  neUnknownRequest1      = $FB; { Unknown request 1                      }
  neSalvageUnavailable   = $FB; { Salvage unavailable                    }

  neMessageQueueFull     = $FC; { Message queue full                     }
  neNoSuchObject         = $FC; { No such an object                      }
  neIntPacketReqCanc     = $FC; { Internet packet request cancelled      }
  neUnknownFileServer    = $FC; { Unknown file server                    }
  neSPXListenCancelled   = $FC; { SPX listen cancelled                   }
  neIPXEventCancelled    = $FC; { IPX Event cancelled                    }
  neECBCancelled         = $FC; { ECB cancelled                          }

  neBadStationNumber     = $FD; { Bad station number                     }
  neImvaildPacketLength  = $FD; { Invaild packet length                  }
  neUnknownRequest2      = $FD; { Unknown request 2                      }
  neSPXMalformedPacket   = $FD; { SPX Malformed packet                   }
  neSPXPacketOverflow    = $FD; { SPX Packet overflow                    }
  neFieldAlreadyLocked   = $FD; { Field already locked                   }
  neTTSDisabled          = $FD; { TTS disabled                           }
  neDifferentNetworks    = $FD; { Different networks                     }
  nePacketOverflow       = $FD; { Packet overflow                        }

  neIOError              = $FE; { IO-error, lack of dynamic workspace    }
  neUserNotFound         = $FE; { User not found                         }
  neInsuffAccessPriv     = $FE; { Insufficient access privileges         }
  neNotPermittSearchDir  = $FE; { Not permitted to search in directory   }
  neBinderyLocked        = $FE; { Bindery locked                         }
  neDirectoryLocked      = $FE; { Directory locked                       }
  neInvalidSemNameLength = $FE; { Invalid semaphore name length          }
  nePacketNotDeliverable = $FE; { Packet not deliverable                 }
  neServerBinderyLocked  = $FE; { Server bindery locked                  }
  neSocketTableFull      = $FE; { Socket table full                      }
  neSpoolDirectoryError  = $FE; { Spool directory error                  }
  neSupervisorDisLogin   = $FE; { Supervisor disabled login              }
  neTimeoutError         = $FE; { Timeout error                          }
  neTTSEndRecordLock     = $FE; { Transaction ends record lock           }
  neImplicitTTSactive    = $FE; { Implicit transaction active            }

  neConnectionNotExist   = $FF; { connections does not exist             }
  neNoLockedRecordFound  = $FF; { No locked record found                 }
  neError                = $FF; { Error                                  }
  neFileOpen             = $FF; { Files open                             }
  neNoSuchPrinter        = $FF; { No such printer                        }
  neBadPrinterError      = $FF; { Bad printer error                      }
  neBadRecordOffset      = $FF; { Bad record offset                      }
  neCloseFCBError        = $FF; { Close FCB error                        }
  neFileExtensionError   = $FF; { File extension error                   }
  neFileNameError        = $FF; { File name error                        }
  neHardwareError        = $FF; { Hardware error                         }
  neInvalidDriveNumber   = $FF; { Invalid drive number                   }
  neInvalidInitalSemaph  = $FF; { Invalud initial semaphore value        }
  neInvalidSemaphHandle  = $FF; { Invalid semaphore handle               }
  neNoMoreErasedFiles    = $FF; { No more erased files                   }
  neIOBoundError         = $FF; { IO bound error                         }
  neNoFilesFoundError    = $FF; { No files found error                   }
  neNoResponseFromServer = $FF; { No response from server                }
  neNoSuchObjectOrBadPwd = $FF; { No such object or bad password         }
  nePathNotLocatable     = $FF; { Path not locatable                     }
  neQueueFullError       = $FF; { Queue full error                       }
  neReqNotOutstanding    = $FF; { Request not outstanding                }
  neSocketAlreadyOpen    = $FF; { Socket already open                    }
  neSocketNotOpen        = $FF; { Socket not open                        }
  neTTSNotYetWritten     = $FF; { Transaction not yet written to disk    }
  neNoMoreMatchingFiles  = $FF; { No more matching files                 }
  neBinderyError         = $FF; { Bindery error                          }
  neSPXIsInstalled       = $FF; { SPX is installed                       }
  neSPXSocketNotOpened   = $FF; { SPX Socket not opened                  }
  neExpTTSactive         = $FF; { Expilicit transaction active           }
  neNoExpTTSactive       = $FF; { No expilicit transaction active        }
  neNoRecordFound        = $FF; { No record found                        }
  neTransmitError        = $FF; { Transmit error                         }
  neECBNotInUse          = $FF; { ECB not in use                         }
  neCaptureIsActive      = $FF; { Capture is active                      }
  neInvalidDirHandle2    = $FF; { Invalid directory handle 2             }
  nePathAlreadyExists    = $FF; { Path alread exists                     }
  nePrintJobAlreadySet   = $FF; { Print job already set                  }
  neNoCaptureInEffect    = $FF; { No capture in effect                   }

  { (N)ame (s)pace types }
  nsNameSpaceDOS         = $00; { Name space DOS       }
  nsNameSpaceMac         = $01; { Name space Macintosh }
  nsNameSpaceNFS         = $02; { Name space NFS       }
  nsNameSpaceFTAM        = $03; { Name space FTAM      }
  nsNameSpaceHPFS        = $04; { Name space HPFS      }

{
              TYPE declarations
 }

type

  { type casting for LongInt }
  tHiLoWord     =
  record
    Hi,
    Lo          : Word;
  end;

  { DPMI-registers }
  tDPMIRegisters =
  record
    DI, SI, BP,
    Reserved,
    BX, DX, CX, AX  : LongInt;
    Flags,
    ES, DS, FS, GS,
    IP, CS, SP, SS  : Word;
  end;

  { DOS registers }
  tRegister =
  record
    case Integer of
      0 : (AX, BX, CX, DX, BP, SI, DI, DS, ES, Flags: Word);
      1 : (AL, AH, BL, BH, CL, CH, DL, DH: Byte);
  end;

{
        procedure and function headers
 }

{ Convert an string to upercase }
function StupCase(LowStr : String):String;
{$IFDEF PROTECTED} export; {$ENDIF}

{ Swap network node adress }
procedure SwapNodeAddress(var NodeAddress);
{$IFDEF PROTECTED} export; {$ENDIF}

{ Convert decimal to hex }
function Convert2Hex(Value : Byte):String;
{$IFDEF PROTECTED} export; {$ENDIF}

{ Swap long-integer bytes to make him big endian }
function SwapLongInt(SwapLong : LongInt):LongInt;
{$IFDEF PROTECTED} export; {$ENDIF}

{$IFDEF DPMI}
{ DPMI SERVICES Simulate Real-mode interrupt }
function SimulateRealIntr(Interrupt : Byte;
                          var Regs : tDPMIRegisters):boolean;
{$ENDIF}

{ Call MS-DOS interrupt }
function CallIntr(var Regs : tRegister):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ Call MS-DOS interrupt with request and reply buffer }
function ReqCallIntr(var Request;
                     var Reply;
                     ReqSize,
                     RplSize : Integer;
                     var NovRegsAX : Word):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ Call MS-DOS interrupt with reply buffer }
function ReplyBufferIntr(var ReplyBuffer;
                         RplSize : Integer;
                         var Regs : tRegister):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ Call MS-DOS interrupt with request buffer }
function RequestBufferIntr(var RequestBuffer;
                           ReqSize : Integer;
                           var Regs : tRegister):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ Call MS-DOS interrupt with path-reply }
function PathIntr(var Path;
                  PathSize : Integer;
                  var Regs : tRegister):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{$IFDEF DPMI}
{ convert an Real-mode segment to an Protected-mode descriptor }
procedure Segment2descriptor(var RealMSeg : Word); export;
{$ENDIF}

(* -------------------------- implementation -------------------------- *)

implementation

{
  function        : StupCase

  desc : Converts an string to upercase
 }

function StupCase(LowStr : String):String;

var
  i     : Byte;

begin
  { Make all chars upcase }
  for i := 1 to Length(LowStr) do
    LowStr[i] := UpCase(LowStr[i]);
  StupCase := LowStr;
end;

{
  procedure       : SwapNodeAddress

  desc : Swap's the node adress
 }

procedure SwapNodeAddress(var NodeAddress);

var
  Address      : array[1..6] of Byte absolute NodeAddress;
                 { Node-Adress to swap }
  TempArray    : array[1..6] of Byte; { Temp Array }

begin
  { Copy node-adress to temp }
  Move(Address[1], TempArray[1], SizeOf(Address));
  Address[1] := TempArray[6];   { Swap all bytes }
  Address[2] := TempArray[5];
  Address[3] := TempArray[4];
  Address[4] := TempArray[3];
  Address[5] := TempArray[2];
  Address[6] := TempArray[1];
end;

{
  function        : Convert2Hex

  desc : Converts an byte to hexadecimal string
 }

function Convert2Hex(Value : Byte):String;

const
  HexTable : array[0..15] of Char = ('0', '1', '2', '3',
                                     '4', '5', '6', '7',
                                     '8', '9', 'A', 'B',
                                     'C', 'D', 'E', 'F');
                                     { Table of Hex-Chars }
var
  HexStr : String;

begin
  HexStr[2] := HexTable[Value and $0F];        { Convert lower nibble  }
  HexStr[1] := HexTable[Value and $F0 div 16]; { Convert higher nibble }
  HexStr[0] := #2; { Set Stringlength }
  Convert2Hex := HexStr;
end;

{
  function        : SwapLongInt

  desc : Swap's an LongInt
 }

function SwapLongInt(SwapLong : LongInt):LongInt;

var
  Result       : LongInt;

begin
  tHiLoWord(Result).Lo := Swap(tHiLoWord(SwapLong).Hi);
  tHiLoWord(Result).Hi := Swap(tHiLoWord(SwapLong).Lo);
  SwapLongInt := Result;
end;

{$IFDEF DPMI}
{
  function        : SimulateRealIntr

  desc : Simulates an Real-Mode interrupt in
         DPMI-Mode
 }

function SimulateRealIntr(Interrupt : Byte;
                          var Regs : tDPMIRegisters):boolean;

var
  RealCall : Registers;

begin
  { Clear the Registers }
  FillChar(RealCall, SizeOf(RealCall), 0);
  with RealCall do
  begin
    AX := $0300;      { Interrupt                     }
    BX := Interrupt;  { Interrupt to call             }
    CX := 0;          { 0 Byte Stack to copy          }
    ES := Seg(Regs);  { ES:DI points to the registers }
    DI := Ofs(Regs);
  end;
  Intr($31, RealCall); { Call interrupt }
end;
{$ENDIF}

{
  function        : CallIntr

  desc : Interrupt Call for DOS Real and
         Protected Mode
 }

function CallIntr(var Regs : tRegister):boolean;

var
{$IFDEF DPMI}
  DPMIRegister  : tDPMIRegisters;  { DPMI-registers  }
{$ELSE}
  {$IFDEF WINDOWS}
  NovRegs       : tRegisters;     { Windows tRegisters }
  {$ELSE}
  NovRegs       : Registers;      { DOS-registers }
  {$ENDIF}
{$ENDIF}

begin
  {$IFDEF DPMI} { Protected-mode interrrupt call }
  CallIntr := false;
  FillChar(DPMIRegister, SizeOf(DPMIRegister), 0); { Clear the registers }
  with DPMIRegister do
  begin
    AX := Regs.AX;  { Copy registers }
    BX := Regs.BX;
    CX := Regs.CX;
    DX := Regs.DX;
  end;
  if SimulateRealIntr($21, DPMIRegister) then { Call Real-mode interrupt }
  begin
    CallIntr := true;
    with Regs do
    begin
      AX := DPMIRegister.AX; { Copy registers back }
      BX := DPMIRegister.BX;
      CX := DPMIRegister.CX;
      DX := DPMIRegister.DX;
      ES := DPMIRegister.ES;
      DS := DPMIRegister.DS;
      SI := LoWord(DPMIRegister.SI);
    end;
  end
  else
  begin
    FillChar(Regs, SizeOf(Regs), 0); { If error fill registers with zero }
  end;
  {$ELSE} { Real-mode/Windows call }
  Move(Regs, NovRegs, SizeOf(Regs));      { Copy registers down }
  Intr($21, NovRegs);
  Move(NovRegs, Regs, SizeOf(NovRegs));   { Copy registers back }
  {$ENDIF}
end;

{
  function        : ReqCallIntr

  desc : Interrupt call with request and reply
         for DOS Real and Proteced mode
 }

function ReqCallIntr(var Request;
                     var Reply;
                     ReqSize,
                     RplSize : Integer;
                     var NovRegsAX : Word):boolean;

var
{$IFDEF DPMI}
  RequestL,
  ReplyL        : LongInt;        { Real-Mode pointer for request and reply }
  DPMIRegister  : tDPMIRegisters; { DPMI-Registers                          }
{$ELSE}
  {$IFDEF WINDOWS}
  NovRegs       : tRegisters;     { Windows tRegisters  }
  {$ELSE}
  NovRegs       : Registers;      { DOS registers       }
  {$ENDIF}
{$ENDIF}

begin
  {$IFDEF DPMI} { Protected-mode interrupt call }
  ReqCallIntr := false;
  { allocate DOS-Mem and move request down }
  if (ReqSize <> 0) then
  begin
    RequestL := GlobalDOSAlloc(ReqSize);
    if RequestL = 0 then exit;
    Move(Request, Ptr(LoWord(RequestL), 0)^, ReqSize);
  end;
  { allocate DOS-Mem and move reply down }
  if (RplSize <> 0) then
  begin
    ReplyL   := GlobalDOSAlloc(RplSize);
    if ReplyL = 0 then exit;
    Move(Reply, Ptr(LoWord(ReplyL), 0)^, 2);
  end;
  FillChar(DPMIRegister, SizeOf(DPMIRegister), 0); { Clear the registers }
  with DPMIRegister do
  begin
    AX := NovRegsAX; { Copy registers AX }
    { Segment pointer, offset = 0 }
    if RequestL <> 0 then DS := HiWord(RequestL);
    if ReplyL   <> 0 then ES := HiWord(ReplyL);
    CX := ReqSize; { copy request-buffer size to CX }
    DX := RplSize; { copy reply-buffer size to DX   }
  end;
  if SimulateRealIntr($21, DPMIRegister) then
  begin
    ReqCallIntr := true;
    NovRegsAX   := DPMIRegister.AX; { Copy AX back }
    { Move Reply back }
    if RplSize <>  0 then  Move(Ptr(LoWord(ReplyL), 0)^, Reply, RplSize);
    { Free allocated DOS-mem }
    if (ReqSize <> 0) then RequestL := GlobalDOSFree(LoWord(RequestL));
    if (RplSize <> 0) then ReplyL := GlobalDOSFree(LoWord(ReplyL));
  end
  else
    FillChar(Reply, RplSize, 0); { If error fill reply with zero }
  {$ELSE} { Real Mode/Windows Interrupt Call }
  FillChar(NovRegs, SizeOf(NovRegs), 0); { Clear the registers }
  with NovRegs do
  begin
    AX := NovRegsAX;    { Copy AX                        }
    DS := Seg(Request); { DS:SI points to request        }
    SI := Ofs(Request);
    ES := Seg(Reply);   { ES:DI points to reply          }
    DI := Ofs(Reply);
    CX := ReqSize;      { copy request-buffer size to CX }
    DX := RplSize;      { copy reply-buffer size to DX   }
  end;
  Intr($21, NovRegs);      { Call interrrupt  }
  NovRegsAX := NovRegs.AX; { Copy AX back     }
  ReqCallIntr := true;
  {$ENDIF}
end;

{
  Function        : ReplyBufferIntr

  desc : Reply buffer interrupt call for DOS Real
         and Proteced mode
 }

function ReplyBufferIntr(var ReplyBuffer;
                         RplSize : Integer;
                         var Regs : tRegister):boolean;

var
{$IFDEF DPMI}
  ReplyL        : LongInt;        { Real-mode pointer to reply }
  DPMIRegister  : tDPMIRegisters; { DPMI-registers }
{$ELSE}
  {$IFDEF WINDOWS}
  NovRegs       : TRegisters;    { Windows tRegisters }
  {$ELSE}
  NovRegs       : Registers;     { DOS-registers }
  {$ENDIF}
{$ENDIF}

begin
  {$IFDEF DPMI}
  (* Protected-mode interrupt call *)
  ReplyBufferIntr := false;
  { allocate DOS mem and move request down }
  ReplyL   := GlobalDOSAlloc(RplSize);
  if ReplyL = 0 then exit;
  Move(ReplyBuffer, Ptr(LoWord(ReplyL), 0)^, RplSize);
  FillChar(DPMIRegister, SizeOf(DPMIRegister), 0);  { Clear the registers }
  with DPMIRegister do
  begin
    AX := Regs.AX;          { Copy registers down }
    BX := Regs.BX;
    CX := Regs.CX;
    DX := Regs.DX;
    ES := HiWord(ReplyL);   { ES Pointer on segment, offset = zero }
  end;
  if SimulateRealIntr($21, DPMIRegister) then
  begin
    ReplyBufferIntr := true;
    with Regs do
    begin
      AX := DPMIRegister.AX; { Move registers back }
      BX := DPMIRegister.BX;
      CX := DPMIRegister.CX;
      DX := DPMIRegister.DX;
    end;
  end;
  Move(Ptr(LoWord(ReplyL), 0)^, ReplyBuffer, RplSize); { Move reply back }
  ReplyL := GlobalDOSFree(LoWord(ReplyL));      { Free allocated DOS mem }
  {$ELSE}
  (* Real Mode/Windows interrupt call *)
  Move(Regs, NovRegs, SizeOf(Regs)); { Move registers down }
  with NovRegs do
  begin
    ES := Seg(ReplyBuffer);  { EX segement of reply }
    BX := Ofs(ReplyBuffer);  { BX offset of reply   }
  end;
  Intr($21, NovRegs);
  Move(NovRegs, Regs, SizeOf(NovRegs)); { Move registers back }
  {$ENDIF}
end;

{
  Function        : RequestBufferIntr

  desc : Request buffer interrupt call for
         DOS Real and Proteced mode
 }

function RequestBufferIntr(var RequestBuffer;
                           ReqSize : Integer;
                           var Regs : tRegister):boolean;

var
{$IFDEF DPMI}
  RequestL      : LongInt;         { Real-Mode pointer for request }
  DPMIRegister  : tDPMIRegisters;  { DPMI-Registers                }
{$ELSE}
  {$IFDEF WINDOWS}
  NovRegs       : tRegisters;     { Windows tRegisters  }
  {$ELSE}
  NovRegs       : Registers;      { DOS Registers       }
  {$ENDIF}
{$ENDIF}

begin
  {$IFDEF DPMI}
  (* Protected Mode Interrupt Call *)
  RequestBufferIntr := false;
  { allocate DOS-Mem and move request down }
  if (ReqSize <> 0) then
  begin
    RequestL := GlobalDOSAlloc(ReqSize);
    if RequestL = 0 then exit;
    Move(RequestBuffer, Ptr(LoWord(RequestL), 0)^, ReqSize);
  end;
  FillChar(DPMIRegister, SizeOf(DPMIRegister), 0); { Clear the registers }
  with DPMIRegister do
  begin
    { Copy registers }
    AX := Regs.AX;
    BP := Regs.BP;
    CX := ReqSize;
    { Segment pointer, offset = 0 }
    if RequestL <> 0 then DS := HiWord(RequestL);
  end;
  if SimulateRealIntr($21, DPMIRegister) then
  begin
    RequestBufferIntr := true;
    Regs.AX := DPMIRegister.AX; { Copy AX back }
    { Free allocated DOS-mem }
    if (ReqSize <> 0) then RequestL := GlobalDOSFree(LoWord(RequestL));
  end;
  {$ELSE} { Real Mode/Windows interrupt call }
  FillChar(NovRegs, SizeOf(NovRegs), 0); { Clear the registers }
  with NovRegs do
  begin
    { Copy registers }
    AX := Regs.AX;
    BP := Regs.BP;
    DS := Seg(RequestBuffer); { DS:SI points to request }
    SI := Ofs(RequestBuffer);
  end;
  Intr($21, NovRegs);    { Call interrrupt }
  Regs.AX := NovRegs.AX; { Copy AX back    }
  {$ENDIF}
end;

{
  function        : PathIntr

  desc : Path interrupt call for DOS Real and
         Proteced mode
 }

function PathIntr(var Path;PathSize : Integer;
                  var Regs : tRegister):boolean;

var
{$IFDEF DPMI}
  ReplyL        : LongInt;        { Real-Mode Pointer to reply }
  DPMIRegister  : tDPMIRegisters; { DPMI registers }
{$ELSE}
  {$IFDEF WINDOWS}
  NovRegs       : tRegisters;    { Windows tRegisters }
  {$ELSE}
  NovRegs       : Registers;     { DOS Registers }
  {$ENDIF}
{$ENDIF}

begin
  {$IFDEF DPMI}
  (* Protected interrupt call *)
  PathIntr := false;
  { allocate DOS-Mem and move reply down }
  ReplyL   := GlobalDOSAlloc(PathSize);
  if ReplyL = 0 then exit;
  Move(Path, Ptr(LoWord(ReplyL), 0)^, PathSize);
  FillChar(DPMIRegister, SizeOf(DPMIRegister), 0); { Clear the registers }
  with DPMIRegister do
  begin
    AX := Regs.AX;  { Copy registers down }
    BX := Regs.BX;
    CX := Regs.CX;
    DX := Regs.DX;
    DS := HiWord(ReplyL);   { DS Segment of reply, offset = 0 }
  end;
  if SimulateRealIntr($21, DPMIRegister) then
  begin
    PathIntr := true;
    with Regs do
    begin
      AX := DPMIRegister.AX;    { Move registers back }
      BX := DPMIRegister.BX;
      CX := DPMIRegister.CX;
      DX := DPMIRegister.DX;
    end;
  end;
  Move(Ptr(LoWord(ReplyL), 0)^, Path, PathSize); { Move reply back     }
  ReplyL := GlobalDOSFree(LoWord(ReplyL));    { free allocated DOS-mem }
  {$ELSE}
  (* Real Mode/Windows Interrupt Call *)
  Move(Regs, NovRegs, SizeOf(Regs)); { Move registers down }
  with NovRegs do
  begin
    DS := Seg(Path);  { DS segment of path }
    DX := Ofs(Path);  { DX offset of path  }
  end;
  Intr($21, NovRegs);
  Move(NovRegs, Regs, SizeOf(NovRegs));   { Move rgister back }
  {$ENDIF}
end;

{
  procedure       : Segment2descriptor

  desc : Converts Real mode segment to
         DPMI descriptor
 }

{$IFDEF DPMI}
procedure Segment2descriptor(var RealMSeg : Word);

var
  Regs : Registers; { registers }

begin
  FillChar(Regs, SizeOf(Regs), 0); { Clear the registers }
  with Regs do
  begin
    AX := $0002;                 { Subfunction 02, convert real mode segment
                                   to descriptor                            }
    BX := RealMSeg;              { BX = Real mode segment                   }
  end;
  Intr($31, Regs);
  RealMSeg := Regs.AX;           { Copy converted segment back             }
end;
{$ENDIF}

{------------------------ end of unit ------------------------}

end.
