 {ͻ
   unit : Novell Message                        Target Platforms :       
   desc : Novell message functions                - DOS Real             
                                                  - DOS Protected        
                                                  - Windows              
   (C) 1994 by Christoph Weller 16/01/93 v1.1                            
  ͼ}

(*

  18.1.1995  : Inserted all possible error-results of a procedure/function
               into the description-header.

*)

unit NVMsg;

interface

{$I NVDEFINE.INC}

uses
  NvMain;   { Novell main unit                          }

{
              CONST declarations
 }

const

  { per-(c)onnection (r)esults send broadcast }
  crMessageRejected       = $FC; { Message rejected due to lack of
                                   buffer                          }
  crInvalidConnNumber     = $FD; { Invalid connection number       }
  crMessageBlocked        = $FF; { Message blocked                 }

  { (B)roadcast (m)odes }
  bmRecSvWsBroadcast      = $00; { Receive server and workstation
                                   broadcasts                       }
  bmRecSvDisWsBroadcast   = $01; { Receive server, discard
                                   user messages                    }
  bmStoreServerBroadcast  = $02; { Store server broadcast for
                                   later retrival                   }
  bmStoreAllBroadcast     = $03; { Store all broadcasts for
                                   later retrival                   }

{
              TYPE declarations
 }

type

  { Connection list }
  tConnList       = String[100];

  { Network message }
  tNetworkMessage = String[55];

{
        procedure and function headers
 }

{ MESSAGE SERVICES Get broadcast mode }
function GetBroadCastMode:Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ MESSAGE SERVICES Set broadcast mode }
function SetBroadCastMode(BMode : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ MESSAGE SERVICES Send broadcast message }
function SendBroadcast(var UserList : tConnList;
                       Message : tNetworkMessage):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ MESSAGE SERVICES Get broadcast message }
function GetBroadcast(var Message : tNetworkMessage):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ MESSAGE SERVICES Console broadcast message }
function ConsoleBroadcast(Message : tNetworkMessage):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

(* -------------------------- implemenation -------------------------- *)

implementation

{
  function        : GetBroadcastMode
  Service type    : message services
  Netware Version : NW v2.0 - v4.x

  Desc : Gets the broadcast-mode of the station
 }

function GetBroadcastMode:Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $DE;
    DL := 04;
  end;
  CallIntr(NovRegs);
  GetBroadCastMode := NovRegs.AL;
end;

{
  function        : SetBroadcastMode
  Service type    : message services
  Netware Version : NW v2.0 - v4.x

  Desc : Set's the broadcast-mode for the
         station
 }

function SetBroadcastMode(BMode : Byte):Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $DE;
    DL := BMode;
  end;
  CallIntr(NovRegs);
  SetBroadCastMode := NovRegs.AL;
end;

{
  function        : SendBroadcastMessage
  Service type    : message services
  Netware Version : NW v2.0 - v4.x

  Desc : Send an broadcast-message to the
         choosen stations

  Errors : - neSuccessfull
           - neIOError
 }

function SendBroadcast(var UserList : tConnList;
                       Message : tNetworkMessage):boolean;

var
  NovRegs       : Word;
  Marker        : Word;

  Request       :
  record
    FLen        : Word;                  { Length of request    }
    SubF        : Byte;                  { Subfunction          }
    NMessage    : array[1..156] of Byte; { Connection list and
                                           network message      }
  end;

  Reply         :
  record
    Size        : Word;        { Size of reply                  }
    Result      : String[100]; { List of per connection results }
  end;

begin
  Reply.Size := SizeOf(Reply) -2;
  with Request do
  begin
    SubF := $00;
    for Marker := 1 to Length(Message) do
    begin
      if (Ord(Message[Marker]) > 126) or (Ord(Message[Marker]) < 32) then
        Message[Marker] := ' ';
    end;
    Marker := 1;

    Move(UserList, Ptr(Seg(NMessage[Marker]), Ofs(NMessage[Marker]))^,
           Length(UserList) + 1);
    Inc(Marker, Length(UserList) + 1);

    Move(Message, Ptr(Seg(NMessage[Marker]), Ofs(NMessage[Marker]))^,
           Length(Message) + 1);
    Inc(Marker, Length(Message));

    FLen := 1 + Marker;
  end;
  NovRegs := $E100;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  SendBroadcast := (Lo(NovRegs) = neSuccessfull);
  UserList      := Reply.Result;
end;

{
  function        : GetBroadcastMessage
  Service type    : message services
  Netware Version : NW v2.0 - v4.0x

  Desc : Gets a broadcast-message

  Errors : - neSuccessfull
           - neMessageQueueFull
           - neIOError
 }

function GetBroadcast(var Message : tNetworkMessage):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    FLen        : Word; { Length of request    }
    SubF        : Byte; { Subfunction          }
  end;

  Reply         :
  record
    Size        : Word;            { Size of reply   }
    NMessage    : tNetworkMessage; { Network message }
  end;

begin
  Reply.Size := SizeOf(Reply) -2;
  with Request do
  begin
    FLen := SizeOf(Request) -2;
    SubF := $01;
  end;
  NovRegs := $E100;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetBroadcast := Lo(NovRegs);
  Message      := Reply.NMessage;
end;

{
  function        : SendConsoleBroadcast
  Service type    : message services
  Netware Version : NW v2.0 - v4.0x

  Desc : Sends an broadcast to the server console

  Errors : - neSuccessfull
           - neMessageQueueFull
           - neIOError
 }

function ConsoleBroadcast(Message : tNetworkMessage):Byte;

var
  NovRegs       : Word;
  Reply         : Word;
  i             : Byte;

  Request       :
  record
    FLen        : Word;        { Length of request }
    SubF        : Byte;        { Subfunction       }
    NMessage    : String[57];  { Network message   }
  end;

begin
  Reply := SizeOf(Reply) -2;
  with Request do
  begin
    FLen := 2 + Length(Message);
    SubF := $09;
    for i := 1 to Length(Message) do
    begin
      if (Ord(Message[i]) > 126) or (Ord(Message[i]) < 32) then
        Message[i] := ' ';
    end;
    Move(Message, NMessage, Length(Message) + 2);
  end;
  NovRegs := $E100;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  ConsoleBroadcast := Lo(NovRegs);
end;

{------------------------ end of unit ------------------------}

end.
