 {ͻ
   unit : Novell printer                        Target Platforms         
   desc : Novell printer functions                - DOS Real             
                                                  - DOS Protected        
                                                  - Windows              
   (C) 1994 by Christoph Weller 16/01/93 v1.1                            
  ͼ}

(*

  18.1.1995  : Inserted all possible error-results of a procedure/function
               into the description-header.

*)

unit NVPrint;

interface

{$I NVDEFINE.INC}

uses
  Strings,  { Borland strings unit                      }
  NvMain;   { Novell main unit                          }

{
              CONST declarations
 }

const

  { (P)rint (F)lags }
  pfPrintCaptureByLostConn      = $02; { Print capture due loss of connection }
  pfNoAutomaticFormFeed         = $04; { No automatic form feed               }
  pfSupressFormFeed             = $08; { Supress form feed                    }
  pfNotifyWhenDone              = $10; { Notify user when done                }
  pfPrintControlSequenzes       = $40; { Print control sequenzes              }
  pfTextEntry                   = $40; { Queue-entry is text-entry not stream }
  pfPrintBanner                 = $80; { Print banner                         }

{
              TYPE declarations
 }

type

  { netware handle }
  tNetWareHandle    = array[1..3] of Word;

  { printer banner name }
  tBannerUserName   = String[12];

  { printer status record }
  tPrinterStatus   =
  record
    PtrActiv       : boolean; { True if printer activ     }
    PtrOnline      : boolean; { true if printer online    }
    PtrForm        : Byte;    { Current printer form      }
    PtrTarget      : Byte;    { Target printer-no.        }
  end;

  { capture flag table }
  tCaptureFlagTable =
  record
    Status      : Byte;   { internally should be set to zero             }
    PrintFlag   : Byte;   { bit 2: print capture file if interrupted by
                                   loss of connection
    	                        3: no automatic form feed after print job
		                6: printing control sequences interpreted
                                   by print service
		                7: print banner page before capture file }
    TabSize     : Byte;   { Tab size default 08h                         }
    PrinterNo   : Byte;   { Printer number on server                     }
    Copies      : Byte;   { Number of copies to print                    }
    FormType    : Byte;   { Form Type required in printer                }
    Reserved    : Byte;   { Reserved                                     }
    BannerText  : array[1..13] of Char; { Banner text                    }
    Reserverd2  : Byte;   { Reserved                                     }
    DefLocalPrt : Byte;   { Default local printer                        }
    TimeOut     : Word;   { Timeout in clock ticks for flushing
                            capture file on inactivity
                            0000h = never timeout                        }
    FlushCapt   : Byte;   { Flush capture file on LPT close if Non-Zero  }
    MaxLines    : Word;   { Max. lines per page                          }
    MaxChars    : Word;   { Max chars per line                           }
    PrtForm     : array[1..13] of Char; { Required form in printer       }
    CaptFlag    : Byte;   { LPT Capture flag 00 inactive                 }
    FileCapFlag : Byte;   { File capture flag 00 if no file specified    }
    TimingOut   : Byte;   { Timing out                                   }
    PrtSetup    : LongInt;{ Adress of printer setup string               }
    PrtReset    : LongInt;{ Adress of printer reset string               }
    TargetConnId: Byte;   { Target connection id                         }
    CapInProg   : Byte;   { Capture in progress if FFh                   }
    JobQueued   : Byte;   { Job queued for printing if FFh               }
    PrintJob    : Byte;   { Print job valid if FFh                       }
    BinderyId   : LongInt;{ Bindery object id                            }
    PrintJobNo  : Word;   { Print Job number                             }
  end;

{
        procedure and function headers
 }

{ CAPTURE FLAG Get default capture flags }
Procedure GetDefaultCaptureFlags(var CaptureFlags : tCaptureFlagTable);
{$IFDEF PROTECTED} export; {$ENDIF}

{ CAPTURE FLAG Set default capture flags }
function SetDefaultCaptureFlags(CaptureFlags : tCaptureFlagTable):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ CAPTURE FLAG Get specific default capture flags }
Procedure GetSpecificCaptureFlags(var CaptureFlags : tCaptureFlagTable;
                                  LPTPort : Byte);
{$IFDEF PROTECTED} export; {$ENDIF}

{ CAPTURE FLAG Set specific capture flags }
function SetSpecificCaptureFlags(CaptureFlags : tCaptureFlagTable;
                                 LPTPort : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LOCAL PRINTER Get default local printer }
function GetDefaultLocalPrinter:Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LOCAL PRINTER Set default local printer
  Crash if Function is called maybe printer server must be present }
function SetDefaultLocalPrinter(LPTPort : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LOCAL PRINTER Get banner user name }
function GetBannerUser(var UserName : tBannerUserName):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LOCAL PRINTER Get banner user name }
function SetBannerUser(UserName : tBannerUserName):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LOCAL PRINTER Get printer status }
function GetPtrStatus(var Status : tPrinterStatus;
                      Printer : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LPT CAPTURE Specify capture file }
function SpecifyCaptureFile(DirHandle : Byte;
                            FileName : String):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LPT CAPTURE Get LPT capture status, true if activ }
function GetLPTCaptureStatus(var ServerConn : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LPT CAPTURE Start LPT capture }
function StartLPTCapture:boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LPT CAPTURE End LPT capture }
function EndLPTCapture:boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LPT CAPTURE Cancel LPT capture }
function CancelLPTCapture:boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LPT CAPTURE Flush Lpt capture }
function FlushLPTCapture:boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LPT CAPTURE Start Specific LPT capture PrinterPort = 00h - 02h }
function StartSpecificLPTCapture(PrinterPort : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LPT CAPTURE End Specific LPT capture PrinterPort = 00h - 02h }
function EndSpecificLPTCapture(PrinterPort : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LPT CAPTURE Cancel Specific LPT capture PrinterPort = 00h - 02h }
function CancelSpecificLPTCapture(PrinterPort : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LPT CAPTURE Flush Specific LPT capture PrinterPort = 00h - 02h }
function FlushSpecificLPTCapture(PrinterPort : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LPT CAPTURE  Set printer capture queue not tested yet !!! ++}
function SetPtrCaptureQueue(PrinterPort : Byte;
                            ObjId : LongInt):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LPT CAPTURE  Set capture print job not tested yet !!! ++}
function SetCapturePrintJob(PrinterPort : Byte;
                            Handle : tNetWareHandle):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

(* -------------------------- implemenation -------------------------- *)

implementation

{
  procedure       : GetDefaultCaptureFlags
  service type    : Capture Flags
  Netware version : NW v2.0 - v4.x

  Desc : Gets the capture-flags for the
         current default LPT-port

  Errors : - neSuccessfull
 }

procedure GetDefaultCaptureFlags(var CaptureFlags : tCaptureFlagTable);

var
  NovRegs : tRegister;

begin
  FilLChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $B800;
    CX := SizeOf(CaptureFlags);
  end;
  if (not ReplyBufferIntr(CaptureFlags, SizeOf(CaptureFlags), NovRegs)) and
     (NovRegs.AL <> $00)                                                then
    FillChar(CaptureFlags, SizeOf(CaptureFlags), 0);
  with CaptureFlags do
  begin
    MaxLines := Swap(MaxLines);
    MaxChars := Swap(MaxChars);
    PrtSetup := SwapLongInt(PrtSetup);
    PrtReset := SwapLongInt(PrtReSet);
    {$IFDEF DPMI}
    Segment2Descriptor(HiLoWord(PrtSetup).Hi);
    Segment2Descriptor(HiLoWord(PrtReset).Hi);
    {$ENDIF}
    PrintJobNo := Swap(PrintJobNo);
  end;
end;

{
  procedure       : SetDefaultCaptureFlags
  service type    : Capture Flags
  Netware version : NW v2.0 - v4.x

  Desc : Sets the capture-flags for the current
         default LPT-port

  Errors : - neSuccessfull
 }

function SetDefaultCaptureFlags(CaptureFlags : tCaptureFlagTable):boolean;

var
  NovRegs : tRegister;

begin
  FilLChar(NovRegs, SizeOf(NovRegs), 0);
  CaptureFlags.MaxLines := Swap(CaptureFlags.MaxLines);
  CaptureFlags.MaxChars := Swap(CaptureFlags.MaxChars);
  with NovRegs do
  begin
    AX := $B801;
    CX := SizeOf(CaptureFlags);
  end;
  if (not ReplyBufferIntr(CaptureFlags, SizeOf(CaptureFlags), NovRegs)) and
     (NovRegs.AL <> 0)                                                  then
    SetDefaultCaptureFlags := false
  else
    SetDefaultCaptureFlags := (NovRegs.AL = neSuccessfull);
end;

{
  procedure       : GetSpecificCaptureFlags
  service type    : Capture Flags
  Netware version : NW v2.0 - v4.x

  Desc : Gets the capture-flags of the
         specific LPT-port

  Errors : - neSuccessfull
 }

procedure GetSpecificCaptureFlags(var CaptureFlags : tCaptureFlagTable;
                                  LPTPort : Byte);

var
  NovRegs : tRegister;

begin
  FilLChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $B800;
    CX := SizeOf(CaptureFlags);
    DH := LPTPort;
  end;
  if (not ReplyBufferIntr(CaptureFlags, SizeOf(CaptureFlags), NovRegs)) and
     (NovRegs.AL <> 0)                                                  then
    FillChar(CaptureFlags, SizeOf(CaptureFlags), 0);
  with CaptureFlags do
  begin
    MaxLines   := Swap(MaxLines);
    MaxChars   := Swap(MaxChars);
    PrtSetup   := SwapLongInt(PrtSetup);
    PrtReSet   := SwapLongInt(PrtReSet);
    BinderyId  := SwapLongInt(BinderyId);
    PrintJobNo := Swap(PrintJobNo);
  end;
end;

{
  procedure       : SetSpecificCaptureFlags
  service type    : Capture Flags
  Netware version : NW v2.0 - v4.x

  Desc : Sets the capture-flags of a specific
         LPT-port

  Errors : - neSuccessfull
 }

function SetSpecificCaptureFlags(CaptureFlags : tCaptureFlagTable;
                                 LPTPort : Byte):boolean;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  CaptureFlags.MaxLines := Swap(CaptureFlags.MaxLines);
  CaptureFlags.MaxChars := Swap(CaptureFlags.MaxChars);
  with NovRegs do
  begin
    AX := $B801;
    CX := SizeOf(CaptureFlags);
    DH := LPTPort;
  end;
  ReplyBufferIntr(CaptureFlags, SizeOf(CaptureFlags), NovRegs);
  SetSpecificCaptureFlags := (NovRegs.AL = neSuccessfull);
end;

{
  procedure       : GetDefaultLocalPrinter
  service type    : local printer
  Netware version : NW v2.0 - v4.x

  Desc : Gets the current default local LPT-port
 }

function GetDefaultLocalPrinter:Byte;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $B804;
  CallIntr(NovRegs);
  GetDefaultLocalPrinter := NovRegs.DH;
end;

{
  procedure       : SetDefaultLocalPrinter
  service type    : local printer
  Netware version : NW v2.0 - v4.x

  Desc : Sets the default LPT-port

  Errors : - neSuccessfull
 }

function SetDefaultLocalPrinter(LPTPort : Byte):boolean;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $B805;
    DH := LPTPort;
  end;
  if (CallIntr(NovRegs)) and (NovRegs.AL = neSuccessfull) then
    SetDefaultLocalPrinter := true
  else
    SetDefaultLocalPrinter := false;
end;

{
  function        : GetBannerUser
  service type    : local printer
  Netware version : NW v2.0 - v4.x

  Desc : Returns the user-name which will be
         printed on the banner

  Errors : - neSuccessfull
 }

function GetBannerUser(var UserName : tBannerUserName):boolean;

var
  NovRegs    : tRegister;
  BannerName : array[1..12] of Char;
  i          : Byte;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $B808;
  if (ReplyBufferIntr(BannerName, SizeOf(BannerName), NovRegs)) and
     (NovRegs.AL = neSuccessfull)                               then
  begin
    GetBannerUser := true;
    UserName := StrPas(@BannerName);
  end
  else
  begin
    GetBannerUser := false;
  end;
end;

{
  function        : SetBannerUser
  service type    : local printer
  Netware version : NW v2.0 - v4.x

  Desc : Sets the banner user-name

  Errors : - neSuccessfull
 }

function SetBannerUser(UserName : tBannerUserName):boolean;

var
  NovRegs    : tRegister;
  BannerName : array[1..12] of Char;
  i          : Byte;

begin
  FillChar(BannerName, SizeOf(BannerName), 0);
  StrPCopy(@BannerName, UserName);
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $B809;
  if (ReplyBufferIntr(BannerName, SizeOf(BannerName), NovRegs)) and
     (NovRegs.AL = neSuccessfull)                               then
    SetBannerUser := true
  else
    SetBannerUser := false;
end;

{
  function        : GetPtrStatus
  service type    : local printer
  Netware version : NW v2.0 - v4.x

  Desc : Returns the status of one from the
         file server printers

  Errors : - neSuccessfull
           - neNoSuchPrinter
 }

function GetPtrStatus(var Status : tPrinterStatus;
                      Printer : Byte):boolean;

var
  NovRegs       : Word;

  Request       :
  record
    FLen        : Word;
    SubF        : Byte;
    Ptr         : Byte;
  end;

  Reply         :
  record
    Size        : Word;
    PtrAct      : Byte;
    PtrOnl      : Byte;
    PtrFr       : Byte;
    PtrTar      : Byte;
  end;

begin
  GetPtrStatus := false;
  if Printer > 4 then exit;
  Reply.Size := SizeOf(Reply) -2;
  with Request do
  begin
    FLen := SizeOf(Request) -2;
    SubF := $06;
    Ptr  := Printer;
  end;
  NovRegs := $E000;
  if ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs) and
     (Lo(NovRegs) = neSuccessfull)                                        then
  begin
    GetPtrStatus := true;
    with Status, Reply do
    begin
      PtrActiv    := (PtrAct = $00);
      PtrOnline   := (PtrOnl = $00);
      PtrForm     := PtrFr;
      PtrTarget   := PtrTar;
    end;
  end
  else
    FillChar(Status, SizeOf(Status), 0);
end;

{
  function        : SpecifyCaptureFile
  service type    : LPT capture
  Netware version : NW v2.0 - v4.x

  Desc : Specifies an capture-file for
         printing

  Errors : - neSuccessfull
           - neInvalidPath
 }

function SpecifyCaptureFile(DirHandle : Byte;
                            FileName : String):boolean;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    FLen        : Word;
    SubF        : Byte;
    Handle      : Byte;
    FName       : String;
  end;

begin
  Reply := SizeOf(Reply) -2;
  with Request do
  begin
    FLen    := SizeOf(Request) -2;
    SubF    := $09;
    Handle  := DirHandle;
    FName   := StupCase(FileName);
  end;
  NovRegs := $E000;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  SpecifyCaptureFile := (Lo(NovRegs) = neSuccessfull);
end;

{
  procedure       : GetLPTCaptureStatus
  service type    : LPT capture
  Netware version : NW v2.0 - v4.x

  Desc : Returns true if the capture on the
         default LPT-port is active

  Errors : - neSuccessfull
           - neCaptureIsActive
 }

function GetLPTCaptureStatus(Var ServerConn : Byte):boolean;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $F003;
  CallIntr(NovRegs);
  GetLPTCaptureStatus := (NovRegs.AH = $FF);
  ServerConn          := NovRegs.AL;
end;

{
  function        : StartLPTCapture
  service type    : LPT capture
  Netware version : NW v2.0 - v4.x

  Desc : Starts LPT-capture on the preseted
         LPT-port

  Errors : - neSuccessfull
 }

function StartLPTCapture:boolean;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $DF;
  NovRegs.Dl := $00;
  CallIntr(NovRegs);
  StartLPTCapture := (NovRegs.AL = neSuccessfull);
end;

{
  function        : EndLPTCapture
  service type    : LPT capture
  Netware version : NW v2.0 - v4.x

  Desc : Ends the current capture

  Errors : - neSuccessfull
 }

function EndLPTCapture:boolean;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $DF;
  NovRegs.DL := $01;
  CallIntr(NovRegs);
  EndLPTCapture := (NovRegs.AL = neSuccessfull)
end;

{
  function        : CancelLPTCapture
  service type    : LPT capture
  Netware version : NW v2.0 - v4.x

  Desc : Cancels the current capture

  Errors : - neSuccessfull
 }

function CancelLPTCapture:boolean;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $DF;
  NovRegs.DL := $02;
  CallIntr(NovRegs);
  CancelLPTCapture := (NovRegs.AL = neSuccessfull);
end;

{
  function        : FlushLPTCapture
  service type    : LPT capture
  Netware version : NW v2.0 - v4.x

  Desc : Closes the current capture-file and
         opens a new one. The old one can
         be printed

  Errors : - neSuccessfull
 }

function FlushLPTCapture:boolean;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $DF;
  NovRegs.DL := $03;
  CallIntr(NovRegs);
  FlushLPTCapture := (NovRegs.AL = neSuccessfull);
end;

{
  function        : StartSpecificLPTCapture
  service type    : LPT capture
  Netware version : NW v2.0 - v4.x

  Desc : Starts an capture on a specific
         LPT-port

  Errors : - neSuccessfull
 }

function StartSpecificLPTCapture(PrinterPort : Byte):boolean;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $DF;
    DL := $04;
    DH := PrinterPort;
  end;
  CallIntr(NovRegs);
  StartSpecificLPTCapture := (NovRegs.AL = neSuccessfull);
end;

{
  function        : EndSpecificLPTCapture
  service type    : LPT capture
  Netware version : NW v2.0 - v4.x

  Desc : Ends the capture on a specific
         LPT-port

  Errors : - neSuccessfull
 }

function EndSpecificLPTCapture(PrinterPort : Byte):boolean;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $DF;
    DL := $05;
    DH := PrinterPort;
  end;
  CallIntr(NovRegs);
  EndSpecificLPTCapture := (NovRegs.AL = neSuccessfull);
end;

{
  function        : CancelSpecificLPTCapture
  service type    : LPT capture
  Netware version : NW v2.0 - v4.x

  Desc : Cancels the capture on a specific
         LPT-port

  Errors : - neSuccessfull
 }

function CancelSpecificLPTCapture(PrinterPort : Byte):boolean;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $DF;
    DL := $06;
    DH := PrinterPort;
  end;
  CallIntr(NovRegs);
  CancelSpecificLPTCapture := (NovRegs.AL = neSuccessfull);
end;

{
  function        : FlushSpecificLPTCapture
  service type    : LPT capture
  Netware version : NW v2.0 - v4.x

  Desc : Closes the current capture-file and
         opens a new. The old one can be
         printed

  Errors : - neSuccessfull
 }

function FlushSpecificLPTCapture(PrinterPort : Byte):boolean;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $DF;
    DL := $07;
    DH := PrinterPort;
  end;
  CallIntr(NovRegs);
  FlushSpecificLPTCapture := (NovRegs.AL = neSuccessfull)
end;

{
  function        : SetPrinterCaptureQueue
  service type    : LPT capture
  Netware version : NW v2.0 - v4.x

  Desc : Sets the printer-queue for the capture

  Errors : - neSuccessfull
           - nePrintJobAlreadySet
 }

function SetPtrCaptureQueue(PrinterPort : Byte;
                            ObjId : LongInt):boolean;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX    := $B806;
    DH    := PrinterPort;
    ObjId := SwapLongInt(ObjId);
    BX    := tHiLoWord(ObjId).Hi;
    CX    := tHiLoWord(ObjId).Lo;
  end;
  CallIntr(NovRegs);
  SetPtrCaptureQueue := (NovRegs.AL = neSuccessfull);
end;

{
  function        : SetCapturePrintJob
  service type    : LPT capture
  Netware version : NW v2.0 - v4.x

  Desc : Sets the capture print-job

  Errors : - neSuccessfull
           - nePrintJobAlreadySet
 }

function SetCapturePrintJob(PrinterPort : Byte;
                            Handle : tNetWareHandle):boolean;

var
  NovRegs : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $B807;
    DH := PrinterPort;
    SI := Handle[1];
    DI := Handle[2];
    CX := Handle[3];
  end;
  CallIntr(NovRegs);
  SetCapturePrintJob := (NovRegs.AL = neSuccessfull);
end;

{------------------------ end of unit ------------------------}

end.
