 {ͻ
   unit : Novell Server                         Target Platforms :       
   desc : Novell server functions                 - DOS Real             
                                                  - DOS Protected        
                                                  - Windows              
   (C) 1994 by Christoph Weller 16/01/93 v1.1                            
  ͼ}

(*

  18.1.1995  : Inserted all possible error-results of a procedure/function
               into the description-header.

*)

unit NVServer;

interface

{$I NVDEFINE.INC}

uses
  Strings,  { Borland strings unit                      }
  NvMain;   { Novell main unit                          }

{
              TYPE declarations
 }

type

  { network-server table }
  tServerTable = array[1..8] of String[48];

  { server description }
  tServerDescription =
  record
    Company,                               { Company name                  }
    Version          : String;             { Netware Version string        }
    RevisionDate     : String[9];          { Revision date                 }
    Copyright        : String;             { copyright notice              }
  end;

  { server info }
  tServerInfo            =
  record
    ServerName           : String[48];  { server name                   }
    NetWareVersion       : Byte;        { Netware version               }
    NetWareSubVersion	 : Byte;        { Netware sub version           }
    MaxConn              : Word;        { max. connections supported    }
    ConnInUse            : Word;        { connections in use            }
    MaxVols              : Word;        { max. supported volumes        }
    Revision             : Byte;        { revision                      }
    SFTLevel             : Byte;        { SFT level                     }
    TTSLevel             : Byte;        { TTS level                     }
    PeakConn             : Word;        { servers peak connections      }
    AccountVer           : Byte;        { account version               }
    VAPVersion           : Byte;        { VAP version                   }
    QueueVer             : Byte;        { Queue version                 }
    PrintServerVer       : Byte;        { Print server version          }
    VirtualVer           : Byte;        { Virtual version               }
    SecLevel             : Byte;        { Security level                }
    BrigdeVersion        : Byte;        { Bridge version                }
    Reserverd            : array[1..60] of Byte; { reserved             }
  end;

  { name space list }
  tNameSpaceLoaded       =
  record
    NumberOfNameSpaces   : Word;        { Number of names spaces loaded }
    NameSpaceList        : array[1..512] of Byte;
                           { Name space list, see NvMain for
                             name space codes                           }
  end;

{
        procedure and function headers
 }

{ INFO-SERVICES Get file server table }
procedure GetFileServerTable(var Servers : tServerTable);
{$IFDEF PROTECTED} export; {$ENDIF}

{ INFO-SERVICES get file server info }
procedure GetServerInfo(var ServerInformation : tServerInfo);
{$IFDEF PROTECTED} export; {$ENDIF}

{ INFO-SERVICES get file server description string }
procedure GetServerDescription(var ServerDesc : tServerDescription);
{$IFDEF PROTECTED} export; {$ENDIF}

{ INFO-SERVICES get name spaces loaded }
function GetNameSpacesLoaded(VolumeNo : Byte;
                             var NameSpaceLoaded : tNameSpaceLoaded):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ INFO-SERVICES get file server serial number }
function GetFileServerSerialNo(var NWSerial : LongInt;var ApplicationNo : Word):boolean;

{ INFO-SERVICES verify file server serial number }
function VerifyFileServerSerialNo(NWSerial : LongInt):Word;

{ LOGIN SERVICES disable server login }
function DisableServerLogin:boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LOGIN SERVICES enable server login }
function EnableServerLogin:boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ LOGIN SERVICES get server login status }
function GetLoginStatus(var Status : boolean):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DATE/TIME SERVICES set file server date and time }
function SetFileServerDateTime(Year,
                               Month,
                               Day,
                               Hour,
                               Minute,
                               Second : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ DATE/TIME SERVICES get file server date and time }
function GetFileServerDateTime(var Year,
                               Month,
                               Day,
                               Hour,
                               Minute,
                               Second,
                               DayOfWeek : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRANSACTION TRACKING SYSTEM enable TTS }
function EnableTTS:boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRANSACTION TRACKING SYSTEM disable TTS }
function DisableTTS:boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRANSACTION TRACKING SYSTEM get TTS-status }
function TTSStatus:Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SERVER SERVICES clear connection }
function ClearConnection(ConnectionNo : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SERVER SERVICES down the server }
function DownServer(ForceIt : boolean):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

(* -------------------------- implemenation -------------------------- *)

implementation

{
  procedure       : GetFileServerTable
  service type    : info services
  Netware version : NW v2.0 - v4.x

  Desc : Returns the file-server name-table
 }

procedure GetFileServerTable(var Servers : tServerTable);

type

  TablePtr = array[1..8] of array[1..48] of Char;

var
  NovRegs      : tRegister;
  i            : Byte;
  Table        : ^TablePtr;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $EF04;
  CallIntr(NovRegs);
  {$IFDEF DPMI}
  Segment2Descriptor(NovRegs.ES);
  {$ENDIF}
  Table := Ptr(NovRegs.ES, NovRegs.SI);
  for i := 1 to 8 do
  begin
    Servers[i]    := Table^[i];
    Servers[i][0] := Chr(Pos(#0, Servers[i])-1);
  end;
end;

{
  procedure       : GetServerInfo
  service type    : info services
  Netware version : NW v2.1x - v4.x

  Desc : Get's various information about
         the default Server
 }

procedure GetServerInfo(var ServerInformation : tServerInfo);

var
  NovRegs : Word;

  Request :
  record
    Size : Word;
    SubF : Byte;
  end;

  Reply         :
  record
    Size        : Word;
    Server      : array[1..48] of Char;
    Buffer      : array[1..80] of Byte;
  end;

begin
  with Request do
  begin
    Size := SizeOf(Request) - 2;
    SubF := $11;
  end;
  Reply.Size := SizeOf(Reply) - 2;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  with ServerInformation, Reply do
  begin
    ServerName         := StrPas(@Server);
    Move(Buffer, NetwareVersion, SizeOf(Buffer));
    MaxConn            := Swap(MaxConn);
    MaxVols            := Swap(MaxVols);
    PeakConn           := Swap(PeakConn);
    ConnInUse          := Swap(ConnInUse);
  end;
end;

{
  procedure       : GetServerDescription
  service type    : info services
  Netware version : NW v2.1x - v4.x

  Desc : Get's server description from
         default server
 }

procedure GetServerDescription(var ServerDesc : tServerDescription);

var
  NovRegs : Word;
  Marker  : Word;

  Request :
  record
    Size : Word;
    SuBF : Byte;
  end;

  Reply  :
  record
    Size : Word;
    ZStr : array[1..512] of Char;
  end;

begin
  Reply.Size := SizeOf(Reply) - 2;
  with Request do
  begin
    Size := SizeOf(Request) - 2;
    SubF := $C9;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  if (Lo(NovRegs) <> neSuccessfull) then
  begin
    FillChar(ServerDesc, SizeOf(ServerDesc), ' ');
    exit;
  end
  else
  begin
    with ServerDesc, Reply do
    begin
      Marker := 1;

      Company := StrPas(@ZStr);
      Inc(Marker, Length(Company) + 1);

      Version := StrPas(@ZStr[Marker]);
      Inc(Marker, Length(Version) + 1);

      RevisionDate := StrPas(@ZStr[Marker]);
      Inc(Marker, Length(RevisionDate) + 1);

      Copyright := StrPas(@ZStr[Marker]);
    end;
  end;
end;

{
  function        : GetNameSpacesLoaded
  service type    : info services
  Netware version : NW v3.11, v4.x

  Desc : Get's a list of loaded name space
         supports on the file server.
         For the name space list see NvMain

  Errors : - neSuccessfull
           - neNoConsoleOperator
 }

function GetNameSpacesLoaded(VolumeNo : Byte;
                             var NameSpaceLoaded : tNameSpaceLoaded):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    SuBF        : Byte;   { subfunction       }
    Reserved    : Word;   { reserved          }
    Volume      : Byte;   { volume-no         }
  end;

  Reply         : tNameSpaceLoaded absolute NameSpaceLoaded;

begin
  FillChar(Reply, SizeOf(Reply), 0);
  with Request do
  begin
    SubF   := $18;
    Volume := VolumeNo;
  end;
  NovRegs := $F257;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetNameSpacesLoaded := Lo(NovRegs);
end;

{
  function        : GetFileServerSerialNo
  service type    : info services
  Netware version : NW v2.1x - v4.x

  Desc : Return's default file server
         serial number

  Errors : - neSuccessfull
           - neNoConsoleOperator
 }

function GetFileServerSerialNo(var NWSerial : LongInt;
                               var ApplicationNo : Word):boolean;

var
  NovRegs       : Word;

  Request       :
  record
    Size        : Word;
    SubF        : Byte;
  end;

  Reply         :
  record
    Size        : Word;
    NWSer       : LongInt;
    ApplSer     : Word;
  end;

begin
  Reply.Size   := SizeOf(Reply) - 2;
  with Request do
  begin
    Size := SizeOf(Request) - 2;
    SubF := $12;
  end;
  NovRegs      := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetFileServerSerialNo := (Lo(NovRegs) = neSuccessfull);
  NWSerial              := SwapLongInt(Reply.NWSer);
  ApplicationNo         := Swap(Reply.ApplSer);
end;

{
  function        : VerifyFileServerSerialNo
  service type    : info services
  Netware version : NW v2.x - vx.x

  Desc : Verify's the file server serial number
         returns the application serial number
 }

function VerifyFileServerSerialNo(NWSerial : LongInt):Word;

var
  NovRegs   : Word;

  Request   :
  record
    Size    : Word;
    SubF    : Byte;
    NWSer   : LongInt;
  end;

  Reply     :
  record
    Size    : Word;
    ApplSer : Word;
  end;

begin
  Reply.Size := SizeOf(Reply) - 2;
  with Request do
  begin
    Size  := SizeOf(Request) - 2;
    SubF  := $0C;
    NWSer := SwapLongInt(NWSerial);
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  if Lo(NovRegs) = neSuccessfull then
    VerifyFileServerSerialNo := Swap(Reply.ApplSer)
  else
    VerifyFileServerSerialNo := 0;
end;

{
  function        : DisableServerLogin
  service type    : login services
  Netware version : NW v2.1x - v4.x

  Desc : Disable's server login, console-privilege
         required.
 }

function DisableServerLogin:boolean;

var
  NovRegs     : Word;
  Reply       : Word;

  Request     :
  record
    Size      : Word;
    SubF      : Byte;
  end;

begin
  Reply := SizeOf(Reply) - 2;
  with Request do
  begin
    Size := SizeOf(Request) - 2;
    SubF := $CB;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  DisableServerLogin := (Lo(NovRegs) <> neNoConsoleOperator);
end;

{
  function        : EnableServerLogin
  service type    : login services
  Netware version : NW v2.1x - v4.x

  Desc : Enable's login to server,
         console privilege required
 }

function EnableServerLogin:boolean;

var
  NovRegs      : Word;
  Reply        : Word;

  Request      :
  record
    Size       : Word;
    SubF       : Byte;
  end;

begin
  Reply := SizeOf(Reply) - 2;
  with Request do
  begin
    Size := SizeOf(Request) - 2;
    SubF := $CC;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  EnableServerLogin := (Lo(NovRegs) <> neNoConsoleOperator);
end;

{
  function        : GetLoginStatus
  service type    : login services
  Netware version : NW v2.1x - v4.x

  Desc : Return's the activ server login status,
         console-privilege required.
 }

function GetLoginStatus(var Status : boolean):boolean;

var
  NovRegs     : Word;

  Request     :
  record
    Size      : Word;
    SubF      : Byte;
  end;

  Reply       :
  record
    Size      : Word;
    Status    : Byte;
  end;

begin
  Reply.Size := SizeOf(Reply) - 2;
  with Request do
  begin
    Size := SizeOf(Request) - 2;
    SubF := $CD;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetLoginStatus := (Lo(NovRegs) <> neNoConsoleOperator);
  Status := Reply.Status <> neSuccessfull;
end;

{
  function        : SetFileServerDateTime
  service type    : date/time services
  Netware version : NW v2.1x - v4.x

  Desc : Set's the default file server
         date and time
 }

function SetFileServerDateTime(Year,
                               Month,
                               Day,
                               Hour,
                               Minute,
                               Second : Byte):boolean;

var
  NovRegs     : Word;
  Reply       : Word;

  Request     :
  record
    Size      : Word;
    SubF      : Byte;
    NewYear   : Byte;
    NewMonth  : Byte;
    NewDay    : Byte;
    NewHour   : Byte;
    NewMinute : Byte;
    NewSecond : Byte;
  end;

begin
  Reply := SizeOf(Reply) - 2;
  with Request do begin
    Size      := SizeOf(Request) - 2;
    SuBF      := $CA;
    NewYear   := Year;
    NewMonth  := Month;
    NewDay    := Day;
    NewHour   := Hour;
    NewMinute := Minute;
    NewSecond := Second;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  SetFileServerDateTime := (Lo(NovRegs) <> neNoConsoleOperator);
end;

{
  function        : GetFileServerDateTime
  service type    : date/time services
  Netware version : NW v2.1x - v4.x

  Desc : Get's the default file server
         date and time
 }

function GetFileServerDateTime(var Year,
                               Month,
                               Day,
                               Hour,
                               Minute,
                               Second,
                               DayOfWeek : Byte):boolean;

var
  NovRegs        : tRegister;

  DateTimeBuffer :
  record
    ServerYear,
    ServerMonth,
    ServerDay,
    ServerHour,
    ServerMinute,
    ServerSecond,
    ServerDayOfWeek  : Byte;
  end;

begin
  FillChar(DateTimeBuffer, SizeOf(DateTimeBuffer), 0);
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $E7;
  if PathIntr(DateTimeBuffer, SizeOf(DateTimeBuffer), NovRegs) then
  begin
    GetFileServerDateTime := NovRegs.AL <> $FF;
    with DateTimeBuffer do
    begin
      Year      := ServerYear;
      Month     := ServerMonth;
      Day       := ServerDay;
      Hour      := ServerHour;
      Minute    := ServerMinute;
      Second    := ServerSecond;
      DayOfWeek := ServerDayOfWeek;
    end;
  end
  else
  begin
    GetFileServerDateTime := false;
    FilLChar(DateTimeBuffer, SizeOf(DateTimeBuffer), 0);
  end;
end;

{
  function        : EnableTTS
  service type    : Transaction Tracking System
  Netware version : NW v2.1x - v4.x

  Desc : Enable's file server Transaction Tracking
         System, console privilege required
 }

function EnableTTS:boolean;

var
  NovRegs        : Word;
  Reply          : Word;

  Request        :
  record
    Size         : Word;
    SubF         : Byte;
  end;

begin
  Reply := SizeOf(Reply) - 2;
  with Request do
  begin
    Size := SizeOf(Request) - 2;
    SuBF := $D0;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  EnableTTS := (Lo(NovRegs) <> neNoConsoleOperator);
end;

{
  function        : DisableTTS
  service type    : Transaction Tracking System
  Netware version : NW v2.1x - v4.x

  Desc : Disable's file server Transaction Tracking
         System, console privilege required
 }

function DisableTTS:boolean;

var
  NovRegs        : Word;
  Reply          : Word;

  Request        :
  record
    Size         : Word;
    SubF         : Byte;
  end;

begin
  Reply := SizeOf(Reply) - 2;
  with Request do
  begin
    Size := SizeOf(Request) - 2;
    SuBF := $CF;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  DisableTTS := (Lo(NovRegs) <> neNoConsoleOperator);
end;

{
  function        : TTSStatus
  service type    : Transaction Tracking System
  Netware version : NW v2.0 - v4.x

  Desc : Return's activ Transaction Tracking
         System status.
 }

function TTSStatus:Byte;

var
  NovRegs     : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $C702;
  CallIntr(NovRegs);
  TTSStatus := NovRegs.AL;
end;

{
  function        : ClearConnection
  service type    : servcer services
  Netware version : NW v2.1x - v4.x

  Desc : Clear's connection of an logged in user,
         supervisor rights required.
 }

function ClearConnection(ConnectionNo : Byte):boolean;

var
  NovRegs        : Word;
  Reply          : Word;

  Request        :
  record
    Size         : Word;
    SubF         : Byte;
    ConnNo       : Byte;
  end;

begin
  Reply := SizeOf(Reply) - 2;
  with Request do
  begin
    Size   := SizeOf(Request) - 2;
    SubF   := $D2;
    ConnNo := ConnectionNo;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  ClearConnection := (Lo(NovRegs) <> neNoConsoleOperator);
end;

{
  function        : DownServer
  service type    : servcer services
  Netware version : NW v2.1x - v4.x

  Desc : Shut down the server, console privilege
         required.If ForceIt true then shut down
         even if files are opened.

  Errors : - neSuccessfull
           - neNoConsoleOperator
           - neFileOpen
 }

function DownServer(ForceIt : boolean):Byte;

var
  NovRegs       : Word;
  Reply         :  Word;

  Request       :
  record
    Size        : Word;
    SubF        : Byte;
    Force       : Byte;
  end;

begin
  Reply := SizeOf(Reply) - 2;
  with Request do begin
    Size     := SizeOf(Request) - 2;
    SuBF     := $D3;
    if ForceIt then
      Force  := $01
    else
      Force  := $00;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  DownServer := Lo(NovRegs);
end;

{------------------------ end of unit ------------------------}

end.
