 {ͻ
   unit : Novell Sync                           Target Platforms :       
   desc : Novell syncronization Services          - DOS Real             
                                                  - DOS Protected        
                                                  - Windows              
   (C) 1994 by Christoph Weller 16/01/93 v1.1                            
  ͼ}

(*

  18.1.1995  : Inserted all possible error-results of a procedure/function
               into the description-header.

*)

unit NVSync;

interface

{$I NVDEFINE.INC }

uses
  Strings,  { Borland strings unit }
  NvMain;   { Novell main unit     }

{
              CONST declarations
 }

const

  { (l)ock (m)odes }
  lmCompatibiltyMode          = $00; { old compatibilty mode              }
  lmExtentedLockMode          = $01; { new extended lock mode             }

  { (l)ocking (m)odes }
  lmLogRecord                 = $00; { Log record                         }
  lmLogAndLockRecordExc       = $01; { Log and lock record exclusive      }
  lmLogAndLogRecordShareable  = $03; { Log and lock record shareable, RO  }

{
              TYPE declarations
 }

type

  { Semaphore-information }
  tConnectionSemaphoreInfo  =
  record
    OpenCount               : Word;     { open count        }
    SemaphoreValue          : Word;     { semaphore value   }
    TaskNumber              : Word;     { Task number       }
    SemaphoreName           : String;   { Semaphore name    }
  end;

  { Connections semaphore information }
  tConnectionSemaphore      =
  record
    NextReqRecord           : Word;     { Next request record       }
    NoOfSemaphores          : Word;     { number of semaphores      }
    SemaphoreInfoRec        : array[1..4] of tConnectionSemaphoreInfo;
                              { Semaphore information records,
                                NoOfSemaphores count                }
  end;

  { Semaphore information record, used in tSemaphoreInformation record }
  tSemaphoreInfoRec         =
  record
    ConnNo                  : Word;     { Connection-no     }
    TaskNumber              : Word;     { Task number       }
  end;

  { Connections semaphore information }
  tSemaphoreInformation     =
  record
    NextReqRecord           : Word;     { Next request record       }
    OpenCount               : Word;     { Open count                }
    SemaphoreValue          : Word;     { Semaphore value           }
    NoOfRecords             : Word;     { number of info-records    }
    SemaphoreInfoRec        : array[1..126] of tSemaphoreInfoRec;
                              { Semaphore information records,
                                NoOfSemaphores count                }
  end;

{
        procedure and function headers
 }

{ SYNCHRONIZATION SERVICES Get lock mode }
function GetLockMode:Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES Set lock mode }
procedure SetLockMode(Mode :Byte);
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES Log physical record }
function LogPhysicalRecord(LogMode      : Byte;
                           FileHandle   : Word;
                           StartOffset,
                           LockLength   : LongInt;
                           TimeOutTicks : Word):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES Lock physical record set }
function LockPhysicalRecordSet(LogMode      : Byte;
                               TimeOutTicks : Word):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES Release physical record }
function ReleasePhysicalRecord(FileHandle   : Word;
                               StartOffset,
                               LockLength   : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES Clear physical record }
function ClearPhysicalRecord(FileHandle   : Word;
                             StartOffset,
                             LockLength   : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES Release physical record set }
procedure ReleasePhysicalRecordSet;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES Clear physical record set }
procedure ClearPhysicalRecordSet;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES open semaphore }
function OpenSemaphore(SemaphoreName : String;
                       SemaphoreValue : Byte;
                       var OpenCount : Byte;
                       var SemaphoreHandle : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES examine semaphore }
function ExamineSemaphore(var SemaphoreValue : Byte;
                          var OpenCount : Byte;
                          SemaphoreHandle : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES wait on semaphore }
function WaitOnSemaphore(TimeOutTicks : Word;
                         SemaphoreHandle : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES signal semaphore }
function SignalSemaphore(SemaphoreHandle : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES close semaphore }
function CloseSemaphore(SemaphoreHandle : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get connection's semaphore }
function GetConnectionSemaphore(var ConnectionSemaphore : tConnectionSemaphore;
                                Conn : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get semaphore info }
function GetSemaphoreInfo(var SemaphoreInfo : tSemaphoreInformation;
                          SemaphoreName : String;
                          Conn : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES clear file set }
procedure ClearFileSet;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES log logical record }
function LogLogicalRecord(LogicalRecord : String;
                          LogMode : Byte;
                          TimeOutTicks : Word):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES log logical record set }
function LockLogicalRecordSet(LogMode : Byte;
                              TimeOutTicks : Word):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES release logical record }
function ReleaseLogicalRecord(LogicalRecord : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES release logical record set }
procedure ReleaseLogicalRecordSet;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES clear logical set }
function ClearLogicalRecord(LogicalRecord : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES clear logical record set }
procedure ClearLogicalRecordSet;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES log file }
function LogFile(FilePath : String;
                 TimeoutLimit : Word;
                 LogMode : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES release file }
function ReleaseFile(FilePath : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES clear file }
function ClearFile(FilePath : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES lock file set }
function LockFileSet(TimeOutLimit : Word):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SYNCHRONIZATION SERVICES release file set }
procedure ReleaseFileSet;
{$IFDEF PROTECTED} export; {$ENDIF}

(* -------------------------- implemenation -------------------------- *)

implementation

{
  Function        : GetLockMode
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Returns the current lock mode
 }

function GetLockMode:Byte;

var
  NovRegs       : tRegister;

begin
  with NovRegs do
  begin
    AH := $C6;
    AL := $02;
  end;
  CallIntr(NovRegs);
  GetLockMode := NovRegs.AL;
end;

{
  Function        : SetLockMode
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Set's the current lock mode
         $00 : old compatibility mode
         $01 : new extended lock mode
 }

procedure SetLockMode(Mode :Byte);

var
  NovRegs       : tRegister;

begin
  if not Mode in [$00, $01] then exit;
  with NovRegs do
  begin
    AH := $C6;
    AL := Mode;
  end;
  CallIntr(NovRegs);
end;

{
  Function        : LogPhysicalRecord
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Logs an physical record

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neTimeoutError
           - neError
 }

function LogPhysicalRecord(LogMode      : Byte;
                           FileHandle   : Word;
                           StartOffset,
                           LockLength   : LongInt;
                           TimeOutTicks : Word):Byte;

var
  NovRegs       : tRegister;

begin
  with NovRegs do
  begin
    AH := $BC;
    AL := LogMode;
    BX := FileHandle;
    Move(StartOffset, CX, SizeOf(StartOffset));
    Move(LockLength, SI, SizeOf(LockLength));
    BP := TimeOutTicks;
  end;
  CallIntr(NovRegs);
  LogPhysicalRecord := NovRegs.AL;
end;

{
  Function        : LockPhysicalRecordSet
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Locks an physical record set

  Errors : - neSuccessfull
           - neTimeoutError
           - neError
 }

function LockPhysicalRecordSet(LogMode      : Byte;
                               TimeOutTicks : Word):Byte;

var
  NovRegs       : tRegister;

begin
  with NovRegs do
  begin
    AH := $C2;
    AL := LogMode;
    BP := TimeOutTicks;
  end;
  CallIntr(NovRegs);
  LockPhysicalRecordSet := NovRegs.AL;
end;

{
  Function        : ReleasePhysicalRecord
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Releases an physical record

  Errors : - neSuccessfull
           - neNoLockedRecordFound
 }

function ReleasePhysicalRecord(FileHandle   : Word;
                               StartOffset,
                               LockLength   : LongInt):Byte;

var
  NovRegs       : tRegister;

begin
  with NovRegs do
  begin
    AH := $BD;
    BX := FileHandle;
    Move(StartOffset, CX, SizeOf(StartOffset));
    Move(LockLength, SI, SizeOf(LockLength));
  end;
  CallIntr(NovRegs);
  ReleasePhysicalRecord := NovRegs.AL;
end;

{
  Function        : ClearPhysicalRecord
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Clears the physical record

  Errors : - neSuccessfull
           - neNoLockedRecordFound
 }

function ClearPhysicalRecord(FileHandle   : Word;
                             StartOffset,
                             LockLength   : LongInt):Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $BE;
    BX := FileHandle;
    Move(StartOffset, CX, SizeOf(StartOffset));
    Move(LockLength, SI, SizeOf(LockLength));
  end;
  CallIntr(NovRegs);
  ClearPhysicalRecord := NovRegs.AL;
end;

{
  Function        : ReleasePhyiscalRecordSet
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Releases an physical record set
 }

procedure ReleasePhysicalRecordSet;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $C3;
  CallIntr(NovRegs);
end;

{
  Function        : ClearPhysicalRecordSet
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Clears the phyiscal record set
 }

procedure ClearPhysicalRecordSet;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $C4;
  CallIntr(NovRegs);
end;

{
  Function        : OpenSemaphore
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Opens a semaphore

  Errors : - neSuccessfull
           - neInvalidSemNameLength
           - neInvalidSemaphHandle
 }

function OpenSemaphore(SemaphoreName : String;
                       SemaphoreValue : Byte;
                       var OpenCount : Byte;
                       var SemaphoreHandle : LongInt):Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $C500;
    CL := SemaphoreValue;
  end;
  RequestBufferIntr(SemaphoreName, Length(SemaphoreName) + 1, NovRegs);
  OpenSemaphore := NovRegs.AL;
  with NovRegs do
  begin
    OpenSemaphore  := AL;
    OpenCount      := BL;
    if AL = 0 then
    begin
      tHiLoWord(SemaphoreHandle).Lo := CX;
      tHiLoWord(SemaphoreHandle).Hi := DX;
    end
    else
      SemaphoreHandle := 0;
  end;
end;

{
  Function        : Examine semaphore
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Examnines a semaphore

  Errors : - neSuccessfull
           - neInvalidSemaphHandle
 }

function ExamineSemaphore(var SemaphoreValue : Byte;
                          var OpenCount : Byte;
                          SemaphoreHandle : LongInt):Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $C501;
    CX := tHiLoWord(SemaphoreHandle).Lo;
    DX := tHiLoWord(SemaphoreHandle).Hi;
  end;
  CallIntr(NovRegs);
  with NovRegs do
  begin
    ExamineSemaphore := AL;
    OpenCount        := DL;
    SemaphoreValue   := CX;
  end;
end;

{
  Function        : WaitOnSemaphore
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Wait on a semaphore

  Errors : - neSuccessfull
           - neTimeoutError
           - neInvalidSemaphHandle
 }

function WaitOnSemaphore(TimeOutTicks : Word;
                         SemaphoreHandle : LongInt):Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $C502;
    CX := tHiLoWord(SemaphoreHandle).Lo;
    DX := tHiLoWord(SemaphoreHandle).Hi;
    BP := TimeOutTicks;
  end;
  CallIntr(NovRegs);
  WaitOnSemaphore := NovRegs.AL;
end;

{
  Function        : SignalSemaphore
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Signals an semaphore

  Errors : - neSuccessfull
           - neSemaphoreOverflow
           - neInvalidSemaphHandle
 }

function SignalSemaphore(SemaphoreHandle : LongInt):Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $C503;
    CX := tHiLoWord(SemaphoreHandle).Lo;
    DX := tHiLoWord(SemaphoreHandle).Hi;
  end;
  CallIntr(NovRegs);
  SignalSemaphore := NovRegs.AL;
end;

{
  Function        : CloseSemaphore
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Closes a semaphore

  Errors : - neSuccessfull
           - neSemaphoreOverflow
 }

function CloseSemaphore(SemaphoreHandle : LongInt):Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $C504;
    CX := tHiLoWord(SemaphoreHandle).Lo;
    DX := tHiLoWord(SemaphoreHandle).Hi;
  end;
  CallIntr(NovRegs);
  CloseSemaphore := NovRegs.AL;
end;

{
  procedure       : GetConnectionSemaphore
  service type    : workstation infos
  Netware version : NW v3.x, v4.x

  Desc : Get's the semaphores of an connection

  Errors : - neSuccessfull
           - neNoConsoleOperator
 }

function GetConnectionSemaphore(var ConnectionSemaphore : tConnectionSemaphore;
                                Conn : Byte):Byte;

var
  NovRegs       : Word;
  Reply         : tConnectionSemaphore absolute ConnectionSemaphore;

  Request       :
  record
    FLen        : Word; { Length of request    }
    SubF        : Byte; { Subfunction          }
    ConnNo      : Word; { connection number    }
    LastRecord  : Word; { last record seen     }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with Request do
  begin
    FLen       := SizeOf(Request) -2;
    SubF       := $F1;
    ConnNo     := Conn;
    LastRecord := ConnectionSemaphore.NextReqRecord;
  end;
  NovRegs := $F217;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetConnectionSemaphore := Lo(NovRegs);
end;

{
  procedure       : GetSemaphoreInfo
  service type    : workstation infos
  Netware version : NW v3.x, v4.x

  Desc : Get's various information about the
         semaphores

  Errors : - neSuccessfull
           - neNoConsoleOperator
 }

function GetSemaphoreInfo(var SemaphoreInfo : tSemaphoreInformation;
                          SemaphoreName : String;
                          Conn : Byte):Byte;

var
  NovRegs       : Word;
  Reply         : tSemaphoreInformation absolute SemaphoreInfo;

  Request          :
  record
    FLen           : Word;   { Length of request    }
    SubF           : Byte;   { Subfunction          }
    LastRecord     : Word;   { last record seen     }
    SemName        : String; { Semaphore name       }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with Request do
  begin
    FLen       := SizeOf(Request) -2;
    SubF       := $F2;
    LastRecord := Swap(SemaphoreInfo.NextReqRecord);
    SemName    := SemaphoreName;
  end;
  NovRegs := $F217;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetSemaphoreInfo := Lo(NovRegs);
end;

{
  Function        : ClearFileSet
  Service Type    : synchronization services
  Netware version : NW v2.x - vx.x

  Desc : Clears all logged files from the table
 }

procedure ClearFileSet;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs,  SizeOf(NovRegs),  0);
  NovRegs.AH := $CF;
  CallIntr(NovRegs);
end;

{
  Function        : LogLogicalRecord
  Service Type    : synchronization services
  Netware version : NW v2.x - vx.x

  Desc : Logs an logical record

  Errors : - neSuccessfull
           - neTimeoutError
           - neError
 }

function LogLogicalRecord(LogicalRecord : String;
                          LogMode : Byte;
                          TimeOutTicks : Word):Byte;
var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  if not LogMode in [$00, $01, $03] then exit;
  with NovRegs do
  begin
    AH := $D0;
    AL := LogMode;
    BP := TimeOutTicks;
  end;
  RequestBufferIntr(LogicalRecord, SizeOf(LogicalRecord), NovRegs);
  LogLogicalRecord := NovRegs.AL;
end;

{
  Function        : LockLogicalRecordSet
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Locks an logical record set

  Errors : - neSuccessfull
           - neTimeoutError
           - neError
 }

function LockLogicalRecordSet(LogMode : Byte;
                              TimeOutTicks : Word):Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  if not LogMode in [$01, $03] then exit;
  with NovRegs do
  begin
    AH := $D1;
    AL := LogMode;
    BP := TimeOutTicks;
  end;
  CallIntr(NovRegs);
  LockLogicalRecordSet := NovRegs.AL;
end;

{
  Function        : ReleaseLogicalRecord
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Releases an logical record

  Errors : - neSuccessfull
           - neNoRecordFound
 }

function ReleaseLogicalRecord(LogicalRecord : String):Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $D1;
  RequestBufferIntr(LogicalRecord, SizeOf(LogicalRecord), NovRegs);
  ReleaseLogicalRecord := NovRegs.AL;
end;

{
  Function        : ReleaseLogicalRecordSet
  Service Type    : synchronization services
  Netware version : NW v2.x - vx.x

  Desc : Releases an logical record set
 }

procedure ReleaseLogicalRecordSet;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $D3;
  CallIntr(NovRegs);
end;

{
  Function        : ClearLogicalRecord
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Clear logical record

  Errors : - neSuccessfull
           - neNoRecordFound
 }

function ClearLogicalRecord(LogicalRecord : String):Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $D4;
  RequestBufferIntr(LogicalRecord, SizeOf(LogicalRecord), NovRegs);
  ClearLogicalRecord := NovRegs.AL;
end;

{
  Function        : ClearLogicalRecordSet
  Service Type    : synchronization services
  Netware version : NW v2.x - vx.x
 }

procedure ClearLogicalRecordSet;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $D5;
  CallIntr(NovRegs);
end;

{
  Function        : LogFile
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Logs the filename into a table on the
         file server

  Errors : - neSuccessfull
           - neServerOutOfMem
           - neTimeoutError
           - neHardwareError
 }

function LogFile(FilePath : String;
                 TimeoutLimit : Word;
                 LogMode : Byte):Byte;

var
  FilePathZ     : array[1..255] of Char;
  NovRegs       : tRegister;

begin
  FillChar(NovRegs,  SizeOf(NovRegs),  0);
  if not LogMode in [$00,  $01] then exit;
  with NovRegs do
  begin
    AH := $EB;
    AL := LogMode;
    BP := TimeOutLimit;
  end;
  StrPCopy(@FilePathZ, FilePath);
  RequestBufferIntr(FilePathZ, SizeOf(FilePath), NovRegs);
  LogFile := NovRegs.AL;
end;

{
  Function        : ReleaseFile
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Releases an logged file

  Errors : - neSuccessfull
           - neNoFilesFoundError
 }

function ReleaseFile(FilePath : String):Byte;

var
  FilePathZ     : array[1..255] of Char;
  NovRegs       : tRegister;

begin
  FillChar(NovRegs,  SizeOf(NovRegs),  0);
  NovRegs.AH := $EC;
  StrPCopy(@FilePathZ, FilePath);
  RequestBufferIntr(FilePathZ, SizeOf(FilePath), NovRegs);
  ReleaseFile := NovRegs.AL;
end;

{
  Function        : ClearFile
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Clears the file from the log-table

  Errors : - neSuccessfull
           - neNoFilesFoundError
 }

function ClearFile(FilePath : String):Byte;

var
  FilePathZ     : array[1..255] of Char;
  NovRegs       : tRegister;

begin
  FillChar(NovRegs,  SizeOf(NovRegs),  0);
  NovRegs.AH := $ED;
  StrPCopy(@FilePathZ, FilePath);
  RequestBufferIntr(FilePathZ, SizeOf(FilePath), NovRegs);
  ClearFile := NovRegs.AL;
end;

{
  Function        : LockFileSet
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Locks all files who where logged

  Errors : - neSuccessfull
           - neTimeoutError
           - neError
 }

function LockFileSet(TimeOutLimit : Word):Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs,  SizeOf(NovRegs),  0);
  with NovRegs do
  begin
    AH := $CB;
    BP := TimeOutLimit;
  end;
  CallIntr(NovRegs);
  LockFileSet := NovRegs.AL;
end;

{
  Function        : ReleaseFileSet
  Service Type    : synchronization services
  Netware version : NW v2.0 - v4.x

  Desc : Releases the complete file-set
         on the file server
 }

procedure ReleaseFileSet;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs,  SizeOf(NovRegs), 0);
  NovRegs.AH := $CD;
  CallIntr(NovRegs);
end;

{------------------------ end of unit ------------------------}

end.
