 {ͻ
   unit : Novell workstation                    Target Platforms :       
   desc : Novell workstation functions            - DOS-Real             
                                                  - DOS-Protected        
                                                  - Windows              
   (C) 1994 by Christoph Weller 16/01/93 v1.1                            
  ͼ}

(*

  18.1.1995  : Inserted all possible error-results of a procedure/function
               into the description-header.

  19.1.1995  : Some object-names were declared wrong as String[47].

*)

unit NVWorkst;

interface

{$I NVDEFINE.INC}

uses
  Strings,  { Borland strings unit }
  NvMain;   { Novell main unit     }

{
              CONST declarations
 }

const

  { (l)ocking (f)lags }
  lfFileLocked                 = $01; { file is locked          }
  lfFileOpenedShareable        = $02; { file opened shareable   }
  lfFileLogged                 = $04; { file logged             }
  lfFileOpenedNormal           = $08; { file opened normal      }
  lfTTSHoldingLock             = $46; { TTS holding file locked }
  lfTTSFlagSetOnFile           = $80; { TTS flag set on file    }

  { (l)ock (t)ype }
  ltNotLocked                  = $00; { file not locked                   }
  ltLockedByFileLock           = $FE; { locked by file lock               }
  ltLockedByBeginShareFileSet  = $FF; { locked by begin share file set    }

  { (a)ccess (f)lags }
  afReadOpen                   = $01; { file opened in read-mode       }
  afWriteOpen                  = $02; { file opened in write-mode      }
  afDenyReadByOtherSt          = $04; { deny reads by other stations   }
  afDenyWriteByOtherSt         = $08; { deny write by other stations   }
  afFileDetached               = $10; { file detached                  }
  afTTSHoldingDetach           = $20; { TTS holding detach             }
  afTTSHoldingOpen             = $40; { TTS holding open               }

{
              TYPE declarations
 }

type

   { connection info }
   tConnectionInfo      =
   record
     ObjectId           : LongInt;    { Object Id of logged in object }
     ObjectType         : Word;       { Type of object                }
     ObjectName         : String[48]; { Object's name                 }
     LoginTime          : array[1..7] of Byte; { Login-time           }
   end;

   { shell-info }
   tShellInfo           =
   record
     DOSOperatingSystem : boolean; { true for DOS, false for other
                                     Operating Systems }
     Hardwaretype       : Byte;    { Hardware Type 00 = IBM PC,
                                                   01 = Victor 9000 }
     ShellMajorVer      : Byte;    { Shell major version number }
     ShellMinorVer      : Byte;    { Shell minor version number }
     ShellType          : Byte;    { Shell type (v3.01+)
                                     00 = conventional Mem
                                     01 = expanded Mem
                                     02 = extended Mem }
     ShellRevision      : Byte;
   end;

   { Connection Id-Table }
   tConnIDTable         =
   record
     InUseFlag          : Byte; { E0h AES temporary,
                                  F8h IPX in critical section,
		                  FAh processing,
                                  FBh holding,
                                  FCh AES waiting
		                  FDh waiting,
                                  FEh receiving,
                                  FFh sending}
     OrderNo            : Byte;
     NetWorkAddress     : LongInt;
     FileServerNodeNo   : array[1..6] of Byte;
     SocketNo           : Word;
     BaseTimeOut        : Word;
     PreferredRoutNode  : array[1..6] of Byte;
     PacketSequenceNo   : Byte;
     ConnNo             : Byte; { FFh = no connection }
     ConnStatus         : Byte; { 00h = activ }
     MaxReciveTimeOut   : Word;
     Reserved           : array[1..5] of Byte;
   end;

   { physical node address }
   tPhyNodeAddress      = array[1..6] of Byte;

   { connection list }
   tObjConnList         =
   record
     ConnNo             : Byte;
     Conns              : array[1..100] of Byte;
   end;

   { object name }
   tObjName             = String[48];

   { File-information record for tOpenFiles }
   tFileInformation     =
   record
     TaskNumber         : Word;      { Task number                }
     LockType           : Byte;      { Lock type                  }
     AccessFlag         : Byte;      { Access flag                }
     LockFlag           : Byte;      { Lock flag                  }
     VolumeNo           : Byte;      { Volume-number              }
     ParentEntry        : LongInt;   { Parent entry               }
     DirectoryEntry     : LongInt;   { Directory entry            }
     ForkCount          : Byte;      { Fork count                 }
     NameSpace          : Byte;      { Name space support         }
     FileName           : String[14];{ File name                  }
   end;

   { stations open files information }
   tOpenFiles           =
   record
     NextReqRecord      : Word;     { Next request record       }
     NoOfRecords        : Word;     { number of records         }
     { file information records, NoOfRecords count }
     FileInfoRecords    : array[1..16] of tFileInformation;
   end;

   { Semaphore info record }
   tSemaphoreInfoRec    =
   record
     OpenCount          : Word;     { Open count                }
     SemaphoreValue     : Word;     { Semaphore value           }
     TaskNumber         : Word;     { Task number               }
     SemaphoreName      : String;   { Semaphore name            }
   end;

   { Connections semaphore info }
   tSemaphores          =
   record
     NextReqRecord      : Word;     { Next request record       }
     NoOfRecords        : Word;     { number of records         }
     SemaphoreInfoRecs  : array[1..16] of tSemaphoreInfoRec;
                          { Semaphore information records,
                            NoOfRecords count                   }
   end;

   { Connections task info record }
   tTaskInfoRec         =
   record
     TaskNumber         : Byte;     { Task number               }
     Task               : array[1..3] of Byte; { Task           }
     TaskState          : Byte;     { Task current state        }
   end;

   { Connections task info reply structure
     Note ! : not all informations are availavle, it occurs to
              the returned lock status. See the crosses right below  }
   tTaskInfoStructure   =
   record
                                    { Lock Status ->              1 2 3 4 }
     WaitingTaskNo      : Word;     { Waiting task number         x x x x }
     BeginAdress        : LongInt;  { Begin adress                x       }
     EndAdress          : LongInt;  { End adress                  x       }
     VolumeNo           : Byte;     { Volume no                   x x     }
     NameSpace          : Byte;     { Name space                  x x     }
     FileName           : String;   { File name                   x x     }
     DirectoryEntry     : LongInt;  { Directory entry               x     }
     RecordName         : String;   { Record name                     x x }
   end;

   { Connections task info }
   tTaskInfo            =
   record
     ConLockStatus      : Byte;               { Connection lock status    }
     StatusInformation  : tTaskInfoStructure; { Task status information   }
     NoOfRecords        : Byte;               { number of records         }
     { Task info records, repeated NoOfRecords }
     TaskInfos          : array[1..100] of tTaskInfoRec;
   end;

   { File usage info record }
   tFileUsageInfoRecord =
   record
     LogicalConnection  : Word;     { Logical connection no             }
     TaskNumber         : Word;     { Task number                       }
     LockType           : Byte;     { Lock type                         }
     AccessFlag         : Byte;     { Access flag                       }
     LockFlag           : Byte;     { Lock flag                         }
   end;

   { File usage information }
   tFileUsageInfo       =
   record
     NextReqRecord      : Word;     { Next request record               }
     UseCount           : Word;     { Use count                         }
     OpenCount          : Word;     { Open count                        }
     OpenForReadCount   : Word;     { Open for read count               }
     OpenForWriteCount  : Word;     { Open for write count              }
     DenyReadCount      : Word;     { Deny read count                   }
     DenyWriteCount     : Word;     { Deny write count                  }
     LockFlag           : Byte;     { Lock flag                         }
     ForkCount          : Byte;     { Fork count                        }
     NoOfRecords        : Word;     { No of records                     }
     UsageInfoRecs      : array[1..70] of tFileUsageInfoRecord;
                          { Usage info records, repeated NoOfRecords }
   end;

{
        procedure and function-headers
 }

{ WORKSTATION INFOS Returns true if the workstation has console priviliges }
function ConsolePrivilege:boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Set EOJ status of WS }
procedure SetEOJ(Enable : boolean);
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Workstation 'end of job' }
function EOJ(OnlyCurrJob : boolean):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get connection-no  }
function GetConnectionNo:Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get physical station adress }
procedure GetPhyNodeAdress(var NodeAdress : tPhyNodeAddress);
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get default connection id }
function GetDefaultConnId:Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get preferred connection id }
function GetPreferredConnId:Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Set preferred connection id }
procedure SetPreferredConnId(ConnId : Byte);
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get primary connection id }
function GetPrimaryConnId:Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Set primary connection id }
procedure SetPrimaryConnId(ConnId : Byte);
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get connection id ??}
procedure GetConnId(var ConnId : tConnIdTable);
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get connection info }
procedure GetConnInfo(var Connection : tConnectionInfo;
                      Conn : Byte);
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get objects connection numbers }
procedure GetObjectConnection(var CList : tObjConnList;
                              ObjectTyp : Word;
                              ObjectName : tObjName);
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get connection's open files }
function GetConnectionOpenFiles(var OpenFiles : tOpenFiles;
                                Conn : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get connection's semaphores }
function GetConnectionSemaphore(var Semaphores : tSemaphores;
                                Conn : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get connection's task information }
function GetConnectionTaskInfo(var TaskInfo : tTaskInfo;
                               Conn : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get connection's using a file }
function GetConnectionUsingAFile(var UsageInfo : tFileUsageInfo;
                                 ForkType : Byte;
                                 VolumeNo : Byte;
                                 FileEntryId : LongInt):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ WORKSTATION INFOS Get Internet address }
procedure GetInternetAddress(ConnNo            : Byte;
                             var NodeAddress   : tPhyNodeAddress;
                             var NetworkNumber : LongInt;
                             var SocketNumber  : Word);
{$IFDEF PROTECTED} export; {$ENDIF}

{ SHELL FUNCTIONS Get Shell version }
procedure GetShellVersion(var Shell : tShellInfo);
{$IFDEF PROTECTED} export; {$ENDIF}

{ SHELL FUNCTIONS Shell Timer Interrupt Checks }
procedure ShellTimerIntrCheck(Enable : boolean);
{$IFDEF PROTECTED} export; {$ENDIF}

{ SHELL FUNCTIONS set NWError mode }
function SetNWErrorMode(ErrorMode : Byte):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SERVER FUNCTIONS server attach ??}
function ServerAttach(Attachfunction : Byte;
                      Attachment : Byte):byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SERVER FUNCTIONS attach to file server ##}
function AttachToServer(ServerConn : Byte):byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SERVER FUNCTIONS detach from file server ##}
function DetachServer(ServerConn : Byte):byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SERVER FUNCTIONS Enter login area ##}
function EnterLoginArea(LocalDrives : Byte;
                        SubDir      : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SERVER FUNCTIONS System logout }
procedure SystemLogOut;
{$IFDEF PROTECTED} export; {$ENDIF}

{ SERVER FUNCTIONS logout from file server }
procedure LogOutFromServer(ServerConn : Byte);
{$IFDEF PROTECTED} export; {$ENDIF}

{ SERVER FUNCTIONS Login to file server }
function LoginToFileServer(ObjectTyp : Word;
                           LoginName,
                           PassWord : String):Byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRANSACTION TRACKING Get application threshold }
function GetApplicationTreshold(var MaxLogLocks,
                                MaxPhyLocks : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRANSACTION TRACKING Set application threshold}
function SetApplicationTreshold(MaxLogLocks,
                                MaxPhyLocks : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRANSACTION TRACKING Get workstation threshold }
function GetWSTreshold(var MaxLogLocks,
                       MaxPhyLocks : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRANSACTION TRACKING Set workstation threshold}
function SetWSTreshold(MaxLogLocks,
                       MaxPhyLocks : Byte):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRANSACTION TRACKING Begin transaction }
function BeginTransaction:byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRANSACTION TRACKING End transaction }
function EndTransaction(var TransactionNo : LongInt):byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRANSACTION TRACKING Abort transaction }
function AbortTransaction:byte;
{$IFDEF PROTECTED} export; {$ENDIF}

{ TRANSACTION TRACKING Transaction status }
function TransactionStatus(var TransactionNo : LongInt):boolean;
{$IFDEF PROTECTED} export; {$ENDIF}

(* -------------------------- implemenation -------------------------- *)

implementation

{
  function        : ConsolePrivilege
  service type    : workstation infos
  Netware Version : NW v2.1x - v4.x

  Desc : Returns true if the workstation has
         console privileges
 }

function ConsolePrivilege:boolean;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    Size        : Word;
    SubF        : Byte;
  end;

begin
  Reply := 0;
  with Request do
  begin
    Size := SizeOf(Request) - 2;
    SubF := $C8;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  ConsolePrivilege := (Lo(NovRegs) <> neNoConsoleOperator);
end;

{
  procedure       : SetEOJ
  service type    : workstation infos
  Netware Version : NW v2.0 - v4.x

  Desc : Toggles the automatic EOJ by
         returning to the DOS-shell
 }

procedure SetEOJ(Enable : boolean);

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $BB;
    AL := Byte(Enable);
  end;
  CallIntr(NovRegs);
end;

{
  function        : EOJ
  service type    : workstation infos
  Netware Version : NW v2.0 - v4.x

  Desc : Make an EOJ
 }

function EOJ(OnlyCurrJob : boolean):boolean;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $D6;
    if OnlyCurrJob then
      BX := $0000
    else
      BX := $FFFF;
  end;
  CallIntr(NovRegs);
  EOJ := (NovRegs.AL = neSuccessfull);
end;

{
  function        : GetConnection No
  service type    : workstation infos
  Netware Version : NW v2.0 - v4.x

  Desc : Returns the connection-no of the own
         station
 }

function GetConnectionNo:Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $DC;
  CallIntr(NovRegs);
  GetConnectionNo := NovRegs.AL;
end;

{
  procedure       : Get Physical Node Adress
  service type    : workstation infos
  Netware Version : NW v2.0 - v4.x

  Desc : Get's the physical node-adress of
         the station
 }

procedure GetPhyNodeAdress(var NodeAdress : tPhyNodeAddress);

var
  NovRegs       : tRegister;

begin
  FilLChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $EE;
  CallIntr(NovRegs);
  with NovRegs do
  begin
    NodeAdress[1] := Hi(NovRegs.CX);
    NodeAdress[2] := Lo(NovRegs.CX);
    NodeAdress[3] := Hi(NovRegs.BX);
    NodeAdress[4] := Lo(NovRegs.BX);
    NodeAdress[5] := Hi(NovRegs.AX);
    NodeAdress[6] := Lo(NovRegs.AX);
  end;
end;

{
  function        : GetDefaultConnId
  service type    : workstation infos
  Netware Version : NW v2.0 - v4.x

  Desc : Get's the default file server
 }

function GetDefaultConnId:Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $F002;
  CallIntr(NovRegs);
  GetDefaultConnId := NovRegs.AL;
end;

{
  function        : GetPreferredConnId
  service type    : workstation infos
  Netware version : NW v2.0 - v4.x

  Desc : Get's the prefered file server
 }

function GetPreferredConnId:Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $F001;
  CallIntr(NovRegs);
  GetPreferredConnId := NovRegs.AL;
end;

{
  procedure       : SetPreferredConnId
  service type    : workstation infos
  Netware version : NW v2.0 - v4.x

  Desc : Set's the prefered file server
 }

procedure SetPreferredConnId(ConnId : Byte);

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $F000;
    DL := ConnId;
  end;
  CallIntr(NovRegs);
end;

{
  function        : GetPrimaryConnId
  service type    : workstation infos
  Netware version : NW v2.0 - v4.x

  Desc : Get's the primaray file server
 }

function GetPrimaryConnId:Byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $F005;
  CallIntr(NovRegs);
  GetPrimaryConnId := NovRegs.AL;
end;

{
  procedure       : SetPrimaryConnId
  service type    : workstation infos
  Netware version : NW v2.0 - v4.x

  Desc : Defines the primary file server
 }

procedure SetPrimaryConnId(ConnId : Byte);

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $F004;
    DL := ConnId;
  end;
  CallIntr(NovRegs);
end;

{
  procedure       : GetConnID
  service type    : workstation infos
  Netware version : NW v2.0 - v4.x

  Desc : Get's the connection id table of the
         Netware-shell
 }

procedure GetConnId(var ConnId : tConnIdTable);

type
  TablePtr  = ^tConnIdTable;

var
  NovRegs       : tRegister;
  Table         : TablePtr;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $EF03;
  CallIntr(NovRegs);
  {$IFDEF DPMI}
  Segment2Descriptor(NovRegs.ES);
  {$ENDIF}
  Table  := Ptr(NovRegs.ES, NovRegs.SI);
  ConnId := Table^;
  with ConnId do
  begin
    NetworkAddress   := SwapLongInt(NetworkAddress);
    SwapNodeAddress(FileServerNodeNo);
    SwapNodeAddress(PreferredRoutNode);
    SocketNo         := Swap(SocketNo);
    BaseTimeOut      := Swap(BaseTimeOut);
    MaxReciveTimeOut := Swap(MaxReciveTimeOut);
  end;
end;

{
  procedure       : GetConnInfo
  service type    : workstation infos
  Netware version : NW v2.0 - v4.x

  Desc : Get's various information about the
         object using the given connection-no
 }

procedure GetConnInfo(var Connection : tConnectionInfo;
                      Conn : Byte);

var
  NovRegs       : Word;

  Request       :
  record
    Size        : Word; { Length of Request                     }
    SubF        : Byte; { Subfunction                           }
    ConnNo      : Byte; { logical Connection Number             }
  end;

  Reply         :
  record
    Size        : Word;    { length of reply                            }
    OId         : LongInt; { Object id of logged in object (big-endian) }
    OType       : Word;    { Type of object (big-endian)                }
    OName       : array[1..48] of Char; { Name of object                }
    LoginT      : array[1..7] of Byte;  { Login-time                    }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with Request do
  begin
    Size   := SizeOf(Request) -2;
    SubF   := $16;
    ConnNo := Conn;
  end;
  Reply.Size := SizeOf(Reply) - 2;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  with Reply, Connection do
  begin
    ObjectId      := SwapLongInt(OId);
    ObjectType    := Swap(OType);
    ObjectName    := StrPas(@OName);
    Move(LoginT, LoginTime, SizeOf(LoginT));
  end;
end;

{
  procedure       : GetObjectConnection
  service type    : workstation infos
  Netware version : NW v2.0 - v4.x

  Desc : Returns the connection-no of all
         logged in stations of the object
 }

procedure GetObjectConnection(var CList  : tObjConnList;
                              ObjectTyp  : Word;
                              ObjectName : tObjName);

var
  NovRegs       : Word;

  Request       :
  record
    Size        : Word; { Length of Request                     }
    SubF        : Byte; { Subfunction                           }
    ObjTyp      : Word; { Object Typ                            }
    OName       : String[48]; { Objects Name                    }
  end;

  Reply         :
  record
    Size        : Word;    { Length of Reply                            }
    List        : array[1..101] of Byte;
                  { Number of Connections and Connection List  }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  FillChar(Reply, SizeOf(Reply), 0);
  with Request do
  begin
    Size   := SizeOf(Request) -2;
    SubF   := $15;
    ObjTyp := Swap(ObjectTyp);
    OName  := StupCase(ObjectName);
  end;
  Reply.Size := SizeOf(Reply) -2;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  if Lo(NovRegs) = neSuccessfull then
    Move(Reply.List, CList, SizeOf(Reply.List))
  else
    FillChar(Clist, SizeOf(Clist), 0);
end;

{
  procedure       : GetConnectionOpenFiles
  service type    : workstation infos
  Netware version : NW v3.x, v4.x

  Desc : Get's the open files by a station

  Errors : - neSuccessfull
           - neNoConsoleOperator
 }

function GetConnectionOpenFiles(var OpenFiles : tOpenFiles;
                                Conn : Byte):Byte;

var
  NovRegs       : Word;
  Reply         : tOpenFiles absolute OpenFiles;

  Request       :
  record
    Size        : Word; { Length of request    }
    SubF        : Byte; { Subfunction          }
    ConnNo      : Word; { connection number    }
    LastRecord  : Word; { last record seen     }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with Request do
  begin
    Size       := SizeOf(Request) -2;
    SubF       := $EB;
    ConnNo     := Conn;
    LastRecord := OpenFiles.NextReqRecord;
  end;
  NovRegs := $F217;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetConnectionOpenFiles := Lo(NovRegs);
end;

{
  procedure       : GetConnectionsSemaphore
  service type    : workstation infos
  Netware version : NW v2.0 - v4.x

  Desc : Get's info about an connections activ
         semaphores

  Errors : - neSuccessfull
           - neNoConsoleOperator
 }

function GetConnectionSemaphore(var Semaphores : tSemaphores;
                                Conn : Byte):Byte;

var
  NovRegs       : Word;
  Marker,
  i             : Byte;

  Request       :
  record
    Size        : Word; { Length of request    }
    SubF        : Byte; { Subfunction          }
    ConnNo      : Word; { connection number    }
    LastRecord  : Word; { last record seen     }
  end;

  Reply         :
  record
    NextReq     : Word; { Next request record   }
    NoOfRec     : Word; { No of records         }
    Buffer      : array[1..508] of Byte;
                  { 1   Word open count
                    1   Word semaphore value
                    1   Word task number
                    1   Byte semaphore name length
                    N   Bytes semaphore name
                    repeated NoOfRec times      }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with Request do
  begin
    Size       := SizeOf(Request) -2;
    SubF       := $F1;
    ConnNo     := Conn;
    LastRecord := Semaphores.NextReqRecord;
  end;
  NovRegs := $F217;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  if Lo(NovRegs) = neSuccessfull then
  begin
    Semaphores.NextReqRecord := Reply.NextReq;
    Semaphores.NoOfRecords   := Reply.NoOfRec;
    Marker := 1;
    for i := 1 to Reply.NoOfRec do
    begin
      Move(Reply.Buffer[Marker], Semaphores.SemaphoreInfoRecs[i],
           Ord(Reply.Buffer[Marker + 6]) + 7);
      Inc(Marker, Ord(Reply.Buffer[Marker + 6] + 7));
    end;
  end;
  GetConnectionSemaphore := Lo(NovRegs);
end;

{
  procedure       : GetConnectionTaskInfo
  service type    : workstation infos
  Netware version : NW v3.x, 4.x

  Desc : Get's info about an connections
         tasks

  Errors : - neSuccessfull
           - neNoConsoleOperator
           - neBadStationNumber
 }

function GetConnectionTaskInfo(var TaskInfo : tTaskInfo;
                               Conn : Byte):Byte;

var
  NovRegs       : Word;
  Marker,
  NoOfRecs,
  i             : Byte;

  Request       :
  record
    Size        : Word; { Length of request    }
    SubF        : Byte; { Subfunction          }
    ConnNo      : Word; { connection number    }
  end;

  Reply         :
  record
    LockStat    : Byte; { Conn. lock status     }
    Buffer      : array[1..509] of Byte;
                  { N   Bytes structure
                    -------------------------
                    1   Byte No of records
                    1   Byte task number
                    3   Byte task
                    1   Byte task state
                    repeated NoOfRec times      }
  end;

  {--- Task info structures ---}

  LockStatus1          :
  record
    WaitingTaskNo      : Word;     { Waiting task number }
    BeginAdress        : LongInt;  { Begin adress        }
    EndAdress          : LongInt;  { End adress          }
    VolumeNo           : Byte;     { Volume no           }
    Reserved           : LongInt;  { Reserved            }
    NameSpace          : Byte;     { Name space          }
    FileName           : String;   { File name           }
  end;

  LockStatus2          :
  record
    WaitingTaskNo      : Word;     { Waiting task number }
    VolumeNo           : Byte;     { Volume no           }
    DirectoryEntry     : LongInt;  { Directory entry     }
    NameSpace          : Byte;     { Name space          }
    FileName           : String;   { File name           }
  end;

  LockStatus34         :
  record
    WaitingTaskNo      : Word;     { Waiting task number }
    RecordName         : String;   { Record name         }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with Request do
  begin
    Size       := SizeOf(Request) -2;
    SubF       := $EA;
    ConnNo     := Conn;
  end;
  NovRegs := $F217;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  if Lo(NovRegs) = neSuccessfull then
  begin
    Marker := 1;
    TaskInfo.ConLockStatus := Reply.LockStat;
    FillChar(TaskInfo.StatusInformation,
             SizeOf(TaskInfo.StatusInformation), 0);
    case Reply.LockStat of
      0     : { Lock status 0 = no informations }
      begin
      end;
      1     : { Lock status 1 = Info about physical record locking }
      begin
        Move(Reply.Buffer[Marker], LockStatus1, 16 + Reply.Buffer[17]);
        Inc(Marker, 16 + Reply.Buffer[17]);
        with TaskInfo.StatusInformation do
        begin
          WaitingTaskNo      := LockStatus1.WaitingTaskNo;
          BeginAdress        := LockStatus1.BeginAdress;
          EndAdress          := LockStatus1.EndAdress;
          VolumeNo           := LockStatus1.VolumeNo;
          NameSpace          := LockStatus1.NameSpace;
          FileName           := LockStatus1.FileName;
        end;
      end;
      2     : { Lock status 2 = Info about file locking }
      begin
        Move(Reply.Buffer[Marker], LockStatus1, 8 + Reply.Buffer[9]);
        Inc(Marker, 8 + Reply.Buffer[9]);
        with TaskInfo.StatusInformation do
        begin
          WaitingTaskNo      := LockStatus2.WaitingTaskNo;
          VolumeNo           := LockStatus2.VolumeNo;
          DirectoryEntry     := LockStatus2.DirectoryEntry;
          NameSpace          := LockStatus2.NameSpace;
          FileName           := LockStatus2.FileName;
        end;
      end;
      3,4   : { Lock status 3 = Info about logical locking
                Lock status 4 = Info about semaphore lock }
      begin
        Move(Reply.Buffer[Marker], LockStatus1, 2 + Reply.Buffer[3]);
        Inc(Marker, 2 + Reply.Buffer[3]);
        with TaskInfo.StatusInformation do
        begin
          WaitingTaskNo      := LockStatus34.WaitingTaskNo;
          RecordName         := LockStatus34.RecordName;
        end;
      end;
    end; { end case }

    NoOfRecs := Reply.Buffer[Marker];
    Inc(Marker);
    TaskInfo.NoOfRecords := NoOfRecs;

    for i := 1 to NoOfRecs do
    begin
      Move(Reply.Buffer[Marker], TaskInfo.TaskInfos[i], 6);
      Inc(Marker, 6);
    end;
  end;
  GetConnectionTaskInfo := Lo(NovRegs);
end;

{
  procedure       : GetConnectionUsingAFile
  service type    : workstation infos
  Netware version : NW v2.0 - v4.x

  Desc : Get's the connections who are using
         an file

  Errors : - neSuccessfull
           - neNoConsoleOperator
 }

function GetConnectionUsingAFile(var UsageInfo : tFileUsageInfo;
                                 ForkType : Byte;
                                 VolumeNo : Byte;
                                 FileEntryId : LongInt):Byte;

var
  NovRegs       : Word;
  Reply         : tFileUsageInfo absolute UsageInfo;

  Request       :
  record
    Size        : Word;    { Length of request    }
    SubF        : Byte;    { Subfunction          }
    Fork        : Byte;    { Fork type            }
    VolNo       : Byte;    { Volume no            }
    EntryId     : LongInt; { File entry id        }
    LastRec     : Word;    { Last record seen     }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with Request do
  begin
    Size       := SizeOf(Request) -2;
    SubF       := $EC;
    Fork       := ForkType;
    VolNo      := VolumeNo;
    EntryId    := FileEntryId;
    LastRec    := UsageInfo.NextReqRecord;
  end;
  NovRegs := $F217;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  GetConnectionUsingAFile := Lo(NovRegs);
end;

{
  procedure       : GetInternetAdress
  service type    : workstation infos
  Netware version : NW v2.0 - v4.x

  Desc : Get's the internet-adress of the
         station
 }

procedure GetInternetAddress(ConnNo            : Byte;
                             var NodeAddress   : tPhyNodeAddress;
                             var NetworkNumber : LongInt;
                             var SocketNumber  : Word);

var
  NovRegs   : Word;

  Request   :
  record
    Size    : Word; { Length of Request                     }
    SubF    : Byte; { Subfunction                           }
    Conn    : Byte; { Connection Number                     }
  end;

  Reply         :
  record
    Size        : Word;            { Length of Reply                }
    NetworkNo   : LongInt;         { Network Number                 }
    PhyAddress  : tPhyNodeAddress; { Physical Node Address          }
    SocketNo    : Word;            { Socket Number                  }
  end;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with Request do
  begin
    Size  := SizeOf(Request) -2;
    SubF  := $13;
    Conn  := ConnNo;
  end;
  Reply.Size := SizeOf(Reply) -2;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  if Lo(NovRegs) <> neSuccessfull then
    FillChar(Reply, SizeOf(Reply), 0);
  with Reply do
  begin
    SwapNodeAddress(PhyAddress);
    NodeAddress   := PhyAddress;
    NetworkNumber := SwapLongInt(NetworkNo);
    SocketNumber  := Swap(SocketNo);
  end;
end;

{
  procedure       : GetShellVersion
  service type    : shell functions
  Netware version : NW v2.0 - v4.x

  Desc : Returns various information about
         the Netware-shell
 }

procedure GetShellVersion(var Shell : tShellInfo);

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $EA;
    AL := $00;
  end;
  CallIntr(NovRegs);
  with Shell, NovRegs do
  begin
    DOSOperatingSystem := (AH = $00);
    HardwareType       := AL;
    ShellMajorVer      := BH;
    ShellMinorVer      := BL;
    ShellType          := CH;
    ShellRevision      := CL;
  end;
end;

{
  procedure       : ShellTimerIntrCheck
  service type    : shell functions
  Netware version : NW v2.x - vx.x
 }

procedure ShellTimerIntrCheck(Enable : boolean);

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $DE;
  if Enable then
    NovRegs.DL := $05
  else
    NovRegs.DL := $06;
  CallIntr(NovRegs);
end;

{
  function        : SetNWErrorMode
  service type    : shell functions
  Netware version : NW v2.0 - v4.x

  Desc : Set's the error-handling mode for the
         Netware-shell file handling

        $00 : Default error-mode
              (Abort, Retry, Fail)
        $01 : Shell doesn't call Int 24 but
              returns the error-code for
              all file operations in register AL
        $02 : Like mode $01 but not for all
              error-codes

        returns the previous mode
 }

function SetNWErrorMode(ErrorMode : Byte):Byte;

var
  NovRegs       : tRegister;

begin
  { if the error-mode is greater than 2
    return the given error-mode and exit }
  if ErrorMode > 2 then
  begin
    SetNWErrorMode := ErrorMode;
    exit;
  end;
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $DD;
    DL := ErrorMode;
  end;
  CallIntr(NovRegs);
  SetNWErrorMode := NovRegs.AL;
end;

{
  function        : ServerAttach
  service type    : server functions
  Netware version : NW v2.x - vx.x

  Errors : - neSuccessfull
           - neAlreadyAttToServer
           - neNoFreeConnSlots
           - neNoMoreServerSlots
           - neUnknownFileServer
           - neBinderyLocked
           - neNoResponseFromServer
 }

function ServerAttach(Attachfunction : Byte;
                      Attachment : Byte):byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AH := $F1;
    AL := Attachfunction;
    DL := Attachment;
  end;
  CallIntr(NovRegs);
  ServerAttach := NovRegs.AL;
end;

{
  function        : AttachToServer
  service type    : server functions
  Netware version : NW v2.0 - v4.x

  Desc : Attaches the station to a file server

  Errors : - neSuccessfull
           - neAlreadyAttToServer
           - neNoFreeConnSlots
           - neNoMoreServerSlots
           - neUnknownFileServer
           - neBinderyLocked
           - neNoResponseFromServer
 }

function AttachToServer(ServerConn : Byte):byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $F100;
    DL := ServerConn;
  end;
  CallIntr(NovRegs);
  AttachToServer := NovRegs.AL;
end;

{
  function        : DetachServer
  service type    : server functions
  Netware version : NW v2.0 - v4.x

  Desc : Detaches the station from the server

  Errors : - neSuccessfull
           - neConnectionNotExist
 }

function DetachServer(ServerConn : Byte):byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $F101;
    DL := ServerConn;
  end;
  CallIntr(NovRegs);
  DetachServer := NovRegs.AL;
end;

{
  function        : EnterLoginArea
  service type    : server functions
  Netware version : NW v2.0 - v4.x

  Desc : Changes the login directory for
         a station

  Errors : - neSuccessfull
 }

function EnterLoginArea(LocalDrives : Byte;
                        SubDir      : String):Byte;

var
  NovRegs       : Word;
  Reply         : Word;

  Request       :
  record
    Size        : Word;         { size of request       }
    SubF        : Byte;         { Subfuntion            }
    Local       : Byte;         { No of local drives    }
    LoginDir    : String;       { New login directory   }
  end;

begin
  Reply := 0;
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs := $F101;
  with Request do
  begin
    SubF        := $0A;
    Local       := LocalDrives;
    LoginDir    := SubDir;
    Size        := SizeOf(Request) -2;
  end;
  ReqCallIntr(Request, Reply, SizeOf(Request), SizeOf(Reply), NovRegs);
  EnterLoginArea := Lo(NovRegs);
end;

{
  procedure       : SystemLogOut
  service type    : server functions
  Netware version : NW v2.0 - v4.x

  Desc : Logout from all file server
 }

procedure SystemLogOut;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AH := $D7;
  CallIntr(NovRegs);
end;

{
  procedure       : LogOutFromServer
  service type    : server functions
  Netware version : NW v2.0 - v4.x

  Desc : Logout from file server
 }

procedure LogOutFromServer(ServerConn : Byte);

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $F102;
  NovRegs.DL := ServerConn;
  CallIntr(NovRegs);
end;

{
  function        : UserLogin
  service type    : server functions
  Netware version : NW v2.0 - v4.x

  Desc : Log's the object into the default
         file server. Doesn't work with
         encyrpted passwords !

  Errors : - neSuccessfull
 }

function LoginToFileServer(ObjectTyp : Word;
                           LoginName,
                           PassWord : String):Byte;

var
  NovRegs       : Word;

  Request       :
  record
    Size        : Word;                  { Request length      }
    SubF        : Byte;                  { Subfunction         }
    ObjTyp      : Word;                  { Object-typ          }
    ObjName     : String[48];            { Object-name         }
    Pwd         : String;                { Password            }
  end;

  Reply       : Word;

begin
  Reply := 0;
  FillChar(Request, SizeOf(Request), 0);
  with Request do
  begin
    SubF       := $14;
    ObjTyp     := Swap(ObjectTyp);
    ObjName    := LoginName;
    Pwd        := Password;
    Size       := SizeOf(Request) - 2;
  end;
  NovRegs := $E300;
  ReqCallIntr(Request, Reply, Request.Size + 2, SizeOf(Reply), NovRegs);
  LoginToFileServer := Lo(NovRegs);
end;

{
  function        : GetApplicationTreshold
  service type    : Transaction Tracking System
  Netware version : NW v2.0 - v4.x

  Desc : Gets the max. value for implicit
         Transactions
 }

function GetApplicationTreshold(var MaxLogLocks,
                                MaxPhyLocks : Byte):boolean;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $C705;
  CallIntr(NovRegs);
  GetApplicationTreshold := (NovRegs.Al = neSuccessfull);
  MaxLogLocks := NovRegs.CL;
  MaxPhyLocks := NovRegs.CH;
end;

{
  function        : SetApplicationTreshold
  service type    : Transaction Tracking System
  Netware version : NW v2.0 - v4.x

  Desc : Sets the max. value for implicit
         Transaction
 }

function SetApplicationTreshold(MaxLogLocks,
                                MaxPhyLocks : Byte):boolean;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $C706;
    CL := MaxLogLocks;
    CH := MaxPhyLocks;
  end;
  CallIntr(NovRegs);
  SetApplicationTreshold := (NovRegs.Al = neSuccessfull);
end;

{
  function        : GetWSThreshold
  service type    : Transaction Tracking System
  Netware version : NW v2.0 - v4.x

  Desc : Gets the max. value for implicit
         Transactions of the station
 }

function GetWSTreshold(var MaxLogLocks,
                       MaxPhyLocks : Byte):boolean;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $C707;
  CallIntr(NovRegs);
  GetWSTreshold := (NovRegs.Al = neSuccessfull);
  MaxLogLocks := NovRegs.CL;
  MaxPhyLocks := NovRegs.CH;
end;

{
  function        : SetWSThreshold
  service type    : Transaction Tracking System
  Netware version : NW v2.0 - v4.x

  Desc : Sets the max. value for implicit
         Transactions of the station
 }

function SetWSTreshold(MaxLogLocks,
                       MaxPhyLocks : Byte):boolean;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  with NovRegs do
  begin
    AX := $C708;
    CL := MaxLogLocks;
    CH := MaxPhyLocks;
  end;
  CallIntr(NovRegs);
  SetWSTreshold := (NovRegs.Al = neSuccessfull);
end;

{
  function        : BeginTransaction
  service type    : Transaction Tracking System
  Netware version : NW v2.0 - v4.x

  Desc : Starts an Transaction

  Errors : - neSuccessfull
           - neOutOfDynWorkSpace
           - neImplicitTTSactive
           - neExpTTSactive
 }

function BeginTransaction:byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $C700;
  CallIntr(NovRegs);
  BeginTransaction := NovRegs.AL;
end;

{
  function        : EndTransaction
  service type    : Transaction Tracking System
  Netware version : NW v2.0 - v4.x

  Desc : Ends an Transaction

  Errors : - neSuccessfull
           - neTTSDisabled
           - neTTSEndRecordLock
           - neNoExpTTSactive
 }

function EndTransaction(var TransactionNo : LongInt):byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $C701;
  CallIntr(NovRegs);
  EndTransaction := NovRegs.AL;
  tHiLoWord(TransactionNo).Hi := NovRegs.CX;
  tHiLoWord(TransactionNo).Lo := NovRegs.DX;
end;

{
  function        : AbortTransaction
  service type    : Transaction Tracking System
  Netware version : NW v2.0 - v4.x

  Desc : Aborts an Transaction

  Errors : - neSuccessfull
           - neTTSDisabled
           - neTTSEndRecordLock
           - neNoExpTTSactive
 }

function AbortTransaction:byte;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $C703;
  CallIntr(NovRegs);
  AbortTransaction := NovRegs.AL;
end;

{
  function        : Transaction Status
  service type    : Transaction Tracking System
  Netware version : NW v2.0 - v4.x

  Desc : Checks if the current transaction
         is written to disk
 }

function TransactionStatus(var TransactionNo : LongInt):boolean;

var
  NovRegs       : tRegister;

begin
  FillChar(NovRegs, SizeOf(NovRegs), 0);
  NovRegs.AX := $C704;
  CallIntr(NovRegs);
  TransactionStatus := (NovRegs.AL <> $FF);
  tHiLoWord(TransactionNo).Hi := NovRegs.CX;
  tHiLoWord(TransactionNo).Lo := NovRegs.DX;
end;

{------------------------ end of unit ------------------------}

end.
