#
#  A sample Makefile for the NetWare loadable modules making
#  on Linux and Win32 (Cygwin) platforms with the GNU utilities
#
#  Written by Pavel Novy <novy@feld.cvut.cz>
#  Version 1.0.21 (2001-12-23)
#

NLMSTUFF      := $(NLMSTUFF)
NDKLIB         = $(LIBC)
LIBDB          = ../..
GNU-BUILD      = $(LIBDB)/build/netware-GNU

TARGET         = libdb
BUILD          =
MAKEFILE       = $(TARGET).Makefile
CFLAGS         = -include $(GNU-BUILD)/pre_nw.h #-save-temps #-v
DEFINES        = -DN_PLAT_NLM
INCLUDES       = -I$(GNU-BUILD) -I$(LIBDB)/include -I$(LIBDB)/include_auto
LIBRARIES      =
SOURCE_DEP     = $(GNU-BUILD)/pre_nw.h
TARGET_DEP     = $(GNU-BUILD)/$(TARGET).imp
#$(LIBDB)/db185/db185.c 
#		$(LIBDB)/clib/strcasecmp.c
#		$(LIBDB)/mutex/mut_fcntl.c
#		$(LIBDB)/mutex/mut_pthread.c
#		$(LIBDB)/mutex/uts4_cc.c

SOURCES        = $(LIBDB)/os/os_map.c \
		 $(LIBDB)/os/os_sleep.c \
		 $(LIBDB)/btree/bt_compare.c \
		 $(LIBDB)/btree/bt_conv.c \
		 $(LIBDB)/btree/bt_curadj.c \
		 $(LIBDB)/btree/bt_cursor.c \
		 $(LIBDB)/btree/bt_delete.c \
		 $(LIBDB)/btree/bt_method.c \
		 $(LIBDB)/btree/bt_open.c \
		 $(LIBDB)/btree/bt_put.c \
		 $(LIBDB)/btree/bt_rec.c \
		 $(LIBDB)/btree/bt_reclaim.c \
		 $(LIBDB)/btree/bt_recno.c \
		 $(LIBDB)/btree/bt_rsearch.c \
		 $(LIBDB)/btree/bt_search.c \
		 $(LIBDB)/btree/bt_split.c \
		 $(LIBDB)/btree/bt_stat.c \
		 $(LIBDB)/btree/bt_upgrade.c \
		 $(LIBDB)/btree/bt_verify.c \
		 $(LIBDB)/btree/btree_auto.c \
		 $(LIBDB)/db/crdel_auto.c \
		 $(LIBDB)/db/crdel_rec.c \
		 $(LIBDB)/db/db.c \
		 $(LIBDB)/db/db_am.c \
		 $(LIBDB)/db/db_auto.c \
		 $(LIBDB)/common/db_byteorder.c \
		 $(LIBDB)/db/db_cam.c \
		 $(LIBDB)/db/db_conv.c \
		 $(LIBDB)/db/db_dispatch.c \
		 $(LIBDB)/db/db_dup.c \
		 $(LIBDB)/clib/snprintf.c \
		 $(LIBDB)/clib/vsnprintf.c \
		 $(LIBDB)/common/db_err.c \
		 $(LIBDB)/common/db_getlong.c \
		 $(LIBDB)/db/db_iface.c \
		 $(LIBDB)/db/db_join.c \
		 $(LIBDB)/common/db_log2.c \
		 $(LIBDB)/db/db_meta.c \
		 $(LIBDB)/db/db_method.c \
		 $(LIBDB)/db/db_overflow.c \
		 $(LIBDB)/db/db_pr.c \
		 $(LIBDB)/db/db_rec.c \
		 $(LIBDB)/db/db_reclaim.c \
		 $(LIBDB)/db/db_ret.c \
		 $(LIBDB)/env/db_salloc.c \
		 $(LIBDB)/env/db_shash.c \
		 $(LIBDB)/db/db_upg.c \
		 $(LIBDB)/db/db_upg_opd.c \
		 $(LIBDB)/db/db_vrfy.c \
		 $(LIBDB)/db/db_vrfyutil.c \
		 $(LIBDB)/dbm/dbm.c \
		 $(LIBDB)/env/env_method.c \
		 $(LIBDB)/env/env_open.c \
		 $(LIBDB)/env/env_recover.c \
		 $(LIBDB)/env/env_region.c \
		 $(LIBDB)/hash/hash.c \
		 $(LIBDB)/hash/hash_auto.c \
		 $(LIBDB)/hash/hash_conv.c \
		 $(LIBDB)/hash/hash_dup.c \
		 $(LIBDB)/hash/hash_func.c \
		 $(LIBDB)/hash/hash_meta.c \
		 $(LIBDB)/hash/hash_method.c \
		 $(LIBDB)/hash/hash_page.c \
		 $(LIBDB)/hash/hash_rec.c \
		 $(LIBDB)/hash/hash_reclaim.c \
		 $(LIBDB)/hash/hash_stat.c \
		 $(LIBDB)/hash/hash_upgrade.c \
		 $(LIBDB)/hash/hash_verify.c \
		 $(LIBDB)/hsearch/hsearch.c \
		 $(LIBDB)/lock/lock.c \
		 $(LIBDB)/lock/lock_deadlock.c \
		 $(LIBDB)/lock/lock_method.c \
		 $(LIBDB)/lock/lock_region.c \
		 $(LIBDB)/lock/lock_stat.c \
		 $(LIBDB)/lock/lock_util.c \
		 $(LIBDB)/log/log.c \
		 $(LIBDB)/log/log_archive.c \
		 $(LIBDB)/log/log_auto.c \
		 $(LIBDB)/log/log_compare.c \
		 $(LIBDB)/log/log_findckp.c \
		 $(LIBDB)/log/log_get.c \
		 $(LIBDB)/log/log_method.c \
		 $(LIBDB)/log/log_put.c \
		 $(LIBDB)/log/log_rec.c \
		 $(LIBDB)/log/log_register.c \
		 $(LIBDB)/mp/mp_alloc.c \
		 $(LIBDB)/mp/mp_bh.c \
		 $(LIBDB)/mp/mp_fget.c \
		 $(LIBDB)/mp/mp_fopen.c \
		 $(LIBDB)/mp/mp_fput.c \
		 $(LIBDB)/mp/mp_fset.c \
		 $(LIBDB)/mp/mp_method.c \
		 $(LIBDB)/mp/mp_region.c \
		 $(LIBDB)/mp/mp_register.c \
		 $(LIBDB)/mp/mp_stat.c \
		 $(LIBDB)/mp/mp_sync.c \
		 $(LIBDB)/mp/mp_trickle.c \
		 $(LIBDB)/mutex/mut_tas.c \
		 $(LIBDB)/mutex/mutex.c \
		 $(LIBDB)/os/os_abs.c \
		 $(LIBDB)/os/os_alloc.c \
		 $(LIBDB)/os/os_dir.c \
		 $(LIBDB)/os/os_errno.c \
		 $(LIBDB)/os/os_fid.c \
		 $(LIBDB)/os/os_finit.c \
		 $(LIBDB)/os/os_fsync.c \
		 $(LIBDB)/os/os_handle.c \
		 $(LIBDB)/os/os_method.c \
		 $(LIBDB)/os/os_oflags.c \
		 $(LIBDB)/os/os_open.c \
		 $(LIBDB)/os/os_region.c \
		 $(LIBDB)/os/os_rename.c \
		 $(LIBDB)/os/os_root.c \
		 $(LIBDB)/os/os_rpath.c \
		 $(LIBDB)/os/os_rw.c \
		 $(LIBDB)/os/os_seek.c \
		 $(LIBDB)/os/os_spin.c \
		 $(LIBDB)/os/os_stat.c \
		 $(LIBDB)/os/os_tmpdir.c \
		 $(LIBDB)/os/os_unlink.c \
		 $(LIBDB)/qam/qam.c \
		 $(LIBDB)/qam/qam_auto.c \
		 $(LIBDB)/qam/qam_conv.c \
		 $(LIBDB)/qam/qam_files.c \
		 $(LIBDB)/qam/qam_method.c \
		 $(LIBDB)/qam/qam_open.c \
		 $(LIBDB)/qam/qam_rec.c \
		 $(LIBDB)/qam/qam_stat.c \
		 $(LIBDB)/qam/qam_upgrade.c \
		 $(LIBDB)/qam/qam_verify.c \
		 $(LIBDB)/txn/txn.c \
		 $(LIBDB)/txn/txn_auto.c \
		 $(LIBDB)/txn/txn_rec.c \
		 $(LIBDB)/txn/txn_recover.c \
		 $(LIBDB)/txn/txn_region.c \
		 $(LIBDB)/txn/txn_stat.c \
		 $(LIBDB)/common/util_log.c \
		 $(LIBDB)/common/util_sig.c \
		 $(LIBDB)/xa/xa.c \
		 $(LIBDB)/xa/xa_db.c \
		 $(LIBDB)/xa/xa_map.c
		 
DESCRIPTION   = Berkeley DB 3.3.11 [$(NLMSTUFF_SIGN)]
VERSION       = 3,3,11
DATE          =
COPYRIGHT     = Copyright \(c\) 1990-2001 Sleepycat Software
THREADNAME    =
SCREENNAME    =

TYPE          = nlm# nlm | lan | dsk | nam | a
OPTIONS       = #pseudopreemption#debug multiple os_domain pseudopreemption reentrant synchronize
FLAG_ON       = 64#64 for autounload
XDCDATA       =
START         =# _Prelude# _libc_start
EXIT          =# _Stop# _libc_stop
CHECK         =
STACK         =
PRELUDE       = $(NLMSTUFF)/imports/nopre0.o
EXPORTS       = @$(GNU-BUILD)/$(TARGET).imp
IMPORTS       =
EXPORTFILES   =
IMPORTFILES   = libc
MODULES       = libc

include $(NLMSTUFF)/Makefile.GNU
