// PROCESS.C -- Miscellaneous routines for LANTEST
// Copyright (c) by Allen Brunson  version 1.00  06/30/94

#include <conio.h>     // getch()
#include <dos.h>       // _osmajor for Borland compilers
#include <stdio.h>     // sprintf()
#include <stdlib.h>    // _osmajor for Microsoft compilers
#include "lantest.h"   // LANTEST-specific defines


/****************************************************************************/
/*                                                                          */
/***  demoStart()                                                         ***/
/*                                                                          */
/****************************************************************************

This procedure starts up the various subsystems and displays opening
messages.                                                                   */

void demoStart(void)                               // Begin demoStart()
  {
    vidStart();                                    // Start video

    message("LANTEST -- Test program for LANLIB"); // Display opening
    message("Version 1.00  06/30/94");             //  messages
    message("Copyright (c) 1994 by Allen Brunson."
     "  All rights reserved.");
    message(emptyStr);

    if (_osmajor < 3)                              // Check DOS version
      {
        message("LANLIB requires DOS version 3.0 " // If it's too old,
         "or later.");                             //  display message
        return;                                    //  and return
      }

    message("Press F1 for help");                  // Display help message
    message(emptyStr);                             //  reminder

    nStart();                                      // Start up net stuff
  }                                                // End demoStart()


/****************************************************************************/
/*                                                                          */
/***  demoStop()                                                          ***/
/*                                                                          */
/****************************************************************************

This procedure shuts down the various subsystems.                           */

void demoStop(void)                                // Begin demoStop()
  {
    nStop();                                       // Shut down net stuff

    message(emptyStr);                             // Print a blank line
    message(                                       // Display final message
     "Program finished.  Press a key to exit.");
    getch();                                       // Get a key

    vidStop();                                     // Reset screen
  }


/****************************************************************************/
/*                                                                          */
/***  err()                                                               ***/
/*                                                                          */
/****************************************************************************

This procedure displays an error message for each of the possible LANLIB
errors.                                                                     */

word err(word error)                               // Begin err()
  {
    switch (error)                                 // Decision on error
      {
        case ipxeNOERR:                            // No error
          return error;                            // Return

        case TRUE:                                 // TRUE
          return error;                            // Return

        case ipxeNOIPX:                            // IPX not loaded
          message("IPX driver not loaded.");
          return error;

        case ipxeIPXNOTSTARTED:                    // ipxStart() not called
          message("IPX not started.");
          return error;

        case ipxeIPXSTARTED:                       // ipxStart() called twice
          message("IPX is already started.");
          return error;

        case ipxeBADCOMMPARMS:                     // Bad ipxStart() parms
          message("Improper communication parameters.");
          return error;

        case ipxeMEMTOOSMALL:                      // Memory block too small
          message("IPX memory block is too small.");
          return error;

        case ipxeMEMABOVE64K:                      // More than 64k required
          message("Memory required is above 64k.");
          return error;

        case ipxeNETOVERFLOW:                      // Network overflow
          message("Found more networks than IPXNETCNT.");
          return error;

        case ipxeNOPATHFOUND:                      // Can't find this address
          message("Path not found to specified address.");
          return error;

        case ipxeROUTEFINDABORT:                   // Route find aborted
          message("Route find aborted.");
          return error;

        case ipxeSOCKETTABLEFULL:                  // Socket table full
          message("No free IPX sockets.");
          return error;

        case ipxeSOCKETOPEN:                       // Socket already open
          message("Selected socket is in use.");
          return error;

        case ipxeSOCKETNOTOPEN:                    // Socket not open
          message("Socket isn't open.");
          return error;

        case ipxeNOFREESENDECB:                    // No free send ECBs
          message("No free send ECBs.");
          return error;

        case ipxeRECVCANCEL:                       // Receive event canceled
          message("Receive event was canceled.");
          return error;

        case ipxeSENDCANCEL:                       // Send was canceled
          message("Send event was canceled.");
          return error;

        case ipxeRECVPKTTOOBIG:                    // Received packet too big
          message("Received packet was too big for buffer.");
          return error;

        case ipxeSENDPKTBAD:                       // Sent packet bad
          message("Sent packet was malformed.");
          return error;

        case ipxeSENDBADROUTE:                     // Can't send packet
          message("Couldn't deliver packet.");
          return error;

        case ipxeSENDNETFAIL:                      // Hardware failure
          message("Hardware or network failure!");
          return error;

        default:                                   // Unknown error
          sprintf(str, "Unknown error %02Xh.", error);
          message(str);
          return error;
      }
  }                                                // End err()
