#
#  A sample Makefile for the NetWare loadable modules making
#  on Linux and Win32 (Cygwin) platforms with the GNU utilities
#
#  Written by Pavel Novy <novy@feld.cvut.cz>
#  Version 1.0.21 (2001-12-23)
#

NLMSTUFF      := $(NLMSTUFF)
NDKLIB         = $(LIBC)
LIBPNG         = ../..
GNU-BUILD      = $(LIBPNG)/build/netware-GNU
ZLIB           = ../../../zlib-1.1.3

TARGET         = libpng
BUILD          =
MAKEFILE       = $(TARGET).Makefile
CFLAGS         = #-save-temps #-v
DEFINES        = -DN_PLAT_NLM
INCLUDES       = -I$(GNU-BUILD) -I$(LIBPNG) -I$(ZLIB)
LIBRARIES      =
SOURCE_DEP     =
TARGET_DEP     = $(GNU-BUILD)/$(TARGET).imp $(ZLIB)/build/netware-GNU/zlib.imp
SOURCES        = $(LIBPNG)/png.c \
		 $(LIBPNG)/pngerror.c \
		 $(LIBPNG)/pngget.c \
		 $(LIBPNG)/pngmem.c \
		 $(LIBPNG)/pngpread.c \
		 $(LIBPNG)/pngread.c \
		 $(LIBPNG)/pngrio.c \
		 $(LIBPNG)/pngrtran.c \
		 $(LIBPNG)/pngrutil.c \
		 $(LIBPNG)/pngset.c \
		 $(LIBPNG)/pngtest.c \
		 $(LIBPNG)/pngtrans.c \
		 $(LIBPNG)/pngwio.c \
		 $(LIBPNG)/pngwrite.c \
		 $(LIBPNG)/pngwtran.c \
		 $(LIBPNG)/pngwutil.c

DESCRIPTION    = libpng 1.2.1 [$(NLMSTUFF_SIGN)]
VERSION        = 1,2,1
DATE           =
COPYRIGHT      = Copyright \(c\) 1998-2001 Glenn Randers-Pehrson
THREADNAME     = $(TARGET)_p
SCREENNAME     = $(DESCRIPTION)#NONE

TYPE           = nlm# nlm | lan | dsk | nam | a
OPTIONS        = #pseudopreemption#debug multiple os_domain pseudopreemption reentrant synchronize
FLAG_ON        = 64#64 for autounload
XDCDATA        =
START          =# _Prelude
EXIT           =# _Stop
CHECK          =
STACK          = 8192
PRELUDE        = $(NLMSTUFF)/imports/nopre0.o
EXPORTS        = @$(GNU-BUILD)/$(TARGET).imp
IMPORTS        = @$(ZLIB)/build/netware-GNU/zlib.imp
EXPORTFILES    =
IMPORTFILES    = libc
MODULES        = libc zlib

include $(NLMSTUFF)/Makefile.GNU
