unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, nwlib, nwnds,
  StdCtrls, nwbase;

type
  TwinMain = class(TForm)
    NWBase1: TNWBase;
    Memo1: TMemo;
    Button1: TButton;
    Label1: TLabel;
    editFilter: TEdit;
    Label2: TLabel;
    editType: TComboBox;
    editContext: TEdit;
    Label3: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  winMain: TwinMain;

implementation

{$R *.DFM}

procedure TwinMain.Button1Click(Sender: TObject);
var
  startTime : TDateTime ;
  tempList  : TStringList ;
  ntemp     : integer ;
begin
  screen.cursor := crHourglass ;
  startTime := now ;
  ntemp     := 0 ;
  try
    memo1.lines.add(format('%s : %s  -  Start Time: %s',[editType.text,editFilter.text,formatDateTime('hh:nn:ss:zz',startTime)])) ;
    memo1.lines.add('-----------------------------------------------------------------------------------------------------------') ;
    
    // here's the key call:
    tempList := ndsSearch(editContext.text,editType.text,editFilter.text) ;
    
    try
      if (tempList.count > 0) then
        begin
          memo1.lines.addStrings(tempList) ;
          ntemp := tempList.count ;
        end
      else
        memo1.lines.add('Found No Objects of Specified Type!') ;
    finally
      tempList.free ;
    end;
  finally
    memo1.lines.add('-----------------------------------------------------------------------------------------------------------') ;
    memo1.lines.add(format('Found %d Objects.  Elapsed Time: %s',[ntemp,formatDateTime('hh:nn:ss:zz',now-startTime)])) ;
    memo1.lines.add('') ;
    memo1.lines.add('') ;
    screen.cursor := crDefault ;
  end;

end;

end.
