#
# Audcont.pl
#
# This script demonstrates how to get all records from a container
# audit log.
#
# Copyright (c) 1997 Steinar Kleven
#



BEGIN { $| = 1; print "1..5\n"; }
use NDSm;
use NDSm::Audit;

print "ok 1\n";

$Cont = new NDSm;

$Aud = new NDSm::Audit($Cont, "HIST");

$Value = $Aud->Open();
print "Value: $Value\n";

@Filelist = $Aud->GetFileList();

while ($val = pop(@Filelist)) {
    print "$val\n";
}

print "test\n";

$Aud->OpenRecordFile(-1);

@Records = $Aud->ReadRecords();

$i=0;
while ($val = $Records[$i++]) {
    ($date, @vals) = split ("\t", $val);

    print localtime($date) . "-> @vals\n";
 }


__END__
