#
# GetAttr.pl
#
# This script demonstrates how to get selected attribute-values from NDS
# with the perl extension NDSm.
#
# Copyright (c) 1997 Steinar Kleven
#



BEGIN { $| = 1; }
use NDSm::NDSContext;
use NDSm::Buf_T;

$C = new NDSm::NDSContext;

# Buffer for query
$InBuf = new NDSm::Buf_T;

# buffer for reply
$OutBuf = new NDSm::Buf_T;

#Attributes we should fetch
# This example reads the replica information stored in a container object if
# the conainer is root of a partitiom.
@Attributes = ("Replica");

$CHandle = $C->GetHandle();


# We can't do anything if we're not logged on
$Result = $C->IsDSAuthenticated();
if (!$Result){die("You're not logged on, bailing out!!")};

# The container which is a partition root..
$Object = "[root]";


# Alloc and initiate buffer for NDS read operation.
$Result = $InBuf->AllocBuf();
$Result = $InBuf->InitBuf($CHandle, "DSV_READ");


# Alloc Result-buffer.
$Result = $OutBuf->AllocBuf();

# Put attributenames in query-buffer
$i=0;
while ($i < @Attributes){
  $InBuf->PutAttrName($CHandle, $Attributes[$i++])
}

# Read NDS
# If you set $Iter to anything, it should be -1 or 0.
$Iter = $InBuf->Read($CHandle, $Object, "DS_ATTRIBUTE_VALUES", 0, $Iter, $OutBuf);

# Get number of attributes
$AttrCount = $OutBuf->GetAttrCount($CHandle);
print "number of Attributes: $AttrCount\n";
$outer=0;
while ($outer < $AttrCount) {
  ($AttrName, $ValCount, $SyntaxId) = $OutBuf->GetAttrName($CHandle);
  $inner = 0;
  while ($inner < $ValCount)
  {
    $AttrVal = $OutBuf->GetAttrVal($CHandle, $SyntaxId);
    if (defined($AttrVal)){
      print "** Syntax    : $SyntaxId\n";
      print "** $AttrName : $AttrVal\n";}
    $inner++;
  }
  $outer++;
}


__END__

