#
# SetVar.pl
#
# This script demonstrates how to get SET variables from a Netware
# server with the perl extension NDSm. You have to be logged in to the
# server to use this script. You must also have console operator
# rights.
#
# Copyright (c) 1997, 1998 Steinar Kleven
#



BEGIN { $| = 1;}


use NDSm::NWServer;


@Vars = ("Default Tree Name", "Bindery Context", "NDS Trace Filename",
         "Time Zone", "Minimum Directory Cache Buffers");




$ServerName = "NWBETA1";
if (!defined($ServerName)){die("You have to tell me what server to work with\n");}

$Server = new NDSm::NWServer($ServerName);
die("NWServer creation failed") if (!defined($Server));

$Server->Debug(1);

# We need to license the connection because Novell say so.
$Result = $Server->LicenseConn();
if ($Result)
{
  printf ("Error: %X\n", $Result);
  die("You can't license you connection, bailing out!!\n");
}

while(($Var = pop(@Vars)))
{
	$SetValue = $Server->GetSetCommandValue($Var);
   if (defined($SetValue))
   {
     print "SET variable name: $Var\tValue:$SetValue\n";
   }
   else
   {
     $Err = $Server->LastErr();
     printf " GetSetCommandValue( %s ) failed with code %X\n", $Var, $Err;
   }
}

