#
# Stattree.pl
#
# This script demonstrates how to browse through your entire tree with NDSm
#
# Copyright (c) 1997 Steinar Kleven, all rights reserved
#
#	Please adjust the 'require cgi-lib.pl' to 
#  match this scripts relative location to cgi-lib.pl on your system.
#


BEGIN {$| = 1; require "cgi-lib.pl"; print &PrintHeader; }

use strict;
use vars qw($C $Start $Flags %in %Images $ibase @Expanded);

$ibase = '/NDSm-demo/images';

%Images = ('Printer' => "$ibase/Printer.gif",
            'Computer' => "$ibase/Computer.gif",
            'Country' => "$ibase/Country.gif",
				'Group' => "$ibase/Group.gif",
				'NCP Server' => "$ibase/NCP_Server.gif",
				'Organizational Unit' => "$ibase/Organizational_Unit.gif",
				'Print Server' => "$ibase/Print_Server.gif",
				'Profile' => "$ibase/Profile.gif",
				'Queue' => "$ibase/Queue.gif",
				'Template' => "$ibase/Template.gif",
				'Unknown' => "$ibase/Unknown.gif",
				'User' => "$ibase/User.gif",
				'Volume' => "$ibase/Volume.gif",
				'Organization' => "$ibase/Organization.gif",
				'App:Application' => "$ibase/App_Application.gif",
				'Application (Windows 3.x)' => "$ibase/Application_win3.gif");



use NDSm::NDSContext;
use NDSm::Buf_T;



sub MyDie {
   my ($Object, $Msg) = @_;
   my $Err = $Object->LastErr();
   die("$Msg, error $Err");
}



sub IsExpanded {
   my ($Container) = shift;
   for (@Expanded)
   {
#      print "$Container and $_ ->\n";
      if ($_ =~ /^.*$Container(' '|$)/){ return 1; }
   }
   return 0;
}



sub CreateExp {
   my ($expand, $Ctx) = @_;
   my @Args = @Expanded;
   my $i = 0;
   my $done = 0;
   while ($Args[$i] && !$done)
   {
      if ($expand && ($Ctx =~ /^.*$Args[$i]/))
      {
         $Args[$i] = $Ctx; $done=1;
      }
      elsif ($Args[$i] =~ /^.*$Ctx$/)
      {
       $Ctx =~ s/^.*\.|^.*\.{0}//; $done=1;
       $Args[$i] = $Ctx;
      }
      $i++;
   }
   push (@Args, $Ctx) if (!$done);
   @Args = sort (@Args);
   $i=0;
   while ($Args[$i])
   {
      if ($Args[$i] =~ /\$Args[$i+1]/) {$Args[$i] = undef;}
      $i++;
   }
# Some debugging....
#   print "****";
#   for(@Args){print ;} 
#   print "****<P>";
   return join("+", @Args);
}


# This is a recursive method listing number of different objects in each container.
sub ShowExpTree {
   my $StartContainer = shift;
   my $Context = shift;
   my %Objects = ();
   my ($i, $iter, $ObjectName, $CanonName, $ObjectCount, $AttrCount, @ObjInfo, $Image, $NewArg);
   my $Buf = new NDSm::Buf_T;
   my $CHandle = $Context->GetHandle();
	$Context->SetContext("DCK_NAME_CONTEXT", "$StartContainer");

   $Buf->AllocBuf(32768);
   print "<DL>";
   $iter = $Buf->GetConst("NO_MORE_ITERATIONS");
   do
   {
      $iter = $Buf->List($CHandle, "", $iter);
      MyDie($Buf, "List()") if (!defined($iter));
      $ObjectCount = $Buf->GetObjectCount($CHandle);
      MyDie($Buf, "GetObjectCount()") if  (!defined($ObjectCount));

      #Now we can list all objects in this context
      for($i=0; $i < $ObjectCount; $i++) {
         ($ObjectName, $AttrCount, @ObjInfo) = $Buf->GetObjectName($CHandle);
         MyDie($Buf, "GetObjectName()") if (!defined($ObjectName));
         if (!($Image = $Images{$ObjInfo[3]})){$Image = $Images{'Unknown'};}

         $CanonName = $C->CanonicalizeName($ObjectName);
         if ($ObjInfo[0] & $Buf->GetConst("DS_CONTAINER_ENTRY"))
         {
            if (IsExpanded($CanonName))
            {
#               print "$CanonName is expanded\n";
              $NewArg = CreateExp(0, $CanonName); 
              print "\n<DT><A HREF=\"$ENV{'SCRIPT_NAME'}?root=$in{'root'}\&expanded=$NewArg\">";
              print "\n<IMG BORDER=0 SRC=\"$ibase/expanded.gif\"></A>";
              print "\n<IMG SRC=\"$Image\">$ObjectName\n<DD>";
              ShowExpTree("$CanonName", $Context);
				  $Context->SetContext("DCK_NAME_CONTEXT", "$StartContainer");
            }else {
#               print "$CanonName is NOT expanded\n";
              $NewArg = CreateExp(1, $CanonName); 
              print "\n<DT><A HREF=\"$ENV{'SCRIPT_NAME'}?root=$in{'root'}\&expanded=$NewArg\">";
              print "\n<IMG BORDER=0 SRC=\"$ibase/collapsed.gif\"></A>";
              print "\n<IMG SRC=\"$Image\">$ObjectName\n<DD>";
            }
         }else { print "\n<DT><IMG SRC=\"$Image\">$ObjectName\n<DD>"; }
      }
   }while ($iter != -1);
   print "</DL>\n";
}

sub Myend { 
	print &HtmlBot;
	exit();
}


#######
# Execution start here
#######

$C = new NDSm::NDSContext;

print &HtmlTop("NDSm tree example");


# We can't do anything if we're not logged on
if (!$C->IsDSAuthenticated())
{
  print("You're not logged on, bailing out!!") ;
  &Myend();
}


&ReadParse(\*in);

$Start = $in{'root'};
$Start = '[root]' if (!$Start);

@Expanded = split(' ', $in{'expanded'});

# Make sure we always get full name and context
# when we call CanonicalizeName() in StatTree 
# We also want those nice O=, OU= ....

$Flags = $C->GetContext("DCK_FLAGS");
$Flags |= $C->GetConst("DCV_CANONICALIZE_NAMES", 0);
# $Flags &= ~ $C->GetConst("DCV_TYPELESS_NAMES", 0);
$C->SetContext("DCK_FLAGS", $Flags);

&ShowExpTree($Start, $C);
print "<HR><p>Powered by <A HREF=\"http://www.ahs.hist.no/distr/NDSm\"><B>NDSm</B></A>\n";
&Myend();



__END__
