#
# Treeview.pl
#
# This script demonstrates how to browse through your entire tree with NDSm
#
# Copyright (c) 1998 Steinar Kleven, all rights reserved
#
#	Please adjust the 'require ../cgi-lib.pl' to 
#  match this scripts relative location to cgi-lib.pl on your system.
#


BEGIN {$| = 1; require "../cgi-lib.pl"; print &PrintHeader; }

use strict;
use vars qw($C $Start $Flags %in %Images $ibase);

$ibase = '/NDSm-demo/images';

%Images = ('Printer' => "$ibase/Printer.gif",
            'Computer' => "$ibase/Computer.gif",
            'Country' => "$ibase/Country.gif",
				'Group' => "$ibase/Group.gif",
				'NCP Server' => "$ibase/NCP_Server.gif",
				'Organizational Unit' => "$ibase/Organizational_Unit.gif",
				'Print Server' => "$ibase/Print_Server.gif",
				'Profile' => "$ibase/Profile.gif",
				'Queue' => "$ibase/Queue.gif",
				'Template' => "$ibase/Template.gif",
				'Unknown' => "$ibase/Unknown.gif",
				'User' => "$ibase/User.gif",
				'Volume' => "$ibase/Volume.gif",
				'Organization' => "$ibase/Organization.gif",
				'App:Application' => "$ibase/App_Application.gif",
				'Application (Windows 3.x)' => "$ibase/Application_win3.gif");


use NDSm::NDSContext;
use NDSm::Buf_T;




sub MyDie {
   my ($Object, $Msg) = @_;
   my $Err = $Object->LastErr();
   die("$Msg, error $Err");
}



sub PrintContext {
	my ($Container, $ContObj, $arefObjects) = @_;
	my ($ObjType, @Record, $i, $linkContainer, $Image);
	@$arefObjects = sort(@$arefObjects);
	$linkContainer = !($Container =~ /^\[root\]/i) ? ".".$Container : "";
# Table header
   print "<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0>\n";
	print "<CAPTION><B><I><FONT COLOR=\"#990000\" SIZE=+2> " .
			"$Container</FONT></I></B></CAPTION>\n\n";
	print "<TR><TD COLSPAN=2><B><I><FONT SIZE=+1>Object type</FONT></I></B></TD>\n";
	print "<TD><B><I><FONT SIZE=+1>Object name</FONT></I></B></TD></TR>\n\n";

	$i=0;
   while(@Record = split(/\n/, $$arefObjects[$i++]) )
   {
 		if ($i % 2)
		{print "<TR BGCOLOR=\"#CCCCCC\">";}else{print "<TR BGCOLOR=\"#999999\">";} 
      if (!($Image = $Images{$Record[1]})){$Image = $Images{'Unknown'};}
      print "<TD><IMG SRC=\"$Image\"></TD><TD>$Record[1] </TD><TD ALIGN=CENTER>";
 		if ($Record[2] & $ContObj->GetConst("DS_CONTAINER_ENTRY"))
      { 
			print "<A HREF=\"$ENV{'SCRIPT_NAME'}?context=$Record[0]$linkContainer\">\n";
			print "$Record[0]</A>\n";	
			print "</TD></TR>\n";
		}
		else 
		{
			print "$Record[0]</TD></TR>\n";
		}
  	}
	print "</TABLE>\n\n";
}


# Returns a array with one or more:
# "ObjectName\nObjectType\nFlags" Records.
#

sub GetObjects {
   my $Context = shift;
   my ($i, $j, @Records, $iter, $ObjectName, $ObjectCount, $AttrCount, @ObjInfo);
   my $Buf = new NDSm::Buf_T;
   my $CHandle = $Context->GetHandle();

   $Buf->AllocBuf(32768);
   $iter = $Buf->GetConst("NO_MORE_ITERATIONS");
	$j = 0;
   do
   {
      $iter = $Buf->List($CHandle, "", $iter);
      MyDie($Buf, "List()") if (!defined($iter));
      $ObjectCount = $Buf->GetObjectCount($CHandle);
      MyDie($Buf, "GetObjectCount()") if  (!defined($ObjectCount));

      #Now we can store all objects in this context in array
      for($i=0; $i < $ObjectCount; $i++) {
         ($ObjectName, $AttrCount, @ObjInfo) = $Buf->GetObjectName($CHandle);
         MyDie($Buf, "GetObjectName()") if (!defined($ObjectName));
			$Records[$j++] = "$ObjectName\n$ObjInfo[3]\n$ObjInfo[0]";
      }
   }while ($iter != -1);
	\@Records;
}



sub Myend { 
	print &HtmlBot;
	exit();
}


#######
# Execution start here
#######

$C = new NDSm::NDSContext;

print &HtmlTop("NDSm browse example");


# We can't do anything if we're not logged on
if (!$C->IsDSAuthenticated())
{
  print("You're not logged on, bailing out!!") ;
  &Myend();
}

# Get parameters
&ReadParse(\*in);

# Make sure we always get full name and context
# when we call CanonicalizeName() in StatTree 
# We also want those nice O=, OU= ....
$Flags = $C->GetContext("DCK_FLAGS");
$Flags |= $C->GetConst("DCV_CANONICALIZE_NAMES", 0);
# $Flags &= ~ $C->GetConst("DCV_TYPELESS_NAMES", 0);
$C->SetContext("DCK_FLAGS", $Flags);

$C->SetContext("DCK_NAME_CONTEXT", $in{'context'});
print "<P><HR><P>\n";
PrintContext( $in{'context'}, $C, &GetObjects($C));

print "<HR><p>Powered by <A HREF=\"http://www.ahs.hist.no/distr/NDSm\"><B>NDSm</B></A>\n";
&Myend();

__END__
