#
# Browse.pl
#
# This script demonstrates how to get all object in a context from NDS
# with the perl extension NDSm.
#
# Copyright (c) 1997 Steinar Kleven
#



use NDSm::NDSContext;
use NDSm::Buf_T;

sub Mydie {
	$ErrMsg = shift;
	open LOG, ">>rattrib.err";
	print LOG $ErrMsg;
   print $ErrMsg;
   exit(-1);
}


sub GetErrAndDie {
	$Text = shift;
 	$Class = shift;
   Mydie($Text . ",error : ". $Class->LastErr());
}


$C = new NDSm::NDSContext;

$CHandle = $C->GetHandle();

# buffer for reply
$OutBuf = new NDSm::Buf_T;
Mydie("Error creating all classes.\n") if (!($C && $OutBuf));


# We can't do anything if we're not logged on
$Result = $C->IsDSAuthenticated();
Mydie("You're not logged on, bailing out!!") if (!$Result);


# Alloc Result-buffer.
$Result = $OutBuf->AllocBuf();
GetErrAndDie("Could not allocate buffer", $OutBuf) if $Result;

print "Type the context you want to list : ";
$Context = <STDIN>;
chomp($Context);

$Result = $C->SetContext("DCK_NAME_CONTEXT", $Context);
GetErrAndDie("Could not set context", $C) if $Result;

$iter = $OutBuf->GetConst("NO_MORE_ITERATIONS");
do
{
  $iter = $OutBuf->List($CHandle, $Context, $iter);
  GetErrAndDie("Error retrieving objects", $OutBuf) if (!defined($iter));
  $ObjectCount = $OutBuf->GetObjectCount($CHandle);
  GetErrAndDie("Could not get object count", $OutBuf) if (!defined($ObjectCount));

  #Now we can list all objects in this context
  $ok = 1;
  for($i=0; $i < $ObjectCount; $i++) {
    ($ObjectName) = $OutBuf->GetObjectName($CHandle);
    GetErrAndDie("Could not get object name", $OutBuf) if (!defined($ObjectName));
    print "$i: $ObjectName\n";
  }
}while ($ok && $iter != -1);

print "All methods passed\n";
__EN