#
# Stattree.pl
#
# This script demonstrates how to browse through your entire tree with NDSm
#
# Copyright (c) 1997 Steinar Kleven
#



BEGIN { $| = 1;}

use strict;
use vars qw($C $Start $Flags);

use NDSm::NDSContext;
use NDSm::Buf_T;



sub MyDie {
   my ($Object, $Msg) = @_;
   my $Err = $Object->LastErr();
   die("$Msg, error $Err");
}



# This is a recursive method listing number of different objects in each container.
sub StatTree {
   my $StartContainer = shift;
   my $Context = shift;
   my %Objects = ();
   my ($i, $iter, $ObjectName, $ObjectCount, $AttrCount, @ObjInfo, $ObjType);
   my $Buf = new NDSm::Buf_T;
   my $CHandle = $Context->GetHandle();
	$Context->SetContext("DCK_NAME_CONTEXT", "$StartContainer");

   $Buf->AllocBuf(32768);
   $iter = $Buf->GetConst("NO_MORE_ITERATIONS");
   do
   {
      $iter = $Buf->List($CHandle, "", $iter);
      MyDie($Buf, "List()") if (!defined($iter));
      $ObjectCount = $Buf->GetObjectCount($CHandle);
      MyDie($Buf, "GetObjectCount()") if  (!defined($ObjectCount));

      #Now we can list all objects in this context
      for($i=0; $i < $ObjectCount; $i++) {
         ($ObjectName, $AttrCount, @ObjInfo) = $Buf->GetObjectName($CHandle);
         MyDie($Buf, "GetObjectName()") if (!defined($ObjectName));
         $ObjectName = $C->CanonicalizeName($ObjectName);
         if ($ObjInfo[0] & $Buf->GetConst("DS_CONTAINER_ENTRY"))
         {
            StatTree("$ObjectName", $Context);
				$Context->SetContext("DCK_NAME_CONTEXT", "$StartContainer");
         }
         $Objects{$ObjInfo[3]}++;
      }
   }while ($iter != -1);
   print "$StartContainer has:\n";
   foreach $ObjType (keys %Objects)
   {
      print "\t\t$ObjType : $Objects{$ObjType}\n";
   }
   print "\n\n";
}


# Execution start here

$C = new NDSm::NDSContext;


# We can't do anything if we're not logged on
die("You're not logged on, bailing out!!") if (!$C->IsDSAuthenticated());

print "Please type the context to start from : ";
chomp ($Start = <STDIN>);

# Make sure we always get full name and context
# when we call CanonicalizeName() in StatTree 
# We also want those nice O=, OU= ....

$Flags = $C->GetContext("DCK_FLAGS");
$Flags |= $C->GetConst("DCV_CANONICALIZE_NAMES", 0);
$Flags &= ~ $C->GetConst("DCV_TYPELESS_NAMES", 0);
$C->SetContext("DCK_FLAGS", $Flags);

print "\n\n";
&StatTree($Start, $C);

# If you found this example usefull, click <HERE> :-)

__END__
