
package NDSm::NDSContext;
use strict;
use NDSm;

use vars qw($BIN_DEBUG $REGUSER $REGCODE $VERSION @ISA @EXPORT @EXPORT_OK);


@ISA = qw(Exporter DynaLoader NDSm);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(

);

*AUTOLOAD = \&NDSm::AUTOLOAD;
*BIN_DEBUG = \$NDSm::BIN_DEBUG;
*VERSION = \$NDSm::VERSION;



sub AbbreviateName {
	my $self = shift;
	if (@_ < 1){ warn("AbbreviateName needs 1 param\n");return undef;}
   my ($InName) = @_;
	my $abbrev = &NDSm::NWDSAbbreviateName($self->{CONTEXT}, $InName);
   if (!defined($abbrev)) {
	  $self->{LAST_ERR} = &NDSm::GetLastErr();
     warn "AbbreviateName returning <undef>\n" if $self->{DEBUG};
	  undef;
	}else { $abbrev; }
        
}






sub AddSecurityEquiv {
	my $self = shift;
	my ($equalFrom, $equalTo) = @_;
	return &NDSm::NWDSAddSecurityEquiv($self->{CONTEXT}, $equalFrom, $equalTo);
}



sub CanDSAuthenticate {
	my $self = shift;
	return &NDSm::NWDSCanDSAuthenticate($self->{CONTEXT});
}





sub CanonicalizeName {
	my $self = shift;
	my $InName = shift;
	my $Canon = &NDSm::NWDSCanonicalizeName($self->{CONTEXT}, $InName);
        if (!defined($Canon)) {
	  $self->{LAST_ERR} = &NDSm::GetLastErr();
          warn "CanonicalizeName returning <undef>\n" if $self->{DEBUG};
	  undef;
	}else { $Canon; }
}




# Opt is not used in NSDK(13)
sub ChangeObjectPassword {
	my $self = shift;
	my ($foo, $Obj, $Old, $New) = @_;
	return &NDSm::NWDSChangeObjectPassword($self->{CONTEXT}, $foo, $Obj, $Old, $New);
}






sub CreateContextHandle {
	my $self = shift;
	my $Handle = &NDSm::NWDSCreateContextHandle();
	if (!defined($Handle)) {
	  $self->{LAST_ERR} = &NDSm::GetLastErr();
	  warn "CreateContextHandle returning <undef>\n" if $self->{DEBUG};
	  undef;
	}else { $Handle; }
}





sub GenerateObjectKeyPair {
	my $self = shift;
	my ($ObjName, $newpass, $flag) = @_;
	return &NDSm::NWDSGenerateObjectKeyPair($self->{CONTEXT}, $ObjName, $newpass, $flag);
}





sub GetDefNameContext {
	my $self = shift;
	my $Context =  &NDSm::NWDSGetDefNameContext($self->{CONTEXT});	
	if (!defined($Context)) {
     $self->{LAST_ERR} = &NDSm::GetLastErr();
	  warn "GetDefNameContext returning <undef>\n" if $self->{DEBUG};
     undef;
	}else { $Context; }
}





sub IsDSAuthenticated {
	my $self = shift;
	return &NDSm::NWIsDSAuthenticated();
}



sub Login {
	my $self = shift;
	my ($Opt, $User, $Passwd, $Period) = @_;
   return &NDSm::NWDSLogin($self->{CONTEXT}, 0, $User, $Passwd, 0);
}



sub Logout {
	my $self = shift;
	return &NDSm::NWDSLogout($self->{CONTEXT});
}



sub MoveObject {
	my $self = shift;
	my ($Obj, $destParentDN, $destRDN) = @_;
	return &NDSm::NWDSMoveObject($self->{CONTEXT}, $Obj, $destParentDN, $destRDN);
}



sub RemoveAllTypes {
	my $self = shift;
	my $Name = shift;
   my $TypeLess = &NDSm::NWDSRemoveAllTypes($self->{CONTEXT}, $Name);
	if (!defined($TypeLess)) {
	  $self->{LAST_ERR} = &NDSm::GetLastErr();
	  warn "RemoveAllTypes returning <undef>\n" if $self->{DEBUG};
          undef;
	}else { $TypeLess; }
}







sub RemoveObject {
	my $self = shift;
	my ($ObjectName) = @_;
	return &NDSm::NWDSRemoveObject($self->{CONTEXT}, $ObjectName);
}




sub RemSecurityEquiv {
        my $self = shift;
	my ($equalFrom, $equalTo) = @_;
	return &NDSm::NWDSRemSecurityEquiv($self->{CONTEXT}, $equalFrom, $equalTo);
}





sub ReplaceAttrNameAbbrev {
	my $self = shift;
	my $inStr = shift;
	my $Full = &NDSm::NWDSReplaceAttrNameAbbrev($self->{CONTEXT}, $inStr);
	if (!defined($Full)) {
	  $self->{LAST_ERR} = &NDSm::GetLastErr();
	  warn "ReplaceAttrNameAbbrev returning <undef>\n" if $self->{DEBUG};
     undef;
	}else { $Full; }
}





sub SetDefNameContext {
	my $self = shift;
	my ($NameContext) = @_;
	my $Len = length($NameContext);
   return &NDSm::NWDSSetDefNameContext($self->{CONTEXT}, $Len, $NameContext);
}



sub VerifyObjectPassword {
	my $self = shift;
	my ($opt, $objectName, $Passwd) = @_;
	return &NDSm::NWDSVerifyObjectPassword($self->{CONTEXT}, $opt, $objectName, $Passwd);
}



sub WhoAmI {
        my $self = shift;
        my $MyCN = &NDSm::NWDSWhoAmI($self->{CONTEXT});
	if (!defined($MyCN)) {
	  $self->{LAST_ERR} = &NDSm::GetLastErr();
	  warn "WhoAmI returning <undef>\n" if $self->{DEBUG};
          undef;
	}else { $MyCN; }
}





1;

__END__


