
package NDSm::Buf_T;

use strict;
use IO::Handle;
use NDSm::Reg;

use vars qw($VERSION @ISA);

require Exporter;
require DynaLoader;
@ISA = qw(Exporter DynaLoader);

$VERSION = '1.00';

bootstrap NDSm::Buf_T $VERSION;

SetRegInfo($NDSm::Reg::REGUSER, $NDSm::Reg::REGCODE);


sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $self  = {};
	$self->{PBUF} = undef;
	$self->{LAST_ERR} = 0;
   $self->{DEBUG} = 0;
	bless ($self, $class);
	$self;
}


sub DESTROY {
	my $self = shift;
	$self->FreeBuf();
}



sub AddObject {
	my $self = shift;
	if (@_ < 4){
	  warn("Not enough parameters to AddObject\n") if $self->{DEBUG};
     return undef;
	  $self->{LAST_ERR} = -1;
   }
	my ($Context, $ObjName, $iter, $more) = @_;
   $iter = -1 if (!defined($iter) || !$iter);
	$iter = &NWDSAddObject($Context, $ObjName, $iter, $more, $self->{PBUF});
   if (!defined($iter)) {
	  $self->{LAST_ERR} = &GetLastErr();
     warn "AddObject returning <undef>\n" if $self->{DEBUG};
   }
   $iter;
}


sub AddPartition {
	my $self = shift;
	my ($context, $server, $partitionRoot, $iter, $more) = @_;
   $iter = -1 if (!defined($iter) || !$iter);
	$iter =  &NWDSAddPartition($context, $server, $partitionRoot, $iter, $more, $self->{PBUF});
   if (!defined($iter)) {
	  $self->{LAST_ERR} = &GetLastErr();
     warn "AddPartition returning <undef>\n" if $self->{DEBUG};
   }
   $iter;
}


sub AllocBuf {
	my $self = shift;
	my $Retval;
	my ($Size) = @_;
   if (defined($self->{PBUF})){$self->FreeBuf();}
	if (!$Size){$Size = &constant("DEFAULT_MESSAGE_LEN", 0);}
	$Retval = &NWDSAllocBuf($Size, $self->{PBUF});
	if ($Retval){$self->{PBUF} = undef;}
	return $Retval;
}


sub Compare {
	my $self = shift;
	my ($Context, $Object) = @_;
	chomp($Object);
	my $match = &NWDSCompare($Context, $Object, $self->{PBUF});
	if (!defined($match)) {
	  $self->{LAST_ERR} = &GetLastErr();
	  warn "Compare returning <undef>\n" if $self->{DEBUG};
   }
   $match;
}


sub Debug {
	my $self = shift;
   $self->{DEBUG} = shift;
}



sub FreeBuf {
	my $self = shift;
	if (defined($self->{PBUF})){
	  &NWDSFreeBuf($self->{PBUF});
	  $self->{PBUF} = undef;
	}
}




sub GetAttrCount {
	my $self = shift;
	my $Context = shift;
	my $Count = &NWDSGetAttrCount($Context, $self->{PBUF});
	if (!defined($Count)) {
	  $self->{LAST_ERR} = &GetLastErr();
     warn "GetAttrCount returning <undef>\n" if $self->{DEBUG};
	}
   $Count;
}





sub GetAttrName {
	my $self = shift;
	my $Context = shift;
	my @Vals = &NWDSGetAttrName($Context, $self->{PBUF});
	if (!defined(@Vals)) {
	  $self->{LAST_ERR} = &GetLastErr();
	  warn "GetAttrName returning <undef>, (". $self->{LAST_ERR} .")\n" if $self->{DEBUG};
   }
   @Vals;
}




sub GetAttrVal {
	my $self = shift;
	my ($Context, $SyntaxId) = @_;
	my $Val = &NWDSGetAttrVal($Context, $self->{PBUF}, $SyntaxId);
	if (!defined($Val)) {
	  $self->{LAST_ERR} = &GetLastErr();
	  warn "GetAttrVal returning <undef>\n" if $self->{DEBUG};
   }
	$Val;
}


sub _GetBuf {
	my $self = shift;
	return $self->{PBUF};
}


# Call with ($ConstName)
# returns the value of a given constantname
sub GetConst {
      my ($self, $ConstName)  = @_;
	   return &constant($ConstName, 0);
}



sub GetObjectCount {
	my $self = shift;
	my ($Context) = @_;
	my $Count = &NWDSGetObjectCount($Context, $self->{PBUF});
	if (!defined($Context)) {
	  $self->{LAST_ERR} = &GetLastErr();
     warn "GetObjectCount returning <undef>\n" if $self->{DEBUG};
   }
   $Count;
}



sub GetObjectName {
	my $self = shift;
	my ($Context) = @_;
	my (@Vals) = &NWDSGetObjectName($Context, $self->{PBUF});
	if (!defined(@Vals)) {
	  $self->{LAST_ERR} = &GetLastErr();
     warn "GetObjectName returning <undef>\n" if $self->{DEBUG};
   }
   @Vals;
}





sub GetPartitionInfo {
	my $self = shift;
	my $Context = shift;
	my @Vals = &NWDSGetPartitionInfo($Context, $self->{PBUF});
	if (!defined(@Vals)) {
	  $self->{LAST_ERR} = &GetLastErr();
     warn "GetPartitionInfo returning <undef>\n" if $self->{DEBUG};
   }
   @Vals;
}


sub GetServerName {
	my $self=shift;
   my ($Context, $ServerName) = @_;
   my @Vals = &NWDSGetServerName($Context, $self->{PBUF});
   if (!defined(@Vals)) {
	  $self->{LAST_ERR} = &GetLastErr();
     warn "GetServerName returning <undef>\n" if $self->{DEBUG};
   }
   @Vals;
}



sub InitBuf {
	my $self = shift;
	my ($Context, $Op) = @_;
	my $Retval = -1;
	$self->AllocBuf() if (!defined($self->{PBUF}));
   if (defined($self->{PBUF})){
	   $Retval = &NWDSInitBuf($Context, &NDSm::constant($Op, 0), $self->{PBUF});
   }
	return $Retval;
}




sub IsNumType {
      my ($self, $syntaxId) = @_;
      return &xsIsNumType($syntaxId);
}




sub IsStringType {
      my ($self, $syntaxId) = @_;
      return &xsIsStringType($syntaxId);
}




sub IsMLType {
      my ($self, $syntaxId) = @_;
      return &xsIsMLType($syntaxId);
}



sub LastErr {
	   my $self = shift;
      return $self->{LAST_ERR};
}



sub List {
	my $self = shift;
	my($Context, $ObjectName, $iter) = @_;
   $iter = -1 if (!defined($iter) || !$iter);
	chomp($ObjectName);
	$iter = &NWDSList($Context, $ObjectName, $iter, $self->{PBUF});
	if (!defined($iter)) {
	  $self->{LAST_ERR} = &GetLastErr();
	  warn "List returning <undef>\n" if $self->{DEBUG};
   }
   $iter;
}


sub ListPartitions {
	my $self = shift;
	my($Context, $iter, $Server) = @_;
   $iter = -1 if (!defined($iter) || !$iter);
	chomp($Server);
	$iter = &NWDSListPartitions($Context, $iter, $Server, $self->{PBUF});
	if (!defined($iter)) {
	  $self->{LAST_ERR} = &GetLastErr();
	  warn "ListPartitions returning <undef>\n" if $self->{DEBUG};
   }
   $iter;
}



sub ModifyObject {
	my $self = shift;
	if (@_ < 4){warn("Not enough parameters to ModifyObject\n");return -1;}
	my ($Context, $ObjName, $iter, $more) = @_;
	chomp($ObjName);
   $iter = -1 if (!defined($iter) || !$iter);
	$iter = &NWDSModifyObject($Context, $ObjName, $iter, $more, $self->{PBUF});
	if (!defined($iter)) {
	  $self->{LAST_ERR} = &GetLastErr();
	  warn "ModifyObject returning <undef>\n" if $self->{DEBUG};
	}
   $iter;
}



sub OpenStream($Context, $ObjectName, $AttrName, $flag) {
	my $self = shift;
	my ($Context, $ObjectName, $AttrName, $flag) = @_;
	my ($nwHandle, $fh, $Retval);
	chomp($ObjectName);
	undef $fh;
# First we need to delete the existing value if we are going to write
	$Retval = 0;
	if ($flag eq "w")
	{
		my $Buf = new NDSm::Buf_T;
		if (!defined($Buf)){ return undef;}
		$Retval |= $Buf->AllocBuf();
		$Retval |= $Buf->InitBuf($Context, "DSV_MODIFY_ENTRY");
		$Retval |= $Buf->PutChange($Context, "DS_OVERWRITE_VALUE", $AttrName);
		$Retval |= $Buf->PutAttrVal($Context, "SYN_STREAM", 0);
		$Buf->ModifyObject($Context, $ObjectName, 0, 0);
		undef $Buf;
	}
	if (!($Retval))
	{
	  $nwHandle = &NWDSOpenStream ($Context, $ObjectName, $AttrName, ($flag eq "w") ? 2 : 1);
	  if (defined($nwHandle)) {
		 $fh = new IO::Handle;
		 if (!($fh->fdopen($nwHandle, $flag))) {
			if ($self->{DEBUG}) {
			  warn("Could not open SYN_STREAM attribute\n");
			  warn("Maybe attribute never used before or broken C _open_osfhandle()\n");
			}
		 }
	  }else {
     	$self->{LAST_ERR} = &GetLastErr();
     	warn "NWDSOpenStream returning <undef>\n" if $self->{DEBUG};
     }
	}
	$fh;
}



sub PutAttrName {
	my $self = shift;
	my ($Context, $AttrName) = @_;
	chomp($AttrName);
	return &NWDSPutAttrName($Context, $self->{PBUF}, $AttrName);
}



sub PutAttrVal {
	my $self = shift;
	if (@_ < 3){warn("Not enough parameters to PutAttrVal\n");return -1;}
	my ($Context, $Type, $Data) = @_;
	chomp($Data);
	return &NWDSPutAttrVal($Context, $self->{PBUF}, &NDSm::constant($Type, 0), $Data);
}



# Call with ($Context, $OperationName, $AttributeName)
sub PutChange{
	my $self = shift;
	if (@_ < 3){warn("Not enough parameters to PutChange\n"); return -1;}
	my ($Context, $Op, $AttrName) = @_;
	return &NWDSPutChange($Context, $self->{PBUF}, &NDSm::constant($Op,0), $AttrName);
}



sub Read {
	my $self = shift;
	die ("Read needs 6 args\n") if (@_ != 6);
	my ($Context, $ObjName, $InfoType, $AllAttrs, $Iter, $ResultBuf) = @_;
	$InfoType = $self->GetConst($InfoType);
   $Iter = -1 if (!defined($Iter) || !$Iter);
	$Iter = &NWDSRead($Context, $ObjName, $InfoType, $AllAttrs, $self->{PBUF}, $Iter, $ResultBuf->_GetBuf());
	if (!defined($Iter)) {
	  $self->{LAST_ERR} = &GetLastErr();
	  warn "Read returning <undef>\n" if $self->{DEBUG};
   }
   $Iter;
}



END {;}

1;

__END__


