/*
        +==========================================================+
        |                                                          |
        |           Novell NWServer extension for NT Perl          |
        |           -------------------------------------          |
        |           Audit.xs :    Implements methods for audit log |
        |                         management.                      |
        |                                                          |
        |            by Steinar Kleven <stk@ahs.hist.no>           |
        |                                                          |
        |                  version 1.00                            |
        |                                                          |
        |                                                          |
        | Copyright (c) 1997 Steinar Kleven. All rights reserved.  |
        |   This program is NOT free software, you can NOT         |
        |   redistribute it and/or modify it.                      |
        |                                                          |
        +==========================================================+
*/

/* Turn of these annoying "Structure packing size .." Warnings */
#if defined(__BORLANDC__)
        #pragma warn -pck
#endif



#ifdef NLM_PLATFORM
  #define N_PLAT_NETWARE
  #define N_PLAT_NLM
  #define N_ARCH_32
  #ifndef LC_ALL
    #define LC_ALL 0
  #endif  
  #undef _Windows
#endif


#if !defined(N_PLAT_NLM)
#define WIN32_LEAN_AND_MEAN  
#include <windows.h>
#endif

#include <time.h>
#include <stddef.h>
#include <stdarg.h>


/* Novell SDK includes */
#ifdef __cplusplus
extern "C" {
#endif
#include <ntypes.h>
#include <nwlocale.h>
#include <nwnet.h>
#include <nwcalls.h>
#include <nwserver.h>
#include <nwsm.h>
#include <nwclxcon.h>
#include <nwfse.h>
#include <unicode.h>
#ifdef NLM_PLATFORM
	#include <nlm\nwtime.h>
#endif   
#ifdef __cplusplus
}
#endif


#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#undef _open_osfhandle

#ifdef NLM_PLATFORM
  	#define _timezone timezone
#endif


/* NDSm headers */
#include "NDSm.h"
#include "paudit.h"

#if defined(_MSC_VER)
#define tzset _tzset
#endif


char *UnicodeToLocal(PProto_ nuint8 **src, int AudType);



/* ErrCode is set to the return value of last NW* called.
   Users creating scripts based on this extension can
   retrieve this by calling LastErr at class the error aqured.
*/

NWCCODE ErrCode = 0;

/* The size of the buffer which we sprintf into */
#define RET_BUF_SIZE 1024


/* If you want to use the internal debugging you should define this.
   You can comment it out if you want this extension to go 1 ns. faster. (whitout
   possibilities of turning it on.
*/

// The different debug types OR'ed  

#define DBG_ARGS 1
#define DBG_NWRET 2
#define DBG_DUMP 4

//#define AUDIT_DBG (DBG_ARGS|DBG_NWRET|DBG_DUMP)
#undef AUDIT_DBG

#if (AUDIT_DBG > 0)
#define DBGMSG(_x_)  if (_dbglvl _x_){ printf("%s, %d: ",__FILE__,__LINE__); \
                     _dbgprint _x_; }
#else
#define DBGMSG(_x_)
#endif



/* This section handles messages of different sorts */

/* Debug, Errors aso */

#if (AUDIT_DBG > 0)
bool _dbglvl(int type, char *format, ...)
{
/*   va_list ap;
   va_start(ap, format);
   va_end(ap);  */
 return (type && AUDIT_DBG);
}


int _dbgprint(int type, char *format, ...)
{
   va_list ap;
   int cnt;
   va_start(ap, type);
   cnt = va_arg(ap, int);

   if (AUDIT_DBG & type)
   {
      cnt = vprintf(format, ap);
   }
   va_end(ap);
   return(cnt);
}
#endif








/* This section handles help functions / structures */


typedef struct _audit_ver
{
        nuint8   majorVersion;
   nuint8   minorVersion;
        nuint8   revisionLevel;
   nuint8   betaReleaseLevel;
} audit_ver;


typedef struct _userRcd
{
   nuint32  userID;
   char     userName[MAX_DN_CHARS];
   char     *NetworkAddr;
   nuint16  replica;
   struct _userRcd *next;
} userRcd;



typedef struct _audit_netaddr
{
   nuint8 type;
   nuint8 len;
   nuint8 addr[1];
} audit_netaddr;



   /* global array used to track user information
   */
userRcd* userList = NULL;


/* -----------------------------------------------------------
 * AudVerCmp(audit_ver *v1, audit_ver *v2) compares two audit
 * versions and returns:
 *
 * negative value for v1 < v2
 * 0 for v1 == v2
 * positive value for v1 > v2
*/
int AudVerCmp(audit_ver *v1, audit_ver *v2)
{
        long myv1, myv2;
        if (v1 && v2)
   {
                myv1 = FOUR_U8_TO_U32(v1->majorVersion, v1->minorVersion, v1->revisionLevel, v1->betaReleaseLevel);
                myv2 = FOUR_U8_TO_U32(v2->majorVersion, v2->minorVersion, v2->revisionLevel, v2->betaReleaseLevel);
                if (myv1 < myv2)
        return -1;
      else if (myv1 == myv2)
        return 0;
      else return 1;
   }
   return 0;
}




/* -----------------------------------------------------------
 * This routine adds a user record to the user index.  The
 * index is used to match connection IDs to user names when
 * processing the audit records.
*/
void addUser(PProto_ pnuint8 pRcdHdr, int Audtype )
{

   pnuint8  pRcdData = (pnuint8)pRcdHdr;
   userRcd* pUserRcd;
   int      userNameLen;
   int      netAddrLen;
        char*           strPtr;


      /* Extract the user name from the audit/volume record
       *
       * Audit records have record header and event specific
       * data.  In order to extract data for a specific event, skip
       * over the header area and process the event data.  An application
       * must know the format of event specific data.
       *
       * The login event record and active connection event record have
       * the same format for the event data:
       *
       *             UserID                  - 4 bytes
       *             Network address type    - 1 byte
       *             Network address length  - 1 byte
       *             Network address         - variable length
       *             User name length        - 2 bytes for container / 1 byte for volume
       *             User name               - variable length
      */

   /* Allocate a new user record
      or reuse if the old record is obsolete
   */
   pUserRcd = userList;

   while ( pUserRcd )
   {
      if (Audtype == PERL_CONTAINER_AUDIT)
      {
       if ( pUserRcd->replica == ((NWContAuditRecord*)pRcdHdr)->replicaNumber
            && pUserRcd->userID  == ((NWContAuditRecord*)pRcdHdr)->userID )
                        break;
           else
                        pUserRcd = pUserRcd->next;

       }else {
         if ( ((NWVolumeAuditRcd*)pRcdHdr)->connectionID == pUserRcd->userID)
           break;
         else
            pUserRcd = pUserRcd->next;

       }
   }
   // Not found, create a new one.
   if (!pUserRcd)
   {
      pUserRcd = (userRcd*) malloc(sizeof(userRcd));
      if ( pUserRcd == NULL )
         return;

      pUserRcd->next = userList;
      userList = pUserRcd;
   }

   // skip rcd header area
   pRcdData += (Audtype == PERL_VOLUME_AUDIT) ?
                    sizeof(NWVolumeAuditRcd) : sizeof(NWContAuditRecord);
   pRcdData += 4;    // skip UserID
   pRcdData += 1;    // skip address type

   netAddrLen = (nuint8)*pRcdData; // save network address length
   pRcdData += 1;    // skip address length
   pRcdData += netAddrLen; // skip network address

   userNameLen = (nuint16)*pRcdData; // save user name length
   pRcdData += (Audtype == PERL_VOLUME_AUDIT) ? 1 : 2;    // skip user name length

   /* copy user name to index record
   */
   if ((char*)pRcdData[1] != '\0')
        strncpy( pUserRcd->userName, (char*)pRcdData, userNameLen);
        else
        {
        pRcdData -= (Audtype == PERL_VOLUME_AUDIT) ? 1 : 2;    // Go back again because of UnicodeToLocal()
                strPtr = UnicodeToLocal(PArg_ (nuint8**)&pRcdData, Audtype);
                strncpy( pUserRcd->userName, strPtr, userNameLen);
      free(strPtr);
   }
   pUserRcd->userName[userNameLen] = '\0';
   pUserRcd->userID  = (Audtype == PERL_VOLUME_AUDIT) ?
   ((NWVolumeAuditRcd*)pRcdHdr)->connectionID : ((NWContAuditRecord*)pRcdHdr)->userID;
   if (Audtype == PERL_CONTAINER_AUDIT)
      pUserRcd->replica = ((NWContAuditRecord*)pRcdHdr)->replicaNumber;
#ifdef AUDIT_DBG
   printf("User %s found in container/volume audit log\n", pUserRcd->userName);
#endif
}


/* -----------------------------------------------------------
 * Look up the user in the user index
*/
char* ContfindUser( nuint16 replica, nuint32 userID )
{
   userRcd* pUserRcd = userList;

   while ( pUserRcd )
   {
      if ( pUserRcd->replica == replica && pUserRcd->userID  == userID )
         return pUserRcd->userName;
      else
         pUserRcd = pUserRcd->next;
   }
   return NULL;
}

/* -----------------------------------------------------------
 * Look up the user in the user index
*/
char* VolfindUser(nuint32 connID )
{
   userRcd* pUserRcd = userList;

   while ( pUserRcd )
   {
      if (pUserRcd->userID == connID )
         return pUserRcd->userName;
      else
         pUserRcd = pUserRcd->next;
   }
   return NULL;
}



/* -------------------------------------------------------------
 * free the memory used in the user index
*/
void freeUserIndex(PProto)
{
   userRcd *pUserRcd;

   while (userList)
   {
      pUserRcd = userList;
      userList = userList->next;
      free( pUserRcd );
   }
   return;
}



long Time2Perl(NW_DATE *date, NW_TIME *time)
{
   struct tm               when;
   long                            unixtime;
        when.tm_sec = time->seconds;
        when.tm_min = time->minutes;
        when.tm_hour = time->hours;
   when.tm_mday = date->day;
        when.tm_mon = date->month - 1;
        when.tm_year = date->year - 1900;
        when.tm_isdst = -1; // Make runtime library compute

        unixtime = mktime(&when);

   DBGMSG((DBG_DUMP,"Date: %02d-%02d-%04d Time: %02d:%02d:%02d isdst:%d, timezone:%d\n",
                date->month, date->day, date->year, time->hours, time->minutes,
                time->seconds, when.tm_isdst, _timezone));
        return unixtime;
}




/* --------------------------------------------------------------
 * This section decode the information in the records
 */

char *GetNetworkAddr(PProto_ nuint8 **data)
{
   audit_netaddr *addr = (audit_netaddr *)*data;
   char *szRet;
   nuint8 netAddrLen;
   nuint8 netAddrType = (nuint8)addr->type;
   szRet = (char*)malloc(256);
   memset( szRet, 0, 256 );
   netAddrLen = (nuint8)addr->len;
   DBGMSG((DBG_DUMP, "Address of addr: %p, len of address: %X\n", *data, netAddrLen));
   switch (netAddrType)
   {
      case 1:
      sprintf(szRet, "%02X%02X%02X%02X:%02X%02X%02X%02X%02X%02X",
               addr->addr[0], addr->addr[1], addr->addr[2], addr->addr[3],
               addr->addr[4], addr->addr[5], addr->addr[6], addr->addr[7],
               addr->addr[8], addr->addr[9]);
         break;
   }
   *data = (pnuint8)(*data) + 1 + 1 + netAddrLen;
   DBGMSG((DBG_DUMP, "returning %s, new ptr: %p\n", szRet, *data));
   return szRet;
}


char *ExtractLong(PProto_ nuint8 **data)
{
   char *szBuf = (char*)malloc(16);
   sprintf(szBuf, "%ld", (nint32)**data);
   *data += 4;
   return szBuf;
}


void DumpHex(char *value, int count)
{
   while(count--)
   {
      printf ("%X -> %c\n", *value, *value);
      value++;
   }
}



char *ExtractLenStr(PProto_ nuint8 **data, int AudType)
{
   int totlen = 0;
   char *str = (char*)*data;
   nuint16 len;
   nuint8 lensize = 2;
   int Num = 1;
   char *szBuf = (char*)malloc(MAX_DN_CHARS);
   *szBuf = '\0';

   if (AudType == PVA)
   {
      lensize = 1;
      len =  (nuint8)*str;
   }
   else
      len =  (nuint16)*str;
   while(Num-- > 0)
   {
//      printf("len = %d, lensize=%d\n", len, lensize);
      str += lensize;
//      DumpHex(str, 20);
//      str[len] = '\0';
      totlen += len + lensize;
      if (len > 1)
      {
         strncat(szBuf, str, len);
         DBGMSG((DBG_DUMP, "ExtraInfo = (%s)\n", szBuf));
         if (Num > 0)
            strcat(szBuf, "\t");
      }
      str += len;
      len = (AudType == PVA) ? (nuint8)*str : (nuint16)*str;
   }
   *str = len;
   *data = (pnuint8)str;
   szBuf[strlen(szBuf)] = '\0';
   DBGMSG((DBG_DUMP, "returning %s, new ptr: %p\n", szBuf, *data));
   return szBuf;
}


char *UnicodeToLocal(PProto_ nuint8 **src, int AudType)
{
   size_t len;
   nuint16 srclen;
   int i=0;
        LCONV                   lconvInfo;
        void            *localToUniHandle=NULL;
   char *szPtr;
   nuint8 *szRet = (nuint8 *)malloc(MAX_DN_CHARS);
        srclen = (char)**src;
   (*src)+=2;
   szPtr = (char*)*src;
   *szRet = '\0';
   DBGMSG((DBG_DUMP, "Address of src: %p\n", src));
   NWLsetlocale(LC_ALL, "");
        NWLlocaleconv(&lconvInfo);
   if (NWInitUnicodeTables(lconvInfo.country_id, lconvInfo.code_page))
     printf("Error initializing Unicode\n");
   if (NWGetLocalToUnicodeHandle(&localToUniHandle))
   {
      printf("*********************ERROR********\n");
   }
   ErrCode = NWUnicodeToLocal(localToUniHandle, (unsigned char*)szRet, (size_t)MAX_DN_CHARS, (unicode *)*src, 0, &len);
   if (ErrCode)
        {
     *szRet = '\0';
   }
   szPtr += srclen;
   *src = (pnuint8)szPtr;
   DBGMSG((DBG_DUMP, "returning %s\n", szRet));
   return (char*)szRet;
}



char *DoContainerRecord(PProto_ NWContAuditRecord* pContRcdHdr, char *szRecord, nuint32 recordSize)
{
      char*             pUserName;
      NW_DATE           date;
      NW_TIME           time;
//      struct date                dosdate;
//      struct time             dostime;
//      struct tm*                      local_t;
      long                                      unixtime;
      pnuint8           pCurrentData;
      char *szMoreData[10];
      int dataidx = 0;
                int BugFixoffset = 0;
      int dataIdxCount = 0;

      audit_ver firstUniVer = AUD_CONTAINER_UNI;
      audit_ver MyVer;
      char* (*audstrget)(PProto_ nuint8 **data, int AudType);

      NWGetNWADVersion (&MyVer.majorVersion, &MyVer.minorVersion, &MyVer.revisionLevel, &MyVer.betaReleaseLevel);

      if (AudVerCmp(&MyVer, &firstUniVer) >= 0)
      {
         audstrget = UnicodeToLocal;
         BugFixoffset = 1;
      }
      else
         audstrget = ExtractLenStr;

      DBGMSG((DBG_DUMP, "Entering DoContainerRecord\n"));

      /* Login and connection records contain information
       * to match connections with users
       */
      if ( pContRcdHdr->eventTypeID == ADS_LOGIN ||
              pContRcdHdr->eventTypeID == A_ACTIVE_CONNECTION_RCD )
      {
          addUser(PArg_ (pnuint8) pContRcdHdr, PERL_CONTAINER_AUDIT);
      }
      pUserName = ContfindUser(pContRcdHdr->replicaNumber,pContRcdHdr->userID);
      NWUnpackDateTime( pContRcdHdr->dosDateTime, &date, &time );
      unixtime = Time2Perl(&date, &time);
      DBGMSG((DBG_DUMP, "Address of pContRcdHdr: %p, sizeof(NWContAuditRecord):%X, Datastart:%X\n", pContRcdHdr, sizeof(NWContAuditRecord),
               (pnuint8)pContRcdHdr + sizeof(NWContAuditRecord)));
/*    pCurrentData is always pointing to the next piece of information,
      starting at the byte after the audit header.
      The address of this pointer is feed into funtions retieving data so that the
      pointer is updated to the next dataelement.
*/
      pCurrentData = (pnuint8)pContRcdHdr + sizeof(NWContAuditRecord);
      switch (pContRcdHdr->eventTypeID)
      {
         /* start container audit history events */
         case A_ACTIVE_CONNECTION_RCD:
         case A_ADD_AUDITOR_ACCESS:
         case A_INTRUDER_DETECT:
                szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = GetNetworkAddr(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case 94:
                szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
                szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
                szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
                szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
         break;
         case 95:
                szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case 98:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case A_CHANGE_AUDIT_PASSWORD:
         break;
         /* Container audit events */

         case ADS_ADD_ENTRY:                /*101*/  /* unsigned long newEntryID */
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_REMOVE_ENTRY:               /* unsigned long oldEntryID */
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_RENAME_OBJECT:              /* unsigned long renamedEntryID, char *oldRDN */
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_MOVE_ENTRY:                 /* unsigned long movedEntryID, char *oldDN */
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_CHANGE_SECURITY_EQUIV:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_CHG_SECURITY_ALSO_EQUAL:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_CHANGE_ACL:
                // I would like to know what's in front here !!!!!
            pCurrentData +=4*BugFixoffset;
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
                                pCurrentData +=1*BugFixoffset;
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_CHG_STATION_RESTRICTION:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = GetNetworkAddr(PArg_ &pCurrentData);
         break;
         case ADS_LOGIN:                      /* unsigned long entryID */
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = GetNetworkAddr(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_LOGOUT:
         case ADS_CHANGE_PASSWORD:            /* unsigned long entryID */
         case ADS_USER_LOCKED:                /* unsigned long entryID */
         case ADS_USER_UNLOCKED:              /* unsigned long entryID */
         case ADS_USER_DISABLE:               /* unsigned long entryID */
         case ADS_USER_ENABLE:                /* unsigned long entryID */
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_CHANGE_INTRUDER_DETECT:
         case ADS_ADD_PARTITION:
         case ADS_REMOVE_PARTITION:
         break;
         case ADS_ADD_REPLICA:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
         break;
         case ADS_REMOVE_REPLICA:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_SPLIT_PARTITION:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_JOIN_PARTITIONS:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_CHANGE_REPLICA_TYPE:
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_REPAIR_TIME_STAMPS:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_MOVE_SUB_TREE:
         break;
         case ADS_ABORT_PARTITION_OP:
         case ADS_SEND_REPLICA_UPDATES:
         case ADS_RECEIVE_REPLICA_UPDATES:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;

         /* start Trusted NetWare auditing events */
         case ADS_ADD_MEMBER:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_BACKUP_ENTRY:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_CHANGE_BIND_OBJ_SECURITY:
         case ADS_CHANGE_PROP_SECURITY:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
         break;
         case ADS_CHANGE_TREE_NAME:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_CHECK_CONSOLE_OPERATOR:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
         break;
         case ADS_COMPARE_ATTR_VALUE:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_CREATE_PROPERTY:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
         break;
         case ADS_CREATE_SUBORDINATE_REF:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_DEFINE_ATTR_DEF:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_DEFINE_CLASS_DEF:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_DELETE_MEMBER:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_DELETE_PROPERTY:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_DS_NCP_RELOAD:
         break;
         case ADS_RESET_DS_COUNTERS:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_FRAG_REQUEST:
         break;
         case ADS_INSPECT_ENTRY:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_LIST_CONTAINABLE_CLASSES:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_LIST_PARTITIONS:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_LIST_SUBORDINATES:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_MERGE_TREE:
         break;
         case ADS_MODIFY_CLASS_DEF:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_MOVE_TREE:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_OPEN_STREAM:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_READ:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_READ_REFERENCES:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_REMOVE_ATTR_DEF:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_REMOVE_CLASS_DEF:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_REMOVE_ENTRY_DIR:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_RESTORE_ENTRY:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_START_JOIN:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_START_UPDATE_REPLICA:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_START_UPDATE_SCHEMA:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_SYNC_PARTITION:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_SYNC_SCHEMA:
         break;
         case ADS_UPDATE_REPLICA:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_UPDATE_SCHEMA:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_VERIFY_PASSWORD:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_ABORT_JOIN:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_RESEND_ENTRY:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_MUTATE_ENTRY:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_MERGE_ENTRIES:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_END_UPDATE_REPLICA:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_END_UPDATE_SCHEMA:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_CREATE_BACKLINK:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_MODIFY_ENTRY:
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
            szMoreData[dataIdxCount++] = audstrget(PArg_ (nuint8**)&pCurrentData, PCA);
         break;
         case ADS_NEW_SCHEMA_EPOCH:
         case ADS_CLOSE_BINDERY_RECORDS:
         case ADS_OPEN_BINDERYRECORDS:
         break;
      };
      sprintf(szRecord, "%lu\t%d\t%lu\t%s\t%d", unixtime, pContRcdHdr->eventTypeID,
                                        pContRcdHdr->userID, pUserName, pContRcdHdr->successFailureStatusCode);
      DBGMSG((DBG_DUMP, "%lu %d %lu %s %d\n", unixtime, pContRcdHdr->eventTypeID,
                                        pContRcdHdr->userID, pUserName, pContRcdHdr->successFailureStatusCode));
      while (dataidx < dataIdxCount)
      {
         if (strlen(szMoreData[dataidx]))
         {
            strcat(szRecord, "\t");
            strcat(szRecord, szMoreData[dataidx]);
         }
         free(szMoreData[dataidx++]);
      }
      return szRecord;
}




char *DoVolumeRecord(PProto_ NWVolumeAuditRcd* pVolRcdHdr, char *szRecord, nuint32 recordSize)
{
      char*             pUserName;
      NW_DATE           date;
      NW_TIME           time;
//      struct date                dosdate;
//      struct time             dostime;
//      struct tm*                      when;
      long                                      unixtime;
      pnuint8           pCurrentData;
      char *szMoreData[10];
      int dataidx = 0;
      int dataIdxCount = 0;

      DBGMSG((DBG_DUMP, "Entering DoContainerRecord\n"));

      /* Login and connection records contain information
       * to match connections with users
       */
      if ( pVolRcdHdr->eventTypeID == ADS_LOGIN ||
              pVolRcdHdr->eventTypeID == A_ACTIVE_CONNECTION_RCD )
      {
          addUser(PArg_ (pnuint8)pVolRcdHdr, PERL_VOLUME_AUDIT);
      }
      pUserName = VolfindUser(pVolRcdHdr->connectionID);
      DBGMSG((DBG_DUMP, "Address of pVolRcdHdr: %p, sizeof(NWVolumeAuditRcd):%X, Datastart:%X\n", pVolRcdHdr, sizeof(NWVolumeAuditRcd),
               (pnuint8)pVolRcdHdr + sizeof(NWVolumeAuditRcd)));
/*    pCurrentData is always pointing to the next piece of information,
      starting at the byte after the audit header.
      The address of this pointer is feed into funtions retieving data so that the
      pointer is updated to the next dataelement.
*/
      pCurrentData = (pnuint8)pVolRcdHdr + sizeof(NWVolumeAuditRcd);

      switch(pVolRcdHdr->eventTypeID)
      {
         case A_EVENT_BIND_CHG_OBJ_SECURITY: // 1
                        case A_EVENT_BIND_CHG_PROP_SECURITY:
                        case A_EVENT_BIND_CREATE_OBJ:
                        case A_EVENT_BIND_CREATE_PROPERTY:
                        case A_EVENT_BIND_DELETE_OBJ:
                        case A_EVENT_BIND_DELETE_PROPERTY:  // 6
         // Not used anymore ????
         break;
                        case A_EVENT_CHANGE_DATE_TIME:      // 7
            szMoreData[dataIdxCount] = (char*)malloc(128);
            NWUnpackDateTime( (nuint32)*pCurrentData, &date, &time );
            sprintf(szMoreData[dataIdxCount++], "%lu", Time2Perl(&date, &time));
            pCurrentData+=4;
         break;
                        case A_EVENT_CHANGE_EQUIVALENCE:    // 8
                        case A_EVENT_CHANGE_SECURITY_GROUP: // 9
         // Not used anymore ????
         break;
                        case A_EVENT_CLOSE_FILE:            // 10
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
         break;
                        case A_EVENT_CLOSE_BINDERY:         // 11
         // Not used anymore ????
         break;
                        case A_EVENT_CREATE_FILE:           // 12
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_CREATE_USER:           // 13
         // Not used anymore ????
         break;
                        case A_EVENT_DELETE_FILE:           // 14
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_DELETE_USER:           // 15
                        case A_EVENT_DIR_SPACE_RESTRICTIONS:   // 16
         // Not used anymore ????
         break;
                        case A_EVENT_DISABLE_ACCOUNT:       // 17
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_DOWN_SERVER:           // 18
         break;
                        case A_EVENT_GRANT_TRUSTEE:         // 19
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_INTRUDER_LOCKOUT_CHNG: // 20
         // Not used anymore ????
         break;
                        case A_EVENT_LOGIN_USER:         // 21
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = GetNetworkAddr(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_LOGIN_USER_FAILURE:    // 22
         // Not used anymore ????
         break;
                        case A_EVENT_LOGOUT_USER:           // 23
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_NET_LOGIN:             // 24
         // Not used anymore ????
         break;
                        case A_EVENT_MODIFY_ENTRY:          // 25
         break;
                        case A_EVENT_OPEN_BINDERY:          // 26
         // Not used anymore ????
         break;
                        case A_EVENT_OPEN_FILE:             // 27
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_ATTACH_SERVER:       // 28
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_CREATE:              // 29
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_CREATE_JOB:          // 30
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_DESTROY:             // 31
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_DETACH_SERVER:       // 32
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_EDIT_JOB:            // 33
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);

         break;
                        case A_EVENT_Q_JOB_FINISH:          // 34
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_JOB_SERVICE:         // 35
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_JOB_SERVICE_ABORT:   // 36
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_REMOVE_JOB:          // 37
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_SET_JOB_PRIORITY:    // 38
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_SET_STATUS:          // 39
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_START_JOB:           // 40
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_SWAP_RIGHTS:         // 41
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_READ_FILE:             // 42
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
         break;
                        case A_EVENT_REMOVE_TRUSTEE:        // 43
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_RENAME_MOVE_FILE:      // 44
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);

         break;
                        case A_EVENT_RENAME_USER:           // 45
         // Not used anymore ????
         break;
                        case A_EVENT_SALVAGE_FILE:          // 46
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_STATION_RESTRICTIONS:  // 47
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
         break;
                        case A_EVENT_CHANGE_PASSWORD:       // 48
                        case A_EVENT_TERMINATE_CONNECTION:  // 49
         // Not used anymore ????
         break;
                        case A_EVENT_UP_SERVER:             // 50
         break;
                        case A_EVENT_USER_CHANGE_PASSWORD:  // 51
                        case A_EVENT_USER_LOCKED:           // 52
         // Not used anymore ????
         break;
                        case A_EVENT_USER_SPACE_RESTRICTION:   // 53
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_USER_UNLOCKED:            // 54
         // Not used anymore ????
         break;
                        case A_EVENT_VOLUME_MOUNT:             // 55
                        case A_EVENT_VOLUME_DISMOUNT:          // 56
         break;
                        case A_EVENT_WRITE_FILE:               // 57
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
         break;
         /* Here are some audit history events */
         case A_ACTIVE_CONNECTION_RCD:          // 58
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = GetNetworkAddr(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_ADD_AUDITOR_ACCESS:             // 59
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = GetNetworkAddr(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_ADD_AUDIT_PROPERTY:             // 60
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_CHANGE_AUDIT_PASSWORD:          // 61
         break;
                        case A_DELETE_AUDIT_PROPERTY:          // 62
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_DISABLE_VOLUME_AUDIT:           // 63
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_OPEN_FILE_HANDLE_RCD:           // 64
                        case A_ENABLE_VOLUME_AUDITING:         // 65
                        case A_REMOVE_AUDITOR_ACCESS:          // 66
                        case A_RESET_AUDIT_FILE:               // 67
                        case A_RESET_AUDIT_FILE2:              // 68
                        case A_RESET_CONFIG_FILE:              // 69
                        case A_WRITE_AUDIT_BIT_MAP:            // 70
                        case A_WRITE_AUDIT_CONFIG_HDR:         // 71
         // No extra data
         break;
                        case A_NLM_ADD_RECORD:                 // 72
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_ADD_NLM_ID_RECORD:              // 73
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = GetNetworkAddr(PArg_ &pCurrentData);
         break;
                        case A_CHANGE_AUDIT_PASSWORD2:         // 74
         // No extra data
         break;
                        case A_EVENT_CREATE_DIRECTORY:         // 75
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_DELETE_DIRECTORY:         // 76
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
/* Audit history event */
                        case A_INTRUDER_DETECT:                // 77
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = GetNetworkAddr(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_VOLUME_NAME_RCD:                // 78
                        case A_BEGIN_AUDIT_FILE_READ:          // 79
         // Not used anymore ????
         break;
                        case A_VOLUME_NAME_RCD_2:              // 80
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_DELETE_OLD_AUDIT_FILE:          // 81
                        case A_QUERY_AUDIT_STATUS:             // 82
         // No extra data
         break;

   /* begin TNW changes */

                        case A_EVENT_GET_CURRENT_ACNT_STATS:   // 200
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_SUBMIT_ACCOUNT_CHARGE:    // 201
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_SUBMIT_ACCOUNT_HOLD:      // 202
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_SUBMIT_ACCOUNT_NOTE:      // 203
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_DISABLE_BROADCASTS:       // 204
                        case A_EVENT_GET_BROADCAST_MESSAGE:    // 205
                        case A_EVENT_ENABLE_BROADCASTS:        // 206
                        case A_EVENT_BROADCAST_TO_CONSOLE:     // 207
         // No extra info
         break;
                        case A_EVENT_SEND_BROADCAST_MESSAGE:   // 208
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_WRITE_EATTRIB:            // 209
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_READ_EATTRIB:             // 210
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_ENUM_EATTRIB:             // 211
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_SEE_FSO:                  // 212
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_GET_FSO_RIGHTS:           // 213
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_PURGE_FILE:               // 214
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_SCAN_DELETED:             // 215
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_DUPLICATE_EATTRIB:        // 216
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_ALLOC_DIR_HANDLE:         // 217
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_SET_HANDLE:               // 218
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_SEARCH:                   // 219
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_GEN_DIR_BASE_AND_VOL:     // 220
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_OBTAIN_FSO_INFO:          // 221
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_GET_REF_COUNT:            // 222
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_MODIFY_ENTRY_NO_SEARCH:   // 223
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_SCAN_TRUSTEES:            // 224
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_GET_OBJ_EFFECTIVE_RGHT:   // 225
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_PARSE_TREE:               // 226
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_SET_SPOOL_FILE_FLAGS:     // 227
            szMoreData[dataIdxCount++] = ExtractLong(PArg_ &pCurrentData);
         break;
                        case A_EVENT_RESTORE_Q_SERVER_RGHT:    // 228
         break;
                        case A_EVENT_Q_JOB_SIZE:               // 229
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_JOB_LIST:               // 230
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_Q_JOB_FROM_FORM_LIST:     // 231
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_READ_Q_JOB_ENTRY:         // 232
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_MOVE_Q_JOB:               // 233
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_READ_Q_STATUS:            // 234
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_READ_Q_SERVER_STATUS:     // 235
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_EXTENDED_SEARCH:          // 236
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_GET_DIR_ENTRY:            // 237
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_SCAN_VOL_USER_RESTR:      // 238
                        case A_EVENT_VERIFY_SERIAL:
         // No extra info
         break;
                        case A_EVENT_GET_DISK_UTILIZATION:     // 240
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_LOG_FILE:                 // 241
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_SET_COMP_FILE_SZ:
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_DISABLE_LOGIN:            // 243
                        case A_EVENT_ENABLE_LOGIN:
                        case A_EVENT_DISABLE_TTS:
                        case A_EVENT_ENABLE_TTS:
                        case A_EVENT_SEND_CONSOLE_BROADCAST:
                        case A_EVENT_GET_REMAIN_OBJ_DISK_SPC:
                        case A_EVENT_GET_CONN_TASKS:
                        case A_EVENT_GET_CONN_OPEN_FILES:
                        case A_EVENT_GET_CONN_USING_FILE:
                        case A_EVENT_GET_PHYS_REC_LOCKS_CONN:
                        case A_EVENT_GET_PHYS_REC_LOCKS_FILE:
                        case A_EVENT_GET_LOG_REC_BY_CONN:
                        case A_EVENT_GET_LOG_REC_INFO:
                        case A_EVENT_GET_CONN_SEMS:
                        case A_EVENT_GET_SEM_INFO:             // 257
         // No extra info
                        case A_EVENT_MAP_DIR_TO_PATH:          // 258
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_CONVERT_PATH_TO_ENTRY:
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_DESTROY_SERVICE_CONN:     // 260
         // No extra info
         break;
                        case A_EVENT_SET_Q_SERVER_STATUS:      // 261
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
                        case A_EVENT_CONSOLE_COMMAND:          // 262
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
         case A_EVENT_REMOTE_ADD_NS:            // 263
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
         case A_EVENT_REMOTE_DISMOUNT:          // 264
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
         case A_EVENT_REMOTE_EXE:               // 265
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
         case A_EVENT_REMOTE_LOAD:              // 266
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
         case A_EVENT_REMOTE_MOUNT:             // 267
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
         case A_EVENT_REMOTE_SET:               // 268
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
         case A_EVENT_REMOTE_UNLOAD:            // 269
            szMoreData[dataIdxCount++] = ExtractLenStr(PArg_ &pCurrentData, PVA);
         break;
      };
      NWUnpackDate( pVolRcdHdr->dosDate, &date );
      NWUnpackTime( pVolRcdHdr->dosTime, &time );
      unixtime = Time2Perl(&date, &time);
      sprintf(szRecord, "%lu\t%d\t%lu\t%s\t%d", unixtime, pVolRcdHdr->eventTypeID,
                                        pVolRcdHdr->connectionID, pUserName, pVolRcdHdr->successFailureStatusCode);
      DBGMSG((DBG_DUMP, "%lu %d %lu %s %d\n", unixtime, pVolRcdHdr->eventTypeID,
                                        pVolRcdHdr->connectionID, pUserName, pVolRcdHdr->successFailureStatusCode));
      while (dataidx < dataIdxCount)
      {
         if (strlen(szMoreData[dataidx]))
         {
            strcat(szRecord, "\t");
            strcat(szRecord, szMoreData[dataidx]);
         }
         free(szMoreData[dataidx++]);
      }
      return szRecord;

}









MODULE = NDSm::Audit  PACKAGE = NDSm::Audit  PREFIX = ndsm_
PROTOTYPES: ENABLE


#/* Returns the last ErrCode */
NWRCODE
ndsm_GetLastErr()
        CODE:
      DBGMSG((DBG_DUMP, "Returning error %hd (%X)\n", ErrCode, ErrCode));
                RETVAL = ErrCode;
        OUTPUT:
                RETVAL


#/* Set the registration info in .LIB */
void
ndsm_SetRegInfo(Key, Code)
                char *Key;
      long Code;
        CODE:
           libSetRegInfo(Key, Code);
                


void
ndsm_NWGetNWADVersion ()
        PREINIT:
        nuint8   majorVersion = 0;
           nuint8   minorVersion = 0;
        nuint8   revisionLevel = 0;
           nuint8   betaReleaseLevel = 0;
        PPCODE:
        NWGetNWADVersion (&majorVersion, &minorVersion, &revisionLevel, &betaReleaseLevel);
           EXTEND(sp, 4);
           PUSHs(sv_2mortal((SV*)newSViv(majorVersion)));
           PUSHs(sv_2mortal((SV*)newSViv(minorVersion)));
           PUSHs(sv_2mortal((SV*)newSViv(revisionLevel)));
           PUSHs(sv_2mortal((SV*)newSViv(betaReleaseLevel)));




void
ndsm_NWADOpen (conn, auditIDType, auditID)
      NWCONN_HANDLE      conn;
      nuint32            auditIDType;
      nuint32            auditID;
   PREINIT:
      nptr              auditHandle;
      NWADOpenStatus    openStatus;
   PPCODE:
      ErrCode = NWADOpen (conn, auditIDType, auditID, &auditHandle, &openStatus);
           EXTEND(sp, 1);
           if (!ErrCode)
        {
                PUSHs(sv_2mortal((SV*)newSViv((long)auditHandle)));
           }else{
                PUSHs(&sv_undef);
        }


NWRCODE
ndsm_NWADLogin (conn, auditIDType, auditID, auditHandle, password)
   NWCONN_HANDLE   conn;
   nuint32         auditIDType;
   nuint32         auditID;
   nptr            auditHandle;
   pnuint8         password;
   CODE:
      RETVAL = NWADLogin(conn, auditIDType, auditID, auditHandle, password);
	OUTPUT:
   	RETVAL





void
ndsm_NWADGetFileList (conn, auditIDType, auditID, auditHandle)
      NWCONN_HANDLE       conn;
      nuint32             auditIDType;
      nuint32             auditID;
      nptr                auditHandle;
   PREINIT:
      NWAuditFileList   fileList;
      unsigned short i = 0;
      char Buf[256];
   PPCODE:
          tzset();
      DBGMSG((DBG_ARGS, "NWADGetFileList(%X, %lu, %lu, %X)\n", conn, auditIDType, auditID, auditHandle));
      ErrCode = NWADGetFileList (conn, auditIDType, auditID, auditHandle, &fileList);
      if (!ErrCode)
      {
         for (i=0; (i<16) && (fileList.fileCreateDateTime[i] != 0); i++);
         EXTEND(sp, i+1);
         for (i=0; (i<16) && (fileList.fileCreateDateTime[i] != 0); i++)
         {
            DBGMSG((DBG_DUMP, "Audit file %d: %lu %lu\n", i, fileList.fileCreateDateTime[i], fileList.fileSize[i]));
            sprintf(Buf, "%lu %lu", fileList.fileCreateDateTime[i], fileList.fileSize[i]);
            PUSHs(sv_2mortal((SV*)newSVpv(Buf, strlen(Buf))));
         }
           }else{
            DBGMSG((DBG_NWRET, "NWADGetFileList() returned %X\n", ErrCode));
           EXTEND(sp, 1);
                PUSHs(&sv_undef);
        }


void
ndsm_NWADOpenRecordFile (conn, auditIDType, auditID, auditHandle, fileCode)
      NWCONN_HANDLE   conn;
      nuint32         auditIDType;
      nuint32         auditID;
      nptr            auditHandle;
      nint16          fileCode;
   PREINIT:
      nptr            recordHandle;
      nuint16           retSize = 0;
      nuint8            eofFlag = 0;
      nuint32           prevpos = 0;
      long              buffSize = 0;
#ifdef AUDIT_DBG
		char rcdBuffer[256];
#endif      
   PPCODE:
#ifdef AUDIT_DBG
      DBGMSG((DBG_ARGS, "NWADOpenRecordFile(%X, %d, %d, %p, %d)\n", conn, auditIDType, auditID, auditHandle, fileCode));
#endif
      ErrCode = NWADOpenRecordFile(conn, auditIDType, auditID, auditHandle, fileCode, &recordHandle);
           EXTEND(sp, 1);
      if (!ErrCode)
        {
#ifdef AUDIT_DBG
      ErrCode = 0;
      buffSize = sizeof(rcdBuffer);
      ErrCode = NWADReadRecord( recordHandle, buffSize, (nint16)1, (pnuint8)rcdBuffer,
                              (pnuint16)&retSize, (pnuint8)&eofFlag, (pnuint32)&prevpos);

      if (ErrCode || eofFlag )
      {
         DBGMSG((DBG_DUMP, "ErrCode is %d (%X), eofFlag = %d, retSize = %d\n", ErrCode, ErrCode, eofFlag, retSize));
      }
      DBGMSG((DBG_DUMP, "NWADOpenRecordFile() returning handle %X\n", recordHandle));
#endif
                PUSHs(sv_2mortal((SV*)newSViv((long)recordHandle)));
           }else{
            DBGMSG((DBG_NWRET, "NWADOpenRecordFile() returned %X\n", ErrCode));
                PUSHs(&sv_undef);
        }




void
ndsm_ReadAllRecords(recordHandle, auditIDType)
      nptr            recordHandle;
      nuint32         auditIDType;
   PREINIT:
      nuint16           retSize = 0;
      nuint8            eofFlag = 0;
      nuint32           prevpos = 0;
      nuint8            rcdBuffer[512];
      char              szRecord[RET_BUF_SIZE];
      long                                      buffSize = 0;
   PPCODE:
           tzset();
#ifdef AUDIT_DBG
            DBGMSG((DBG_ARGS, "ReadAllRecords(%X, %lu)\n", recordHandle, auditIDType));
#endif

        buffSize = sizeof(rcdBuffer);
   while (1)
   {

      memset( rcdBuffer, 0, buffSize );
      memset( szRecord, 0, buffSize );
      ErrCode = 0;
      ErrCode = NWADReadRecord( recordHandle, buffSize, (nint16)1, (pnuint8)rcdBuffer,
                              (pnuint16)&retSize, (pnuint8)&eofFlag, (pnuint32)&prevpos);

      if (ErrCode || eofFlag )
      {
         DBGMSG((DBG_DUMP, "ErrCode is %d (%X), eofFlag = %d, retSize = %d\n", ErrCode, ErrCode, eofFlag, retSize));
         break;
      }

      if (retSize > 0)
      {
        switch (auditIDType)
              {
                      case AUDIT_ID_IS_CONTAINER:
                DoContainerRecord(PArg_ (NWContAuditRecord*)rcdBuffer, szRecord, RET_BUF_SIZE);
                   break;
                        case AUDIT_ID_IS_VOLUME:
                         DoVolumeRecord(PArg_ (NWVolumeAuditRcd*)rcdBuffer, szRecord, RET_BUF_SIZE);
                break;
                 case AUDIT_ID_IS_TRUSTED_NETWARE:
                        *szRecord = '\0';
                   break;
        };
         EXTEND(sp, 1);
         DBGMSG((DBG_NWRET, "Pushing %s onto stack\n", szRecord));
         PUSHs(sv_2mortal((SV*)newSVpv(szRecord, strlen(szRecord))));
      }
      else
      {
         DBGMSG((DBG_DUMP, "NWADReadRecord returned retsize = %d\n", retSize));
      }

   }// while
   freeUserIndex(PArg);





NWRCODE
ndsm_NWADCloseRecordFile(recordHandle)
      nptr   recordHandle;
   CODE:
      RETVAL = NWADCloseRecordFile(&recordHandle);
   OUTPUT:
      RETVAL





NWRCODE
ndsm_NWADClose(auditHandle)
      nptr   auditHandle;
   CODE:
      RETVAL = NWADClose(&auditHandle);
   OUTPUT:
      RETVAL


