package NDSm;

use strict;
use NDSm::Reg;
use vars qw($BIN_DEBUG $REGUSER $REGCODE $VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;
require DynaLoader;


@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(

);
$VERSION = '1.00';

bootstrap NDSm $VERSION;

SetRegInfo($NDSm::Reg::REGUSER, $NDSm::Reg::REGCODE);

my $InitStatus = &NWCallsInit(0, 0);
die("Init failed, error: #$InitStatus\n") if ($InitStatus);
			      
my ($CodePage, $CountryId) = &NWLlocaleconv();
&NWInitUnicodeTables($CountryId, $CodePage);

BEGIN { }


END {
	&NWCallsTerm(0);
	&NWFreeUnicodeTables();
}



sub new {
   my $proto = shift;
	my $class = ref($proto) || $proto;
   my $self  = {};
	$self->{CONTEXT} = undef;
	$self->{LAST_ERR} = 0;
	$self->{DEBUG} = 0;
	bless ($self, $class);
	$self->_Init();
   return $self;
}


sub DESTROY {
	my $self = shift;
   &NWDSFreeContext($self->{CONTEXT});
}



sub AuditGetObjectID {
   my $self = shift;
   my $obj = shift;
   my ($conn, $audid) = &NWDSAuditGetObjectID($self->{CONTEXT}, $obj);
   if (!defined($conn) || !defined($audid)) {
     $self->{LAST_ERR} = GetLastErr();
	  warn "AuditGetObjectID returning <undef>\n" if $self->{DEBUG};
     undef;
	}else {($conn, $audid, 1);}
}



sub GetConst {
      my ($self, $ConstName)  = @_;
	   return &NDSm::constant($ConstName, 0);
}




sub GetHandle{
	my $self = shift;
	return $self->{CONTEXT};
}



sub _Init {
	my $self = shift;
	if (!defined($self->{CONTEXT})){
	  $self->{CONTEXT} = &NDSm::NWDSCreateContextHandle();
     if ($self->{CONTEXT} == &NDSm::constant("ERR_CONTEXT_CREATION", 0)){
     undef $self->{CONTEXT};
	  }else{
# Turn typeless naming on and canonicalize names off as default.
       my $Flags = $self->GetContext("DCK_FLAGS");
       $Flags |= &NDSm::constant("DCV_TYPELESS_NAMES", 0);
       $Flags &= ~&NDSm::constant("DCV_CANONICALIZE_NAMES", 0);
       my $Status = $self->SetContext("DCK_FLAGS", $Flags);
       if ($Status) {$self->{LAST_ERR} = $Status;}
	  }
	}
}




sub IsInit {
	my $self=shift;
	return defined($self->{CONTEXT});
}


sub InitUnicodeTables {
   my $self = shift;
   NWFreeUnicodeTables();
   my ($CountryId, $CodePage) = @_;
   if (!$CountryId || !$CodePage){
     ($CodePage, $CountryId) = $self->LocaleConv();
   }
   return &NWInitUnicodeTables($CountryId, $CodePage);
}


sub GetContext {
	my $self = shift;
	my $Key = shift;
	my $Val = NWDSGetContext($self->{CONTEXT}, &NDSm::constant($Key,0));
	if (!defined($Val)) {
     $self->{LAST_ERR} = GetLastErr();
	  warn "GetContext returning <undef>\n" if $self->{DEBUG};
     undef;
	}else { $Val; }
}


sub LastErr {
	my $self = shift;
   ($self->{LAST_ERR}) ? $self->{LAST_ERR} : &NDSm::GetLastErr();
}


sub LocaleConv {
   my $self = shift;
   return &NWLlocaleconv();
}




sub SetContext {
	my $self = shift;
   my ($key, $value) = @_;
	return &NDSm::NWDSSetContext($self->{CONTEXT}, NDSm::constant($key, 0), $value);
}


sub Debug {
	my $self = shift;
   $self->{DEBUG} = shift;
}


1;
__END__



