/*
        +==========================================================+
        |                                                          |
        |           Novell NWServer extension for NT Perl          |
        |           -------------------------------------          |
        |           NWServer.xs : Implements methods for server    |
        |                         management.                      |
        |                                                          |
        |            by Steinar Kleven <stk@ahs.hist.no>           |
        |                                                          |
        |                  version 1.00                            |
        |                                                          |
        |                                                          |
        | Copyright (c) 1997 Steinar Kleven. All rights reserved.  |
        |   This program is NOT free software, you can NOT         |
        |   redistribute it and/or modify it.                      |
        |                                                          |
        +==========================================================+
*/


#ifdef NLM_PLATFORM
  #define N_PLAT_NETWARE
  #define N_PLAT_NLM
  #define N_ARCH_32
  #ifndef LC_ALL
    #define LC_ALL 0
  #endif  
  #undef _Windows
  #undef _WIN32
#endif



/* If you want to use the internal debugging you should define this.
   You can comment it out if you want this extension to go 1 ns. faster. 
*/

// The different debug types OR'ed

#define DBG_ARGS 1
#define DBG_NWRET 2
#define DBG_DUMP 4

// #define NWSERV_DBG (DBG_ARGS|DBG_NWRET|DBG_DUMP)
#undef NWSERV_DBG

#if (NWSERV_DBG > 0)
#define DBGMSG(_x_)  if (_dbglvl _x_){ printf("%s, %d: ",__FILE__,__LINE__); \
                     _dbgprint _x_; }
#else
#define DBGMSG(_x_) 
#endif

#if defined (_Windows) || defined(_WIN32)
  #define WIN32_LEAN_AND_MEAN
  #include <windows.h>
#endif  

/* Turn of these annoying "Structure packing size .." Warnings */
#if defined(__BORLANDC__)
        #pragma warn -pck
#endif


#/* Novell SDK includes */
#include <ntypes.h>
#include <nwnet.h>
#include <nwcalls.h>
#include <nwserver.h>
#include <nwsm.h>
#include <nwclxcon.h>
#include <nwfse.h>


#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"


/* NDSm headers */
#include "NDSm.h"



/* ErrCode is set to the return value of last NW* called.
   Users creating scripts based on this extension can
   retrieve this by calling LastErr at class the error aqured.
*/

NWCCODE ErrCode = 0;


#ifdef NWSERV_DBG
bool _dbglvl(int type, char *format, ...)
{
 return (type && NWSERV_DBG);
}


int _dbgprint(int type, char *format, ...)
{
   va_list ap;
   int cnt;
   va_start(ap, type);
   cnt = va_arg(ap, int);

   if (NWSERV_DBG & type)
   {
      cnt = vprintf(format, ap);
   }
   va_end(ap);
   return(cnt);
}
#endif




MODULE = NDSm::NWServer  PACKAGE = NDSm::NWServer  PREFIX = ndsm_
PROTOTYPES: ENABLE

long
ndsm_constant(name,arg)
        char *          name
        int             arg
        CODE:
        RETVAL = constant(name, arg);
   OUTPUT:
      RETVAL


#/* Returns the last ErrCode */
NWCCODE
ndsm_GetLastErr()
        CODE:
                RETVAL = ErrCode;
        OUTPUT:
                RETVAL




#/* Set the registration info in .LIB */
void
ndsm_SetRegInfo(Key, Code)
                char *Key;
      long Code;
        CODE:
           libSetRegInfo(Key, Code);
                

#/* NWAddTrustee is NOT verified */
#/* Implemented in NWServer.pm */
NWCCODE
ndsm_NWAddTrustee (conn, dirHandle, path, objID, rightsMask)
      NWCONN_HANDLE     conn;
      NWDIR_HANDLE      dirHandle;
      pnstr8            path;
      nuint32           objID;
      nuint16           rightsMask;
   CODE:
      RETVAL = NWAddTrustee(conn, dirHandle, path, objID, rightsMask);
#ifdef NWSERV_DBG
                printf("NWAddTrustee: %d, %d, %s, %d, %X\n", conn, dirHandle, path, objID, rightsMask);
      printf("NWAddTrustee returned %d\n", RETVAL);
#endif
   OUTPUT:
      RETVAL




#/* NWCallsInit() is verified   */
#/* Implemented in *.pm         */
NWDSCCODE
ndsm_NWCallsInit(unused1,unused2)
        void * unused1;
        void * unused2;
        CODE:
                RETVAL = NWCallsInit(NULL, NULL);
        OUTPUT:
        RETVAL



#/* NWCallsTerm() is verified   */
#/* Implemented in *.pm         */
NWDSCCODE
ndsm_NWCallsTerm(unused1)
        void * unused1 = NULL;
        CODE:
                RETVAL = NWCallsTerm(unused1);
        OUTPUT:
        RETVAL



#/* NWAttachToFileServer() is verified   */
#/* Implemented in *.pm         */
void
ndsm_NWAttachToFileServer(serverName, scopeFlag)
                pnstr8                  serverName;
        nuint16                 scopeFlag;
        PREINIT:
        NWCONN_HANDLE                           newConnID;
        PPCODE:
                ErrCode = NWAttachToFileServer(serverName, scopeFlag, &newConnID);
           EXTEND(sp, 1);
      if (!ErrCode)
                {
                  PUSHs(sv_2mortal((SV*)newSViv(newConnID)));
                }else{
                 PUSHs(&sv_undef);
                }



#/* Implemented in NWServer.pm */
NWCCODE
ndsm_NWSMExecuteNCFFile (connHandle, NCFFileName)
                NWCONN_HANDLE   connHandle;
                pnstr8          NCFFileName;
                CODE:
      RETVAL = NWSMExecuteNCFFile (connHandle, NCFFileName);
        OUTPUT:
        RETVAL

#/* Implemented in NWServer.pm */
NWCCODE
ndsm_NWSMLoadNLM (connHandle, loadCommand)
                NWCONN_HANDLE    connHandle;
                pnstr8           loadCommand;
        CODE:
        RETVAL = NWSMLoadNLM (connHandle, loadCommand);
        OUTPUT:
        RETVAL

#/* Implemented in NWServer.pm */
NWCCODE
ndsm_NWSMUnloadNLM (connHandle, NLMName)
                NWCONN_HANDLE    connHandle;
                pnstr8           NLMName;
        CODE:
                RETVAL = NWSMUnloadNLM (connHandle, NLMName);
        OUTPUT:
        RETVAL


void
ndsm_NWCCGetConnRefInfo(connRef, infoType)
      nuint32   connRef;
      nuint     infoType;
   PREINIT:
                SV*         Ret;
                nptr        value;
                nuint32     MyInt;
   PPCODE:
                switch (infoType){
                case NWCC_INFO_AUTHENT_STATE:
                case NWCC_INFO_BCAST_STATE:
                case NWCC_INFO_CONN_NUMBER:
                case NWCC_INFO_NDS_STATE:
      case NWCC_INFO_MAX_PACKET_SIZE:
      case NWCC_INFO_LICENSE_STATE:
      case NWCC_INFO_DISTANCE:
      case NWCC_INFO_CONN_REF:
      case NWCC_INFO_USER_ID:
                        value = &MyInt;
                        ErrCode = NWCCGetConnRefInfo (connRef, infoType, sizeof(nuint32), value);
                        Ret = newSViv(MyInt);
                break;
                case NWCC_INFO_SERVER_NAME:
                case NWCC_INFO_TREE_NAME:
                        Newz(0, value, 2*(MAX_DN_CHARS+1), char);
                        ErrCode = NWCCGetConnRefInfo (connRef, infoType, 2*(MAX_DN_CHARS+1), value);
                        Ret = newSVpv((char*)value, strlen((const char*)value));
                        Safefree(value);
                break;
                default:
                        croak("Illegal key type received in NWCCGetConnRefInfo: %d.\n", infoType);
                };
                EXTEND(sp, 1);
                if (!ErrCode)
                {
                  PUSHs(sv_2mortal((SV*)Ret));
                }else{
                  PUSHs(&sv_undef);
                }




#/* NWCCLicenseConn is NOT verified */
#/* Implemented in NWServer.pm   */
NWRCODE
ndsm_NWCCLicenseConn (conn)
                NWCONN_HANDLE   conn;
         CODE:
                RETVAL = NWCCLicenseConn(conn);
         OUTPUT:
                RETVAL


#/* NWCCOpenConnByName is NOT verified */
#/* Implemented in NWServer.pm   */
void
ndsm_NWCCOpenConnByName(startConnHandle, name, nameFormat, openState, tranType)
           NWCONN_HANDLE    startConnHandle;
        pnstr8           name;
        nuint            nameFormat;
        nuint            openState;
        nuint            tranType;
   PREINIT:
        NWCONN_HANDLE     newConnID;
        PPCODE:
   DBGMSG((DBG_ARGS, "NWCCOpenConnByName(%d, %s, %d, %d, %d)\n",startConnHandle, name, nameFormat, openState, tranType));
        ErrCode = NWCCOpenConnByName(startConnHandle, name, nameFormat, openState, tranType, &newConnID);
           EXTEND(sp, 1);
      if (!ErrCode)
                {
                  PUSHs(sv_2mortal((SV*)newSViv(newConnID)));
                }else{
                 PUSHs(&sv_undef);
                }

void
ndsm_NWCCOpenConnByRef(connRef, openState, reserved)
      nuint32           connRef;
      nuint             openState;
      nuint             reserved;
   PREINIT:
      NWCONN_HANDLE     ConnHandle;
   PPCODE:
      ErrCode = NWCCOpenConnByRef(connRef, openState, reserved, &ConnHandle);
      EXTEND(sp, 1);
      if (!ErrCode)
                {
         DBGMSG((DBG_DUMP, "NWCCOpenConnByRef returning connection %X\n", ConnHandle));
                   PUSHs(sv_2mortal((SV*)newSViv(ConnHandle)));
                }else{
                PUSHs(&sv_undef);
                }


void
ndsm_NWCCScanConnRefs (scanIterator)
      nuint32   scanIterator;
   PREINIT:
      nuint32   connRef;
        PPCODE:
      ErrCode = NWCCScanConnRefs(&scanIterator, &connRef);
      if (!ErrCode)
                {
         EXTEND(sp, 2);
                   PUSHs(sv_2mortal((SV*)newSViv(scanIterator)));
                   PUSHs(sv_2mortal((SV*)newSViv(connRef)));
                }



#/* NWCheckConsolePrivileges is NOT verified */
#/* Implemented in NWServer.pm   */
NWCCODE
ndsm_NWCheckConsolePrivileges(conn)
         NWCONN_HANDLE   conn;
         CODE:
         RETVAL = NWCheckConsolePrivileges(conn);
         OUTPUT:
         RETVAL



NWRCODE
ndsm_NWCLXInit (arg1, arg2)
                void *  arg1;
      void *    arg2;
        CODE:
        RETVAL = NWCLXInit(NULL, NULL);
   OUTPUT:
        RETVAL


NWRCODE
ndsm_NWCLXTerm ()
        CODE:
        RETVAL = NWCLXTerm(NULL);
   OUTPUT:
        RETVAL



#/* NWCreateDirectory is NOT tested */
#/* Implemented in NWServer.pm */
NWCCODE
ndsm_NWCreateDirectory (conn, dirHandle, dirPath, accessMask)
      NWCONN_HANDLE   conn;
      NWDIR_HANDLE    dirHandle;
      pnstr8          dirPath;
      nuint8          accessMask;
   CODE:
      RETVAL = NWCreateDirectory (conn, dirHandle, dirPath, accessMask);
   OUTPUT:
      RETVAL


#/* NWDeleteDirectory is NOT tested */
#/* Implemented in NWServer.pm */
NWCCODE
ndsm_NWDeleteDirectory (conn, dirHandle, dirPath)
      NWCONN_HANDLE   conn;
      NWDIR_HANDLE    dirHandle;
      pnstr8          dirPath;
   CODE:
      RETVAL = NWDeleteDirectory (conn, dirHandle, dirPath);
   OUTPUT:
      RETVAL



#/* NWDeleteTrustee is NOT tested */
#/* Implemented in NWServer.pm */
NWCCODE
ndsm_NWDeleteTrustee (conn, dirHandle, dirPath, ObjectID)
      NWCONN_HANDLE     conn;
      NWDIR_HANDLE      dirHandle;
      pnstr8            dirPath;
      nuint32           ObjectID;
   CODE:
      RETVAL = NWDeleteTrustee(conn, dirHandle, dirPath, ObjectID);
   OUTPUT:
      RETVAL




#/* NWDisableFileServerLogin() is NOT verified  */
#/* Implemented in NWServer.pm   */
NWCCODE
ndsm_NWDisableFileServerLogin(conn)
         NWCONN_HANDLE     conn;
         CODE:
         RETVAL = NWDisableFileServerLogin(conn);
         OUTPUT:
         RETVAL



#/* NWDownFileServer() is NOT verified  */
#/* Implemented in NWServer.pm   */
NWCCODE
ndsm_NWDownFileServer(conn, forceFlag)
         NWCONN_HANDLE     conn;
         nuint8            forceFlag;
         CODE:
         RETVAL = NWDownFileServer(conn, forceFlag);
         OUTPUT:
         RETVAL


#/* NWDSAuthenticateConn() is NOT verified  */
#/* Implemented in NWServer.pm   */
NWDSCCODE
ndsm_NWDSAuthenticateConn(context, connHandle)
                NWDSContextHandle   context
                NWCONN_HANDLE       connHandle
        CODE:
                RETVAL = NWDSAuthenticateConn(context, connHandle);
        OUTPUT:
                RETVAL



#/* Not used in 1.0
void
ndsm_NWDSGetConnectionInfo(conn)
                NWCONN_HANDLE        conn;
        PREINIT:
                nuint8                              connStatus ;
                nuint8                              connType ;
                nuint8                              serverFlags;
                nuint8                              serverName;
                nuint8                              transType;
                nuint32                             transLen;
                nuint8                              transBuf;
                nuint16                             distance;
                nuint16                             maxPacketSize;
        PPCODE:
                ErrCode = NWDSGetConnectionInfo(conn, &connStatus, &connType, &serverFlags, &serverName, &transType, &transLen, &transBuf, &distance, &maxPacketSize);
                if (!ErrCode){
                  EXTEND(sp, 9);
                  PUSHs(sv_2mortal((SV*)newSViv(connStatus)));
                  PUSHs(sv_2mortal((SV*)newSViv(connType)));
                  PUSHs(sv_2mortal((SV*)newSViv(serverFlags)));
                  PUSHs(sv_2mortal((SV*)newSViv(serverName)));
                  PUSHs(sv_2mortal((SV*)newSViv(transType)));
                  PUSHs(sv_2mortal((SV*)newSViv(transLen)));
                  PUSHs(sv_2mortal((SV*)newSViv(transBuf)));
                  PUSHs(sv_2mortal((SV*)newSViv(distance)));
                  PUSHs(sv_2mortal((SV*)newSViv(maxPacketSize)));
                }else{
                  EXTEND(sp, 1);
                  PUSHs(&sv_undef);
                }
#*/

#/* NWDSGetConnectionSlot() is obsolete 6/96
NWDSCCODE
ndsm_NWDSGetConnectionSlot(connType, transType, transLen, transBuf, conn)
                nuint8                  connType;
                nuint8                  transType;
                nuint32                 transLen;
                nuint8                  transBuf;
                NWCONN_HANDLE              conn;
        CODE:
                RETVAL = NWDSGetConnectionSlot(connType, transType, transLen, &transBuf, &conn);
        OUTPUT:
                transBuf
                conn
                RETVAL
#*/



#/* NWDSMapNameToID() is NOT verified  */
#/* Implemented in NWServer.pm */
void
ndsm_NWDSMapNameToID (context, conn, object)
                NWDSContextHandle   context;
                NWCONN_HANDLE       conn;
                pnstr8              object;
   PREINIT:
                nuint32             objectID;
        PPCODE:
                ErrCode = NWDSMapNameToID (context, conn, object, &objectID);
           EXTEND(sp, 1);
      if (!ErrCode)
                {
                  PUSHs(sv_2mortal((SV*)newSViv(objectID)));
                }else{
                 PUSHs(&sv_undef);
                }


#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSSetMonitoredConnection(conn)
#   NWCONN_HANDLE   conn;
#   CODE:
#   RETVAL = NWDSSetMonitoredConnection(conn);
#   OUTPUT:
#   RETVAL



#/* Not used in 1.0 */
# NWDSCCODE
#   NWCONN_HANDLE   conn;
#   CODE:
#   RETVAL = NWDSUnlockConnection (conn);
#   OUTPUT:
#   RETVAL



#/* NWEnableFileServerLogin() is NOT verified  */
#/* Implemented in NWServer.pm   */
NWCCODE
ndsm_NWEnableFileServerLogin(conn)
         NWCONN_HANDLE     conn;
         CODE:
         RETVAL = NWEnableFileServerLogin(conn);
         OUTPUT:
         RETVAL


#/* NWGetConnectionHandle() is verified  */
#/* Implemented in NWServer.pm   */
void
ndsm_NWGetConnectionHandle(serverName, reserved1, reserved2)
        pnstr8          serverName;
        nuint16         reserved1 = NULL;
        pnuint16                reserved2 = NULL;
        PREINIT:
        NWCONN_HANDLE   conn;
        PPCODE:
      ErrCode = NWGetConnectionHandle((unsigned char*)serverName, reserved1, &conn, reserved2);
           EXTEND(sp, 1);
           if(!ErrCode)
           {
         DBGMSG((DBG_NWRET, "NWGetConnectionHandle returning %u\n", conn));
              PUSHs(sv_2mortal((SV*)newSViv(conn)));
           }else{
              PUSHs(&sv_undef);
           }


#/* NWGetExtendedVolumeInfo is NOT verified */
#/* Implemented in NWServer.pm */
void
ndsm_NWGetExtendedVolumeInfo(conn, volNum)
                NWCONN_HANDLE              conn;
        nuint16                    volNum;
        PREINIT:
        NWVolExtendedInfo *volinfo;
   PPCODE:
                New(0, volinfo, 1, NWVolExtendedInfo);
#ifdef NWSERV_DBG
      printf ("XS_NWGetExtendedVolumeInfo(%d, %d\n", conn, volNum);
#endif
      ErrCode = NWGetExtendedVolumeInfo(conn, volNum, volinfo);
#ifdef NWSERV_DBG
      printf ("XS_NWGetExtendedVolumeInfo, ReturnCode: %lu\n", ErrCode);
#endif
      if (!ErrCode)
        {
        EXTEND(sp, 33);
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->volType)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->statusFlag)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->sectorSize)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->sectorsPerCluster)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->volSizeInClusters)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->freeClusters)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->subAllocFreeableClusters)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->freeableLimboSectors)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->nonfreeableLimboSectors)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->availSubAllocSectors)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->nonuseableSubAllocSectors)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->subAllocClusters)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->numDataStreams)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->numLimboDataStreams)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->oldestDelFileAgeInTicks)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->numCompressedDataStreams)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->numCompressedLimboDataStreams)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->numNoncompressibleDataStreams)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->precompressedSectors)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->compressedSectors)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->numMigratedDataStreams)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->migratedSectors)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->clustersUsedByFAT)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->clustersUsedByDirs)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->clustersUsedByExtDirs)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->totalDirEntries)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->unusedDirEntries)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->totalExtDirExtants)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->unusedExtDirExtants)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->extAttrsDefined)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->extAttrExtantsUsed)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->DirectoryServicesObjectID)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->volLastModifiedDateAndTime)));
                }else{
        EXTEND(sp, 1);
                PUSHs(&sv_undef);
        }
      Safefree(volinfo);


#/* NWGetFileServerUTCTime() is NOT verified  */
NWDSCCODE
ndsm_NWGetFileServerUTCTime (conn, time)
        NWCONN_HANDLE   conn;
        nuint32         time;
        CODE:
        RETVAL = NWGetFileServerUTCTime (conn, &time);
        OUTPUT:
        time
        RETVAL





#/* Obsolete 6/96, Call NWCCScanConnRefs instead */
NWDSCCODE
ndsm_NWGetNextConnectionID (conn)
        NWCONN_HANDLE    conn;
        CODE:
        RETVAL = NWGetNextConnectionID (&conn);
        OUTPUT:
        conn
        RETVAL




void
ndsm_NWGetObjDiskRestrictions (conn, volNumber, objectID)
                NWCONN_HANDLE   conn;
        nuint8          volNumber;
        nuint32         objectID;
        PREINIT:
        nuint32        restriction;
        nuint32        inUse;
   PPCODE:
        ErrCode = NWGetObjDiskRestrictions(conn, volNumber, objectID, &restriction, &inUse);
           if (!ErrCode)
        {
                        EXTEND(sp, 2);
        PUSHs(sv_2mortal((SV*)newSViv(restriction)));
                PUSHs(sv_2mortal((SV*)newSViv(inUse)));
                }else{
         EXTEND(sp, 1);
                PUSHs(&sv_undef);
        }


#/* NWGetSetCommandValue is verified */
#/* Implemented in NWServer.pm */
void
ndsm_NWGetSetCommandValue (conn, setCommand)
        NWCONN_HANDLE           conn;
                pnstr8          setCommand;
        PREINIT:
        NWFSE_SERVER_SET_CMDS_INFO CmdInfo;
      nuint32           startNum = 0;
      bool                                      found = 0;
   PPCODE:
        CmdInfo.numberOfSetCommands = 1; //Just to enter the while()
      ErrCode = 0;
      while(!found && !ErrCode && (startNum < CmdInfo.numberOfSetCommands))
      {
        ErrCode = NWGetServerSetCommandsInfo (conn, startNum, &CmdInfo);
                        DBGMSG((DBG_DUMP, "%s\n", CmdInfo.setNameAndValueInfo));
        if (!stricmp((const char*)CmdInfo.setNameAndValueInfo, setCommand))
                found = TRUE;
                startNum++;
      }
      EXTEND(sp, 1);
                if (!ErrCode && found)
                {
                        DBGMSG((DBG_DUMP, "SET varable %s, type:%d\n",CmdInfo.setNameAndValueInfo, CmdInfo.setCmdType));
                        if (CmdInfo.setCmdType == FSE_TYPE_STRING)
                        {
                PUSHs(sv_2mortal((SV*)newSVpv((char*)&(CmdInfo.setNameAndValueInfo[strlen((const char*)&CmdInfo.setNameAndValueInfo)+1]), 0)));
                        }
                        else
                        {
                                DBGMSG((DBG_NWRET, "Value is %ld\n", CmdInfo.setNameAndValueInfo[strlen((const char*)CmdInfo.setNameAndValueInfo)+1]));
                        PUSHs(sv_2mortal((SV*)newSViv((long)CmdInfo.setNameAndValueInfo[strlen((const char*)CmdInfo.setNameAndValueInfo)+1])));
                        }
                }else{
                        PUSHs(&sv_undef);
                }



#/* NWGetVolumeNumber is verified */
#/* Implemented in NWServer.pm */
void
ndsm_NWGetVolumeNumber (conn, volName)
        NWCONN_HANDLE   conn;
        pnstr8          volName;
        PREINIT:
        nuint16        volNum;
        PPCODE:
        ErrCode = NWGetVolumeNumber(conn, volName, &volNum);
                EXTEND(sp, 1);
           if (!ErrCode)
        {
        PUSHs(sv_2mortal((SV*)newSViv(volNum)));
                }else{
                PUSHs(&sv_undef);
        }


#/* NWGetVolumeName is verified */
#/* Implemented in NWServer.pm */
void
ndsm_NWGetVolumeName (conn, volNum)
        NWCONN_HANDLE   conn;
        nuint16        volNum;
        PREINIT:
                pnstr8          volName;
        PPCODE:
        Newz(0, volName, 17, char);
           ErrCode = NWGetVolumeName (conn, volNum, volName);
        EXTEND(sp, 1);
           if (!ErrCode && *volName != '\0')
        {
                PUSHs(sv_2mortal((SV*)newSVpv(volName, strlen(volName))));
        }else{
                PUSHs(&sv_undef);
        }
        Safefree(volName);



#/* NWSetObjectVolSpaceLimit is verified */
#/* Implemented in NWServer.pm */
NWCCODE
ndsm_NWSetObjectVolSpaceLimit (conn, volNum, objectID, Max)
   NWCONN_HANDLE   conn;
   nuint16         volNum;
   nuint32         objectID;
   nuint32         Max;
   CODE:
#ifdef NWSERV_DBG
        printf("XS_NWSetObjectVolSpaceLimit, 4000 bytes Units: %lu\n", Max);
#endif
      RETVAL = NWSetObjectVolSpaceLimit(conn, volNum, objectID, Max);
   OUTPUT:
        RETVAL


#/* NWSMSetDynamicCmdIntValue is NOT verified */
#/* Implemented in NWServer.pm */
NWCCODE
ndsm_NWSMSetDynamicCmdIntValue(connHandle, setCommandName, cmdValue)
                NWCONN_HANDLE   connHandle;
        pnstr8          setCommandName;
        nuint32         cmdValue;
   CODE:
      RETVAL = NWSMSetDynamicCmdIntValue(connHandle, setCommandName, cmdValue);
   OUTPUT:
      RETVAL


#/* NWSMSetDynamicCmdStrValue is NOT verified */
#/* Implemented in NWServer.pm */
NWCCODE
ndsm_NWSMSetDynamicCmdStrValue(connHandle, setCommandName, cmdValue)
        NWCONN_HANDLE   connHandle;
        pnstr8          setCommandName;
        pnstr8         cmdValue;
   CODE:
           DBGMSG((DBG_ARGS, "NWSMSetDynamicCmdStrValue(%lu, %s, %s)\n", connHandle,
                        setCommandName, cmdValue));
      RETVAL = NWSMSetDynamicCmdStrValue(connHandle, setCommandName, cmdValue);
           DBGMSG((DBG_NWRET, "NWSMSetDynamicCmdStrValue() returned %X\n", RETVAL));
   OUTPUT:
      RETVAL

