#
# ChangeAttr.pl
# 
# This script demonstrates how to change attributes for an object using
# the perl extension NDSm. You can also learn how to write Login Scripts
# which are of type SYN_STREAM
#
# Copyright (c) 1997 Steinar Kleven
#




BEGIN { $| = 1; print "1..12\n"; }
use NDSm::NDSContext;
use NDSm::Buf_T;
print "ok 1\n";

$C = new NDSm::NDSContext;
$Buf = new NDSm::Buf_T;
print "ok 2\n" if $C;


print "THIS SCRIPT WILL CHANGE YOUR Surname AND LoginScript\n";
print "Please type \"ok\" to continue.\n";

$Val = <STDIN>;
die("You typed: $Val, Aborting..\n") if ($Val !~ /^ok$/i);

$Result = $C->IsDSAuthenticated();
if ($Result){print "ok 3\n"}else{die("You're not logged on, bailing out!!")};

# Get YOUR username, we don't want to mess around with others, do we?
$User = $C->WhoAmI();
print "ok 4\n" if defined($User);

$NewLoginScr = "#This is a sample\n#Loginscript inserted by NDSm 1.0\n";
$NewLastName = "NDSm-applied";
$Attribute = "Surname";

$Result = $Buf->AllocBuf();
print "ok 5\n" if !$Result;

$Result = $Buf->InitBuf($C->GetHandle(), "DSV_MODIFY_ENTRY");
print "ok 6\n" if !$Result;

print "ok 7\n";
print "ok 8\n";

$Result = $Buf->PutChange($C->GetHandle(), "DS_OVERWRITE_VALUE", $Attribute);
print "ok 9\n" if !$Result;

$Result = $Buf->PutAttrVal($C->GetHandle(), "SYN_CI_STRING", $NewLastName);
print "ok 10\n" if !$Result;

$Iter = $Buf->ModifyObject($C->GetHandle(), $User, -1, 0);
print "ok 11\n" if defined($Iter);


#
# Insert the new login script
#
$Attribute = "Login Script";
$nwFile = $Buf->OpenStream($C->GetHandle(), $User, $Attribute, "w");
if (defined($nwFile))
{ print $nwFile $NewLoginScr;
  $nwFile->truncate(length($NewLoginScr));
  print "ok 12\n";
}
else
{ print "Login script change failed\n"; }



