#
# GetAttr.pl
#
# This script demonstrates how to get selected attribute-values from NDS
# with the perl extension NDSm.
#
# Copyright (c) 1997 Steinar Kleven
#



BEGIN { $| = 1; print "1..11\n"; }
use NDSm::NDSContext;
use NDSm::Buf_T;
print "ok 1\n";


$C = new NDSm::NDSContext;

# Buffer for query
$InBuf = new NDSm::Buf_T;

# buffer for reply
$OutBuf = new NDSm::Buf_T;
print "ok 2\n" if ($C && $OutBuf && $InBuf);

#Attributes we should fetch
# This example reads 2 Strings, 1 Integer and a multiline string ("Home Directory").
@Attributes = ("Common Name", "Surname", "Password Minimum Length", "Home Directory");

$CHandle = $C->GetHandle();

# Standard Unicode init.
# NOT required any more
($code_page, $country_id) = $C->LocaleConv();
if (defined($code_page) && defined($country_id)){
  $C->InitUnicodeTables($code_page, $country_id);
}

# We can't do anything if we're not logged on
$Result = $C->IsDSAuthenticated();
if ($Result){print "ok 3\n"}else{die("You're not logged on, bailing out!!")};

# Get YOUR username, and try to get some values..
$Object = $C->WhoAmI();
print "ok 4\n" if defined($Object);


# Alloc and initiate buffer for NDS read operation.
$Result = $InBuf->AllocBuf();
print "ok 5\n" if !$Result;
$Result = $InBuf->InitBuf($CHandle, "DSV_READ");
print "ok 6\n" if !$Result;


# Alloc Result-buffer.
$Result = $OutBuf->AllocBuf();
print "ok 7\n" if !$Result;


# Put attributenames in query-buffer
$Result = 0;
$i=0;
while ($i < @Attributes){
  if ($InBuf->PutAttrName($CHandle, $Attributes[$i++])){
    $Result = 1;
  }
}
print "ok 8\n" if !$Result;

# Read NDS
# If you set $Iter to anything, it should be -1.
$Iter = $InBuf->Read($CHandle, $Object, "DS_ATTRIBUTE_VALUES", 0, $Iter, $OutBuf);
print "ok 9\n" if (defined($Iter));

# Get number of attributes
$AttrCount = $OutBuf->GetAttrCount($CHandle);
print "AttrCount: $AttrCount\n";
print "ok 10\n" if defined($AttrCount);
$ok = 1; # To test for later
$outer=0;
while ($outer < $AttrCount) {
  ($AttrName, $ValCount, $SyntaxId) = $OutBuf->GetAttrName($CHandle);
  $ok = 0 if (!defined($AttrName));
  $inner = 0;
  while ($inner < $ValCount)
  {
    $AttrVal = $OutBuf->GetAttrVal($CHandle, $SyntaxId);
    if (defined($AttrVal)){ print "$AttrName: $AttrVal\n";}
    else {$ok = 0;}
    $inner++;
  }
  $outer++;
}

print "ok 11\n" if $ok;

__END__

