#
# Audcont.pl
#
# This script demonstrates how to get all records from a container
# audit log.
#
# Copyright (c) 1997 Steinar Kleven
#



BEGIN { $| = 1; print "1..5\n"; }
use NDSm::NWServer;
use NDSm::Audit;

$ServerName = "SERVER_1";

print "ok 1\n";

$Server = new NDSm::NWServer($ServerName);
die("No such server: $ServerName") if (!$Server);

$Aud = new NDSm::Audit($Server, "SYS");

#
# Netware 4.x client requester uses NDS rights to determine if
# you have rights to read the audit logs.
# Look for the audit log object in NDS and set rights accordingly.
#
# $Value = $Aud->Login("password");
# print "Login returned $Value\n";

$Value = $Aud->Open();
print "Open returned $Value\n";

@Filelist = $Aud->GetFileList();

while ($val = pop(@Filelist)) {
    print "$val\n";
}

$Aud->OpenRecordFile(1);

$StartTime = time();
@Records = $Aud->ReadRecords();

$Sec = time() - $StartTime;

$i=0;
while ($val = $Records[$i]) {
    ($date, @vals) = split ("\t", $val);

    print localtime($date) . "-> @vals\n";
    $i++;
 }


print "$i records fetched in $Sec seconds\n";

__END__
