#
# FServer.pl
#
# This script demonstrates how to get information from a fileserver with
# the perl extension NDSm. You have to be logged in to the
# server to use this script. You must also have console operator
# rights.
#
# Copyright (c) 1997 Steinar Kleven
#


use NDSm;
use NDSm::NWServer;
use NDSm::Audit;


sub Mydie {
	$ErrMsg = shift;
	open LOG, ">>audit.err";
	print LOG $ErrMsg;
   print $ErrMsg;
   exit(-1);
}


sub GetErrAndDie {
	$Text = shift;
 	$Class = shift;
   Mydie($Text . ",error : ". $Class->LastErr());
}

$AuditType = "XXX";

while(!($AuditType =~ /[vcVC]/i))
{
  print "Do you want to get audit records for Volume or Context (v/c): ";
  chomp($AuditType = <STDIN>);
}

if ($AuditType =~ /[vV]/i)
{
   print "Tell me the server where the volume resides: ";
   chomp($ServerName = <STDIN>);
   print "Tell me the volume which has auditing enabled: ";
   chomp($ObjectToAudit = <STDIN>);
   $ParentObject = new NDSm::NWServer($ServerName);
   die("Could not create server object") if !(defined($ParentObject));
}
if ($AuditType =~ /[cC]/i)
{
   print "Tell me the context which has auditing enabled: ";
   chomp($ObjectToAudit = <STDIN>);
   $ParentObject = new NDSm;
   die("Could not NDSm object") if !(defined($ParentObject));
}

$Aud = new NDSm::Audit($ParentObject, $ObjectToAudit);
die("Could not create NDSm::Audit object") if !(defined($Aud));


$Result = $Aud->Open();
Mydie("Could not open audit connection, error : $Result\n") if $Result;


@Filelist = $Aud->GetFileList();

print "Old audit files:\n";
while ($val = pop(@Filelist)) {
    print "$val\n";
}

$Result = $Aud->OpenRecordFile(-1);
Mydie("Could not open audit file, error : $Result\n") if $Result;


$StartTime = time();
@Records = $Aud->ReadRecords();
GetErrAndDie("Could not read audit file ", $Aud) if !(defined(@Records));

$Sec = time() - $StartTime;

$i=0;
while ($val = $Records[$i++]) {
    ($date, @vals) = split ("\t", $val);
    print gmtime($date) . " @vals\n";
 }

print "$i records fetched in $Sec seconds\n";

$Result = $Aud->CloseRecordFile();
Mydie("Could not close audit file, error : $Result\n") if $Result;

$Result = $Aud->Close();
Mydie("Could not close audit connection, error : $Result\n") if $Result;


print "All methods passed\n";

__END__

