#
# FServer.pl
#
# This script demonstrates how to get information from a fileserver with
# the perl extension NDSm. You have to be logged in to the
# server to use this script. You must also have console operator
# rights.
#
# Copyright (c) 1997 Steinar Kleven
#



use NDSm::NWServer;


sub Mydie {
	$ErrMsg = shift;
	open LOG, ">>fserver.err";
	print LOG $ErrMsg;
   print $ErrMsg;
   exit(-1);
}


print "Type the name of the server to work with : ";
$ServerName = <STDIN>;
chomp($ServerName);
if (!defined($ServerName)){die("You have to tell me what server work with\n");}
print "Type the name of a volume on this server (<ENTER> for SYS) : ";
$Volume = <STDIN>;
chomp($Volume);
if (!$Volume) {$Volume = "SYS"};
print "Type the name of a ncf file to run : ";
$NCFFile = <STDIN>;
chomp($NCFFile);
print "Type the name of a NLM file to load : ";
$NLMFile = <STDIN>;
chomp($NLMFile);
print "Type \"1\" if you want to down server at the end of this script : ";
$Down = ((<STDIN> == "1\n") ? 1 : 0);

$Server = new NDSm::NWServer($ServerName);
Mydie("NWServer creation/connection failed") if (!defined($Server));

$Server->Debug(1);

$ConnHandle = $Server->GetHandle();

print "Connection handle is $ConnHandle\n";


$Value = $Server->CheckConsolePrivileges();
if ($Value) {
  Mydie("No consolle rights found\n");
}


$Value = $Server->ExecuteNCFFile($NCFFile);
Mydie("Error $Value excecuting $NCFFile\n") if ($Value);


@Volinfo = $Server->GetExtendedVolumeInfo($Volume);
Mydie("Error getting volume info for $Volume\n") if (!defined(@Volinfo));

print "volType              : $Volinfo[0]\n";
print "statusFlag           : $Volinfo[1]\n";
print "sectorSize           : $Volinfo[2]\n";
print "sectorsPerCluster    : $Volinfo[3]\n";
print "volSizeInClusters    : $Volinfo[4]\n";
print "freeClusters         : $Volinfo[5]\n";
print "subAllocFreeableClusters    : $Volinfo[6]\n";
print "freeableLimboSectors        : $Volinfo[7]\n";
print "nonfreeableLimboSectors     : $Volinfo[8]\n";
print "availSubAllocSectors        : $Volinfo[9]\n";
print "nonuseableSubAllocSectors   : $Volinfo[10]\n";
print "subAllocClusters            : $Volinfo[11]\n";
print "numDataStreams              : $Volinfo[12]\n";
print "numLimboDataStreams         : $Volinfo[13]\n";
print "oldestDelFileAgeInTicks     : $Volinfo[14]\n";
print "numCompressedDataStreams        : $Volinfo[15]\n";
print "numCompressedLimboDataStreams   : $Volinfo[16]\n";
print "numNoncompressibleDataStreams   : $Volinfo[17]\n";
print "precompressedSectors            : $Volinfo[18]\n";
print "compressedSectors           : $Volinfo[19]\n";
print "numMigratedDataStreams      : $Volinfo[20]\n";
print "migratedSectors             : $Volinfo[21]\n";
print "clustersUsedByFAT           : $Volinfo[22]\n";
print "clustersUsedByDirs          : $Volinfo[23]\n";
print "clustersUsedByExtDirs       : $Volinfo[24]\n";
print "totalDirEntries             : $Volinfo[25]\n";
print "unusedDirEntries            : $Volinfo[26]\n";
print "totalExtDirExtants          : $Volinfo[27]\n";
print "unusedExtDirExtants	        : $Volinfo[28]\n";
print "extAttrsDefined             : $Volinfo[29]\n";
print "extAttrExtantsUsed          : $Volinfo[30]\n";
print "DirectoryServicesObjectID       : $Volinfo[31]\n";
print "volLastModifiedDateAndTime      : $Volinfo[32]\n";

# Just verify.....
$VolNum = $Server->GetVolumeNumber($Volume);
$VolName = $Server->GetVolumeName($VolNum);
$Error = $Server->LastErr();
Mydie("GetVolumeNumber or GetVolumeName failed, errorcode: $Error")
				if (lc($VolName) ne lc($Volume));


$Result = $Server->LoadNLM($NLMFile);
Mydie("Could not load $NLMFile, Errorcode: $Result\n") if $Result;

sleep(3);

$Result = $Server->UnloadNLM($NLMFile);
Mydie("Could not unload $NLMFile, error $Result\n") if $Result;

$Result = $Server->GetSetCommandValue("Replace Console Prompt With Server Name");
$Error = $Server->LastErr();
Mydie("GetSetCommandValue failed, error $Error\n") if (!defined($Result));
print "\"Replace Console Prompt With Server Name\" is set ". ($Result ? "ON\n" : "OFF\n");

$TraceFile = $Server->GetSetCommandValue("NDS Trace Filename");
$Error = $Server->LastErr();
Mydie("GetSetCommandValue failed, error $Error\n") if (!defined($Result));
print "\"NDS Trace Filename\" is $TraceFile\n";


# Turn off server name as prompt...
$Result = $Server->SetDynamicCmdIntValue("Replace Console Prompt With Server Name", 0);
Mydie("SetDynamicCmdIntValue failed, error $Result\n") if ($Result);

# Set NDS trace file
$Result = $Server->SetDynamicCmdStrValue("NDS Trace Filename", "SYSTEM\\DSTRACE.OUT");
Mydie("SetDynamicCmdStrValue failed, error $Result\n") if ($Result);

# Set it back....
$Result = $Server->SetDynamicCmdStrValue("NDS Trace Filename", $TraceFile);
Mydie("SetDynamicCmdStrValue failed, error $Result\n") if ($Result);

# Disable login
$Value = $Server->DisableFileServerLogin();
Mydie("Error $Value disableing login") if $Value;

# Enable login
$Value = $Server->EnableFileServerLogin();
Mydie("Error $Value enableing login") if $Value;


# Downing fileserver even if files are open.
# You can feed the method != 0 and the file server will
# only go down if no files are open.
if ($Down)
{
	if (!$Server->DownFileServer(0))
   {
		Mydie("Error downing server\n");
	}else {print "Server $ServerName is going down NOW!.\n";}
}
else
{
	print "Downing server skipped.\n";
}

print "All methods passed\n";

__END__

