/*
	+==========================================================+
	|                                                          |
	|           Novell NDS extension for NT Perl               |
	|           --------------------------------               |
	|           constant.c : Implements all constants.         |
	|                                                          |
	|            by Steinar Kleven <stk@ahs.hist.no>           |
	|                                                          |
	|                  version v0.13.03b                       |
	|                                                          |
	|                                                          |
	| Copyright (c) 1997 Steinar Kleven. All rights reserved.  |
	|   This program is NOT free software, you can NOT         |
	|   redistribute it and/or modify it.                      |
	|                                                          |
	+==========================================================+
*/



#ifdef __cplusplus
extern "C" {   
#endif

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"


#define WIN32_LEAN_AND_MEAN
#include <windows.h>

/* Turn of these annoying "Structure packing size .." warnings */
#if defined(__BORLANDC__)
	#pragma warn -pck
#endif

/* Novell SDK includes */
#include "nwnet.h"
#include "nwcalls.h"
#include "nwlocale.h"
#include "nwdentry.h"
 

/* NDSm headers */
#include "NDSm.h"

#ifdef __cplusplus
}
#endif



static int not_here(s)
char *s;
{
    croak("%s not implemented on this architecture", s);
    return -1;
}

double constant(char *name, int arg)
/*char *name;
int arg;*/
{
    errno = 0;
    switch (*name) {
    case 'A':
	break;
    case 'B':
	break;
    case 'C':
	break;
    case 'D':
	 if (!strncmp(name, "DCV", 3))
	 {
		if (strEQ(name, "DCV_ASYNC_MODE"))
	 #ifdef DCV_ASYNC_MODE
		return DCV_ASYNC_MODE;
	 #else
		goto not_there;
	 #endif
	   if (strEQ(name, "DCV_CANONICALIZE_NAMES"))
    #ifdef DCV_CANONICALIZE_NAMES
	  	return DCV_CANONICALIZE_NAMES;
	 #else
	  	goto not_there;
	 #endif
	 	if (strEQ(name, "DCV_DEREF_ALIASES"))
	 #ifdef DCV_DEREF_ALIASES
    	return DCV_DEREF_ALIASES;
	 #else
	  	goto not_there;
	 #endif
	 	if (strEQ(name, "DCV_DEREF_BASE_CLASS"))
	 #ifdef DCV_DEREF_BASE_CLASS
	  	return DCV_DEREF_BASE_CLASS;
	 #else
	  	goto not_there;
	 #endif
	 	if (strEQ(name, "DCV_DISALLOW_REFERRALS"))
	 #ifdef DCV_DISALLOW_REFERRALS
	  	return DCV_DISALLOW_REFERRALS;
	 #else
	  	goto not_there;
	 #endif
	 	if (strEQ(name, "DCV_TYPELESS_NAMES"))
	 #ifdef DCV_TYPELESS_NAMES
	  	return DCV_TYPELESS_NAMES;
	 #else
	   goto not_there;
	 #endif
	 	if (strEQ(name, "DCV_XLATE_STRINGS"))
	 #ifdef DCV_XLATE_STRINGS
	  	return DCV_XLATE_STRINGS;
	 #else
	  	goto not_there;
	 #endif
	}//if (!strncmp(name, "DCV", 3))
   else if (!strncmp(name, "DCK", 3))
   {
		if (strEQ(name, "DCK_FLAGS"))
    #ifdef DCK_FLAGS
	   return DCK_FLAGS;
    #else
	   goto not_there;
	 #endif
		if (strEQ(name, "DCK_CONFIDENCE"))
	 #ifdef DCK_CONFIDENCE
	   return DCK_CONFIDENCE;
	 #else
	   goto not_there;
	 #endif
		if (strEQ(name, "DCK_NAME_CONTEXT"))
	 #ifdef DCK_NAME_CONTEXT
	   return DCK_NAME_CONTEXT;
	 #else
	   goto not_there;
	 #endif
		if (strEQ(name, "DCK_TRANSPORT_TYPE"))
	 #ifdef DCK_TRANSPORT_TYPE
	   return DCK_TRANSPORT_TYPE;
	 #else
	   goto not_there;
	 #endif
		if (strEQ(name, "DCK_REFERRAL_SCOPE"))
	 #ifdef DCK_REFERRAL_SCOPE
	   return DCK_REFERRAL_SCOPE;
	 #else
	   goto not_there;
	 #endif
		if (strEQ(name, "DCK_LAST_CONNECTION"))
	 #ifdef DCK_LAST_CONNECTION
	   return DCK_LAST_CONNECTION;
	 #else
	   goto not_there;
	 #endif
		if (strEQ(name, "DCK_TREE_NAME"))
	 #ifdef DCK_TREE_NAME
	   return DCK_TREE_NAME;
	 #else
	   goto not_there;
	 #endif
	}//if (!strncmp(name, "DCK", 3))
	else if (!strncmp(name, "DE", 2))
   {
		if (strEQ(name, "DELIM_DV"))
 	 #ifdef DELIM_DV
	   return DELIM_DV;
	 #else
	   goto not_there;
	 #endif
		if (strEQ(name, "DELIM_RDN"))
	 #ifdef DELIM_RDN
	   return DELIM_RDN;
	 #else
	   goto not_there;
	 #endif
		if (strEQ(name, "DELIM_VALUE"))
	 #ifdef DELIM_VALUE
		return DELIM_VALUE;
	 #else
		goto not_there;
	 #endif
	 }//if (!strncmp(name, "DE", 2))
	 else if (!strncmp(name, "DSV", 3))
	 {
		switch(name[4])
		{
		case 'A':
			if (strEQ(name, "DSV_ABORT_PARTITION_OPERATION"))
		#ifdef DSV_ABORT_PARTITION_OPERATION
			return DSV_ABORT_PARTITION_OPERATION;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_ADD_ENTRY"))
		#ifdef DSV_ADD_ENTRY
			return DSV_ADD_ENTRY;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_ADD_PARTITION"))
		#ifdef DSV_ADD_PARTITION
			return DSV_ADD_PARTITION;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_ADD_REPLICA"))
		#ifdef DSV_ADD_REPLICA
			return DSV_ADD_REPLICA;
		#else
			goto not_there;
		#endif
		break;
		case 'B':
			if (strEQ(name, "DSV_BACKUP_ENTRY"))
		#ifdef DSV_BACKUP_ENTRY
			return DSV_BACKUP_ENTRY;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_BEGIN_AUTHENTICATION"))
		#ifdef DSV_BEGIN_AUTHENTICATION
			return DSV_BEGIN_AUTHENTICATION;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_BEGIN_LOGIN"))
		#ifdef DSV_BEGIN_LOGIN
			return DSV_BEGIN_LOGIN;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_BEGIN_MOVE_ENTRY"))
		#ifdef DSV_BEGIN_MOVE_ENTRY
			return DSV_BEGIN_MOVE_ENTRY;
		#else
			goto not_there;
		#endif
		break;
		case 'C':
			if (strEQ(name, "DSV_CHANGE_PASSWORD"))
		#ifdef DSV_CHANGE_PASSWORD
			return DSV_CHANGE_PASSWORD;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_CHANGE_REPLICA_TYPE"))
		#ifdef DSV_CHANGE_REPLICA_TYPE
			return DSV_CHANGE_REPLICA_TYPE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_CHECK_LOGIN_RESTRICTIONS"))
		#ifdef DSV_CHECK_LOGIN_RESTRICTIONS
			return DSV_CHECK_LOGIN_RESTRICTIONS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_CLOSE_ITERATION"))
		#ifdef DSV_CLOSE_ITERATION
			return DSV_CLOSE_ITERATION;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_COMPARE"))
		#ifdef DSV_COMPARE
			return DSV_COMPARE;
		#else
			goto not_there;
		#endif
		break;
		case 'D':
			if (strEQ(name, "DSV_DEFINE_ATTR"))
		#ifdef DSV_DEFINE_ATTR
			return DSV_DEFINE_ATTR;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_DEFINE_CLASS"))
		#ifdef DSV_DEFINE_CLASS
			return DSV_DEFINE_CLASS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_DESIGNATE_NEW_MASTER"))
		#ifdef DSV_DESIGNATE_NEW_MASTER
			return DSV_DESIGNATE_NEW_MASTER;
		#else
			goto not_there;
		#endif
		break;
		case 'F':
			if (strEQ(name, "DSV_FINISH_AUTHENTICATION"))
		#ifdef DSV_FINISH_AUTHENTICATION
			return DSV_FINISH_AUTHENTICATION;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_FINISH_LOGIN"))
		#ifdef DSV_FINISH_LOGIN
			return DSV_FINISH_LOGIN;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_FINISH_MOVE_ENTRY"))
		#ifdef DSV_FINISH_MOVE_ENTRY
			return DSV_FINISH_MOVE_ENTRY;
		#else
			goto not_there;
		#endif
		break;
		case 'E':
			if (strEQ(name, "DSV_GET_EFFECTIVE_RIGHTS"))
		#ifdef DSV_GET_EFFECTIVE_RIGHTS
			return DSV_GET_EFFECTIVE_RIGHTS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_GET_REPLICA_ROOT_ID"))
		#ifdef DSV_GET_REPLICA_ROOT_ID
			return DSV_GET_REPLICA_ROOT_ID;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_GET_SERVER_ADDRESS"))
		#ifdef DSV_GET_SERVER_ADDRESS
			return DSV_GET_SERVER_ADDRESS;
		#else
			goto not_there;
		#endif
		break;
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
			if (strEQ(name, "DSV_INSPECT_ENTRY"))
		#ifdef DSV_INSPECT_ENTRY
			return DSV_INSPECT_ENTRY;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_JOIN_PARTITIONS"))
		#ifdef DSV_JOIN_PARTITIONS
			return DSV_JOIN_PARTITIONS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_LIST"))
		#ifdef DSV_LIST
			return DSV_LIST;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_LIST_CONTAINABLE_CLASSES"))
		#ifdef DSV_LIST_CONTAINABLE_CLASSES
			return DSV_LIST_CONTAINABLE_CLASSES;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_LIST_PARTITIONS"))
		#ifdef DSV_LIST_PARTITIONS
			return DSV_LIST_PARTITIONS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_LOGOUT"))
		#ifdef DSV_LOGOUT
			return DSV_LOGOUT;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_MODIFY_CLASS_DEF"))
		#ifdef DSV_MODIFY_CLASS_DEF
			return DSV_MODIFY_CLASS_DEF;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_MODIFY_ENTRY"))
		#ifdef DSV_MODIFY_ENTRY
			return DSV_MODIFY_ENTRY;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_MODIFY_RDN"))
		#ifdef DSV_MODIFY_RDN
			return DSV_MODIFY_RDN;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_OPEN_STREAM"))
		#ifdef DSV_OPEN_STREAM
			return DSV_OPEN_STREAM;
		#else
			goto not_there;
		#endif
		break;
		case 'R':
			if (strEQ(name, "DSV_READ"))
		#ifdef DSV_READ
			return DSV_READ;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_READ_ATTR_DEF"))
		#ifdef DSV_READ_ATTR_DEF
			return DSV_READ_ATTR_DEF;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_READ_CLASS_DEF"))
		#ifdef DSV_READ_CLASS_DEF
			return DSV_READ_CLASS_DEF;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_READ_ENTRY_INFO"))
		#ifdef DSV_READ_ENTRY_INFO
			return DSV_READ_ENTRY_INFO;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_READ_REFERENCES"))
		#ifdef DSV_READ_REFERENCES
			return DSV_READ_REFERENCES;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_READ_SYNTAXES"))
		#ifdef DSV_READ_SYNTAXES
			return DSV_READ_SYNTAXES;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_RELEASE_MOVED_ENTRY"))
		#ifdef DSV_RELEASE_MOVED_ENTRY
			return DSV_RELEASE_MOVED_ENTRY;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_REMOVE_ATTR_DEF"))
		#ifdef DSV_REMOVE_ATTR_DEF
			return DSV_REMOVE_ATTR_DEF;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_REMOVE_CLASS_DEF"))
		#ifdef DSV_REMOVE_CLASS_DEF
			return DSV_REMOVE_CLASS_DEF;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_REMOVE_ENTRY"))
		#ifdef DSV_REMOVE_ENTRY
			return DSV_REMOVE_ENTRY;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_REMOVE_PARTITION"))
		#ifdef DSV_REMOVE_PARTITION
			return DSV_REMOVE_PARTITION;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_REMOVE_REPLICA"))
		#ifdef DSV_REMOVE_REPLICA
			return DSV_REMOVE_REPLICA;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_REPAIR_RING"))
		#ifdef DSV_REPAIR_RING
			return DSV_REPAIR_RING;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_REPAIR_TIMESTAMPS"))
		#ifdef DSV_REPAIR_TIMESTAMPS
			return DSV_REPAIR_TIMESTAMPS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_RESOLVE_NAME"))
		#ifdef DSV_RESOLVE_NAME
			return DSV_RESOLVE_NAME;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_RESTORE_ENTRY"))
		#ifdef DSV_RESTORE_ENTRY
			return DSV_RESTORE_ENTRY;
		#else
			goto not_there;
		#endif
		break;
		case 'S':
			if (strEQ(name, "DSV_SEARCH"))
		#ifdef DSV_SEARCH
			return DSV_SEARCH;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_SEARCH_FILTER"))
		#ifdef DSV_SEARCH_FILTER
			return DSV_SEARCH_FILTER;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_SET_KEYS"))
		#ifdef DSV_SET_KEYS
			return DSV_SET_KEYS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_SPLIT_PARTITION"))
		#ifdef DSV_SPLIT_PARTITION
			return DSV_SPLIT_PARTITION;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_SYNC_PARTITION"))
		#ifdef DSV_SYNC_PARTITION
			return DSV_SYNC_PARTITION;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_SYNC_SCHEMA"))
		#ifdef DSV_SYNC_SCHEMA
			return DSV_SYNC_SCHEMA;
		#else
			goto not_there;
		#endif
		break;
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
			if (strEQ(name, "DSV_UNUSED_0"))
		#ifdef DSV_UNUSED_0
			return DSV_UNUSED_0;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DSV_VERIFY_PASSWORD"))
		#ifdef DSV_VERIFY_PASSWORD
			return DSV_VERIFY_PASSWORD;
		#else
			goto not_there;
		#endif
		default:
			break;
		};
	}//if (!strncmp(name, "DSV", 3))
	else if (!strncmp(name, "DS", 2))
	{
		switch(name[3])
		{
		case 'A':
		case 'B':
			if (strEQ(name, "DS_ABBREVIATED_VALUE"))
		#ifdef DS_ABBREVIATED_VALUE
			return DS_ABBREVIATED_VALUE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ADDITIONAL_VALUE"))
		#ifdef DS_ADDITIONAL_VALUE
			return DS_ADDITIONAL_VALUE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ADD_ATTRIBUTE"))
		#ifdef DS_ADD_ATTRIBUTE
			return DS_ADD_ATTRIBUTE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ADD_VALUE"))
		#ifdef DS_ADD_VALUE
			return DS_ADD_VALUE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ALIAS_ENTRY"))
		#ifdef DS_ALIAS_ENTRY
			return DS_ALIAS_ENTRY;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ALIAS_REFERRAL"))
		#ifdef DS_ALIAS_REFERRAL
			return DS_ALIAS_REFERRAL;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_AMBIGUOUS_CONTAINMENT"))
		#ifdef DS_AMBIGUOUS_CONTAINMENT
			return DS_AMBIGUOUS_CONTAINMENT;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_AMBIGUOUS_NAMING"))
		#ifdef DS_AMBIGUOUS_NAMING
			return DS_AMBIGUOUS_NAMING;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ATTRIBUTE_NAMES"))
		#ifdef DS_ATTRIBUTE_NAMES
			return DS_ATTRIBUTE_NAMES;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ATTRIBUTE_VALUES"))
		#ifdef DS_ATTRIBUTE_VALUES
			return DS_ATTRIBUTE_VALUES;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ATTR_COMPARE"))
		#ifdef DS_ATTR_COMPARE
			return DS_ATTR_COMPARE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ATTR_DEFS"))
		#ifdef DS_ATTR_DEFS
			return DS_ATTR_DEFS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ATTR_DEF_NAMES"))
		#ifdef DS_ATTR_DEF_NAMES
			return DS_ATTR_DEF_NAMES;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ATTR_MASK"))
		#ifdef DS_ATTR_MASK
			return DS_ATTR_MASK;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ATTR_READ"))
		#ifdef DS_ATTR_READ
			return DS_ATTR_READ;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ATTR_SELF"))
		#ifdef DS_ATTR_SELF
			return DS_ATTR_SELF;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ATTR_SUPERVISOR"))
		#ifdef DS_ATTR_SUPERVISOR
			return DS_ATTR_SUPERVISOR;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ATTR_WRITE"))
		#ifdef DS_ATTR_WRITE
			return DS_ATTR_WRITE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_BASECLASS"))
		#ifdef DS_BASECLASS
			return DS_BASECLASS;
		#else
			goto not_there;
		#endif
		break;
		case 'C':
			if (strEQ(name, "DS_CLASS_DEFS"))
		#ifdef DS_CLASS_DEFS
			return DS_CLASS_DEFS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_CLASS_DEF_NAMES"))
		#ifdef DS_CLASS_DEF_NAMES
			return DS_CLASS_DEF_NAMES;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_CLEAR_ATTRIBUTE"))
		#ifdef DS_CLEAR_ATTRIBUTE
			return DS_CLEAR_ATTRIBUTE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_CLEAR_VALUE"))
		#ifdef DS_CLEAR_VALUE
			return DS_CLEAR_VALUE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_CONTAINER_ALIAS"))
		#ifdef DS_CONTAINER_ALIAS
			return DS_CONTAINER_ALIAS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_CONTAINER_CLASS"))
		#ifdef DS_CONTAINER_CLASS
			return DS_CONTAINER_CLASS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_CONTAINER_ENTRY"))
		#ifdef DS_CONTAINER_ENTRY
			return DS_CONTAINER_ENTRY;
		#else
			goto not_there;
		#endif
		break;
		case 'D':
		case 'E':
			if (strEQ(name, "DS_EFFECTIVE_CLASS"))
		#ifdef DS_EFFECTIVE_CLASS
			return DS_EFFECTIVE_CLASS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_EFFECTIVE_PRIVILEGES"))
		#ifdef DS_EFFECTIVE_PRIVILEGES
			return DS_EFFECTIVE_PRIVILEGES;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ENTRY_ADD"))
		#ifdef DS_ENTRY_ADD
			return DS_ENTRY_ADD;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ENTRY_BROWSE"))
		#ifdef DS_ENTRY_BROWSE
			return DS_ENTRY_BROWSE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ENTRY_DELETE"))
		#ifdef DS_ENTRY_DELETE
			return DS_ENTRY_DELETE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ENTRY_MASK"))
		#ifdef DS_ENTRY_MASK
			return DS_ENTRY_MASK;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ENTRY_RENAME"))
		#ifdef DS_ENTRY_RENAME
			return DS_ENTRY_RENAME;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_ENTRY_SUPERVISOR"))
		#ifdef DS_ENTRY_SUPERVISOR
			return DS_ENTRY_SUPERVISOR;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_EXPANDED_CLASS_DEFS"))
		#ifdef DS_EXPANDED_CLASS_DEFS
			return DS_EXPANDED_CLASS_DEFS;
		#else
			goto not_there;
		#endif
		break;
		case 'F':
		case 'G':
		case 'H':
		case 'I':
			if (strEQ(name, "DS_FULL_CLASS_DEFS"))
		#ifdef DS_FULL_CLASS_DEFS
			return DS_FULL_CLASS_DEFS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_HIDDEN_ATTR"))
		#ifdef DS_HIDDEN_ATTR
			return DS_HIDDEN_ATTR;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_INFO_CLASS_DEFS"))
		#ifdef DS_INFO_CLASS_DEFS
			return DS_INFO_CLASS_DEFS;
		#else
			goto not_there;
		#endif
		break;
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
			if (strEQ(name, "DS_MATCHES_LIST_FILTER"))
		#ifdef DS_MATCHES_LIST_FILTER
			return DS_MATCHES_LIST_FILTER;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_NAMING"))
		#ifdef DS_NAMING
			return DS_NAMING;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_NCP_AUDITING"))
		#ifdef DS_NCP_AUDITING
			return DS_NCP_AUDITING;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_NCP_BINDERY_CONTEXT"))
		#ifdef DS_NCP_BINDERY_CONTEXT
			return DS_NCP_BINDERY_CONTEXT;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_NCP_FRAGMENT"))
		#ifdef DS_NCP_FRAGMENT
			return DS_NCP_FRAGMENT;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_NCP_FRAGMENT_CLOSE"))
		#ifdef DS_NCP_FRAGMENT_CLOSE
	    	return DS_NCP_FRAGMENT_CLOSE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_NCP_GET_DS_STATISTICS"))
		#ifdef DS_NCP_GET_DS_STATISTICS
			return DS_NCP_GET_DS_STATISTICS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_NCP_MONITOR_CONNECTION"))
		#ifdef DS_NCP_MONITOR_CONNECTION
			return DS_NCP_MONITOR_CONNECTION;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_NCP_PING"))
		#ifdef DS_NCP_PING
			return DS_NCP_PING;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_NCP_RELOAD"))
		#ifdef DS_NCP_RELOAD
			return DS_NCP_RELOAD;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_NCP_RESET_DS_COUNTERS"))
		#ifdef DS_NCP_RESET_DS_COUNTERS
			return DS_NCP_RESET_DS_COUNTERS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_NCP_VERB"))
		#ifdef DS_NCP_VERB
			return DS_NCP_VERB;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_NONREMOVABLE_ATTR"))
		#ifdef DS_NONREMOVABLE_ATTR
			return DS_NONREMOVABLE_ATTR;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_NONREMOVABLE_CLASS"))
		#ifdef DS_NONREMOVABLE_CLASS
			return DS_NONREMOVABLE_CLASS;
		#else
			goto not_there;
		#endif
		break;
		case 'O':
		case 'P':
			if (strEQ(name, "DS_OVERWRITE_VALUE"))
		#ifdef DS_OVERWRITE_VALUE
			return DS_OVERWRITE_VALUE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_PARTITION_REFERRAL"))
		#ifdef DS_PARTITION_REFERRAL
			return DS_PARTITION_REFERRAL;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_PARTITION_ROOT"))
		#ifdef DS_PARTITION_ROOT
			return DS_PARTITION_ROOT;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_PER_REPLICA"))
		#ifdef DS_PER_REPLICA
			return DS_PER_REPLICA;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_PRESENT"))
		#ifdef DS_PRESENT
			return DS_PRESENT;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_PUBLIC_READ"))
		#ifdef DS_PUBLIC_READ
			return DS_PUBLIC_READ;
		#else
			goto not_there;
		#endif
		break;
		case 'R':
			if (strEQ(name, "DS_READ_ONLY_ATTR"))
		#ifdef DS_READ_ONLY_ATTR
			return DS_READ_ONLY_ATTR;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_READ_STREAM"))
		#ifdef DS_READ_STREAM
			return DS_READ_STREAM;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_REMOVE_ATTRIBUTE"))
		#ifdef DS_REMOVE_ATTRIBUTE
			return DS_REMOVE_ATTRIBUTE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_REMOVE_VALUE"))
		#ifdef DS_REMOVE_VALUE
			return DS_REMOVE_VALUE;
		#else
			goto not_there;
		#endif
		break;
		case 'S':
			if (strEQ(name, "DS_SEARCH_AND"))
		#ifdef DS_SEARCH_AND
			return DS_SEARCH_AND;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_APPROX"))
		#ifdef DS_SEARCH_APPROX
			return DS_SEARCH_APPROX;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_BASE_CLASS"))
		#ifdef DS_SEARCH_BASE_CLASS
			return DS_SEARCH_BASE_CLASS;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_ENTRY"))
		#ifdef DS_SEARCH_ENTRY
			return DS_SEARCH_ENTRY;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_EQUAL"))
		#ifdef DS_SEARCH_EQUAL
			return DS_SEARCH_EQUAL;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_GREATER_OR_EQUAL"))
		#ifdef DS_SEARCH_GREATER_OR_EQUAL
			return DS_SEARCH_GREATER_OR_EQUAL;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_ITEM"))
		#ifdef DS_SEARCH_ITEM
			return DS_SEARCH_ITEM;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_LESS_OR_EQUAL"))
		#ifdef DS_SEARCH_LESS_OR_EQUAL
			return DS_SEARCH_LESS_OR_EQUAL;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_MODIFICATION_GE"))
		#ifdef DS_SEARCH_MODIFICATION_GE
			return DS_SEARCH_MODIFICATION_GE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_NOT"))
		#ifdef DS_SEARCH_NOT
			return DS_SEARCH_NOT;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_OR"))
		#ifdef DS_SEARCH_OR
			return DS_SEARCH_OR;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_PRESENT"))
		#ifdef DS_SEARCH_PRESENT
			return DS_SEARCH_PRESENT;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_RDN"))
		#ifdef DS_SEARCH_RDN
			return DS_SEARCH_RDN;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_REFERENCES"))
		#ifdef DS_SEARCH_REFERENCES
			return DS_SEARCH_REFERENCES;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_SUBORDINATES"))
		#ifdef DS_SEARCH_SUBORDINATES
			return DS_SEARCH_SUBORDINATES;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_SUBTREE"))
		#ifdef DS_SEARCH_SUBTREE
			return DS_SEARCH_SUBTREE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SEARCH_VALUE_TIME_GE"))
		#ifdef DS_SEARCH_VALUE_TIME_GE
			return DS_SEARCH_VALUE_TIME_GE;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SERVER_READ"))
		#ifdef DS_SERVER_READ
			return DS_SERVER_READ;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SINGLE_VALUED_ATTR"))
		#ifdef DS_SINGLE_VALUED_ATTR
			return DS_SINGLE_VALUED_ATTR;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SIZED_ATTR"))
		#ifdef DS_SIZED_ATTR
			return DS_SIZED_ATTR;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_STRING_ATTR"))
		#ifdef DS_STRING_ATTR
			return DS_STRING_ATTR;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_SYNC_IMMEDIATE"))
		#ifdef DS_SYNC_IMMEDIATE
			return DS_SYNC_IMMEDIATE;
		#else
			goto not_there;
		#endif
		break;
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
			if (strEQ(name, "DS_VALUE_INFO"))
		#ifdef DS_VALUE_INFO
			return DS_VALUE_INFO;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_WRITE_MANAGED"))
		#ifdef DS_WRITE_MANAGED
			return DS_WRITE_MANAGED;
		#else
			goto not_there;
		#endif
			if (strEQ(name, "DS_WRITE_STREAM"))
		#ifdef DS_WRITE_STREAM
			return DS_WRITE_STREAM;
		#else
			goto not_there;
		#endif
		default:
			break;
		};
	}//if (!strncmp(name, "DS", 2))
	  if (strEQ(name, "DEFAULT_MESSAGE_LEN"))
	#ifdef DEFAULT_MESSAGE_LEN
	  return DEFAULT_MESSAGE_LEN;
	#else
	  goto not_there;
	#endif
	break;
	 case 'E':
	if (strEQ(name, "ERR_CONTEXT_CREATION"))
#ifdef ERR_CONTEXT_CREATION
		 return ERR_CONTEXT_CREATION;
#else
		 goto not_there;
#endif

	break;
	 case 'F':
	break;
	 case 'G':
	break;
	 case 'H':
	break;
    case 'I':
	break;
    case 'J':
	break;
    case 'K':
	break;
    case 'L':
	break;
    case 'M':
	if (strEQ(name, "MAX_MESSAGE_LEN"))
#ifdef MAX_MESSAGE_LEN
	    return MAX_MESSAGE_LEN;
#else
	    goto not_there;
#endif
	break;
    case 'N':
	if (strEQ(name, "NO_MORE_ITERATIONS"))
#ifdef NO_MORE_ITERATIONS
	    return NO_MORE_ITERATIONS;
#else
	    goto not_there;
#endif
	break;
    case 'O':
	break;
    case 'P':
	break;
    case 'Q':
	break;
    case 'R':
	if (strEQ(name, "RT_MASTER"))          //      Master replica
		 return RT_MASTER;
	if (strEQ(name, "RT_SECONDARY"))       //      Secondary replica
		 return RT_SECONDARY;
	if (strEQ(name, "RT_READONLY")) 		  	//      Read-only replica
	    return RT_READONLY;
	break;
    case 'S':
	if (strEQ(name, "SYNTAX_COUNT"))
	    return SYNTAX_COUNT;
	if (strEQ(name, "SYN_ANY"))
		 return SYN_ANY;
	if (strEQ(name, "SYN_BACK_LINK"))
	    return SYN_BACK_LINK;
	if (strEQ(name, "SYN_BOOLEAN"))
	    return SYN_BOOLEAN;
	if (strEQ(name, "SYN_CE_STRING"))
	    return SYN_CE_STRING;
	if (strEQ(name, "SYN_CI_STRING"))
	    return SYN_CI_STRING;
	if (strEQ(name, "SYN_CHOICE"))
	    return SYN_CHOICE;
	if (strEQ(name, "SYN_CI_LIST"))
	    return SYN_CI_LIST;
	if (strEQ(name, "SYN_CLASS_NAME"))
	    return SYN_CLASS_NAME;
	if (strEQ(name, "SYN_COMPONENT"))
	    return SYN_COMPONENT;
	if (strEQ(name, "SYN_COUNTER"))
	    return SYN_COUNTER;
	if (strEQ(name, "SYN_DIST_NAME"))
	    return SYN_DIST_NAME;
	if (strEQ(name, "SYN_EMAIL_ADDRESS"))
		 return SYN_EMAIL_ADDRESS;
	if (strEQ(name, "SYN_ENUMERATED"))
	    return SYN_ENUMERATED;
	if (strEQ(name, "SYN_ENUM_COMPONENT"))
	    return SYN_ENUM_COMPONENT;
	if (strEQ(name, "SYN_FAX_NUMBER"))
	    return SYN_FAX_NUMBER;
	if (strEQ(name, "SYN_HOLD"))
	    return SYN_HOLD;
	if (strEQ(name, "SYN_INTEGER"))
	    return SYN_INTEGER;
	if (strEQ(name, "SYN_INTERVAL"))
	    return SYN_INTERVAL;
	if (strEQ(name, "SYN_NET_ADDRESS"))
	    return SYN_NET_ADDRESS;
	if (strEQ(name, "SYN_NULL"))
	    return SYN_NULL;
	if (strEQ(name, "SYN_NU_STRING"))
	    return SYN_NU_STRING;
	if (strEQ(name, "SYN_OBJECT_ACL"))
	    return SYN_OBJECT_ACL;
	if (strEQ(name, "SYN_OCTET_LIST"))
		 return SYN_OCTET_LIST;
	if (strEQ(name, "SYN_OCTET_STRING"))
	    return SYN_OCTET_STRING;
	if (strEQ(name, "SYN_OID"))
	    return SYN_OID;
	if (strEQ(name, "SYN_PATH"))
	    return SYN_PATH;
	if (strEQ(name, "SYN_PO_ADDRESS"))
	    return SYN_PO_ADDRESS;
	if (strEQ(name, "SYN_PR_STRING"))
	    return SYN_PR_STRING;
	if (strEQ(name, "SYN_REPLICA_POINTER"))
	    return SYN_REPLICA_POINTER;
	if (strEQ(name, "SYN_SEQUENCE"))
	    return SYN_SEQUENCE;
	if (strEQ(name, "SYN_SET"))
	    return SYN_SET;
	if (strEQ(name, "SYN_STREAM"))
	    return SYN_STREAM;
	if (strEQ(name, "SYN_TEL_NUMBER"))
	    return SYN_TEL_NUMBER;
	if (strEQ(name, "SYN_TIME"))
		 return SYN_TIME;
	if (strEQ(name, "SYN_TIMESTAMP"))
	    return SYN_TIMESTAMP;
	if (strEQ(name, "SYN_TYPED_NAME"))
	    return SYN_TYPED_NAME;
	if (strEQ(name, "SYN_UNKNOWN"))
	    return SYN_UNKNOWN;
	break;
    case 'T':
   if (strEQ(name, "TA_ALL"))
#ifdef TA_ALL
	return TA_ALL;
#else
	goto not_there;
#endif
   if (strEQ(name, "TA_READ"))
#ifdef TA_READ
	return TA_READ;
#else
	goto not_there;
#endif
   if (strEQ(name, "TA_WRITE"))
#ifdef TA_WRITE
	return TA_WRITE;
#else
	goto not_there;
#endif
   if (strEQ(name, "TA_OPEN"))
#ifdef TA_OPEN
	return TA_OPEN;
#else
	goto not_there;
#endif
   if (strEQ(name, "TA_CREATE"))
#ifdef TA_CREATE
	return TA_CREATE;
#else
	goto not_there;
#endif
   if (strEQ(name, "TA_DELETE"))
#ifdef TA_DELETE
	return TA_DELETE;
#else
	goto not_there;
#endif
   if (strEQ(name, "TA_OWNERSHIP"))
#ifdef TA_OWNERSHIP
	return TA_OWNERSHIP;
#else
	goto not_there;
#endif
   if (strEQ(name, "TA_SEARCH"))
#ifdef TA_SEARCH
	return TA_SEARCH;
#else
	goto not_there;
#endif
   if (strEQ(name, "TA_MODIFY"))
#ifdef TA_MODIFY
	return TA_MODIFY;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_NONE"))
#ifdef TR_NONE
	return TR_NONE;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_READ"))
#ifdef TR_READ
	return TR_READ;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_WRITE"))
#ifdef TR_WRITE
	return TR_WRITE;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_OPEN"))
#ifdef TR_OPEN
	return TR_OPEN;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_DIRECTORY"))
#ifdef TR_DIRECTORY
	return TR_DIRECTORY;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_CREATE"))
#ifdef TR_CREATE
	return TR_CREATE;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_DELETE"))
#ifdef TR_DELETE
	return TR_DELETE;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_ERASE"))
#ifdef TR_ERASE
	return TR_ERASE;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_OWNERSHIP"))
#ifdef TR_OWNERSHIP
	return TR_OWNERSHIP;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_ACCESS_CTRL"))
#ifdef TR_ACCESS_CTRL
	return TR_ACCESS_CTRL;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_FILE_SCAN"))
#ifdef TR_FILE_SCAN
	return TR_FILE_SCAN;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_SEARCH"))
#ifdef TR_SEARCH
	return TR_SEARCH;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_FILE_ACCESS"))
#ifdef TR_FILE_ACCESS
	return TR_FILE_ACCESS;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_MODIFY"))
#ifdef TR_MODIFY
	return TR_MODIFY;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_ALL"))
#ifdef TR_ALL
	return TR_ALL;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_SUPERVISOR"))
#ifdef TR_SUPERVISOR
	return TR_SUPERVISOR;
#else
	goto not_there;
#endif
   if (strEQ(name, "TR_NORMAL"))
#ifdef TR_NORMAL
	return TR_NORMAL;
#else
	goto not_there;
#endif
	break;
    case 'U':
	break;
    case 'V':
	break;
    case 'W':
	break;
    case 'X':
	break;
    case 'Y':
	break;
    case 'Z':
	break;
	 }
    errno = EINVAL;
    return 0;


not_there:
#ifdef NDS_DBG
    printf("Variable %s not found", name);
#endif
    errno = ENOENT;
    return 0;
}