
package NDSm::Misc;
use strict;
use NDSm;

*AUTOLOAD = \&NDSm::AUTOLOAD;
*VERSION = \&NDSm::VERSION;

BEGIN{&NDSm::NWCallsInit(0, 0);}

# We make sure we clean up after using NW API
END { &NDSm::NWCallsTerm();}


=head1 NAME

Misc - module in the package NDSm.


=head1 SYNOPSIS

  use NDSm::Misc;

  Then you should use the methods outlined below.
  this package contains misc methods that don't fit into any categories.
  Look in the t/ directory for examples.

=head1 DESCRIPTION

  This extension enables you to work with Novell NetWare servers
  and/or NDS from perl 5.004 or higher.
  You should get the NWSDK with same version as this module from
  http://developer.novell.com to understand what each method do.


=head1 METHODS

=over 4


=item * ($majorVersion, $minorVersion, $revisionLevel, $betaReleaseLevel) = &GetNWNetVersion();

    Get the version for the Netware network.
    returns undef on failure.

=cut
sub GetNWNetVersion {
        return &NDSm::NWGetNWNetVersion();
}

1;

__END__

=item * More to come.....

=back

=head1 SEE ALSO

L<NWServer>

L<NDSContext>

L<Buf_T>

L<NDSm>

http://www.ahs.hist.no/distr/NDSm/

http://developer.novell.com/


=head1 COPYRIGHT

  Copyright (c) Steinar Kleven 1997.
  All rights reserved.

=head1 AUTHOR

  Steinar Kleven,
  mailto:Steinar.Kleven@ahs.hist.no


=cut
