#
# Adduser.t
#
# This script demonstrates how to create a user using
# the perl extension NDSm.
#
# Copyright (c) 1997 Steinar Kleven
#



BEGIN { $| = 1; print "1..13\n"; }
use NDSm::NDSContext;
use NDSm::Buf_T;
print "ok 1\n";

print "THIS SCRIPT WILL CREATE A USER IN YOUR DEFAULT CONTEXT\n";
print "Please type \"ok\" to continue.\n";

$Val = <STDIN>;
die("You typed: $Val, Aborting..\n") if ($Val !~ /^ok$/i);


$C = new NDSm::NDSContext;
$Buf = new NDSm::Buf_T;
print "ok 2\n" if ($C && $Buf);

# Handle needed in alot of methods
$NWHandle = $C->GetHandle();

# Standard Unicode init.
# NOT required any more
($code_page, $country_id) = $C->LocaleConv();
if (defined($code_page) && defined($country_id)){
$Retval = $C->InitUnicodeTables($code_page, $country_id);
}


$Result = $C->IsDSAuthenticated();
if ($Result){print "ok 3\n"}else{die("You're not logged on, bailing out!!")};

# Get YOUR username, and add "tmp" to the username
$User = $C->WhoAmI();
print "ok 4\n" if (defined($Retval));

# Add tmp.
$User =~ s/\.{1}/tmp./;
$Surename = "NDSm-applied";
$Newtlf = "+47-180"; # White pages in Norway
$ObjType = "User";

$Result = $Buf->AllocBuf();
print "ok 5\n" if !$Result;

$Result = $Buf->InitBuf($NWHandle, "DSV_ADD_ENTRY");
print "ok 6\n" if !$Result;

# Call PutAttrName and PutAttrVal repeatedly for each type
#  of information about to be entered.  Start with User (Object Class).
#
$Result = $Buf->PutAttrName($NWHandle, "Object Class");
print "ok 7\n" if !$Result;
$Result = $Buf->PutAttrVal($NWHandle, "SYN_CLASS_NAME", $ObjType);
print "ok 8\n" if !$Result;

# Add information for Surname
$Result = $Buf->PutAttrName($NWHandle, "Surname");
print "ok 9\n" if !$Result;
$Result = $Buf->PutAttrVal($NWHandle, "SYN_CI_STRING", $Surename);
print "ok 10\n" if !$Result;


# Add information for Telephone Number
$Result = $Buf->PutAttrName($NWHandle, "Telephone Number");
print "ok 11\n" if !$Result;
$Result = $Buf->PutAttrVal($NWHandle, "SYN_TEL_NUMBER", $Newtlf);
print "ok 12\n" if !$Result;


# Add the user we created in $Buf, the last two params are ignored.
$Iter = $Buf->AddObject($NWHandle, $User, 0, 0);
if (defined($Iter))
{
  print "ok 13\n";
# Delete the newly created object
  $C->RemoveObject($User);
}
else
{
  print STDERR "Reason : $User may exist\n";
}

__END__

