#
# Browse.t
# 
# This script demonstrates how to get all object in a context from NDS
# with the perl extension NDSm.
#
# Copyright (c) 1997 Steinar Kleven
#



BEGIN { $| = 1; print "1..5\n"; }
use NDSm::NDSContext;
use NDSm::Buf_T;
print "ok 1\n";


$C = new NDSm::NDSContext;

$CHandle = $C->GetHandle();

# buffer for reply
$OutBuf = new NDSm::Buf_T;
print "ok 2\n" if ($C && $OutBuf);


# Standard Unicode init.
# NOT required any more
($code_page, $country_id) = $C->LocaleConv();
if (defined($code_page) && defined($country_id)){
$C->InitUnicodeTables($code_page, $country_id);
}

# We can't do anything if we're not logged on
$Result = $C->IsDSAuthenticated();
if ($Result){print "ok 3\n"}
else {die("You're not logged on, bailing out!!")};


# Alloc Result-buffer.
$Result = $OutBuf->AllocBuf();
print "ok 4\n" if !$Result;

# Read the object in current context
$Context = $C->GetContext("DCK_NAME_CONTEXT");
print "Your context is: $Context\n";
$ok = 1;
$iter = $OutBuf->GetConst("NO_MORE_ITERATIONS");
do
{
  $iter = $OutBuf->List($CHandle, $Context, $iter);
  $ok = 0 if (!defined($iter));
  $ObjectCount = $OutBuf->GetObjectCount($CHandle);
  $ok = 0 if (!defined($ObjectCount));

  #Now we can list all objects in this context
  $ok = 1;
  for($i=0; $i < $ObjectCount; $i++) {
    ($ObjectName) = $OutBuf->GetObjectName($CHandle);
    $ok = 0 if (!defined($ObjectName));
    print "$i: $ObjectName\n";
  }
}while ($ok && $iter != -1);
print "ok 5\n" if ($ok);

# If you found this example usefull, click <HERE> :-)

__END__
