#
# DSCompare.t
#
# This script demonstrates how to compare value with given attribute
# with the perl extension NDSm.
#
# Copyright (c) 1997 Steinar Kleven
#



BEGIN { $| = 1; print "1..9\n"; }
use NDSm::NDSContext;
use NDSm::Buf_T;
print "ok 1\n";


$C = new NDSm::NDSContext;

$CHandle = $C->GetHandle();

# Buffer for query
$OutBuf = new NDSm::Buf_T;
print "ok 2\n" if ($C && $OutBuf);

# Attribute to compare
$Attribute = "Telephone Number";
$Val = "+47-150";

# This two lines are not necessary any more.
($code_page, $country_id) = $C->LocaleConv();
$C->InitUnicodeTables($code_page, $country_id);


# We can't do anything if we're not logged on
$Result = $C->IsDSAuthenticated();
if ($Result){print "ok 3\n"}else{die("You're not logged on, bailing out!!")};

# Get YOUR username, and compare "+47-150" with your telephone number.
$Object = $C->WhoAmI();
print "ok 4\n" if defined($Object);


# Alloc and initiate buffer for NDS compare operation.
$Result = $OutBuf->AllocBuf();
print "ok 5\n" if !$Result;
$Result = $OutBuf->InitBuf($CHandle, "DSV_COMPARE");
print "ok 6\n" if !$Result;


# Put attributename in query-buffer
$Result = $OutBuf->PutAttrName($CHandle, $Attribute);
print "ok 7\n" if !$Result;

# Put the name of the object for wich we will compare attribute
$Result = $OutBuf->PutAttrVal($CHandle, "SYN_TEL_NUMBER", $Val);
print "ok 8\n" if !$Result;

# Do the compare
$match = $OutBuf->Compare($CHandle, $Object);
if (defined($match)) {
  print "ok 9\n";
  print "MATCH!\n" if ($match);
}

__END__

