#
# Misc.t
# 
# This script demonstrates misc methods using
# the perl extension NDSm.
#
# Copyright (c) 1997 Steinar Kleven
#



BEGIN { $| = 1; print "1..8\n"; }

use NDSm::NDSContext;
print "ok 1\n";

$C = new NDSm::NDSContext;
print "ok 2\n" if $C;

$Code = $C->CanDSAuthenticate();
if (($Code == 1) || ($Code ==0 )){ print "ok 3\n";}


$MyName = $C->WhoAmI();
print "ok 4\n" if defined($MyName);
$CName = $C->CanonicalizeName($MyName);
$AName = $C->AbbreviateName($MyName);
$Tree = $C->GetContext("DCK_TREE_NAME");
$DefCtx = $C->GetDefNameContext();
$TypeLess = $C->RemoveAllTypes($MyName);
if (defined($AName) && defined(DefCtx) && defined(CName)){
  print "ok 5\n";
}
print "Typeless on, canonicalize off:\n";
print "WhoAmI           : $MyName\n";
print "CanonicalizeName : $CName\n";
print "AbbreviateName   : $AName\n";
print "Typeless         : $TypeLess\n";
print "Tree             : $Tree\n";
print "Default name ctx : $DefCtx\n";


# As default the context flags are set as follows
#  typeless naming on.
#  canonicalize names off.  This means we will get full names (from [root])
#
$Flags = $C->GetContext("DCK_FLAGS");

# Typeless naming off: Should give us  CN=....OU=... O=...
$Flags &= ~&NDSm::constant("DCV_TYPELESS_NAMES", 0);

# Canonicalize names on: Give us names relative to context.
$Flags |= &NDSm::constant("DCV_CANONICALIZE_NAMES", 0);

# Activate the new settings
$Status = $C->SetContext("DCK_FLAGS", $Flags);
print "ok 6\n" if !$Status;
# Run the same tests methods again:

$MyName = $C->WhoAmI();
print "ok 7\n" if defined($MyName);
$CName = $C->CanonicalizeName($MyName);
$AName = $C->AbbreviateName($MyName);
$Tree = $C->GetContext("DCK_TREE_NAME");
$DefCtx = $C->GetDefNameContext();
$TypeLess = $C->RemoveAllTypes($MyName);
if (defined($AName) && defined(DefCtx) && defined(CName)){
  print "ok 8\n";
}
print "Typeless off, canonicalize on:\n";
print "WhoAmI           : $MyName\n";
print "CanonicalizeName : $CName\n";
print "AbbreviateName   : $AName\n";
print "Typeless         : $TypeLess\n";
print "Tree             : $Tree\n";
print "Default name ctx : $DefCtx\n";


__END__
