unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, nwAtEdit, Grids, Outline, nwout, nwbase, ExtCtrls, 
  nwlib, nwnds, nwtools, nwlogmem, ComCtrls, ToolWin, nwtreevw;

type
  TForm1 = class(TForm)
    SuperPanel1: TPanel;
    SuperPanel2: TPanel;
    NWBase1: TNWBase;
    dataPanel: TPanel;
    listPanel: TPanel;
    ToolBar1: TToolBar;
    passBtn: TToolButton;
    ToolButton2: TToolButton;
    lineMsgBtn: TToolButton;
    ToolButton4: TToolButton;
    ImageList1: TImageList;
    ToolButton6: TToolButton;
    ImageList2: TImageList;
    SuperPanel4: TPanel;
    Label3: TLabel;
    Label2: TLabel;
    NWNDSAttrEdit2: TNWNDSAttrEdit;
    objNameEdit: TEdit;
    NWNDSAttrEdit1: TNWNDSAttrEdit;
    label1: TLabel;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    NWLoginScriptMemo1: TNWLoginScriptMemo;
    phoneMemo: TMemo;
    ndsTreeView: TNWTreeView;
    procedure passBtnClick(Sender: TObject);
    procedure ToolButton4Click(Sender: TObject);
    procedure lineMsgBtnClick(Sender: TObject);
    procedure NWOutline1ExpandMembers(Sender: TObject);
    procedure ndsTreeViewExpandUser(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.passBtnClick(Sender: TObject);
var
  ctemp : string ;
begin
  if inputQuery('Change User Password','Type New Password',ctemp) then
    begin
      if ndsChangePassword('',ndsTreeView.text,ctemp,'') then
        okBox('Password Changed Successfully!')
      else
        alertBox('Error Changing Password!') ;  
    end;

end;

procedure TForm1.ToolButton4Click(Sender: TObject);
  begin
    close ;
  end;

procedure TForm1.lineMsgBtnClick(Sender: TObject);
var
  ctemp : string ;
begin
  if inputQuery('Send Line Message','Type Message',ctemp) then
    begin
      if sendLineMessage(0,ndsTreeView.text,ctemp) then
        okBox('Message Sent Successfully')
      else
        alertBox('Unable to Send Message') ;  
    end;
end;

procedure TForm1.NWOutline1ExpandMembers(Sender: TObject);
begin
  lineMsgBtn.enabled := false ;
  passBtn.enabled    := false ;
end;

procedure TForm1.ndsTreeViewExpandUser(Sender: TObject);
  var
    i : integer ;
    tempList : TList ;
  begin
    passBtn.enabled    := true ;
    lineMsgBtn.enabled := true ;
    tempList := TList.create ;
    ndsGetMultiAttr('',ndsTreeView.text,dsaTelephoneNumber,tempList) ;
    with nwBase1 do try
      loginID := ndsTreeView.text ;
      objNameEdit.text := ndsGetObjID(0,loginID) ;
      with phoneMemo.lines do begin
        clear ;
        for i := 0 to (tempList.count-1) do
          add(strPas(tempList[i])) ;
      end;
    finally
      tempList.free ;
    end;
  end;

end.
