{*********************************************************************

  NETSERV - A unit of NetWare Application Program Interfaces
            Relating to File Server Services
            for Turbo Pascal 4.0 and Advanced NetWare (any verison)

  Copyright (c) 1988, Richard S. Sadowsky
  All rights reserved

  version .7 6/10/88 by Richard S. Sadowsky 74017,1670

**********************************************************************}
Unit NetServ;
{$I-,V-,S+,R+}

interface

uses DOS;

type
  DayOfTheWeek     = (Sunday,Monday,Tuesday,Wednesday,Thursday,
                      Friday,Saturday);

var
  NovRegs          : Registers; { register type for DOS/Novell calls }

const
  { error return codes for AttachToServer }
  ALREADY_ATTACHED = $F8;  { already attached to server }
  NO_FREE_SLOTS    = $F9;  { No free connection slots at server }
  NO_SERVER        = $FF;  { No response from server }

procedure GetServerDateTime(var Year,Month,Day,Hour,Minute,Second : Word;
                            var WeekDay : DayOfTheWeek);

function DisableServerLogin : Boolean;
{ returns true if file server login is successfully disabled }
{ THIS FUNCTION DISABLES ALL LOGINS TO A SERVER FROM ANY WORKSTATION }
{ Use EnableServerLogin to enable (must be called from same WS) }

function EnableServerLogin : Boolean;
{ returns true if file server login is successfully enabled }
{ Use DisableServerLogin to disable (must be called from same WS }

function DownFileServer(ForceItDown : Boolean) : Byte;
{
  DOWNS the server!!!
  Warning, this function will really down your file server kiddo!
  If ForceItDown is TRUE, it will down the server EVEN IF FILES ARE OPEN!!!
}

function ServerCopy(Source,Dest : Word; SOff,DOff,NoBytes : LongInt;
                    var NoBytesCopied : LongInt) : Byte;

function GetLoginStatus(var LoginEnabled : Boolean) : Byte;
{ if Login is enabled then returns TRUE in LoginEnabled }
{ return byte
  00h  - Success
  C6h No Console Rights
}

procedure PurgeAllErased;
{ actually delete all deleted files from server }

procedure PurgeErased;
{ delete only files deleted by requesting WS from server }

function AttachToServer(ServerConnID : Byte) : Byte;
{ Create an attachment between a server and a workstation }
{ Does not Login the workstation }

function DetachFromServer(ServerConnID : Byte) : Byte;
{ this functions logs the object out, and detaches the workstation from }
{ the file server. }

implementation

function MakeLong(HiWord,LoWord : Word) : LongInt;
{takes hi and lo words and makes a longint }
Inline(
  $58/    { pop ax ; pop low word into AX }
  $5A);   { pop dx ; pop high word into DX }

procedure GetServerDateTime(var Year,Month,Day,Hour,Minute,Second : Word;
                            var WeekDay : DayOfTheWeek);
type
  ReplyBuffer      = array[1..10] of Byte;

var
  Reply            : ReplyBuffer;

begin
  with NovRegs do begin
    AX := $E700;
    DS := Seg(Reply);
    DX := Ofs(Reply);
  end; {with}
  MsDos(NovRegs);
  Year    := Word(Reply[1]) + 1900;
  Month   := Word(Reply[2]);
  Day     := Word(Reply[3]);
  Hour    := Word(Reply[4]);
  Minute  := Word(Reply[5]);
  Second  := Word(Reply[6]);
  WeekDay := DayOfTheWeek(Reply[7]);
end;

function DisableServerLogin : Boolean;
{ returns true if file server login is successfully disabled }
{ THIS FUNCTION DISABLES ALL LOGINS TO A SERVER FROM ANY WORKSTATION }
{ Use EnableServerLogin to enable (must be called from same WS) }
var
  Reply            : Word;
  Request          : Record
                       Len  : Word;
                       SubF : Byte;
                     end;

begin
  Reply := 0;
  with Request do begin
    Len  := 1;
    SubF := $CB;
  end;
  with NovRegs do begin
    AX := $E300;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    DisableServerLogin := AL = 0;
  end
end;


function EnableServerLogin : Boolean;
{ returns true if file server login is successfully enabled }
{ Use DisableServerLogin to disable (must be called from same WS }

var
  Reply            : Word;
  Request          : Record
                       Len  : Word;
                       SubF : Byte;
                     end;

begin
  Reply := 0;
  with Request do begin
    Len  := 1;
    SubF := $CC;
  end;
  with NovRegs do begin
    AX := $E300;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    EnableServerLogin := AL = 0;
  end
end;

function DownFileServer(ForceItDown : Boolean) : Byte;
{
  DOWNS the server!!!
  Warning, this function will really down your file server kiddo!
  If ForceItDown is TRUE, it will down the server EVEN IF FILES ARE OPEN!!!
}

var
  Reply            : Word;
  Request          : Record
                       Len   : Word;
                       SubF  : Byte;
                       Force : Byte;
                     end;

begin
  Reply := 0;
  with Request do begin
    Len  := 2;
    SubF := $D3;
    Force := Ord(ForceItDown);
  end;
  with NovRegs do begin
    AX := $E300;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    DownFileServer := AL;
  end
end;

function GetLoginStatus(var LoginEnabled : Boolean) : Byte;
{ if Login is enabled then returns TRUE in LoginEnabled }
{ return byte
  00h  - Success
  C6h No Console Rights
}
var
  Reply            : record
                       Len     : Word;
                       Flag    : Byte;
                     end;
  Request          : record
                       Len     : Word;
                       SubF    : Byte;
                     end;

begin
  Reply.Len := 1;
  with Request do begin
    Len     := 1;
    SubF    := $CD;
  end;
  with NovRegs do begin
    AX := $E300;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    GetLoginStatus := AL;
  end;
  with Reply do
    LoginEnabled := Boolean(Flag);
end;

function ServerCopy(Source,Dest : Word; SOff,DOff,NoBytes : LongInt;
                    var NoBytesCopied : LongInt) : Byte;

var
  Request          : Record
                       S,
                       D   : Word;
                       S_O,
                       D_O,
                       NB  : LongInt;
                     end;

begin
  with Request do begin
    S  := Source;
    D  := Dest;
    S_O := Soff;
    D_O := DOff;
    NB := NoBytes;
  end;
  with NovRegs do begin
    AX := $F300;
    ES := Seg(Request);
    DI := Ofs(Request);
    MsDos(NovRegs);
    NoBytesCopied := MakeLong(CX,DX);
    ServerCopy    := AL;
  end;
end;

procedure PurgeAllErased;
{ actually delete all deleted files from server }

var
  Request          : record
                       Len   : Word;
                       SubF  : Byte;
                     end;
  Reply            : Word;

begin
  Reply := 0;
  with Request do begin
    Len := 1;
    SubF := $CE;
  end;
  with NovRegs do begin
    AX := $E300;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
  end;
end;

procedure PurgeErased;
{ delete only files deleted by requesting WS from server }

var
  Request          : record
                       Len   : Word;
                       SubF  : Byte;
                     end;
  Reply            : Word;

begin
  Reply := 0;
  with Request do begin
    Len := 1;
    SubF := $10;
  end;
  with NovRegs do begin
    AX := $E200;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
  end;
end;

function AttachToServer(ServerConnID : Byte) : Byte;
{ Create an attachment between a server and a workstation }
{ Does not Login the workstation }

begin
  with NovRegs do begin
    AX := $F100;
    DL := ServerConnID;
    MsDos(NovRegs);
    AttachToServer := AL;
  end;
end;

function DetachFromServer(ServerConnID : Byte) : Byte;
{ this functions logs the object out, and detaches the workstation from }
{ the file server. }
begin
  with NovRegs do begin
    AX := $F101;
    DL := ServerConnID;
    MsDos(NovRegs);
    DetachFromServer := AL;
  end;
end;

end.
