{$R+,S+,I-,D+,T+,F-,V-,B-,N-,L+ }
{$M 32768,0,163840}
program TestNetAPI;

uses DOS,NetCraft,NetServ,NetTTS;

type
  Str40            = String[40];

const
  DayNames         : Array[DayOfTheWeek] of Str9 = ('Sunday',
                                                    'Monday',
                                                    'Tuesday',
                                                    'Wednesday',
                                                    'Thursday',
                                                    'Friday',
                                                    'Saturday');
  MonthNames       : Array[1..12] of Str9 =
                     ('January','February','March',
                      'April','May','June',
                      'July','August','September',
                      'October','November','December');

function WordToStr(W : Word) : Str40;

var
  S                : Str40;

begin
  Str(W,S);
  WordToStr := S
end;

function ZeroFillNum(W : Word) : Str9;

begin
  if W < 10 then
    ZeroFillNum := '0' + WordtoStr(W)
  else
    ZeroFillNum := WordToStr(W)
end;

function FormatTime(Hour,Minute,Second : Word) : Str80;

begin
  FormatTime :=  ZeroFillNum(Hour) + ':' + ZeroFillNum(Minute) + ':' +
                ZeroFillNum(Second);
end;

function FormatDateTime(Year,Month,Day,Hour,Minute,Second : Word;
                    WeekDay : DayOfTheWeek) : Str80;
var
  DayStr,MonthStr  : Str9;

begin
  DayStr := DayNames[WeekDay];
  MonthStr := MonthNames[Month];
  FormatDateTime := DayStr + ' ' + MonthStr + ' ' +
                    WordToStr(Day) + ', ' + WordToStr(Year) + '  ' +
                    FormatTime(Hour,Minute,Second);
end;

procedure ServerInfo;

var
  Y,M,D,H,Min,S    : Word;
  WeekDay          : DayOfTheWeek;
  DateTime         : Str80;

begin

  GetServerDateTime(Y,M,D,H,Min,S,WeekDay);
  DateTime := FormatDateTime(Y,M,D,H,Min,S,WeekDay);
  WriteLn('The server says it is: ',DateTime);

  Write('Transaction tracking is ');
  if not TTSAvailable then
    Write('not ');
  WriteLn('available.');
  WriteLn('Connection Number of file server: ',ServerConnNo);
end;

procedure WSInfo;

var
  Y,M,D,H,Min,S,S100,WD
                   : Word;
  Major,Minor,Rev  : Byte;
  S1,S2,S3         : Str10;
  DateTime         : Str80;

begin

  GetDate(Y,M,D,WD);
  GetTime(H,Min,S,S100);
  WriteLn('This workstation says it is: ',
          FormatDateTime(Y,M,D,H,Min,S,DayOfTheWeek(WD)));

  Write('This workstation ');
  if ConsolePriv then
    Write('has ')
  else
    Write('does not have ');
  WriteLn('console privileges.');
  WriteLn('Connection number of this workstation: ',GetConnNo);
end;

begin
  WriteLn('TestNet - A Program to test NetCraft!');
  WriteLn('Version .5 6/10/88');
  WriteLn;
  WriteLn('SERVER INFO:');
  ServerInfo;
  WriteLn;
  WriteLn('WORKSTATION INFO:');
  WSInfo;
end.
