;  Environment variable routines assembler interface to Turbo Pascal
;  Copyright 1988 by Mark R. Boler  -  All Rights Reserved

TITLE     ENV

DATA      SEGMENT WORD PUBLIC

          ASSUME  DS:DATA

          EXTRN   PREFIXSEG: WORD

DATA      ENDS

CODE      SEGMENT BYTE PUBLIC

          ASSUME  CS:CODE

          PUBLIC  EnvFirst, EnvNext

; PROCEDURE EnvFirst(VAR St: STRING;
;                    VAR EnvData;
;                    VAR Status: WORD); EXTERNAL;

; PROCEDURE EnvNext (VAR St: STRING;
;                    VAR EnvData;
;                    VAR Status: WORD); EXTERNAL;

EnvDest   EQU     DWORD PTR [bp + 14]
EnvData   EQU     DWORD PTR [bp + 10]
Status    EQU     DWORD PTR [bp + 6]

MaxStrLen EQU     255                  ; maximum length of turbo string
EnvOfs    EQU     [2CH]                ; offset into the PSP of env segment

; If an error occured, Status returns a non-zero error code
; possible values for Status are:
;
;  0 - No error.  A valid string is returned in St
;  1 - No more environment strings.  String St is not altered
;
; WARNING: NEVER NEVER call EnvNext without first calling EnvFirst
;          AND passing the valid EnvData block returned from EnvFirst
;          undetermined results occur if passing an invalid EnvData
;          pointer.  The EnvData block is a 4 byte pointer so if your
;          program knows the address of the environment it can pass
;          that address to EnvNext without using EnvFirst.
;          NEVER call EnvNext if Status was returned non-zero.

EnvFirst  PROC    FAR
          push    bp                   ; save bp
          mov     bp, sp               ; set up stack frame
          push    ds                   ; save ds
          mov     ds, PREFIXSEG        ; get PSP segment into ds
          mov     ds, ds:EnvOfs
          xor     si, si               ; si = 0
ComStrt:
          xor     dx, dx               ; clear out dx - Status = 0
          cld                          ; string ops go forward
          lodsb                        ; see if first byte is Nul
          or      al, al               ; if so, there is a null string
          jnz     SHORT GetStr         ; else go test this string
          lodsb
          or      al, al               ; see if this one is null also
          jnz     SHORT GetStr         ; if not, then get a string
          inc     dx                   ; end of environment Status = 1
          jmp     SHORT Done           ; return error
GetStr:
          les     bx, EnvDest          ; es:bx points to destination
          mov     di, bx               ; es:di points to destination also
          inc     di                   ; point to the first character in Dest
          mov     cx, MaxStrLen        ; cx = maximum length of string
          mov     ah, cl               ; ah = same
Loop1:
          stosb                        ; put the character in destination
          lodsb                        ; get a character
          or      al, al               ; see if its a null
          loopnz  Loop1                ; if not done then loop
          sub     ah, cl               ; compute length of string
          mov     es:[bx], ah          ; set the length byte
          les     bx, EnvData          ; get the data buffer
          dec     si                   ; save offset of last character tested
          mov     es:[bx], si
          mov     es:[bx + 2], ds      ; save segment of environment
Done:
          lds     bx, Status           ; get address of Status
          mov     ds:[bx], dx          ; put value into Status
          pop     ds                   ; restore ds
          pop     bp                   ; restore bp
          ret     12
EnvFirst  ENDP

EnvNext   PROC    FAR
          push    bp                   ; save bp
          mov     bp, sp               ; set up stack frame
          push    ds                   ; save ds
          lds     si, EnvData          ; get pointer to environment
          lds     si, ds:[si]          ; make ds:si => next environment char
          jmp     SHORT ComStrt        ; go process it
EnvNext   ENDP

CODE      ENDS

          END
