{ ENV }

{ Copyright 1988 by Mark R. Boler - All Rights Reserved }

{-----------------------------------------------------------------------------}

{$B-}    { Boolean complete evaluation off }
{$D+}    { Debug information on            }
{$I-}    { I/O checking off                }
{$L+}    { Linker uses memory for a buffer }
{$N-}    { No numeric coprocessor          }
{$R-}    { Range checking off              }
{$S-}    { Stack checking off              }
{$T-}    { .TPM file generation off        }
{$V-}    { No VAR-String checks            }

UNIT Env;

INTERFACE

USES Strings;

FUNCTION GetEnv(Search: STRING): STRING;

PROCEDURE EnvFirst(VAR St: STRING; VAR EnvData; VAR Status: WORD);

PROCEDURE EnvNext(VAR St: STRING; VAR EnvData; VAR Status: WORD);

FUNCTION EnvExec: STRING;

IMPLEMENTATION

PROCEDURE EnvFirst; EXTERNAL;

PROCEDURE EnvNext; EXTERNAL;

{$L ENV.OBJ}

FUNCTION EnvExec: STRING; EXTERNAL;

{$L ENVEXEC.OBJ}

FUNCTION GetEnv(Search: STRING): STRING;

VAR
      Found : BOOLEAN;
      Status: WORD;
      EnvStr: STRING;
      EnvPtr: POINTER;

BEGIN {GetEnv}
      Search:= UpCaseStr(StripBlanks(Search));
      IF (LENGTH(Search) > 0) THEN
      BEGIN
          IF (CharPos('=', Search) = 0) THEN
          BEGIN
              INC(Search[0]);
              Search[LENGTH(Search)]:= '=';
          END; {if}
          EnvFirst(EnvStr, EnvPtr, Status);
          Found:= (LeftStr(EnvStr, LENGTH(Search)) = Search);
          WHILE (NOT Found) AND (Status = 0) DO
          BEGIN
              EnvNext(EnvStr, EnvPtr, Status);
              Found:= (LeftStr(EnvStr, LENGTH(Search)) = Search);
          END; {while}
          IF Found AND (Status = 0) THEN
             GetEnv:= RightStr(EnvStr, SUCC(LENGTH(Search)))
                ELSE GetEnv:= '';
      END
      ELSE GetEnv:= '';
END; {GetEnv}

      {$IFDEF SHOWINIT}
BEGIN {Init Env}
      WRITELN('Initializing unit ENV');
      {$ENDIF}
END.  {Init Env}
