;  Environment variable routines assembler interface to Turbo Pascal
;  Copyright 1988 by Mark R. Boler  -  All Rights Reserved

TITLE     ENVEXEC

DATA      SEGMENT WORD PUBLIC

          ASSUME  DS:DATA

          EXTRN   PREFIXSEG: WORD

DATA      ENDS

CODE      SEGMENT BYTE PUBLIC

          ASSUME  CS:CODE

          PUBLIC  EnvExec

; FUNCTION EnvExec: STRING; EXTERNAL;

EnvDest   EQU     DWORD PTR ss:[bx + 4]

MaxStrLen EQU     80                   ; maximum length string we will return
EnvOfs    EQU     [2CH]                ; offset in PSP of environment segment

EnvExec   PROC    FAR
          mov     bx, sp               ; set up stack frame in bx
          push    ds                   ; save ds
          mov     ds, PREFIXSEG        ; get PSP into es
          mov     es, ds:EnvOfs        ; get environment segment in es
          xor     cx, cx               ; zero out cx
          mov     di, cx               ; es:[di] = environment
          mov     dl, cl               ; zero out dl
          mov     al, cl               ; zero out al - we test for nul = 0
          dec     cx                   ; cx = maximum integer
          cld                          ; string ops go forward
Loop1:
          repne   scasb                ; search for a nul
          jcxz    Done                 ; no match even though 64K bytes
          scasb                        ; see if next byte is a nul
          jne     SHORT Loop1          ; if not double nul then loop

          mov     ax, es               ; make ds:si point to environment
          mov     ds, ax
          mov     si, di
          add     si, 2                ; point to program path string
          les     di, EnvDest          ; es:di points to length byte
          inc     di                   ; es:di points to string start
          mov     cx, MaxStrLen        ; set cx to longest path string
          mov     dl, cl               ; set dl = same

Loop2:
          lodsb                        ; get a character
          or      al, al               ; see if it is a nul
          jz      SHORT Calc           ; done if it is a nul
          stosb                        ; put it in destination if not
          loop    Loop2                ; repeat until done
Calc:
          sub     dl, cl               ; calculate length byte
Done:
          lds     si, EnvDest          ; ds:[si] = length byte
          mov     ds:[si], dl          ; set the length byte
          pop     ds                   ; restore ds
          ret                          ; return to caller
EnvExec   ENDP

CODE      ENDS

          END
