; Assembler interface to Turbo Pascal - MULKEY
;
; Copyright 1988 by Mark R. Boler  -  All Rights Reserved

TITLE        MULKEY

CODE         SEGMENT BYTE PUBLIC

             ASSUME  CS:CODE

             EXTRN   AUD_Record: NEAR

             PUBLIC  AddRecord, UpdateRecord, DeleteRecord

AddOp        EQU     2
UpdateOp     EQU     3
DeleteOp     EQU     4

; PROCEDURE xxxRecord(Handle: WORD; VAR d); EXTERNAL;

Handle       EQU     WORD PTR ss:[bx + 8]
DBufSeg      EQU     WORD PTR ss:[bx + 6]
DBufOfs      EQU     WORD PTR ss:[bx + 4]

UpDateRecord PROC    FAR
             mov     al, UpdateOp         ; set op code
CallEntry:
             mov     bx, sp               ; set up stack frame in bx
             push    Handle               ; set up for call to AUD_Record
             push    DBufSeg
             push    DBufOfs
             push    ax
             call    AUD_Record           ; make the call
             ret     6                    ; clean up and return to caller
UpDateRecord ENDP

AddRecord    PROC    FAR
             mov     al, AddOp            ; load op code
             jmp     SHORT CallEntry      ; make the call
AddRecord    ENDP

; PROCEDURE DeleteRecord(Handle: WORD); EXTERNAL;

DHandle      EQU     WORD PTR ss:[bx + 4]

DeleteRecord PROC    FAR
             mov     al, DeleteOp         ; set op code
             mov     bx, sp               ; set up stack frame in bx
             push    DHandle              ; set up for call to AUD_Record
             push    ss                   ; push address of Handle
             add     bx, 4
             push    bx
             push    ax                   ; push op code
             call    AUD_Record           ; make the call
             ret     2                    ; clean up and return to caller
DeleteRecord ENDP

CODE         ENDS

             END
