; Assembler interface to Turbo Pascal - MULKEY
;
; Copyright 1988 by Mark R. Boler  -  All Rights Reserved

TITLE      MULKEY

CODE       SEGMENT BYTE PUBLIC

           ASSUME  CS:CODE

           EXTRN   RPN_Record: NEAR

           PUBLIC  GetEqual, GetGreater, GetLessThan
           PUBLIC  GetGreaterOrEqual, GetLessThanOrEqual

; WARNING: This is NOT structured code.  It is not intended to be
;          easily read or understood.  It is intended to be small.

GetEqualOp           EQU 5
GetGreaterOp         EQU 8
GetGreaterOrEqualOp  EQU 9
GetLessThanOp        EQU 10
GetLessThanOrEqualOp EQU 11

; PROCEDURE Getxxxx(Handle: WORD;
;                   KeyNum: WORD;
;                    VAR k;
;                    VAR d);

Handle     EQU     WORD  PTR ss:[bx + 14]
KeyNum     EQU     WORD  PTR ss:[bx + 12]
KBufSeg    EQU     WORD  PTR ss:[bx + 10]
KBufOfs    EQU     WORD  PTR ss:[bx + 8]
DBufSeg    EQU     WORD  PTR ss:[bx + 6]
DBufOfs    EQU     WORD  PTR ss:[bx + 4]

GetGreater PROC    FAR
           mov     al, GetEqualOp
CallEntry:
           mov     bx, sp                 ; set up stack frame in bx
           push    Handle                 ; set up for call to RPN_Record
           push    KeyNum
           push    KBufSeg
           push    KBufOfs
           push    DBufSeg
           push    DBufOfs
           push    ax
           call    RPN_Record             ; make the call
           ret     12                     ; clean up and return to caller
GetGreater ENDP

GetEqual   PROC    FAR
           mov     al, GetEqualOp         ; set op code
           jmp     SHORT CallEntry        ; go set it
GetEqual   ENDP

GetLessThan PROC   FAR
           mov     al, GetLessThanOp      ; set op code
           jmp     SHORT CallEntry        ; go set it
GetLessThan ENDP

GetGreaterOrEqual  PROC FAR
           mov     al, GetGreaterOrEqualOp
           jmp     SHORT CallEntry
GetGreaterOrEqual  ENDP

GetLessThanOrEqual PROC FAR
           mov     al, GetLessThanOrEqualOp
           jmp     SHORT CallEntry
GetLessThanOrEqual ENDP

CODE       ENDS

           END
