; Assembler interface to Turbo Pascal - MULKEY
;
; Copyright 1988 by Mark R. Boler  -  All Rights Reserved

TITLE     MULKEY

DATA      SEGMENT WORD PUBLIC

          EXTRN   KeyOnly    : BYTE
          EXTRN   IndexError : BYTE
          EXTRN   LastErrCode: WORD
          EXTRN   MulPtr     : WORD

DATA      ENDS

CODE      SEGMENT WORD PUBLIC

          ASSUME  cs:CODE, ds:DATA

          PUBLIC  HandleActive, AdjOp    ; near functions
          PUBLIC  SetErr                 ; far procedure

TRUE      EQU     1
MaxMulkey EQU     40
GetEqualOp         EQU 5
GetHighestOp       EQU 13
GetDirectOp        EQU 23
BeginTransactionOp EQU 19
StepDirectOp       EQU 24
GetKeyOp           EQU 50

; FUNCTION HandleActive(Handle: WORD): BOOLEAN; EXTERNAL;

Handle    EQU     WORD PTR ss:[bx + 2]   ; near procedure

HandleActive      PROC NEAR
          mov     bx, sp                 ; set up stack frame in bx
          mov     ax, Handle             ; get handle in ax
          or      ax, ax                 ; see if handle is 0
          jz      SHORT NoGood           ; jump if handle was 0
          cmp     ax, MaxMulkey          ; see if handle > MaxMulkey
          ja      SHORT SetNoGood        ; jump if handle > MaxMulkey
          mov     bx, ax                 ; put handle in bx
          dec     bx                     ; 0 base the handle
          shl     bx, 1                  ; scale it for 4 byte pointers
          shl     bx, 1
          mov     ax, [bx + MulPtr]      ; get first word into ax
          or      ax, [bx + MulPtr + 2]  ; OR with the next word
          jz      SHORT NoGood           ; jump if both words were 0
          mov     al, TRUE               ; set resturn value to TRUE
          ret     2                      ; clean up and return to caller
SetNoGood:
          xor     al, al                 ; return FALSE
NoGood:
          ret     2                      ; clean up and return to caller
HandleActive      ENDP

; FUNCTION AdjOp(Op: WORD; LockAttr: FLockAttrib): WORD; EXTERNAL;

OpCode    EQU     WORD  PTR ss:[bx + 4]  ; near function
LockAttr  EQU     BYTE  PTR ss:[bx + 2]

AdjOp     PROC    NEAR
          mov     bx, sp                 ; set up stack frame in bx
          mov     ax, OpCode             ; get op code into ax
          cmp     ax, GetEqualOp         ; if op code > getEqualOp then return
          jb      SHORT AdjDone
          mov     dl, LockAttr           ; get lock attribute in dl
          mov     bx, ax                 ; save op code in bx
          or      dl, dl                 ; if lock attrib = 0 then jump past
          jz      SHORT CkKey
          cmp     ax, GetHighestOp
          jbe     SHORT AdjustIt         ; jump forward to adjust
          cmp     ax, GetDirectOp
          je      SHORT AdjustIt         ; jump forward to adjust
          cmp     ax, StepDirectOp
          je      SHORT AdjustIt         ; jump forward to adjust
          cmp     ax, BeginTransactionOp
          jne     SHORT CkKey            ; jump if we are not to adjust
AdjustIt:
          add     ax, 100                ; add 100 to op code
          test    dl, 00000001B          ; if bit is not set then add another
          jnz     SHORT WaitLocks        ; jump if only wait locks
          add     ax, 100                ; add another 100
WaitLocks:
          cmp     dl, 3                  ; see if multi locks
          jb      SHORT CkKey            ; jump if not multi locks
          add     ax, 200                ; adjust op code for multi locks
CkKey:
          cmp     KeyOnly, 0             ; if keyonly = 0 then return now
          jnz     SHORT SetKey
AdjDone:
          ret     4                      ; clean up and return to caller
SetKey:
          cmp     bx, GetHighestOp       ; if op code > gethighestop
          ja      SHORT AdjDone          ; then return now
          add     ax, GetKeyOp           ; adjust the op code
          ret     4                      ; clean up and return to caller
AdjOp     ENDP

; PROCEDURE SetErr(Status: WORD); EXTERNAL;

Status    EQU     WORD PTR ss:[bx + 4]   ; far procedure

SetErr    PROC    FAR
          mov     bx, sp                 ; set up stack frame in bx
          mov     ax, Status             ; get status in ax
          mov     LastErrCode, ax        ; store LastErrCode variable
          or      ax, ax                 ; see if ax = 0
          jnz     SHORT SetError         ; jump if not zero
          mov     IndexError, al         ; set IndexError variable to FALSE
          retf    2                      ; clean up and return to caller
SetError:
          mov     IndexError, TRUE       ; set IndexError variable to TRUE
          retf    2                      ; clean up and return to caller
SetErr    ENDP

CODE      ENDS

          END
